/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.MainFrame;
import frost.boards.Board;
import frost.boards.Folder;
import frost.boards.TofTree;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.gui.KnownBoard;
import frost.gui.KnownBoardsManager;
import frost.gui.SortedTable;
import frost.gui.TargetFolderChooser;
import frost.gui.model.KnownBoardsTableModel;
import frost.gui.model.TableMember;
import frost.storage.KnownBoardsXmlDAO;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class KnownBoardsFrame
extends JDialog {
    private static final Logger logger = Logger.getLogger(KnownBoardsFrame.class.getName());
    private final Language language;
    private final TofTree tofTree;
    private final HashSet<String> hiddenNames;
    private JButton Bclose;
    private JButton BboardActions;
    private JButton Bimport;
    private JButton Bexport;
    private JCheckBox CBshowHidden;
    private JTextField TFlookupBoard;
    private JTextField TFfilterBoard;
    private SortedTable boardsTable;
    private KnownBoardsTableModel tableModel;
    private NameColumnRenderer nameColRenderer;
    private DescColumnRenderer descColRenderer;
    private ShowContentTooltipRenderer showContentTooltipRenderer;
    private JSkinnablePopupMenu tablePopupMenu;
    private List<KnownBoardsTableMember> allKnownBoardsList;
    private final boolean showColoredLines;

    public KnownBoardsFrame(JFrame parent, TofTree tofTree) {
        super(parent);
        this.setModal(true);
        this.tofTree = tofTree;
        this.language = Language.getInstance();
        this.enableEvents(64L);
        try {
            this.initialize();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", e);
        }
        this.setDefaultCloseOperation(2);
        this.setSize((int)((double)parent.getWidth() * 0.75), (int)((double)parent.getHeight() * 0.75));
        this.setLocationRelativeTo(parent);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                KnownBoardsFrame.this.dialogClosed();
            }
        });
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
        this.hiddenNames = KnownBoardsManager.getInstance().loadHiddenBoardNames();
    }

    private void dialogClosed() {
        KnownBoardsManager.getInstance().saveHiddenBoardNames(this.hiddenNames);
    }

    private void updateBoardCountInTitle() {
        int count = this.tableModel.getRowCount();
        this.setTitle(this.language.getString("KnownBoardsFrame.title") + " (" + count + ")");
    }

    private void initialize() {
        this.setTitle(this.language.getString("KnownBoardsFrame.title"));
        this.setResizable(true);
        this.tableModel = new KnownBoardsTableModel();
        this.nameColRenderer = new NameColumnRenderer();
        this.descColRenderer = new DescColumnRenderer();
        this.showContentTooltipRenderer = new ShowContentTooltipRenderer();
        this.boardsTable = new SortedTable(this.tableModel){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 0) {
                    return KnownBoardsFrame.this.nameColRenderer;
                }
                if (column == 3) {
                    return KnownBoardsFrame.this.descColRenderer;
                }
                return KnownBoardsFrame.this.showContentTooltipRenderer;
            }
        };
        this.boardsTable.setRowSelectionAllowed(true);
        this.boardsTable.setSelectionMode(2);
        this.boardsTable.setRowHeight(18);
        this.Bclose = new JButton(this.language.getString("KnownBoardsFrame.button.close"));
        this.BboardActions = new JButton(this.language.getString("KnownBoardsFrame.button.actions") + " ...");
        this.Bimport = new JButton(this.language.getString("KnownBoardsFrame.button.import") + " ...");
        this.Bexport = new JButton(this.language.getString("KnownBoardsFrame.button.export") + " ...");
        this.CBshowHidden = new JCheckBox();
        this.CBshowHidden.setToolTipText(this.language.getString("KnownBoardsFrame.tooltip.showHidden"));
        this.TFlookupBoard = new JTextField(10);
        new TextComponentClipboardMenu(this.TFlookupBoard, this.language);
        this.TFlookupBoard.setMaximumSize(this.TFlookupBoard.getPreferredSize());
        this.TFlookupBoard.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                KnownBoardsFrame.this.lookupContentChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                KnownBoardsFrame.this.lookupContentChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                KnownBoardsFrame.this.lookupContentChanged();
            }
        });
        this.TFfilterBoard = new JTextField(10);
        new TextComponentClipboardMenu(this.TFfilterBoard, this.language);
        this.TFfilterBoard.setMaximumSize(this.TFfilterBoard.getPreferredSize());
        this.TFfilterBoard.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                KnownBoardsFrame.this.filterContentChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                KnownBoardsFrame.this.filterContentChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                KnownBoardsFrame.this.filterContentChanged();
            }
        });
        this.boardsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                KnownBoardsFrame.this.boardsTableListModel_valueChanged(e);
            }
        });
        this.BboardActions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (KnownBoardsFrame.this.boardsTable.getSelectedRowCount() > 0) {
                    KnownBoardsFrame.this.tablePopupMenu.show(KnownBoardsFrame.this.BboardActions, 5, 5);
                }
            }
        });
        this.Bimport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnownBoardsFrame.this.import_actionPerformed(e);
            }
        });
        this.Bexport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnownBoardsFrame.this.export_actionPerformed(e);
            }
        });
        this.Bclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnownBoardsFrame.this.dispose();
            }
        });
        this.CBshowHidden.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (KnownBoardsFrame.this.CBshowHidden.isSelected()) {
                    KnownBoardsFrame.this.loadKnownBoardsIntoTable(true);
                } else {
                    KnownBoardsFrame.this.removeHiddenBoards();
                }
            }
        });
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel buttons = new JPanel(new BorderLayout());
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(new JLabel(this.language.getString("KnownBoardsFrame.label.lookup") + ":"));
        buttons.add(Box.createRigidArea(new Dimension(5, 3)));
        buttons.add(this.TFlookupBoard);
        buttons.add(Box.createRigidArea(new Dimension(5, 3)));
        buttons.add(new JLabel(this.language.getString("KnownBoardsFrame.label.filter") + ":"));
        buttons.add(Box.createRigidArea(new Dimension(5, 3)));
        buttons.add(this.TFfilterBoard);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.CBshowHidden);
        buttons.add(Box.createRigidArea(new Dimension(5, 3)));
        buttons.add(this.BboardActions);
        buttons.add(Box.createRigidArea(new Dimension(10, 3)));
        buttons.add(this.Bimport);
        buttons.add(Box.createRigidArea(new Dimension(5, 3)));
        buttons.add(this.Bexport);
        buttons.add(Box.createRigidArea(new Dimension(10, 3)));
        buttons.add(this.Bclose);
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JScrollPane scrollPane = new JScrollPane(this.boardsTable);
        scrollPane.setWheelScrollingEnabled(true);
        mainPanel.add((Component)scrollPane, "Center");
        mainPanel.add((Component)buttons, "South");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 7, 7, 7));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, null);
        this.BboardActions.setEnabled(false);
        this.initPopupMenu();
    }

    private void initPopupMenu() {
        this.tablePopupMenu = new JSkinnablePopupMenu();
        JMenuItem addBoardsMenu = new JMenuItem(this.language.getString("KnownBoardsFrame.button.addBoards"));
        JMenuItem addBoardsToFolderMenu = new JMenuItem(this.language.getString("KnownBoardsFrame.button.addBoardsToFolder") + " ...");
        JMenuItem removeBoardEntry = new JMenuItem(this.language.getString("KnownBoardsFrame.button.removeBoard"));
        JMenuItem hideBoardEntry = new JMenuItem(this.language.getString("KnownBoardsFrame.button.hideBoard"));
        JMenuItem unhideBoardEntry = new JMenuItem(this.language.getString("KnownBoardsFrame.button.unhideBoard"));
        addBoardsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnownBoardsFrame.this.addBoards_actionPerformed(e);
            }
        });
        addBoardsToFolderMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnownBoardsFrame.this.addBoardsToFolder_actionPerformed(e);
            }
        });
        removeBoardEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnownBoardsFrame.this.deleteBoards_actionPerformed(e);
            }
        });
        hideBoardEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnownBoardsFrame.this.hideBoards_actionPerformed(e);
            }
        });
        unhideBoardEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnownBoardsFrame.this.unhideBoards_actionPerformed(e);
            }
        });
        this.tablePopupMenu.add(addBoardsMenu);
        this.tablePopupMenu.add(addBoardsToFolderMenu);
        this.tablePopupMenu.addSeparator();
        this.tablePopupMenu.add(hideBoardEntry);
        this.tablePopupMenu.add(unhideBoardEntry);
        this.tablePopupMenu.addSeparator();
        this.tablePopupMenu.add(removeBoardEntry);
        this.boardsTable.addMouseListener(new TablePopupMenuMouseListener());
    }

    public void startDialog() {
        this.loadKnownBoardsIntoTable(this.CBshowHidden.isSelected());
        this.setVisible(true);
    }

    private void loadKnownBoardsIntoTable(boolean showHidden) {
        this.allKnownBoardsList = new LinkedList<KnownBoardsTableMember>();
        this.tableModel.clearDataModel();
        this.TFfilterBoard.setText("");
        this.TFlookupBoard.setText("");
        LinkedList<Board> frostboards = MainFrame.getInstance().getTofTreeModel().getAllBoards();
        for (KnownBoard b : KnownBoardsManager.getKnownBoardsList()) {
            if (this.isNameHidden(b)) {
                if (!showHidden) continue;
                b.setHidden(true);
            }
            String bname = b.getName();
            String bprivkey = b.getPrivateKey();
            String bpubkey = b.getPublicKey();
            boolean addMe = true;
            for (Board board : frostboards) {
                if (!board.getName().equalsIgnoreCase(bname) || (board.getPrivateKey() != null || bprivkey != null) && (board.getPrivateKey() == null || !board.getPrivateKey().equals(bprivkey)) || (board.getPublicKey() != null || bpubkey != null) && (board.getPublicKey() == null || !board.getPublicKey().equals(bpubkey))) continue;
                addMe = false;
                break;
            }
            if (!addMe) continue;
            KnownBoardsTableMember member = new KnownBoardsTableMember(b);
            this.tableModel.addRow(member);
            this.allKnownBoardsList.add(member);
        }
        this.updateBoardCountInTitle();
    }

    private void addBoards_actionPerformed(ActionEvent e) {
        int[] selectedRows = this.boardsTable.getSelectedRows();
        if (selectedRows.length > 0) {
            for (int z = selectedRows.length - 1; z > -1; --z) {
                int rowIx = selectedRows[z];
                if (rowIx >= this.tableModel.getRowCount()) continue;
                KnownBoardsTableMember row = (KnownBoardsTableMember)this.tableModel.getRow(rowIx);
                this.tofTree.addNewBoard(row.getBoard());
                this.tableModel.deleteRow(row);
                this.allKnownBoardsList.remove(row);
            }
            this.boardsTable.clearSelection();
            this.updateBoardCountInTitle();
        }
    }

    private void addBoardsToFolder_actionPerformed(ActionEvent e) {
        TargetFolderChooser tfc = new TargetFolderChooser(MainFrame.getInstance().getTofTreeModel());
        Folder targetFolder = tfc.startDialog();
        if (targetFolder == null) {
            return;
        }
        int[] selectedRows = this.boardsTable.getSelectedRows();
        if (selectedRows.length > 0) {
            for (int z = selectedRows.length - 1; z > -1; --z) {
                int rowIx = selectedRows[z];
                if (rowIx >= this.tableModel.getRowCount()) continue;
                KnownBoardsTableMember row = (KnownBoardsTableMember)this.tableModel.getRow(rowIx);
                MainFrame.getInstance().getTofTreeModel().addNodeToTree(row.getBoard(), targetFolder);
                this.tableModel.deleteRow(row);
                this.allKnownBoardsList.remove(row);
            }
            this.boardsTable.clearSelection();
            this.updateBoardCountInTitle();
        }
    }

    private void deleteBoards_actionPerformed(ActionEvent e) {
        int[] selectedRows = this.boardsTable.getSelectedRows();
        if (selectedRows.length > 0) {
            for (int z = selectedRows.length - 1; z > -1; --z) {
                int rowIx = selectedRows[z];
                if (rowIx >= this.tableModel.getRowCount()) continue;
                KnownBoardsTableMember row = (KnownBoardsTableMember)this.tableModel.getRow(rowIx);
                this.tableModel.deleteRow(row);
                this.allKnownBoardsList.remove(row);
                KnownBoardsManager.deleteKnownBoard(row.getBoard());
            }
            this.boardsTable.clearSelection();
            this.updateBoardCountInTitle();
        }
    }

    private void hideBoards_actionPerformed(ActionEvent e) {
        int[] selectedRows = this.boardsTable.getSelectedRows();
        if (selectedRows.length > 0) {
            for (int z = selectedRows.length - 1; z > -1; --z) {
                int rowIx = selectedRows[z];
                if (rowIx >= this.tableModel.getRowCount()) continue;
                KnownBoardsTableMember row = (KnownBoardsTableMember)this.tableModel.getRow(rowIx);
                this.addHiddenName(row.getBoard().getName());
                row.getBoard().setHidden(true);
            }
            this.boardsTable.clearSelection();
            if (!this.CBshowHidden.isSelected()) {
                this.removeHiddenBoards();
            } else {
                this.tableModel.tableEntriesChanged();
            }
            this.updateBoardCountInTitle();
        }
    }

    private void unhideBoards_actionPerformed(ActionEvent e) {
        int[] selectedRows = this.boardsTable.getSelectedRows();
        if (selectedRows.length > 0) {
            for (int z = selectedRows.length - 1; z > -1; --z) {
                int rowIx = selectedRows[z];
                if (rowIx >= this.tableModel.getRowCount()) continue;
                KnownBoardsTableMember row = (KnownBoardsTableMember)this.tableModel.getRow(rowIx);
                this.removeHiddenName(row.getBoard().getName());
                row.getBoard().setHidden(false);
            }
            this.boardsTable.clearSelection();
            this.tableModel.tableEntriesChanged();
            this.updateBoardCountInTitle();
        }
    }

    private void removeHiddenBoards() {
        for (int row = this.tableModel.getRowCount() - 1; row >= 0; --row) {
            KnownBoardsTableMember memb = (KnownBoardsTableMember)this.tableModel.getRow(row);
            if (!this.isNameHidden(memb.getBoard())) continue;
            this.tableModel.removeRow(row);
        }
        this.updateBoardCountInTitle();
    }

    private void boardsTableListModel_valueChanged(ListSelectionEvent e) {
        if (this.boardsTable.getSelectedRowCount() > 0) {
            this.BboardActions.setEnabled(true);
        } else {
            this.BboardActions.setEnabled(false);
        }
    }

    private void import_actionPerformed(ActionEvent e) {
        File xmlFile = this.chooseImportFile();
        if (xmlFile == null) {
            return;
        }
        List<Board> imports = KnownBoardsXmlDAO.loadKnownBoards(xmlFile);
        if (imports.size() == 0) {
            MiscToolkit.showMessage(this.language.getString("KnownBoardsFrame.noBoardsImported.body"), 2, this.language.getString("KnownBoardsFrame.noBoardsImported.title"));
        } else {
            int added = KnownBoardsManager.addNewKnownBoards(imports);
            MiscToolkit.showMessage(this.language.formatMessage("KnownBoardsFrame.boardsImported.body", Integer.toString(imports.size()), xmlFile.getName(), Integer.toString(added)), 2, this.language.getString("KnownBoardsFrame.boardsImported.title"));
            this.loadKnownBoardsIntoTable(this.CBshowHidden.isSelected());
        }
    }

    private void export_actionPerformed(ActionEvent e) {
        File xmlFile = this.chooseExportFile();
        if (xmlFile == null) {
            return;
        }
        LinkedList<Board> frostboards = MainFrame.getInstance().getTofTreeModel().getAllBoards();
        frostboards.addAll(KnownBoardsManager.getKnownBoardsList());
        Iterator i = frostboards.iterator();
        while (i.hasNext()) {
            Board b = (Board)i.next();
            if (!this.isNameHidden(b)) continue;
            i.remove();
        }
        if (KnownBoardsXmlDAO.saveKnownBoards(xmlFile, frostboards)) {
            MiscToolkit.showMessage(this.language.formatMessage("KnownBoardsFrame.boardsExported.body", Integer.toString(frostboards.size()), xmlFile.getName()), 1, this.language.getString("KnownBoardsFrame.boardsExported.title"));
        } else {
            MiscToolkit.showMessage(this.language.getString("KnownBoardsFrame.exportFailed.body"), 0, this.language.getString("KnownBoardsFrame.exportFailed.title"));
        }
    }

    private File chooseExportFile() {
        FileFilter myFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "*.xml";
            }
        };
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(myFilter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            String s = f.getPath();
            if (!s.endsWith(".xml")) {
                f = new File(s + ".xml");
            }
            return f;
        }
        return null;
    }

    private File chooseImportFile() {
        FileFilter myFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "*.xml";
            }
        };
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(myFilter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private void lookupContentChanged() {
        try {
            String txt = this.TFlookupBoard.getDocument().getText(0, this.TFlookupBoard.getDocument().getLength());
            for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
                KnownBoardsTableMember memb = (KnownBoardsTableMember)this.tableModel.getRow(row);
                if (!memb.getBoard().getName().toLowerCase().startsWith(txt.toLowerCase())) continue;
                this.boardsTable.getSelectionModel().setSelectionInterval(row, row);
                int visibleRows = (int)(this.boardsTable.getVisibleRect().getHeight() / this.boardsTable.getCellRect(row, 0, true).getHeight());
                int scrollToRow = row + visibleRows > this.tableModel.getRowCount() ? this.tableModel.getRowCount() - 1 : row + visibleRows - 1;
                if (scrollToRow > row) {
                    --scrollToRow;
                }
                this.boardsTable.scrollRectToVisible(this.boardsTable.getCellRect(row, 0, true));
                this.boardsTable.scrollRectToVisible(this.boardsTable.getCellRect(scrollToRow, 0, true));
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void filterContentChanged() {
        try {
            this.TFlookupBoard.setText("");
            String txt = this.TFfilterBoard.getDocument().getText(0, this.TFfilterBoard.getDocument().getLength()).trim();
            txt = txt.toLowerCase();
            this.tableModel.clearDataModel();
            for (KnownBoardsTableMember tm : this.allKnownBoardsList) {
                String bn;
                if (txt.length() > 0 && (bn = tm.getBoard().getName().toLowerCase()).indexOf(txt) < 0) continue;
                this.tableModel.addRow(tm);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateBoardCountInTitle();
    }

    private boolean isNameHidden(Board b) {
        String boardName = b.getName();
        return this.isNameHidden(boardName);
    }

    private boolean isNameHidden(String n) {
        return this.hiddenNames.contains(n.toLowerCase());
    }

    private void addHiddenName(String n) {
        this.hiddenNames.add(n.toLowerCase());
    }

    private void removeHiddenName(String n) {
        this.hiddenNames.remove(n.toLowerCase());
    }

    class TablePopupMenuMouseListener
    implements MouseListener {
        TablePopupMenuMouseListener() {
        }

        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && KnownBoardsFrame.this.boardsTable.getSelectedRowCount() > 0) {
                KnownBoardsFrame.this.tablePopupMenu.show(KnownBoardsFrame.this.boardsTable, e.getX(), e.getY());
            }
        }
    }

    private class ShowContentTooltipRenderer
    extends ShowColoredLinesRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            if (value != null && (tooltip = value.toString()).length() == 0) {
                tooltip = null;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    private class ShowColoredLinesRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, KnownBoardsFrame.this.showColoredLines);
                this.setBackground(newBackground);
            } else {
                this.setBackground(table.getSelectionBackground());
            }
            return this;
        }
    }

    class DescColumnRenderer
    extends ShowColoredLinesRenderer {
        DescColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            KnownBoardsTableMember memb = (KnownBoardsTableMember)KnownBoardsFrame.this.tableModel.getRow(row);
            if (memb.getBoard().getDescription() != null && memb.getBoard().getDescription().length() > 0) {
                this.setToolTipText(memb.getBoard().getDescription());
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    class NameColumnRenderer
    extends ShowContentTooltipRenderer {
        NameColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            KnownBoardsTableMember memb = (KnownBoardsTableMember)KnownBoardsFrame.this.tableModel.getRow(row);
            this.setIcon(memb.getBoard().getStateIcon());
            return this;
        }
    }

    class KnownBoardsTableMember
    implements TableMember {
        KnownBoard frostboard;

        public KnownBoardsTableMember(KnownBoard b) {
            this.frostboard = b;
        }

        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    if (this.frostboard.isHidden()) {
                        return this.frostboard.getName() + " (H)";
                    }
                    return this.frostboard.getName();
                }
                case 1: {
                    return this.frostboard.getPublicKey() == null ? "" : this.frostboard.getPublicKey();
                }
                case 2: {
                    return this.frostboard.getPrivateKey() == null ? "" : this.frostboard.getPrivateKey();
                }
                case 3: {
                    return this.frostboard.getDescription() == null ? "" : this.frostboard.getDescription();
                }
            }
            return "*ERR*";
        }

        public int compareTo(TableMember anOther, int tableColumIndex) {
            String c1 = (String)this.getValueAt(tableColumIndex);
            String c2 = (String)anOther.getValueAt(tableColumIndex);
            return c1.compareToIgnoreCase(c2);
        }

        public KnownBoard getBoard() {
            return this.frostboard;
        }
    }
}

