/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.fcp.FcpHandler;
import frost.fcp.FcpResultPut;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadTicker;
import java.util.logging.Level;
import java.util.logging.Logger;

class UploadThread
extends Thread {
    private static final Logger logger = Logger.getLogger(UploadThread.class.getName());
    private UploadTicker ticker;
    private FrostUploadItem uploadItem;
    private boolean doMime;

    protected UploadThread(UploadTicker newTicker, FrostUploadItem ulItem, boolean doMim) {
        this.ticker = newTicker;
        this.uploadItem = ulItem;
        this.doMime = doMim;
    }

    public void run() {
        this.ticker.uploadingThreadStarted();
        try {
            this.upload();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception thrown in run()", e);
        }
        this.ticker.uploadThreadFinished();
    }

    private void upload() {
        logger.info("Upload of " + this.uploadItem.getFile().getName() + " started.");
        FcpResultPut result = null;
        try {
            result = FcpHandler.inst().putFile(2, "CHK@", this.uploadItem.getFile(), null, true, true, this.doMime, this.uploadItem);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception thrown in putFile()", t);
        }
        FileTransferManager.inst().getUploadManager().notifyUploadFinished(this.uploadItem, result);
    }
}

