/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.Core;
import frost.fcp.FcpHandler;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.PersistenceManager;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadModel;
import frost.fileTransfer.upload.UploadTableFormat;
import frost.util.CopyToClipboard;
import frost.util.FileAccess;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.search.TableFindAction;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.SortedModelTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class UploadPanel
extends JPanel {
    private PopupMenuUpload popupMenuUpload = null;
    private final Listener listener = new Listener();
    private static final Logger logger = Logger.getLogger(UploadPanel.class.getName());
    private UploadModel model = null;
    private Language language = null;
    private final JToolBar uploadToolBar = new JToolBar();
    private final JButton uploadAddFilesButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/folder-open.png"));
    private final JCheckBox removeFinishedUploadsCheckBox = new JCheckBox();
    private final JCheckBox showExternalGlobalQueueItems = new JCheckBox();
    private SortedModelTable modelTable;
    private final JLabel uploadItemCountLabel = new JLabel();
    private int uploadItemCount = 0;
    private boolean initialized = false;

    public UploadPanel() {
        this.language = Language.getInstance();
        this.language.addLanguageListener(this.listener);
    }

    public UploadTableFormat getTableFormat() {
        return (UploadTableFormat)this.modelTable.getTableFormat();
    }

    public void initialize() {
        if (!this.initialized) {
            this.refreshLanguage();
            this.uploadToolBar.setRollover(true);
            this.uploadToolBar.setFloatable(false);
            this.removeFinishedUploadsCheckBox.setOpaque(false);
            this.showExternalGlobalQueueItems.setOpaque(false);
            MiscToolkit.configureButton(this.uploadAddFilesButton);
            this.uploadToolBar.add(this.uploadAddFilesButton);
            this.uploadToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
            this.uploadToolBar.add(this.removeFinishedUploadsCheckBox);
            if (PersistenceManager.isPersistenceEnabled()) {
                this.uploadToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
                this.uploadToolBar.add(this.showExternalGlobalQueueItems);
            }
            this.uploadToolBar.add(Box.createRigidArea(new Dimension(80, 0)));
            this.uploadToolBar.add(Box.createHorizontalGlue());
            this.uploadToolBar.add(this.uploadItemCountLabel);
            this.modelTable = new SortedModelTable(this.model);
            new TableFindAction().install(this.modelTable.getTable());
            this.setLayout(new BorderLayout());
            this.add((Component)this.uploadToolBar, "North");
            this.add((Component)this.modelTable.getScrollPane(), "Center");
            this.fontChanged();
            this.uploadAddFilesButton.addActionListener(this.listener);
            this.modelTable.getScrollPane().addMouseListener(this.listener);
            this.modelTable.getTable().addKeyListener(this.listener);
            this.modelTable.getTable().addMouseListener(this.listener);
            this.removeFinishedUploadsCheckBox.addItemListener(this.listener);
            this.showExternalGlobalQueueItems.addItemListener(this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontName", this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontSize", this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontStyle", this.listener);
            this.removeFinishedUploadsCheckBox.setSelected(Core.frostSettings.getBoolValue("removeFinishedUploads"));
            this.showExternalGlobalQueueItems.setSelected(Core.frostSettings.getBoolValue("showExternalGlobalQueueUploads"));
            this.initialized = true;
        }
    }

    private Dimension calculateLabelSize(String text) {
        JLabel dummyLabel = new JLabel(text);
        dummyLabel.doLayout();
        return dummyLabel.getPreferredSize();
    }

    private void refreshLanguage() {
        this.uploadAddFilesButton.setToolTipText(this.language.getString("UploadPane.toolbar.tooltip.browse") + "...");
        String waiting = this.language.getString("UploadPane.toolbar.waiting");
        Dimension labelSize = this.calculateLabelSize(waiting + ": 00000");
        this.uploadItemCountLabel.setPreferredSize(labelSize);
        this.uploadItemCountLabel.setMinimumSize(labelSize);
        this.uploadItemCountLabel.setText(waiting + ": " + this.uploadItemCount);
        this.removeFinishedUploadsCheckBox.setText(this.language.getString("UploadPane.removeFinishedUploads"));
        this.showExternalGlobalQueueItems.setText(this.language.getString("UploadPane.showExternalGlobalQueueItems"));
    }

    private PopupMenuUpload getPopupMenuUpload() {
        if (this.popupMenuUpload == null) {
            this.popupMenuUpload = new PopupMenuUpload();
            this.language.addLanguageListener(this.popupMenuUpload);
        }
        return this.popupMenuUpload;
    }

    private void uploadTable_keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\u007f' && !this.modelTable.getTable().isEditing()) {
            this.removeSelectedFiles();
        }
    }

    private void removeSelectedFiles() {
        ModelItem[] selectedItems = this.modelTable.getSelectedItems();
        final LinkedList<String> externalRequestsToRemove = new LinkedList<String>();
        LinkedList<ModelItem> requestsToRemove = new LinkedList<ModelItem>();
        for (ModelItem mi : selectedItems) {
            FrostUploadItem i = (FrostUploadItem)mi;
            requestsToRemove.add(mi);
            if (!i.isExternal()) continue;
            externalRequestsToRemove.add(i.getGqIdentifier());
        }
        ModelItem[] ri = requestsToRemove.toArray(new ModelItem[requestsToRemove.size()]);
        this.model.removeItems(ri);
        this.modelTable.getTable().clearSelection();
        if (FileTransferManager.inst().getPersistenceManager() != null && externalRequestsToRemove.size() > 0) {
            new Thread(){

                public void run() {
                    FileTransferManager.inst().getPersistenceManager().removeRequests(externalRequestsToRemove);
                }
            }.start();
        }
    }

    public void uploadAddFilesButton_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(Core.frostSettings.getValue("lastUsedDirectory"));
        fc.setDialogTitle(this.language.getString("UploadPane.filechooser.title"));
        fc.setFileHidingEnabled(true);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setPreferredSize(new Dimension(600, 400));
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        File[] selectedFiles = fc.getSelectedFiles();
        if (selectedFiles == null) {
            return;
        }
        String parentDir = null;
        LinkedList<File> uploadFileItems = new LinkedList<File>();
        for (File element : selectedFiles) {
            ArrayList<File> allFiles = FileAccess.getAllEntries(element, "");
            for (File newFile : allFiles) {
                if (!newFile.isFile() || newFile.length() <= 0L) continue;
                uploadFileItems.add(newFile);
                if (parentDir != null) continue;
                parentDir = newFile.getParent();
            }
        }
        if (parentDir != null) {
            Core.frostSettings.setValue("lastUsedDirectory", parentDir);
        }
        for (File file : uploadFileItems) {
            FrostUploadItem ulItem = new FrostUploadItem(file);
            this.model.addNewUploadItem(ulItem);
        }
    }

    private void showUploadTablePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        int y = this.modelTable.getTable().rowAtPoint(p);
        if (y < 0) {
            return;
        }
        if (!this.modelTable.getTable().getSelectionModel().isSelectedIndex(y)) {
            this.modelTable.getTable().getSelectionModel().setSelectionInterval(y, y);
        }
        this.getPopupMenuUpload().show(e.getComponent(), e.getX(), e.getY());
    }

    private void uploadTableDoubleClick(MouseEvent e) {
        ModelItem[] selectedItems = this.modelTable.getSelectedItems();
        if (selectedItems.length != 0) {
            FrostUploadItem ulItem = (FrostUploadItem)selectedItems[0];
            if (!ulItem.isSharedFile()) {
                return;
            }
            FrostSharedFileItem sfi = ulItem.getSharedFileItem();
            FileTransferManager.inst().getSharedFilesManager().selectTab();
            FileTransferManager.inst().getSharedFilesManager().selectModelItem(sfi);
        }
    }

    private void fontChanged() {
        int fontSize;
        int fontStyle;
        String fontName = Core.frostSettings.getValue("fileListFontName");
        Font font = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("fileListFontStyle"), fontSize = Core.frostSettings.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(fontName)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
            Core.frostSettings.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", fontStyle, fontSize);
        }
        this.modelTable.setFont(font);
    }

    public void setModel(UploadModel model) {
        this.model = model;
    }

    public void setUploadItemCount(int newUploadItemCount) {
        this.uploadItemCount = newUploadItemCount;
        String s = this.language.getString("UploadPane.toolbar.waiting") + ": " + this.uploadItemCount;
        this.uploadItemCountLabel.setText(s);
    }

    private class Listener
    extends MouseAdapter
    implements LanguageListener,
    KeyListener,
    ActionListener,
    MouseListener,
    PropertyChangeListener,
    ItemListener {
        public void languageChanged(LanguageEvent event) {
            UploadPanel.this.refreshLanguage();
        }

        public void keyPressed(KeyEvent e) {
            if (e.getSource() == UploadPanel.this.modelTable.getTable()) {
                UploadPanel.this.uploadTable_keyPressed(e);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == UploadPanel.this.uploadAddFilesButton) {
                UploadPanel.this.uploadAddFilesButton_actionPerformed(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getSource() == UploadPanel.this.modelTable.getTable()) {
                    UploadPanel.this.uploadTableDoubleClick(e);
                }
            } else if (e.isPopupTrigger() && (e.getSource() == UploadPanel.this.modelTable.getTable() || e.getSource() == UploadPanel.this.modelTable.getScrollPane())) {
                UploadPanel.this.showUploadTablePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 1 && e.isPopupTrigger() && (e.getSource() == UploadPanel.this.modelTable.getTable() || e.getSource() == UploadPanel.this.modelTable.getScrollPane())) {
                UploadPanel.this.showUploadTablePopupMenu(e);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("fileListFontName")) {
                UploadPanel.this.fontChanged();
            }
            if (evt.getPropertyName().equals("fileListFontSize")) {
                UploadPanel.this.fontChanged();
            }
            if (evt.getPropertyName().equals("fileListFontStyle")) {
                UploadPanel.this.fontChanged();
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (UploadPanel.this.removeFinishedUploadsCheckBox.isSelected()) {
                Core.frostSettings.setValue("removeFinishedUploads", true);
                UploadPanel.this.model.removeFinishedUploads();
            } else {
                Core.frostSettings.setValue("removeFinishedUploads", false);
            }
            if (UploadPanel.this.showExternalGlobalQueueItems.isSelected()) {
                Core.frostSettings.setValue("showExternalGlobalQueueUploads", true);
            } else {
                Core.frostSettings.setValue("showExternalGlobalQueueUploads", false);
                UploadPanel.this.model.removeExternalUploads();
            }
        }
    }

    private class PopupMenuUpload
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private final JMenuItem copyKeysItem = new JMenuItem();
        private final JMenuItem copyExtendedInfoItem = new JMenuItem();
        private final JMenuItem generateChkForSelectedFilesItem = new JMenuItem();
        private final JMenuItem uploadSelectedFilesItem = new JMenuItem();
        private final JMenuItem removeSelectedFilesItem = new JMenuItem();
        private final JMenuItem showSharedFileItem = new JMenuItem();
        private final JMenuItem startSelectedUploadsNow = new JMenuItem();
        private final JMenu copyToClipboardMenu = new JMenu();
        private final JMenuItem disableAllDownloadsItem = new JMenuItem();
        private final JMenuItem disableSelectedDownloadsItem = new JMenuItem();
        private final JMenuItem enableAllDownloadsItem = new JMenuItem();
        private final JMenuItem enableSelectedDownloadsItem = new JMenuItem();
        private final JMenuItem invertEnabledAllItem = new JMenuItem();
        private final JMenuItem invertEnabledSelectedItem = new JMenuItem();
        private JMenu changePriorityMenu = null;
        private JMenuItem prio0Item = null;
        private JMenuItem prio1Item = null;
        private JMenuItem prio2Item = null;
        private JMenuItem prio3Item = null;
        private JMenuItem prio4Item = null;
        private JMenuItem prio5Item = null;
        private JMenuItem prio6Item = null;
        private JMenuItem removeFromGqItem = null;

        public PopupMenuUpload() {
            this.initialize();
        }

        private void initialize() {
            if (PersistenceManager.isPersistenceEnabled()) {
                this.changePriorityMenu = new JMenu();
                this.prio0Item = new JMenuItem();
                this.prio1Item = new JMenuItem();
                this.prio2Item = new JMenuItem();
                this.prio3Item = new JMenuItem();
                this.prio4Item = new JMenuItem();
                this.prio5Item = new JMenuItem();
                this.prio6Item = new JMenuItem();
                this.changePriorityMenu.add(this.prio0Item);
                this.changePriorityMenu.add(this.prio1Item);
                this.changePriorityMenu.add(this.prio2Item);
                this.changePriorityMenu.add(this.prio3Item);
                this.changePriorityMenu.add(this.prio4Item);
                this.changePriorityMenu.add(this.prio5Item);
                this.changePriorityMenu.add(this.prio6Item);
                this.removeFromGqItem = new JMenuItem();
                this.prio0Item.addActionListener(this);
                this.prio1Item.addActionListener(this);
                this.prio2Item.addActionListener(this);
                this.prio3Item.addActionListener(this);
                this.prio4Item.addActionListener(this);
                this.prio5Item.addActionListener(this);
                this.prio6Item.addActionListener(this);
                this.removeFromGqItem.addActionListener(this);
            }
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            if (FcpHandler.isFreenet05()) {
                this.copyToClipboardMenu.add(this.copyKeysItem);
            }
            this.copyToClipboardMenu.add(this.copyExtendedInfoItem);
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyKeysItem.addActionListener(this);
            this.copyExtendedInfoItem.addActionListener(this);
            this.removeSelectedFilesItem.addActionListener(this);
            this.uploadSelectedFilesItem.addActionListener(this);
            this.startSelectedUploadsNow.addActionListener(this);
            this.generateChkForSelectedFilesItem.addActionListener(this);
            this.showSharedFileItem.addActionListener(this);
            this.enableAllDownloadsItem.addActionListener(this);
            this.disableAllDownloadsItem.addActionListener(this);
            this.enableSelectedDownloadsItem.addActionListener(this);
            this.disableSelectedDownloadsItem.addActionListener(this);
            this.invertEnabledAllItem.addActionListener(this);
            this.invertEnabledSelectedItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.copyKeysItem.setText(UploadPanel.this.language.getString("Common.copyToClipBoard.copyKeysOnly"));
            this.copyKeysAndNamesItem.setText(UploadPanel.this.language.getString("Common.copyToClipBoard.copyKeysWithFilenames"));
            this.copyExtendedInfoItem.setText(UploadPanel.this.language.getString("Common.copyToClipBoard.copyExtendedInfo"));
            this.generateChkForSelectedFilesItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.startEncodingOfSelectedFiles"));
            this.uploadSelectedFilesItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.uploadSelectedFiles"));
            this.startSelectedUploadsNow.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.startSelectedUploadsNow"));
            this.removeSelectedFilesItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.remove.removeSelectedFiles"));
            this.showSharedFileItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.showSharedFile"));
            this.copyToClipboardMenu.setText(UploadPanel.this.language.getString("Common.copyToClipBoard") + "...");
            this.enableAllDownloadsItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.enableUploads.enableAllUploads"));
            this.disableAllDownloadsItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.enableUploads.disableAllUploads"));
            this.enableSelectedDownloadsItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.enableUploads.enableSelectedUploads"));
            this.disableSelectedDownloadsItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.enableUploads.disableSelectedUploads"));
            this.invertEnabledAllItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.enableUploads.invertEnabledStateForAllUploads"));
            this.invertEnabledSelectedItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.enableUploads.invertEnabledStateForSelectedUploads"));
            if (PersistenceManager.isPersistenceEnabled()) {
                this.changePriorityMenu.setText(UploadPanel.this.language.getString("Common.priority.changePriority"));
                this.prio0Item.setText(UploadPanel.this.language.getString("Common.priority.priority0"));
                this.prio1Item.setText(UploadPanel.this.language.getString("Common.priority.priority1"));
                this.prio2Item.setText(UploadPanel.this.language.getString("Common.priority.priority2"));
                this.prio3Item.setText(UploadPanel.this.language.getString("Common.priority.priority3"));
                this.prio4Item.setText(UploadPanel.this.language.getString("Common.priority.priority4"));
                this.prio5Item.setText(UploadPanel.this.language.getString("Common.priority.priority5"));
                this.prio6Item.setText(UploadPanel.this.language.getString("Common.priority.priority6"));
                this.removeFromGqItem.setText(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.removeFromGlobalQueue"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.copyKeysItem) {
                CopyToClipboard.copyKeys(UploadPanel.this.modelTable.getSelectedItems());
            } else if (e.getSource() == this.copyKeysAndNamesItem) {
                CopyToClipboard.copyKeysAndFilenames(UploadPanel.this.modelTable.getSelectedItems());
            } else if (e.getSource() == this.copyExtendedInfoItem) {
                CopyToClipboard.copyExtendedInfo(UploadPanel.this.modelTable.getSelectedItems());
            } else if (e.getSource() == this.removeSelectedFilesItem) {
                UploadPanel.this.removeSelectedFiles();
            } else if (e.getSource() == this.uploadSelectedFilesItem) {
                this.uploadSelectedFiles();
            } else if (e.getSource() == this.generateChkForSelectedFilesItem) {
                this.generateChkForSelectedFiles();
            } else if (e.getSource() == this.showSharedFileItem) {
                UploadPanel.this.uploadTableDoubleClick(null);
            } else if (e.getSource() == this.prio0Item) {
                this.changePriority(0);
            } else if (e.getSource() == this.prio1Item) {
                this.changePriority(1);
            } else if (e.getSource() == this.prio2Item) {
                this.changePriority(2);
            } else if (e.getSource() == this.prio3Item) {
                this.changePriority(3);
            } else if (e.getSource() == this.prio4Item) {
                this.changePriority(4);
            } else if (e.getSource() == this.prio5Item) {
                this.changePriority(5);
            } else if (e.getSource() == this.prio6Item) {
                this.changePriority(6);
            } else if (e.getSource() == this.removeFromGqItem) {
                this.removeSelectedUploadsFromGlobalQueue();
            } else if (e.getSource() == this.enableAllDownloadsItem) {
                this.enableAllDownloads();
            } else if (e.getSource() == this.disableAllDownloadsItem) {
                this.disableAllDownloads();
            } else if (e.getSource() == this.enableSelectedDownloadsItem) {
                this.enableSelectedDownloads();
            } else if (e.getSource() == this.disableSelectedDownloadsItem) {
                this.disableSelectedDownloads();
            } else if (e.getSource() == this.invertEnabledAllItem) {
                this.invertEnabledAll();
            } else if (e.getSource() == this.invertEnabledSelectedItem) {
                this.invertEnabledSelected();
            } else if (e.getSource() == this.startSelectedUploadsNow) {
                this.startSelectedUploadsNow();
            }
        }

        private void removeSelectedUploadsFromGlobalQueue() {
            if (FileTransferManager.inst().getPersistenceManager() == null) {
                return;
            }
            ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
            ArrayList<String> requestsToRemove = new ArrayList<String>();
            ArrayList<FrostUploadItem> itemsToUpdate = new ArrayList<FrostUploadItem>();
            for (ModelItem mi : selectedItems) {
                FrostUploadItem item = (FrostUploadItem)mi;
                if (!FileTransferManager.inst().getPersistenceManager().isItemInGlobalQueue(item)) continue;
                requestsToRemove.add(item.getGqIdentifier());
                itemsToUpdate.add(item);
                item.setInternalRemoveExpected(true);
            }
            FileTransferManager.inst().getPersistenceManager().removeRequests(requestsToRemove);
            for (FrostUploadItem item : itemsToUpdate) {
                item.setState(7);
                item.setEnabled(false);
                item.setPriority(-1);
                item.fireValueChanged();
            }
        }

        private void changePriority(int prio) {
            if (FileTransferManager.inst().getPersistenceManager() != null) {
                ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
                FileTransferManager.inst().getPersistenceManager().changeItemPriorites(selectedItems, prio);
            }
        }

        private void generateChkForSelectedFiles() {
            ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
            UploadPanel.this.model.generateChkItems(selectedItems);
        }

        private void startSelectedUploadsNow() {
            ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
            LinkedList<FrostUploadItem> itemsToStart = new LinkedList<FrostUploadItem>();
            for (ModelItem mi : selectedItems) {
                FrostUploadItem i = (FrostUploadItem)mi;
                if (i.isExternal() || i.getState() != 7) continue;
                itemsToStart.add(i);
            }
            for (FrostUploadItem ulItem : itemsToStart) {
                ulItem.setEnabled(true);
                FileTransferManager.inst().getUploadManager().startUpload(ulItem);
            }
        }

        private void uploadSelectedFiles() {
            ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
            UploadPanel.this.model.uploadItems(selectedItems);
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        private void invertEnabledSelected() {
            ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
            UploadPanel.this.model.setItemsEnabled(null, selectedItems);
        }

        private void invertEnabledAll() {
            UploadPanel.this.model.setAllItemsEnabled(null);
        }

        private void disableSelectedDownloads() {
            ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
            UploadPanel.this.model.setItemsEnabled(Boolean.FALSE, selectedItems);
        }

        private void enableSelectedDownloads() {
            ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
            UploadPanel.this.model.setItemsEnabled(Boolean.TRUE, selectedItems);
        }

        private void disableAllDownloads() {
            UploadPanel.this.model.setAllItemsEnabled(Boolean.FALSE);
        }

        private void enableAllDownloads() {
            UploadPanel.this.model.setAllItemsEnabled(Boolean.TRUE);
        }

        public void show(Component invoker, int x, int y) {
            FrostUploadItem item;
            this.removeAll();
            ModelItem[] selectedItems = UploadPanel.this.modelTable.getSelectedItems();
            if (selectedItems.length == 0) {
                return;
            }
            this.add(this.copyToClipboardMenu);
            this.addSeparator();
            if (FileTransferManager.inst().getPersistenceManager() != null) {
                this.add(this.changePriorityMenu);
                this.addSeparator();
            }
            JMenu enabledSubMenu = new JMenu(UploadPanel.this.language.getString("UploadPane.fileTable.popupmenu.enableUploads") + "...");
            enabledSubMenu.add(this.enableSelectedDownloadsItem);
            enabledSubMenu.add(this.disableSelectedDownloadsItem);
            enabledSubMenu.add(this.invertEnabledSelectedItem);
            enabledSubMenu.addSeparator();
            enabledSubMenu.add(this.enableAllDownloadsItem);
            enabledSubMenu.add(this.disableAllDownloadsItem);
            enabledSubMenu.add(this.invertEnabledAllItem);
            this.add(enabledSubMenu);
            this.add(this.startSelectedUploadsNow);
            this.add(this.generateChkForSelectedFilesItem);
            this.add(this.uploadSelectedFilesItem);
            this.addSeparator();
            this.add(this.removeSelectedFilesItem);
            if (FileTransferManager.inst().getPersistenceManager() != null && selectedItems != null) {
                for (ModelItem mi : selectedItems) {
                    FrostUploadItem item2 = (FrostUploadItem)mi;
                    if (!FileTransferManager.inst().getPersistenceManager().isItemInGlobalQueue(item2)) continue;
                    this.add(this.removeFromGqItem);
                    break;
                }
            }
            if (selectedItems.length == 1 && (item = (FrostUploadItem)selectedItems[0]).isSharedFile()) {
                this.addSeparator();
                this.add(this.showSharedFileItem);
            }
            super.show(invoker, x, y);
        }
    }
}

