/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.Core;
import frost.fcp.FcpHandler;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.util.CopyToClipboardItem;
import frost.util.model.ModelItem;
import java.io.File;

public class FrostUploadItem
extends ModelItem
implements CopyToClipboardItem {
    public static final int STATE_DONE = 1;
    public static final int STATE_PROGRESS = 4;
    public static final int STATE_ENCODING_REQUESTED = 5;
    public static final int STATE_ENCODING = 6;
    public static final int STATE_WAITING = 7;
    public static final int STATE_FAILED = 8;
    private File file = null;
    private long fileSize = 0L;
    private String chkKey = null;
    private Boolean enabled = Boolean.TRUE;
    private int state;
    private long uploadAddedMillis = 0L;
    private long uploadStartedMillis = 0L;
    private long uploadFinishedMillis = 0L;
    private int retries = 0;
    private long lastUploadStopTimeMillis = 0L;
    private String gqIdentifier = null;
    private boolean isLoggedToFile = false;
    private int totalBlocks = -1;
    private int doneBlocks = -1;
    private Boolean isFinalized = null;
    private String errorCodeDescription = null;
    private int priority = -1;
    private FrostSharedFileItem sharedFileItem = null;
    private boolean isExternal = false;
    private transient boolean internalRemoveExpected = false;
    private transient boolean stateShouldBeProgress = false;

    public FrostUploadItem() {
    }

    public FrostUploadItem(File newFile) {
        this.file = newFile;
        this.fileSize = this.file.length();
        this.gqIdentifier = this.buildGqIdentifier(this.file.getName());
        this.uploadAddedMillis = System.currentTimeMillis();
        this.state = 7;
    }

    public FrostUploadItem(File newFile, long newFilesize, String newKey, boolean newIsEnabled, int newState, long newUploadAdded, long newUploadStarted, long newUploadFinished, int newRetries, long newLastUploadStopTimeMillis, String newGqIdentifier, boolean newIsLoggedToFile) {
        this.file = newFile;
        this.fileSize = newFilesize;
        this.chkKey = newKey;
        this.enabled = newIsEnabled;
        this.state = newState;
        this.uploadAddedMillis = newUploadAdded;
        this.uploadStartedMillis = newUploadStarted;
        this.uploadFinishedMillis = newUploadFinished;
        this.retries = newRetries;
        this.lastUploadStopTimeMillis = newLastUploadStopTimeMillis;
        this.gqIdentifier = newGqIdentifier;
        this.isLoggedToFile = newIsLoggedToFile;
        if (this.state == 4) {
            if (!this.isSharedFile()) {
                this.stateShouldBeProgress = true;
            }
            this.state = 7;
        } else if (this.state == 6 || this.state == 5) {
            this.state = 7;
        }
    }

    public boolean isSharedFile() {
        return this.getSharedFileItem() != null;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long newFileSize) {
        this.fileSize = newFileSize;
        this.fireChange();
    }

    public String getKey() {
        return this.chkKey;
    }

    public void setKey(String newKey) {
        this.chkKey = newKey;
        this.fireChange();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        this.state = newState;
        this.fireChange();
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public void setTotalBlocks(int newTotalBlocks) {
        this.totalBlocks = newTotalBlocks;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int newRetries) {
        this.retries = newRetries;
        this.fireChange();
    }

    public int getDoneBlocks() {
        return this.doneBlocks;
    }

    public void setDoneBlocks(int newDoneBlocks) {
        this.doneBlocks = newDoneBlocks;
    }

    public void setEnabled(Boolean newEnabled) {
        if (newEnabled == null && this.enabled != null) {
            boolean temp = this.enabled;
            newEnabled = !temp;
        }
        this.enabled = newEnabled;
        this.fireChange();
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public long getLastUploadStopTimeMillis() {
        return this.lastUploadStopTimeMillis;
    }

    public void setLastUploadStopTimeMillis(long lastUploadStopTimeMillis) {
        this.lastUploadStopTimeMillis = lastUploadStopTimeMillis;
    }

    public long getUploadAddedMillis() {
        return this.uploadAddedMillis;
    }

    public long getUploadStartedMillis() {
        return this.uploadStartedMillis;
    }

    public void setUploadStartedMillis(long v) {
        this.uploadStartedMillis = v;
        this.fireChange();
    }

    public long getUploadFinishedMillis() {
        return this.uploadFinishedMillis;
    }

    public void setUploadFinishedMillis(long v) {
        this.uploadFinishedMillis = v;
        this.fireChange();
    }

    public String getGqIdentifier() {
        return this.gqIdentifier;
    }

    public void setGqIdentifier(String i) {
        this.gqIdentifier = i;
    }

    public FrostSharedFileItem getSharedFileItem() {
        return this.sharedFileItem;
    }

    public void setSharedFileItem(FrostSharedFileItem sharedFileItem) {
        this.sharedFileItem = sharedFileItem;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public Boolean isFinalized() {
        return this.isFinalized;
    }

    public void setFinalized(boolean finalized) {
        this.isFinalized = finalized ? Boolean.TRUE : Boolean.FALSE;
    }

    public void fireValueChanged() {
        super.fireChange();
    }

    private String buildGqIdentifier(String filename) {
        if (FcpHandler.isFreenet07()) {
            return "Frost-" + filename.replace(' ', '_') + "-" + System.currentTimeMillis() + Core.getCrypto().getSecureRandom().nextInt(10);
        }
        return null;
    }

    public String getErrorCodeDescription() {
        return this.errorCodeDescription;
    }

    public void setErrorCodeDescription(String errorCodeDescription) {
        this.errorCodeDescription = errorCodeDescription;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean e) {
        this.isExternal = e;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        super.fireChange();
    }

    public boolean isInternalRemoveExpected() {
        return this.internalRemoveExpected;
    }

    public void setInternalRemoveExpected(boolean internalRemoveExpected) {
        this.internalRemoveExpected = internalRemoveExpected;
    }

    public String toString() {
        return this.getFilename();
    }

    public boolean isLoggedToFile() {
        return this.isLoggedToFile;
    }

    public void setLoggedToFile(boolean isLoggedToFile) {
        this.isLoggedToFile = isLoggedToFile;
    }

    public boolean isStateShouldBeProgress() {
        return this.stateShouldBeProgress;
    }
}

