/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.fcp.fcp05.FcpRequest;
import frost.fileTransfer.FileTransferInformation;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.DownloadPanel;
import frost.fileTransfer.download.DownloadTableFormat;
import frost.fileTransfer.download.DownloadTicker;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.filelist.FileListStorage;
import frost.util.FileAccess;
import frost.util.Mixed;
import frost.util.model.ModelItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadManager
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(DownloadManager.class.getName());
    private DownloadModel model;
    private DownloadPanel panel;
    private DownloadTicker ticker;
    private static final Comparator<FrostDownloadItem> nextItemCmp = new Comparator<FrostDownloadItem>(){

        @Override
        public int compare(FrostDownloadItem value1, FrostDownloadItem value2) {
            int blocksTodo2;
            int cmp1 = Mixed.compareLong(value1.getDownloadAddedMillis(), value2.getDownloadAddedMillis());
            if (cmp1 != 0) {
                return cmp1;
            }
            int blocksTodo1 = value1.getRequiredBlocks() > 0 && value1.getDoneBlocks() > 0 ? value1.getRequiredBlocks() - value1.getDoneBlocks() : Integer.MAX_VALUE;
            int cmp2 = Mixed.compareInt(blocksTodo1, blocksTodo2 = value2.getRequiredBlocks() > 0 && value2.getDoneBlocks() > 0 ? value2.getRequiredBlocks() - value2.getDoneBlocks() : Integer.MAX_VALUE);
            if (cmp2 != 0) {
                return cmp2;
            }
            return Mixed.compareLong(value1.getFileSize(), value2.getFileSize());
        }
    };

    public void initialize() throws StorageException {
        this.getPanel();
        this.getModel().initialize();
        if (FcpHandler.isFreenet05()) {
            for (int x = 0; x < this.getModel().getItemCount(); ++x) {
                FrostDownloadItem item = (FrostDownloadItem)this.getModel().getItemAt(x);
                FcpRequest.updateProgress(item);
            }
        }
    }

    public boolean startDownload(FrostDownloadItem dlItem) {
        if (FileTransferManager.inst().getPersistenceManager() != null) {
            return FileTransferManager.inst().getPersistenceManager().startDownload(dlItem);
        }
        return this.ticker.startDownload(dlItem);
    }

    public void startTicker() {
        if (Core.isFreenetOnline()) {
            this.getTicker().start();
        }
    }

    @Override
    public void exitSave() throws StorageException {
        this.getPanel().getTableFormat().saveTableLayout();
        this.getModel().exitSave();
    }

    public void addPanelToMainFrame(MainFrame mainFrame) {
        mainFrame.addPanel("MainFrame.tabbedPane.downloads", this.getPanel());
    }

    public void updateFileTransferInformation(FileTransferInformation infos) {
        int waitingItems = 0;
        int runningItems = 0;
        for (int x = 0; x < this.model.getItemCount(); ++x) {
            FrostDownloadItem dlItem = (FrostDownloadItem)this.model.getItemAt(x);
            if (dlItem == null) continue;
            if (dlItem.getState() != 3 && dlItem.getState() != 4) {
                ++waitingItems;
            }
            if (dlItem.getState() != 5) continue;
            ++runningItems;
        }
        infos.setDownloadsRunning(runningItems);
        infos.setDownloadsWaiting(waitingItems);
    }

    public String ensureUniqueFilename(String filename) {
        boolean loopAgain;
        String newFilename = filename;
        int count = 2;
        do {
            loopAgain = false;
            for (int x = 0; x < this.getModel().getItemCount(); ++x) {
                FrostDownloadItem dlItem = (FrostDownloadItem)this.getModel().getItemAt(x);
                if (!dlItem.getFilename().equalsIgnoreCase(newFilename)) continue;
                loopAgain = true;
                int pos = filename.lastIndexOf(46);
                if (pos > 0) {
                    String beforeDot = filename.substring(0, pos);
                    String afterDot = filename.substring(pos);
                    newFilename = beforeDot + "_" + count++ + afterDot;
                    continue;
                }
                newFilename = filename + "_" + count++;
            }
        } while (loopAgain);
        return newFilename;
    }

    public DownloadPanel getPanel() {
        if (this.panel == null) {
            this.panel = new DownloadPanel();
            this.panel.setModel(this.getModel());
            this.panel.initialize();
        }
        return this.panel;
    }

    public DownloadModel getModel() {
        if (this.model == null) {
            this.model = new DownloadModel(new DownloadTableFormat());
        }
        return this.model;
    }

    private DownloadTicker getTicker() {
        if (this.ticker == null) {
            this.ticker = new DownloadTicker(this.getPanel());
        }
        return this.ticker;
    }

    public void addNewDownload(String key, String fileName) {
        FrostDownloadItem dlItem = new FrostDownloadItem(fileName, key);
        this.model.addDownloadItem(dlItem);
    }

    public boolean notifyDownloadFinished(FrostDownloadItem downloadItem, FcpResultGet result, File targetFile) {
        String filename = downloadItem.getFilename();
        String key = downloadItem.getKey();
        boolean retryImmediately = false;
        if (result == null || !result.isSuccess()) {
            if (result != null) {
                downloadItem.setErrorCodeDescription(result.getCodeDescription());
            }
            if (result != null && FcpHandler.isFreenet07() && result.getReturnCode() == 5 && key.startsWith("CHK@") && key.indexOf("/") > 0) {
                String newKey = key.substring(0, key.indexOf("/"));
                downloadItem.setKey(newKey);
                downloadItem.setState(1);
                downloadItem.setLastDownloadStopTime(0L);
                downloadItem.setInternalRemoveExpected(true);
                retryImmediately = true;
                logger.warning("Removed all path levels from key: " + key + " ; " + newKey);
            } else if (result != null && FcpHandler.isFreenet07() && result.getReturnCode() == 11 && key.startsWith("CHK@") && key.indexOf("/") > 0) {
                String newKey = key.substring(0, key.lastIndexOf("/"));
                downloadItem.setKey(newKey);
                downloadItem.setState(1);
                downloadItem.setLastDownloadStopTime(0L);
                downloadItem.setInternalRemoveExpected(true);
                retryImmediately = true;
                logger.warning("Removed one path level from key: " + key + " ; " + newKey);
            } else if (result != null && FcpHandler.isFreenet07() && result.getReturnCode() == 27 && result.getRedirectURI() != null) {
                downloadItem.setKey(result.getRedirectURI());
                downloadItem.setState(1);
                downloadItem.setInternalRemoveExpected(true);
                retryImmediately = true;
                logger.warning("Redirected to URI: " + result.getRedirectURI());
            } else if (result != null && result.isFatal()) {
                downloadItem.setState(4);
                logger.warning("FILEDN: Download of " + filename + " failed FATALLY.");
            } else {
                downloadItem.setRetries(downloadItem.getRetries() + 1);
                logger.warning("FILEDN: Download of " + filename + " failed.");
                if (downloadItem.getRetries() > Core.frostSettings.getIntValue("downloadMaxRetries")) {
                    downloadItem.setState(4);
                } else {
                    downloadItem.setState(1);
                }
            }
        } else {
            logger.info("FILEDN: Download of " + filename + " was successful.");
            downloadItem.setFileSize(new Long(targetFile.length()));
            downloadItem.setState(3);
            downloadItem.setEnabled(false);
            downloadItem.setDownloadFinishedTime(System.currentTimeMillis());
            if (downloadItem.isSharedFile()) {
                FileListStorage.inst().updateFrostFileListFileObjectAfterDownload(downloadItem.getFileListFileObject().getSha(), System.currentTimeMillis());
            }
            if (Core.frostSettings.getBoolValue("logDownloads") && !downloadItem.isLoggedToFile()) {
                String line = downloadItem.getKey() + "/" + downloadItem.getFilename();
                String fileName = Core.frostSettings.getValue("localdata.dir") + "Frost-Downloads.log";
                File targetLogFile = new File(fileName);
                FileAccess.appendLineToTextfile(targetLogFile, line);
                downloadItem.setLoggedToFile(true);
            }
            if (Core.frostSettings.getBoolValue("removeFinishedDownloads")) {
                FileTransferManager.inst().getDownloadManager().getModel().removeFinishedDownloads();
            }
        }
        if (retryImmediately) {
            downloadItem.setLastDownloadStopTime(-1L);
        } else {
            downloadItem.setLastDownloadStopTime(System.currentTimeMillis());
        }
        return retryImmediately;
    }

    public List<FrostDownloadItem> getDownloadItemList() {
        return this.getModel().getItems();
    }

    public FrostDownloadItem selectNextDownloadItem() {
        ArrayList<FrostDownloadItem> waitingItems = new ArrayList<FrostDownloadItem>();
        for (int i = 0; i < this.model.getItemCount(); ++i) {
            boolean itemIsEnabled;
            FrostDownloadItem dlItem = (FrostDownloadItem)this.model.getItemAt(i);
            boolean bl = itemIsEnabled = dlItem.isEnabled() == null ? true : dlItem.isEnabled();
            if (!itemIsEnabled || dlItem.isExternal() || dlItem.getKey() == null || dlItem.getState() != 1) continue;
            long waittimeMillis = (long)Core.frostSettings.getIntValue("downloadWaittime") * 60L * 1000L;
            if (dlItem.getLastDownloadStopTime() != 0L && System.currentTimeMillis() - dlItem.getLastDownloadStopTime() <= waittimeMillis) continue;
            waitingItems.add(dlItem);
        }
        if (waitingItems.size() == 0) {
            return null;
        }
        if (waitingItems.size() > 1) {
            Collections.sort(waitingItems, nextItemCmp);
        }
        return (FrostDownloadItem)waitingItems.get(0);
    }

    public void notifyDownloadItemEnabledStateChanged(FrostDownloadItem dlItem) {
        boolean itemIsEnabled;
        if (FileTransferManager.inst().getPersistenceManager() == null) {
            return;
        }
        if (dlItem.isExternal()) {
            return;
        }
        if (dlItem.getState() != 5) {
            return;
        }
        boolean bl = itemIsEnabled = dlItem.isEnabled() == null ? true : dlItem.isEnabled();
        if (itemIsEnabled) {
            int prio = Core.frostSettings.getIntValue("fcp2.defaultPriorityFileDownload");
            FileTransferManager.inst().getPersistenceManager().changeItemPriorites(new ModelItem[]{dlItem}, prio);
        } else {
            FileTransferManager.inst().getPersistenceManager().changeItemPriorites(new ModelItem[]{dlItem}, 6);
        }
    }
}

