/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.common;

import frost.Core;
import frost.fileTransfer.common.FileListFileDetailsItem;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.gui.RatingStringProvider;
import frost.identities.Identity;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.SortedModelTable;
import frost.util.model.SortedTableFormat;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FileListFileDetailsTableFormat
extends SortedTableFormat
implements LanguageListener {
    private static final String CFGKEY_SORTSTATE_SORTEDCOLUMN = "FileListFileDetailsDialog.sortState.sortedColumn";
    private static final String CFGKEY_SORTSTATE_SORTEDASCENDING = "FileListFileDetailsDialog.sortState.sortedAscending";
    private static final String CFGKEY_COLUMN_TABLEINDEX = "FileListFileDetailsDialog.tableindex.modelcolumn.";
    private static final String CFGKEY_COLUMN_WIDTH = "FileListFileDetailsDialog.columnwidth.modelcolumn.";
    private String stateNever;
    private String unknown;
    private final Language language = Language.getInstance();
    private static ImageIcon ICON_GOOD = null;
    private static ImageIcon ICON_OBSERVE = null;
    private static ImageIcon ICON_CHECK = null;
    private static ImageIcon ICON_BAD = null;
    private static final int COLUMN_COUNT = 9;
    private final boolean showColoredLines;

    public FileListFileDetailsTableFormat() {
        super(9);
        this.refreshLanguage();
        this.setComparator(new FileNameComparator(), 0);
        this.setComparator(new OwnerComparator(), 1);
        this.setComparator(new IdentityStateComparator(), 2);
        this.setComparator(new RatingComparator(), 3);
        this.setComparator(new CommentComparator(), 4);
        this.setComparator(new KeywordsComparator(), 5);
        this.setComparator(new LastUploadedComparator(), 6);
        this.setComparator(new LastReceivedComparator(), 7);
        this.setComparator(new KeyComparator(), 8);
        this.loadIcons();
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
    }

    private void loadIcons() {
        if (ICON_GOOD == null) {
            ICON_GOOD = MiscToolkit.getScaledImage("/data/toolbar/weather-clear.png", 12, 12);
            ICON_OBSERVE = MiscToolkit.getScaledImage("/data/toolbar/weather-few-clouds.png", 12, 12);
            ICON_CHECK = MiscToolkit.getScaledImage("/data/toolbar/weather-overcast.png", 12, 12);
            ICON_BAD = MiscToolkit.getScaledImage("/data/toolbar/weather-storm.png", 12, 12);
        }
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("FileListFileDetailsDialog.table.filename"));
        this.setColumnName(1, this.language.getString("FileListFileDetailsDialog.table.owner"));
        this.setColumnName(2, this.language.getString("FileListFileDetailsDialog.table.trustState"));
        this.setColumnName(3, this.language.getString("FileListFileDetailsDialog.table.rating"));
        this.setColumnName(4, this.language.getString("FileListFileDetailsDialog.table.comment"));
        this.setColumnName(5, this.language.getString("FileListFileDetailsDialog.table.keywords"));
        this.setColumnName(6, this.language.getString("FileListFileDetailsDialog.table.lastUploaded"));
        this.setColumnName(7, this.language.getString("FileListFileDetailsDialog.table.lastReceived"));
        this.setColumnName(8, this.language.getString("FileListFileDetailsDialog.table.key"));
        this.stateNever = this.language.getString("FileListFileDetailsDialog.table.state.never");
        this.unknown = this.language.getString("FileListFileDetailsDialog.table.state.unknown");
        this.refreshColumnNames();
    }

    public Object getCellValue(ModelItem item, int columnIndex) {
        if (item == null) {
            return "*null*";
        }
        FileListFileDetailsItem detailsItem = (FileListFileDetailsItem)item;
        switch (columnIndex) {
            case 0: {
                return detailsItem.getFileOwner().getName();
            }
            case 1: {
                return detailsItem.getFileOwner().getOwner();
            }
            case 2: {
                return detailsItem.getOwnerIdentity();
            }
            case 3: {
                return RatingStringProvider.getRatingString(detailsItem.getFileOwner().getRating());
            }
            case 4: {
                return detailsItem.getDisplayComment();
            }
            case 5: {
                return detailsItem.getDisplayKeywords();
            }
            case 6: {
                if (detailsItem.getDisplayLastUploaded().length() == 0) {
                    return this.stateNever;
                }
                return detailsItem.getDisplayLastUploaded();
            }
            case 7: {
                if (detailsItem.getDisplayLastReceived().length() == 0) {
                    return this.stateNever;
                }
                return detailsItem.getDisplayLastReceived();
            }
            case 8: {
                if (detailsItem.getKey() == null) {
                    return this.unknown;
                }
                return detailsItem.getKey();
            }
        }
        return "**ERROR**";
    }

    public int[] getColumnNumbers(int fieldID) {
        return new int[0];
    }

    public void customizeTable(ModelTable table) {
        super.customizeTable(table);
        SortedModelTable modelTable = (SortedModelTable)table;
        modelTable.getTable().setAutoResizeMode(1);
        if (Core.frostSettings.getBoolValue("saveSortStates") && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDCOLUMN) != null && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDASCENDING) != null) {
            int sortedColumn = Core.frostSettings.getIntValue(CFGKEY_SORTSTATE_SORTEDCOLUMN);
            boolean isSortedAsc = Core.frostSettings.getBoolValue(CFGKEY_SORTSTATE_SORTEDASCENDING);
            if (sortedColumn > -1) {
                modelTable.setSortedColumn(sortedColumn, isSortedAsc);
            }
        } else {
            modelTable.setSortedColumn(7, false);
        }
        TableColumnModel columnModel = modelTable.getTable().getColumnModel();
        ShowContentTooltipRenderer showContentTooltipRenderer = new ShowContentTooltipRenderer();
        ShowColoredLinesRenderer showColoredLinesRenderer = new ShowColoredLinesRenderer();
        columnModel.getColumn(0).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(1).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(2).setCellRenderer(new IdentityStateRenderer());
        columnModel.getColumn(3).setCellRenderer(showColoredLinesRenderer);
        columnModel.getColumn(4).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(5).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(6).setCellRenderer(showColoredLinesRenderer);
        columnModel.getColumn(7).setCellRenderer(showColoredLinesRenderer);
        columnModel.getColumn(8).setCellRenderer(showContentTooltipRenderer);
        if (!this.loadTableLayout(columnModel)) {
            int[] widths = new int[]{150, 80, 20, 20, 80, 80, 55, 55, 55};
            for (int i = 0; i < widths.length; ++i) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
            }
        }
    }

    public void saveTableLayout(ModelTable table) {
        SortedModelTable modelTable = (SortedModelTable)table;
        TableColumnModel tcm = modelTable.getTable().getColumnModel();
        for (int columnIndexInTable = 0; columnIndexInTable < tcm.getColumnCount(); ++columnIndexInTable) {
            TableColumn tc = tcm.getColumn(columnIndexInTable);
            int columnIndexInModel = tc.getModelIndex();
            Core.frostSettings.setValue(CFGKEY_COLUMN_TABLEINDEX + columnIndexInModel, columnIndexInTable);
            int columnWidth = tc.getWidth();
            Core.frostSettings.setValue(CFGKEY_COLUMN_WIDTH + columnIndexInModel, columnWidth);
        }
        if (Core.frostSettings.getBoolValue("saveSortStates") && modelTable.getSortedColumn() > -1) {
            int sortedColumn = modelTable.getSortedColumn();
            boolean isSortedAsc = modelTable.isSortedAscending();
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDCOLUMN, sortedColumn);
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDASCENDING, isSortedAsc);
        }
    }

    private boolean loadTableLayout(TableColumnModel tcm) {
        int[] tableToModelIndex = new int[tcm.getColumnCount()];
        int[] columnWidths = new int[tcm.getColumnCount()];
        for (int x = 0; x < tableToModelIndex.length; ++x) {
            String indexKey = CFGKEY_COLUMN_TABLEINDEX + x;
            if (Core.frostSettings.getObjectValue(indexKey) == null) {
                return false;
            }
            int tableIndex = Core.frostSettings.getIntValue(indexKey);
            if (tableIndex < 0 || tableIndex >= tableToModelIndex.length) {
                return false;
            }
            tableToModelIndex[tableIndex] = x;
            String widthKey = CFGKEY_COLUMN_WIDTH + x;
            if (Core.frostSettings.getObjectValue(widthKey) == null) {
                return false;
            }
            int columnWidth = Core.frostSettings.getIntValue(widthKey);
            if (columnWidth <= 0) {
                return false;
            }
            columnWidths[x] = columnWidth;
        }
        TableColumn[] tcms = new TableColumn[tcm.getColumnCount()];
        for (int x = tcms.length - 1; x >= 0; --x) {
            tcms[x] = tcm.getColumn(x);
            tcm.removeColumn(tcms[x]);
            tcms[x].setPreferredWidth(columnWidths[x]);
        }
        for (int element : tableToModelIndex) {
            tcm.addColumn(tcms[element]);
        }
        return true;
    }

    private class ShowColoredLinesRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, FileListFileDetailsTableFormat.this.showColoredLines);
                this.setBackground(newBackground);
            } else {
                this.setBackground(table.getSelectionBackground());
            }
            return this;
        }
    }

    private class IdentityStateRenderer
    extends ShowColoredLinesRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Identity id = (Identity)value;
            if (id == null) {
                this.setIcon(null);
            } else if (id.isGOOD()) {
                this.setIcon(ICON_GOOD);
            } else if (id.isOBSERVE()) {
                this.setIcon(ICON_OBSERVE);
            } else if (id.isCHECK()) {
                this.setIcon(ICON_CHECK);
            } else if (id.isBAD()) {
                this.setIcon(ICON_BAD);
            } else {
                this.setIcon(null);
            }
            this.setText("");
            return this;
        }
    }

    private class ShowContentTooltipRenderer
    extends ShowColoredLinesRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            if (value != null && (tooltip = value.toString()).length() == 0) {
                tooltip = null;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyComparator
    implements Comparator<FileListFileDetailsItem> {
        private KeyComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem o1, FileListFileDetailsItem o2) {
            String key1 = o1.getKey();
            String key2 = o2.getKey();
            if (key1 == null) {
                key1 = FileListFileDetailsTableFormat.this.unknown;
            }
            if (key2 == null) {
                key2 = FileListFileDetailsTableFormat.this.unknown;
            }
            return key1.compareToIgnoreCase(key2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastReceivedComparator
    implements Comparator<FileListFileDetailsItem> {
        private LastReceivedComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem o1, FileListFileDetailsItem o2) {
            long val1 = o1.getFileOwner().getLastReceived();
            long val2 = o2.getFileOwner().getLastReceived();
            return new Long(val1).compareTo(new Long(val2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastUploadedComparator
    implements Comparator<FileListFileDetailsItem> {
        private LastUploadedComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem o1, FileListFileDetailsItem o2) {
            long val1 = o1.getFileOwner().getLastUploaded();
            long val2 = o2.getFileOwner().getLastUploaded();
            return new Long(val1).compareTo(new Long(val2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeywordsComparator
    implements Comparator<FileListFileDetailsItem> {
        private KeywordsComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem item1, FileListFileDetailsItem item2) {
            return item1.getDisplayKeywords().compareToIgnoreCase(item2.getDisplayKeywords());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommentComparator
    implements Comparator<FileListFileDetailsItem> {
        private CommentComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem item1, FileListFileDetailsItem item2) {
            return item1.getDisplayComment().compareToIgnoreCase(item2.getDisplayComment());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RatingComparator
    implements Comparator<FileListFileDetailsItem> {
        private RatingComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem o1, FileListFileDetailsItem o2) {
            int val1 = o1.getFileOwner().getRating();
            int val2 = o2.getFileOwner().getRating();
            return new Long(val1).compareTo(new Long(val2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IdentityStateComparator
    implements Comparator<FileListFileDetailsItem> {
        private IdentityStateComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem item1, FileListFileDetailsItem item2) {
            Integer i1 = new Integer(item1.getOwnerIdentity().getState());
            Integer i2 = new Integer(item2.getOwnerIdentity().getState());
            return i1.compareTo(i2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnerComparator
    implements Comparator<FileListFileDetailsItem> {
        private OwnerComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem item1, FileListFileDetailsItem item2) {
            return item1.getFileOwner().getOwner().compareToIgnoreCase(item2.getFileOwner().getOwner());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileNameComparator
    implements Comparator<FileListFileDetailsItem> {
        private FileNameComparator() {
        }

        @Override
        public int compare(FileListFileDetailsItem item1, FileListFileDetailsItem item2) {
            return item1.getFileOwner().getName().compareToIgnoreCase(item2.getFileOwner().getName());
        }
    }
}

