/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.fileTransfer.upload.GenerateShaThread;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.FrostFilesStorage;
import frost.storage.perst.NewUploadFile;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewUploadFilesManager
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(NewUploadFilesManager.class.getName());
    private LinkedList<NewUploadFile> newUploadFiles;
    private GenerateShaThread generateShaThread;

    public void initialize() throws StorageException {
        try {
            this.newUploadFiles = FrostFilesStorage.inst().loadNewUploadFiles();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error loading new upload files", e);
            throw new StorageException("Error loading new upload files");
        }
        this.generateShaThread = new GenerateShaThread();
    }

    public void start() {
        this.generateShaThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitSave() throws StorageException {
        LinkedList<NewUploadFile> linkedList = this.newUploadFiles;
        synchronized (linkedList) {
            try {
                FrostFilesStorage.inst().saveNewUploadFiles(this.newUploadFiles);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Error saving new upload files", e);
                throw new StorageException("Error saving new upload files");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewUploadFiles(List<NewUploadFile> newFiles) {
        LinkedList<NewUploadFile> linkedList = this.newUploadFiles;
        synchronized (linkedList) {
            for (NewUploadFile nuf : newFiles) {
                this.newUploadFiles.add(nuf);
                this.generateShaThread.addToFileQueue(nuf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNewUploadFile(NewUploadFile nuf) {
        LinkedList<NewUploadFile> linkedList = this.newUploadFiles;
        synchronized (linkedList) {
            this.newUploadFiles.remove(nuf);
        }
    }
}

