/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.fileTransfer.FrostFileListFileObjectOwner;
import frost.fileTransfer.SharedFileXmlFile;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.identities.Identity;
import frost.storage.perst.filelist.FileListStorage;
import frost.util.DateFun;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.garret.perst.IPersistentList;
import org.garret.perst.Persistent;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrostFileListFileObject
extends Persistent {
    private static final Logger logger = Logger.getLogger(FrostFileListFileObject.class.getName());
    private String sha = null;
    private long size = 0L;
    private String key = null;
    private long lastDownloaded = 0L;
    private long lastUploaded = 0L;
    private long firstReceived = 0L;
    private long lastReceived = 0L;
    private long requestLastReceived = 0L;
    private int requestsReceivedCount = 0;
    private long requestLastSent = 0L;
    private int requestsSentCount = 0;
    private boolean isHidden = false;
    private IPersistentList<FrostFileListFileObjectOwner> frostFileListFileObjectOwnerList;
    private transient String displayName = null;
    private transient String displayComment = null;
    private transient String displayKeywords = null;
    private transient int displayRating = -1;
    private transient Boolean hasInfosFromMultipleSources = null;
    private transient List<FrostDownloadItem> listeners;
    private static MutableInt defaultMutableInt = new MutableInt();

    public FrostFileListFileObject(String newSha1, long newSize, String newKey, long newLastDownloaded, long newLastUploaded, long newFirstReceived, long newLastReceived, long newRequestLastReceived, int newRequestsReceivedCount, long newRequestLastSent, int newRequestSentCount) {
        this.sha = newSha1;
        this.size = newSize;
        this.key = newKey;
        this.lastDownloaded = newLastDownloaded;
        this.lastUploaded = newLastUploaded;
        this.firstReceived = newFirstReceived;
        this.lastReceived = newLastReceived;
        this.requestLastReceived = newRequestLastReceived;
        this.requestsReceivedCount = newRequestsReceivedCount;
        this.requestLastSent = newRequestLastSent;
        this.requestsSentCount = newRequestSentCount;
    }

    public FrostFileListFileObject(SharedFileXmlFile sfo, Identity owner, long timestamp) {
        this.sha = sfo.getSha();
        this.size = sfo.getSize();
        this.key = sfo.getKey();
        this.lastDownloaded = 0L;
        this.firstReceived = timestamp;
        this.lastReceived = timestamp;
        long lastUploadDate = 0L;
        if (sfo.getKey() != null && sfo.getLastUploaded() != null) {
            try {
                DateTime dt = DateFun.FORMAT_DATE.parseDateTime(sfo.getLastUploaded());
                lastUploadDate = dt.getMillis();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, " error parsing file last uploaded date", t);
            }
        }
        this.lastUploaded = lastUploadDate;
        FrostFileListFileObjectOwner ob = new FrostFileListFileObjectOwner(sfo.getFilename(), owner.getUniqueName(), sfo.getComment(), sfo.getKeywords(), sfo.getRating(), timestamp, lastUploadDate, sfo.getKey());
        this.addFrostFileListFileObjectOwner(ob);
    }

    private IPersistentList<FrostFileListFileObjectOwner> getFrostFileListFileObjectOwnerList() {
        if (this.frostFileListFileObjectOwnerList == null) {
            this.frostFileListFileObjectOwnerList = FileListStorage.inst().createList();
        }
        return this.frostFileListFileObjectOwnerList;
    }

    public void addFrostFileListFileObjectOwner(FrostFileListFileObjectOwner v) {
        v.setFileListFileObject(this);
        this.getFrostFileListFileObjectOwnerList().add(v);
    }

    public void deleteFrostFileListFileObjectOwner(FrostFileListFileObjectOwner v) {
        this.getFrostFileListFileObjectOwnerList().remove(v);
    }

    public Iterator<FrostFileListFileObjectOwner> getFrostFileListFileObjectOwnerIterator() {
        return this.getFrostFileListFileObjectOwnerList().iterator();
    }

    public int getFrostFileListFileObjectOwnerListSize() {
        return this.getFrostFileListFileObjectOwnerList().size();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.notifyListeners();
    }

    public long getLastDownloaded() {
        return this.lastDownloaded;
    }

    public void setLastDownloaded(long lastDownloaded) {
        this.lastDownloaded = lastDownloaded;
    }

    public long getLastUploaded() {
        return this.lastUploaded;
    }

    public void setLastUploaded(long lastUploaded) {
        this.lastUploaded = lastUploaded;
        this.notifyListeners();
    }

    public long getLastReceived() {
        return this.lastReceived;
    }

    public void setLastReceived(long lastReceived) {
        this.lastReceived = lastReceived;
        this.notifyListeners();
    }

    public String getSha() {
        return this.sha;
    }

    public long getSize() {
        return this.size;
    }

    public long getRequestLastReceived() {
        return this.requestLastReceived;
    }

    public void setRequestLastReceived(long requestLastReceived) {
        this.requestLastReceived = requestLastReceived;
        this.notifyListeners();
    }

    public long getRequestLastSent() {
        return this.requestLastSent;
    }

    public void setRequestLastSent(long requestLastSent) {
        this.requestLastSent = requestLastSent;
        this.notifyListeners();
    }

    public int getRequestsReceivedCount() {
        return this.requestsReceivedCount;
    }

    public void setRequestsReceivedCount(int requestsReceivedCount) {
        this.requestsReceivedCount = requestsReceivedCount;
    }

    public int getRequestsSentCount() {
        return this.requestsSentCount;
    }

    public void setRequestsSentCount(int requestsSentCount) {
        this.requestsSentCount = requestsSentCount;
    }

    public long getFirstReceived() {
        return this.firstReceived;
    }

    public void setFirstReceived(long v) {
        this.firstReceived = v;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            IPersistentList<FrostFileListFileObjectOwner> lst = this.getFrostFileListFileObjectOwnerList();
            if (lst == null || lst.size() == 0) {
                this.displayName = "(no sources)";
            } else {
                Hashtable<String, MutableInt> ht = new Hashtable<String, MutableInt>();
                for (FrostFileListFileObjectOwner e : lst) {
                    MutableInt mi = (MutableInt)ht.get(e.getName());
                    if (mi == null) {
                        mi = new MutableInt();
                        mi.name = e.getName();
                        mi.i = 1;
                        ht.put(e.getName(), mi);
                        continue;
                    }
                    ++mi.i;
                }
                MutableInt bestMi = defaultMutableInt;
                for (MutableInt mi : ht.values()) {
                    if (mi.i <= bestMi.i) continue;
                    bestMi = mi;
                }
                this.displayName = bestMi.name;
            }
        }
        return this.displayName;
    }

    public Boolean hasInfosFromMultipleSources() {
        if (this.hasInfosFromMultipleSources == null) {
            if (this.getFrostFileListFileObjectOwnerList().size() > 1) {
                int valuesCount = 0;
                for (FrostFileListFileObjectOwner o : this.getFrostFileListFileObjectOwnerList()) {
                    if (o.getComment() != null && o.getComment().length() > 0) {
                        ++valuesCount;
                    } else if (o.getKeywords() != null && o.getKeywords().length() > 0) {
                        ++valuesCount;
                    } else if (o.getRating() > 0) {
                        ++valuesCount;
                    }
                    if (valuesCount <= 1) continue;
                    this.hasInfosFromMultipleSources = Boolean.TRUE;
                    break;
                }
                if (this.hasInfosFromMultipleSources == null) {
                    this.hasInfosFromMultipleSources = Boolean.FALSE;
                }
            } else {
                this.hasInfosFromMultipleSources = Boolean.FALSE;
            }
        }
        return this.hasInfosFromMultipleSources;
    }

    public String getDisplayComment() {
        if (this.displayComment == null) {
            IPersistentList<FrostFileListFileObjectOwner> lst = this.getFrostFileListFileObjectOwnerList();
            if (lst == null || lst.size() == 0) {
                this.displayComment = "(no sources)";
            } else {
                Hashtable<String, MutableInt> ht = new Hashtable<String, MutableInt>();
                for (FrostFileListFileObjectOwner e : lst) {
                    String c = e.getComment();
                    if (c == null || c.length() == 0) continue;
                    MutableInt mi = (MutableInt)ht.get(c);
                    if (mi == null) {
                        mi = new MutableInt();
                        mi.name = c;
                        mi.i = 1;
                        ht.put(c, mi);
                        continue;
                    }
                    ++mi.i;
                }
                MutableInt bestMi = defaultMutableInt;
                for (MutableInt mi : ht.values()) {
                    if (mi.i <= bestMi.i) continue;
                    bestMi = mi;
                }
                this.displayComment = bestMi.name;
            }
        }
        return this.displayComment;
    }

    public String getDisplayKeywords() {
        if (this.displayKeywords == null) {
            IPersistentList<FrostFileListFileObjectOwner> lst = this.getFrostFileListFileObjectOwnerList();
            if (lst == null || lst.size() == 0) {
                this.displayKeywords = "(no sources)";
            } else {
                Hashtable<String, MutableInt> ht = new Hashtable<String, MutableInt>();
                for (FrostFileListFileObjectOwner e : lst) {
                    String c = e.getKeywords();
                    if (c == null || c.length() == 0) continue;
                    MutableInt mi = (MutableInt)ht.get(c);
                    if (mi == null) {
                        mi = new MutableInt();
                        mi.name = c;
                        mi.i = 1;
                        ht.put(c, mi);
                        continue;
                    }
                    ++mi.i;
                }
                MutableInt bestMi = defaultMutableInt;
                for (MutableInt mi : ht.values()) {
                    if (mi.i <= bestMi.i) continue;
                    bestMi = mi;
                }
                this.displayKeywords = bestMi.name;
            }
        }
        return this.displayKeywords;
    }

    public int getDisplayRating() {
        if (this.displayRating < 0) {
            IPersistentList<FrostFileListFileObjectOwner> lst = this.getFrostFileListFileObjectOwnerList();
            if (lst == null || lst.size() == 0) {
                return 0;
            }
            int[] ratings = new int[6];
            for (FrostFileListFileObjectOwner e : lst) {
                int r = e.getRating();
                if (r < 1 || r > 5) continue;
                int n = r;
                ratings[n] = ratings[n] + 1;
            }
            int bestRating = 0;
            for (int x = 1; x < ratings.length; ++x) {
                if (ratings[x] <= bestRating) continue;
                bestRating = x;
            }
            this.displayRating = bestRating;
        }
        return this.displayRating;
    }

    public void addListener(FrostDownloadItem d) {
        if (!this.getListeners().contains(d)) {
            this.getListeners().add(d);
        }
    }

    public void removeListener(FrostDownloadItem d) {
        if (this.getListeners().contains(d)) {
            this.getListeners().remove(d);
        }
    }

    public List<FrostDownloadItem> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<FrostDownloadItem>();
        }
        return this.listeners;
    }

    private void notifyListeners() {
        for (FrostDownloadItem dl : this.getListeners()) {
            dl.fireValueChanged();
        }
    }

    static class MutableInt {
        public int i = 0;
        public String name = "";
        public int rating = 0;

        MutableInt() {
        }
    }
}

