/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07.filepersistence;

import frost.fcp.fcp07.NodeMessage;
import frost.fcp.fcp07.filepersistence.FcpPersistentRequest;

public class FcpPersistentGet
extends FcpPersistentRequest {
    private boolean isDirect = false;
    private String filename = null;
    private String uri = null;
    private int doneBlocks = -1;
    private int requiredBlocks = -1;
    private int totalBlocks = -1;
    private boolean isFinalized = false;
    private long filesize = -1L;
    private String redirectURI = null;

    public FcpPersistentGet(NodeMessage msg, String id) {
        super(msg, id);
        this.filename = msg.getStringValue("Filename");
        this.uri = msg.getStringValue("URI");
        String isDirectStr = msg.getStringValue("ReturnType");
        this.isDirect = !isDirectStr.equalsIgnoreCase("disk");
    }

    public boolean isPut() {
        return false;
    }

    public void setProgress(NodeMessage msg) {
        this.doneBlocks = msg.getIntValue("Succeeded");
        this.requiredBlocks = msg.getIntValue("Required");
        this.totalBlocks = msg.getIntValue("Total");
        this.isFinalized = msg.getBoolValue("FinalizedTotal");
        super.setProgress();
    }

    public void setSuccess(NodeMessage msg) {
        this.filesize = msg.getLongValue("DataLength");
        super.setSuccess();
    }

    public void setFailed(NodeMessage msg) {
        super.setFailed(msg);
        this.redirectURI = msg.getStringValue("RedirectURI");
    }

    public int getDoneBlocks() {
        return this.doneBlocks;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }

    public int getRequiredBlocks() {
        return this.requiredBlocks;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public String getUri() {
        return this.uri;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }
}

