/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07;

import frost.Core;
import frost.ext.DefaultMIMETypes;
import frost.fcp.fcp07.FcpMultiRequestConnection;
import frost.fcp.fcp07.FcpSocket;
import frost.fcp.fcp07.NodeMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpMultiRequestConnectionTools {
    private static final Logger logger = Logger.getLogger(FcpMultiRequestConnectionTools.class.getName());
    private final FcpMultiRequestConnection fcpPersistentConnection;

    public FcpMultiRequestConnectionTools(FcpMultiRequestConnection fcpPersistentConnection) {
        this.fcpPersistentConnection = fcpPersistentConnection;
    }

    public FcpMultiRequestConnection getFcpPersistentConnection() {
        return this.fcpPersistentConnection;
    }

    public void changeRequestPriority(String id, int newPrio) {
        LinkedList<String> msg = new LinkedList<String>();
        msg.add("ModifyPersistentRequest");
        msg.add("Global=true");
        msg.add("Identifier=" + id);
        msg.add("PriorityClass=" + Integer.toString(newPrio));
        this.fcpPersistentConnection.sendMessage(msg, true);
    }

    public void removeRequest(String id) {
        LinkedList<String> msg = new LinkedList<String>();
        msg.add("RemovePersistentRequest");
        msg.add("Global=true");
        msg.add("Identifier=" + id);
        this.fcpPersistentConnection.sendMessage(msg, true);
    }

    public void watchGlobal(boolean enabled) {
        LinkedList<String> msg = new LinkedList<String>();
        msg.add("WatchGlobal");
        msg.add("Enabled=" + enabled);
        msg.add("VerbosityMask=1");
        this.fcpPersistentConnection.sendMessage(msg, true);
    }

    public void startPersistentPut(String id, File sourceFile, boolean doMime, boolean setTargetFileName) {
        List<String> msg = this.getDefaultPutMessage(id, sourceFile, doMime, setTargetFileName);
        msg.add("UploadFrom=disk");
        msg.add("Filename=" + sourceFile.getAbsolutePath());
        this.fcpPersistentConnection.sendMessage(msg, true);
    }

    public boolean isDDA() {
        return this.fcpPersistentConnection.isDDA();
    }

    public void startPersistentGet(String key, String id, File targetFile) {
        LinkedList<String> msg = new LinkedList<String>();
        msg.add("ClientGet");
        msg.add("IgnoreDS=false");
        msg.add("DSOnly=false");
        msg.add("URI=" + key);
        msg.add("Identifier=" + id);
        msg.add("MaxRetries=-1");
        msg.add("Verbosity=-1");
        msg.add("Persistence=forever");
        msg.add("Global=true");
        int prio = Core.frostSettings.getIntValue("fcp2.defaultPriorityFileDownload");
        msg.add("PriorityClass=" + Integer.toString(prio));
        if (this.isDDA()) {
            msg.add("ReturnType=disk");
            msg.add("Filename=" + targetFile.getAbsolutePath());
            File ddaTempFile = new File(targetFile.getAbsolutePath() + "-f");
            if (ddaTempFile.isFile()) {
                ddaTempFile.delete();
            }
            msg.add("TempFilename=" + ddaTempFile.getAbsolutePath());
        } else {
            msg.add("ReturnType=direct");
        }
        this.fcpPersistentConnection.sendMessage(msg, true);
    }

    public void listPersistentRequests() {
        LinkedList<String> msg = new LinkedList<String>();
        msg.add("ListPersistentRequests");
        this.fcpPersistentConnection.sendMessage(msg, true);
    }

    private List<String> getDefaultPutMessage(String id, File sourceFile, boolean doMime, boolean setTargetFileName) {
        LinkedList<String> lst = new LinkedList<String>();
        lst.add("ClientPut");
        lst.add("URI=CHK@");
        lst.add("Identifier=" + id);
        lst.add("Verbosity=-1");
        lst.add("MaxRetries=-1");
        lst.add("DontCompress=false");
        if (setTargetFileName) {
            lst.add("TargetFilename=" + sourceFile.getName());
        } else {
            lst.add("TargetFilename=");
        }
        if (doMime) {
            lst.add("Metadata.ContentType=" + DefaultMIMETypes.guessMIMEType(sourceFile.getAbsolutePath()));
        } else {
            lst.add("Metadata.ContentType=application/octet-stream");
        }
        int prio = Core.frostSettings.getIntValue("fcp2.defaultPriorityFileUpload");
        lst.add("PriorityClass=" + Integer.toString(prio));
        lst.add("Persistence=forever");
        lst.add("Global=true");
        return lst;
    }

    public NodeMessage startDirectPersistentPut(String id, File sourceFile, boolean doMime, boolean setTargetFileName) throws IOException {
        int d;
        FcpSocket newSocket = FcpSocket.create(this.fcpPersistentConnection.getNodeAddress());
        if (newSocket == null) {
            return null;
        }
        BufferedOutputStream dataOutput = new BufferedOutputStream(newSocket.getFcpSock().getOutputStream());
        List<String> msg = this.getDefaultPutMessage(id, sourceFile, doMime, setTargetFileName);
        msg.add("UploadFrom=direct");
        msg.add("DataLength=" + Long.toString(sourceFile.length()));
        msg.add("Data");
        for (String line : msg) {
            newSocket.getFcpOut().println(line);
        }
        newSocket.getFcpOut().flush();
        BufferedInputStream fileInput = new BufferedInputStream(new FileInputStream(sourceFile));
        while ((d = fileInput.read()) >= 0) {
            dataOutput.write(d);
        }
        fileInput.close();
        dataOutput.flush();
        NodeMessage nodeMsg = NodeMessage.readMessage(newSocket.getFcpIn());
        System.out.println("*PPUT** INFO - NodeMessage:");
        System.out.println(nodeMsg == null ? "(null)" : nodeMsg.toString());
        dataOutput.close();
        newSocket.close();
        return nodeMsg;
    }

    public NodeMessage startDirectPersistentGet(String id, File targetFile) throws IOException {
        FcpSocket newSocket = FcpSocket.create(this.fcpPersistentConnection.getNodeAddress());
        if (newSocket == null) {
            return null;
        }
        newSocket.getFcpOut().println("GetRequestStatus");
        newSocket.getFcpOut().println("Global=true");
        newSocket.getFcpOut().println("Identifier=" + id);
        newSocket.getFcpOut().println("OnlyData=true");
        newSocket.getFcpOut().println("EndMessage");
        newSocket.getFcpOut().flush();
        NodeMessage nodeMsg = NodeMessage.readMessage(newSocket.getFcpIn());
        if (nodeMsg == null) {
            return null;
        }
        System.out.println("*PGET** INFO - NodeMessage:");
        System.out.println(nodeMsg.toString());
        String endMarker = nodeMsg.getMessageEnd();
        if (endMarker == null) {
            logger.severe("*PGET** ENDMARKER is NULL! " + nodeMsg.toString());
            return null;
        }
        if (nodeMsg.isMessageName("AllData") && endMarker.equals("Data")) {
            int count;
            long dataLength = nodeMsg.getLongValue("DataLength");
            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[4096];
            long bytesLeft = dataLength;
            long bytesWritten = 0L;
            while (bytesLeft > 0L && (count = newSocket.getFcpIn().read(b, 0, bytesLeft > (long)b.length ? b.length : (int)bytesLeft)) >= 0) {
                bytesLeft -= (long)count;
                fileOut.write(b, 0, count);
                bytesWritten += (long)count;
            }
            fileOut.close();
            System.out.println("*GET** Wrote " + bytesWritten + " of " + dataLength + " bytes to file.");
            newSocket.close();
            if (bytesWritten == dataLength) {
                return nodeMsg;
            }
            return null;
        }
        logger.severe("Invalid node answer, expected AllData: " + nodeMsg);
        newSocket.close();
        return null;
    }

    public void startDirectGet(String id, String key, int priority, int maxSize, int maxRetries) {
        LinkedList<String> msg = new LinkedList<String>();
        msg.add("ClientGet");
        msg.add("IgnoreDS=false");
        msg.add("DSOnly=false");
        msg.add("URI=" + key);
        msg.add("Identifier=" + id);
        if (maxRetries <= 0) {
            maxRetries = 1;
        }
        msg.add("MaxRetries=" + Integer.toString(maxRetries));
        msg.add("Verbosity=0");
        msg.add("ReturnType=direct");
        msg.add("Persistence=connection");
        msg.add("PriorityClass=" + Integer.toString(priority));
        if (maxSize > 0) {
            msg.add("MaxSize=" + maxSize);
        }
        this.fcpPersistentConnection.sendMessage(msg, true);
    }

    public void startDirectPut(String id, String key, int priority, File sourceFile) {
        LinkedList<String> msg = new LinkedList<String>();
        msg.add("ClientPut");
        msg.add("URI=" + key);
        msg.add("Identifier=" + id);
        msg.add("Verbosity=0");
        msg.add("MaxRetries=1");
        msg.add("DontCompress=false");
        msg.add("PriorityClass=" + Integer.toString(priority));
        msg.add("Persistence=connection");
        msg.add("UploadFrom=direct");
        msg.add("DataLength=" + Long.toString(sourceFile.length()));
        this.fcpPersistentConnection.sendMessageAndData(msg, true, sourceFile);
    }
}

