/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import frost.fcp.NodeAddress;
import frost.fcp.fcp05.FcpConnection;
import frost.util.Mixed;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpFactory {
    private static final Logger logger = Logger.getLogger(FcpFactory.class.getName());
    private static List<NodeAddress> nodes = new ArrayList<NodeAddress>();
    private static Random random = new Random();

    public static FcpConnection getFcpConnectionInstance() throws ConnectException {
        FcpConnection connection = null;
        int maxTries = FcpFactory.getNodes().size() == 1 ? 3 : FcpFactory.getNodes().size() * 2;
        int tries = 0;
        while (connection == null && tries < maxTries) {
            try {
                connection = FcpFactory.getConnection();
            }
            catch (UnknownHostException e) {
                logger.severe("FcpConnection.getFcpConnectionInstance: UnknownHostException " + e);
                break;
            }
            catch (ConnectException e) {
                logger.warning("FcpConnection.getFcpConnectionInstance: java.net.ConnectException " + e + " , this was try " + (tries + 1) + "/" + maxTries);
            }
            catch (IOException e) {
                logger.warning("FcpConnection.getFcpConnectionInstance: IOException " + e + " , this was try " + (tries + 1) + "/" + maxTries);
            }
            catch (Throwable e) {
                logger.severe("FcpConnection.getFcpConnectionInstance: Throwable " + e);
                break;
            }
            Mixed.wait(++tries * 1250);
        }
        if (connection == null) {
            logger.warning("ERROR: FcpConnection.getFcpConnectionInstance: Could not connect to node!");
            throw new ConnectException("Could not connect to FCP node.");
        }
        return connection;
    }

    public static List<NodeAddress> getNodes() {
        return nodes;
    }

    protected static NodeAddress selectNode() {
        int size = nodes.size();
        if (size == 0) {
            throw new Error("All connections to nodes failed. Check your network settings and restart Frost.");
        }
        if (size == 1) {
            return nodes.get(0);
        }
        return nodes.get(random.nextInt(nodes.size()));
    }

    public static void init(List<String> nodeList) {
        for (String element : nodeList) {
            NodeAddress na;
            block8: {
                int port;
                InetAddress ia;
                String nodeName = element;
                if (nodeName.indexOf(":") < 0) {
                    InetAddress ia2 = null;
                    try {
                        ia2 = InetAddress.getByName(nodeName);
                        na = new NodeAddress(ia2, 8481, ia2.getHostName(), ia2.getHostAddress());
                        break block8;
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, "Unknown FCP host: " + nodeName, t);
                        continue;
                    }
                }
                String[] splitNodeName = nodeName.split(":");
                try {
                    ia = InetAddress.getByName(splitNodeName[0]);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Unknown FCP host: " + nodeName, t);
                    continue;
                }
                try {
                    port = Integer.parseInt(splitNodeName[1]);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Unknown FCP port: " + nodeName, t);
                    continue;
                }
                na = new NodeAddress(ia, port, ia.getHostName(), ia.getHostAddress());
            }
            nodes.add(na);
        }
        logger.info("Frost will use " + nodes.size() + " Freenet nodes");
    }

    protected static synchronized FcpConnection getConnection() throws IOException, Error {
        FcpConnection con = null;
        if (FcpFactory.getNodes().size() == 0) {
            throw new Error("No Freenet nodes available.  You need at least one.");
        }
        NodeAddress selectedNode = FcpFactory.selectNode();
        logger.info("Using node " + selectedNode.getHost().getHostAddress() + " port " + selectedNode.getPort());
        con = new FcpConnection(selectedNode);
        return con;
    }
}

