/*
 * Decompiled with CFR 0.152.
 */
package frost.crypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public final class FrostCrypt {
    private static final Logger logger = Logger.getLogger(FrostCrypt.class.getName());
    private PSSSigner signer;
    private SecureRandom secureRandom = null;
    private KeyGenerator keyGeneratorAES = null;

    public FrostCrypt() {
        Security.addProvider(new BouncyCastleProvider());
        this.signer = new PSSSigner(new RSAEngine(), new SHA1Digest(), 16);
        try {
            this.secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.secureRandom = new SecureRandom();
        }
    }

    public synchronized String[] generateKeys() {
        RSAKeyPairGenerator keygen = new RSAKeyPairGenerator();
        keygen.init(new RSAKeyGenerationParameters(new BigInteger("3490529510847650949147849619903898133417764638493387843990820577"), this.getSecureRandom(), 1024, 80));
        AsymmetricCipherKeyPair keys = keygen.generateKeyPair();
        RSAKeyParameters pubKey = (RSAKeyParameters)keys.getPublic();
        RSAPrivateCrtKeyParameters privKey = (RSAPrivateCrtKeyParameters)keys.getPrivate();
        String[] result = new String[2];
        StringBuilder temp = new StringBuilder();
        temp.append(new String(Base64.encode(pubKey.getExponent().toByteArray())));
        temp.append(":");
        temp.append(new String(Base64.encode(pubKey.getModulus().toByteArray())));
        result[1] = temp.toString();
        temp = new StringBuilder();
        temp.append(new String(Base64.encode(privKey.getModulus().toByteArray())));
        temp.append(":");
        temp.append(new String(Base64.encode(privKey.getPublicExponent().toByteArray())));
        temp.append(":");
        temp.append(new String(Base64.encode(privKey.getExponent().toByteArray())));
        temp.append(":");
        temp.append(new String(Base64.encode(privKey.getP().toByteArray())));
        temp.append(":");
        temp.append(new String(Base64.encode(privKey.getQ().toByteArray())));
        temp.append(":");
        temp.append(new String(Base64.encode(privKey.getDP().toByteArray())));
        temp.append(":");
        temp.append(new String(Base64.encode(privKey.getDQ().toByteArray())));
        temp.append(":");
        temp.append(new String(Base64.encode(privKey.getQInv().toByteArray())));
        result[0] = temp.toString();
        return result;
    }

    public synchronized String digest(String message) {
        try {
            SHA1Digest stomach = new SHA1Digest();
            stomach.reset();
            byte[] food = message.getBytes("UTF-8");
            stomach.update(food, 0, food.length);
            byte[] poop = new byte[64];
            stomach.doFinal(poop, 0);
            return new String(Base64.encode(poop)).substring(0, 27);
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "UTF-8 encoding is not supported.", ex);
            return null;
        }
    }

    public synchronized String digest(File file) {
        SHA1Digest stomach = new SHA1Digest();
        byte[] poop = new byte[64];
        FileChannel chan = null;
        try {
            chan = new FileInputStream(file).getChannel();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in digest(File file)", e);
        }
        byte[] temp = new byte[4096];
        ByteBuffer _temp = ByteBuffer.wrap(temp);
        try {
            while (true) {
                int pos = _temp.position();
                int read = chan.read(_temp);
                if (read == -1) break;
                stomach.update(temp, pos, read);
                if (_temp.remaining() != 0) continue;
                _temp.position(0);
            }
            chan.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in digest(File file)", e);
        }
        stomach.doFinal(poop, 0);
        return new String(Base64.encode(poop)).substring(0, 27);
    }

    public synchronized String encrypt(String what, String publicKey) {
        try {
            byte[] whatBytes = what.getBytes("UTF-8");
            byte[] encryptedBytes = this.encrypt(whatBytes, publicKey);
            String result = new String(Base64.encode(encryptedBytes), "ISO-8859-1");
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "UTF-8 encoding is not supported.", ex);
            return null;
        }
    }

    public synchronized byte[] encrypt(byte[] what, String publicKey) {
        byte[] aesKeyBytes = null;
        Cipher cipherAES = null;
        Cipher cipherRSA = null;
        int cipherRSAinSize = 0;
        int cipherRSAoutSize = 0;
        aesKeyBytes = this.generateAESSessionKey();
        if (aesKeyBytes == null) {
            return null;
        }
        cipherAES = this.buildCipherAES(1, aesKeyBytes);
        if (cipherAES == null) {
            return null;
        }
        try {
            StringTokenizer keycutter = new StringTokenizer(publicKey, ":");
            BigInteger Exponent = new BigInteger(Base64.decode(keycutter.nextToken()));
            BigInteger Modulus = new BigInteger(Base64.decode(keycutter.nextToken()));
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(Modulus, Exponent);
            KeyFactory fact = KeyFactory.getInstance("RSA", "BC");
            PublicKey pubKey = fact.generatePublic(pubKeySpec);
            cipherRSA = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipherRSA.init(1, pubKey);
            cipherRSAinSize = cipherRSA.getBlockSize();
            cipherRSAoutSize = cipherRSA.getOutputSize(cipherRSAinSize);
            if (cipherRSAinSize != 117 || cipherRSAoutSize != 128) {
                throw new Exception("block size invalid, inSize=" + cipherRSAinSize + "; outSize=" + cipherRSAoutSize);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error in encrypt, RSA preparation", t);
            return null;
        }
        byte[] rsaEncData = null;
        try {
            byte[] rsaInpData = new byte[cipherRSAinSize];
            byte[] randomBytes = new byte[cipherRSAinSize - aesKeyBytes.length];
            this.getSecureRandom().nextBytes(randomBytes);
            System.arraycopy(aesKeyBytes, 0, rsaInpData, 0, aesKeyBytes.length);
            System.arraycopy(randomBytes, 0, rsaInpData, aesKeyBytes.length, randomBytes.length);
            rsaEncData = cipherRSA.doFinal(rsaInpData, 0, rsaInpData.length);
            if (rsaEncData.length != cipherRSAoutSize) {
                throw new Exception("RSA out block size invalid: " + rsaEncData.length);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error in encrypt, RSA encryption", t);
            return null;
        }
        ByteArrayOutputStream plainOut = new ByteArrayOutputStream(what.length + what.length / 10 + rsaEncData.length);
        try {
            plainOut.write(rsaEncData);
            CipherOutputStream cOut = new CipherOutputStream(plainOut, cipherAES);
            cOut.write(what);
            cOut.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error in encrypt, AES encryption", e);
            return null;
        }
        return plainOut.toByteArray();
    }

    public synchronized String decrypt(String what, String privateKey) {
        try {
            byte[] encBytes = Base64.decode(what.getBytes("ISO-8859-1"));
            byte[] decBytes = this.decrypt(encBytes, privateKey);
            return new String(decBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "UTF-8 encoding is not supported.", ex);
            return null;
        }
    }

    public synchronized byte[] decrypt(byte[] what, String privateKey) {
        Cipher cipherAES = null;
        Cipher cipherRSA = null;
        int cipherRSAinSize = 0;
        int cipherRSAoutSize = 0;
        try {
            StringTokenizer keycutter = new StringTokenizer(privateKey, ":");
            RSAPrivateCrtKeySpec privKeySpec = new RSAPrivateCrtKeySpec(new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())));
            KeyFactory fact = KeyFactory.getInstance("RSA", "BC");
            PrivateKey privKey = fact.generatePrivate(privKeySpec);
            cipherRSA = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipherRSA.init(2, privKey);
            cipherRSAinSize = cipherRSA.getBlockSize();
            cipherRSAoutSize = cipherRSA.getOutputSize(cipherRSAinSize);
            if (cipherRSAinSize != 128 || cipherRSAoutSize != 117) {
                throw new Exception("RSA decryption block size invalid, inSize=" + cipherRSAinSize + "; outSize=" + cipherRSAoutSize);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error in decrypt, RSA preparation", e);
            return null;
        }
        byte[] aesKeyBytes = null;
        try {
            byte[] sessionKeyBytes = cipherRSA.doFinal(what, 0, cipherRSAinSize);
            if (sessionKeyBytes == null) {
                throw new Exception("RSA decryption failed, sessionKeyBytes = null");
            }
            if (sessionKeyBytes.length != cipherRSAoutSize) {
                throw new Exception("RSA decryption failed, sessionKeyBytes.length = " + sessionKeyBytes.length + ", must be " + cipherRSAoutSize);
            }
            aesKeyBytes = new byte[16];
            System.arraycopy(sessionKeyBytes, 0, aesKeyBytes, 0, aesKeyBytes.length);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error in decrypt, RSA decryption", e);
            return null;
        }
        cipherAES = this.buildCipherAES(2, aesKeyBytes);
        if (cipherAES == null) {
            return null;
        }
        ByteArrayOutputStream plainOut = new ByteArrayOutputStream(what.length - cipherRSAinSize);
        ByteArrayInputStream bIn = new ByteArrayInputStream(what, cipherRSAinSize, what.length - cipherRSAinSize);
        CipherInputStream cIn = new CipherInputStream(bIn, cipherAES);
        try {
            int bLen;
            byte[] buf = new byte[1024];
            while ((bLen = cIn.read(buf)) >= 0) {
                plainOut.write(buf, 0, bLen);
            }
            cIn.close();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error in decrypt, AES decryption", e);
            return null;
        }
        return plainOut.toByteArray();
    }

    public synchronized String detachedSign(String message, String key) {
        try {
            byte[] msgBytes = message.getBytes("UTF-8");
            return this.detachedSign(msgBytes, key);
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "UTF-8 encoding is not supported.", ex);
            return null;
        }
    }

    public synchronized String detachedSign(byte[] message, String key) {
        StringTokenizer keycutter = new StringTokenizer(key, ":");
        RSAPrivateCrtKeyParameters privKey = new RSAPrivateCrtKeyParameters(new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())), new BigInteger(Base64.decode(keycutter.nextToken())));
        this.signer.init(true, privKey);
        this.signer.update(message, 0, message.length);
        byte[] signature = null;
        try {
            signature = this.signer.generateSignature();
        }
        catch (CryptoException e) {
            logger.log(Level.SEVERE, "Exception thrown in detachedSign(String message, String key)", e);
        }
        this.signer.reset();
        try {
            String result = new String(Base64.encode(signature), "ISO-8859-1");
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "ISO-8859-1 encoding is not supported.", ex);
            return null;
        }
    }

    public synchronized boolean detachedVerify(String message, String key, String sig) {
        try {
            byte[] msgBytes = message.getBytes("UTF-8");
            return this.detachedVerify(msgBytes, key, sig);
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "UTF-8 encoding is not supported.", ex);
            return false;
        }
    }

    public synchronized boolean detachedVerify(byte[] message, String key, String _sig) {
        try {
            byte[] sig = Base64.decode(_sig.getBytes("ISO-8859-1"));
            StringTokenizer keycutter = new StringTokenizer(key, ":");
            BigInteger Exponent = new BigInteger(Base64.decode(keycutter.nextToken()));
            BigInteger Modulus = new BigInteger(Base64.decode(keycutter.nextToken()));
            this.signer.init(false, new RSAKeyParameters(true, Modulus, Exponent));
            this.signer.update(message, 0, message.length);
            boolean result = this.signer.verifySignature(sig);
            this.signer.reset();
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "ISO-8859-1 encoding is not supported.", ex);
            return false;
        }
    }

    public synchronized SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public String decode64(String what) {
        try {
            byte[] whatBytes = what.getBytes("ISO-8859-1");
            return new String(Base64.decode(whatBytes), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "UTF-8 or ISO-8859-1 encoding is not supported.", ex);
            return null;
        }
    }

    public String encode64(String what) {
        try {
            byte[] whatBytes = what.getBytes("UTF-8");
            return new String(Base64.encode(whatBytes), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "UTF-8 or ISO-8859-1 encoding is not supported.", ex);
            return null;
        }
    }

    private byte[] generateAESSessionKey() {
        if (this.keyGeneratorAES == null) {
            try {
                this.keyGeneratorAES = KeyGenerator.getInstance("AES");
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.SEVERE, "Could not get a KeyGenerator for AES.", e);
                return null;
            }
            this.keyGeneratorAES.init(128);
        }
        SecretKey skey = this.keyGeneratorAES.generateKey();
        byte[] keyBytes = skey.getEncoded();
        return keyBytes;
    }

    private Cipher buildCipherAES(int mode, byte[] aesKey) {
        Cipher cipherAES = null;
        try {
            if (aesKey == null) {
                return null;
            }
            SecretKeySpec sessionKey = new SecretKeySpec(aesKey, "AES");
            cipherAES = Cipher.getInstance("AES", "BC");
            cipherAES.init(mode, sessionKey);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error in AES preparation", t);
            return null;
        }
        return cipherAES;
    }

    public String computeChecksumSHA256(String message) {
        try {
            byte[] food = message.getBytes("UTF-8");
            return this.computeChecksumSHA256(food);
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "UTF-8 encoding is not supported.", ex);
            return null;
        }
    }

    public String computeChecksumSHA256(byte[] message) {
        try {
            byte[] food = message;
            MessageDigest sha256 = MessageDigest.getInstance("SHA256", "BC");
            sha256.update(food);
            byte[] poop = sha256.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < poop.length; ++i) {
                sb.append(Integer.toString((poop[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, "Algorithm SHA256 not supported.", ex);
        }
        catch (NoSuchProviderException ex) {
            logger.log(Level.SEVERE, "Provider BC not supported.", ex);
        }
        return null;
    }

    public String computeChecksumSHA256(File file) {
        try {
            FileChannel chan = null;
            try {
                chan = new FileInputStream(file).getChannel();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Exception thrown 1", e);
                return null;
            }
            MessageDigest sha256 = MessageDigest.getInstance("SHA256", "BC");
            byte[] temp = new byte[4096];
            ByteBuffer _temp = ByteBuffer.wrap(temp);
            try {
                while (true) {
                    int pos = _temp.position();
                    int read = chan.read(_temp);
                    if (read == -1) break;
                    sha256.update(temp, pos, read);
                    if (_temp.remaining() != 0) continue;
                    _temp.position(0);
                }
                chan.close();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Exception thrown 2", e);
            }
            byte[] poop = sha256.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < poop.length; ++i) {
                sb.append(Integer.toString((poop[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, "Algorithm SHA256 not supported.", ex);
        }
        catch (NoSuchProviderException ex) {
            logger.log(Level.SEVERE, "Provider BC not supported.", ex);
        }
        return null;
    }
}

