/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.MainFrame;
import frost.boards.Board;
import frost.util.DateFun;
import frost.util.FormatterUtils;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardUpdateInformation {
    private final Board board;
    private final String dateString;
    private final long dateMillis;
    private int countTriedIndices = 0;
    private int currentIndex = -1;
    private int maxIndex = -1;
    private int maxSuccessfulIndex = -1;
    private int countADNF = 0;
    private int countDNF = 0;
    private int countInvalid = 0;
    private int countValid = 0;
    private long nodeTime = 0L;
    private int subsequentInvalidMsgs = 0;
    private Boolean isBoardUpdateAllowed = null;

    public BoardUpdateInformation(Board newBoard, String newDateString, long newDateMillis) {
        this.board = newBoard;
        this.dateString = newDateString;
        this.dateMillis = newDateMillis;
    }

    public int getCountTriedIndices() {
        return this.countTriedIndices;
    }

    public void incCountTriedIndices() {
        ++this.countTriedIndices;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
        if (this.maxIndex < currentIndex) {
            this.maxIndex = currentIndex;
        }
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMaxSuccessfulIndex() {
        return this.maxSuccessfulIndex;
    }

    public void updateMaxSuccessfulIndex(int lMaxSuccessfulIndex) {
        if (this.maxSuccessfulIndex < lMaxSuccessfulIndex) {
            this.maxSuccessfulIndex = lMaxSuccessfulIndex;
        }
    }

    public int getCountADNF() {
        return this.countADNF;
    }

    public void incCountADNF() {
        ++this.countADNF;
        this.incSubsequentInvalidMsgs();
    }

    public int getCountDNF() {
        return this.countDNF;
    }

    public void incCountDNF() {
        ++this.countDNF;
    }

    public int getCountInvalid() {
        return this.countInvalid;
    }

    public void incCountInvalid() {
        ++this.countInvalid;
        this.incSubsequentInvalidMsgs();
    }

    public int getCountValid() {
        return this.countValid;
    }

    public void incCountValid() {
        ++this.countValid;
        this.resetSubsequentInvalidMsgs();
    }

    public String getDateString() {
        return this.dateString;
    }

    public long getDateMillis() {
        return this.dateMillis;
    }

    public Board getBoard() {
        return this.board;
    }

    public String toString() {
        return this.dateString;
    }

    public long getNodeTime() {
        return this.nodeTime;
    }

    public void addNodeTime(long addNodeTime) {
        this.nodeTime += addNodeTime;
    }

    public String getInfoString() {
        int dayCount = (int)(this.getNodeTime() / 86400000L);
        StringBuilder sb = new StringBuilder();
        sb.append("Board: ").append(this.getBoard().getName()).append("\n");
        sb.append("Date : ").append(this.getDateString()).append("\n");
        sb.append("\n");
        sb.append("Informations for current session:").append("\n");
        sb.append("\n");
        sb.append("nodeTime: ").append(dayCount).append("d ").append(DateFun.FORMAT_TIME_PLAIN.print(this.nodeTime)).append("  (").append(FormatterUtils.formatFraction(this.nodeTime / 1000L, this.getCountTriedIndices())).append(" s/req)\n");
        sb.append("\n");
        sb.append("countTriedIndices : ").append(this.getCountTriedIndices()).append("\n");
        sb.append("currentIndex      : ").append(this.getCurrentIndex()).append("\n");
        sb.append("maxIndex          : ").append(this.getMaxIndex()).append("\n");
        sb.append("maxSuccessfulIndex: ").append(this.getMaxSuccessfulIndex()).append("\n");
        sb.append("\n");
        sb.append("countADNF   : ").append(this.getCountADNF()).append("  (").append(FormatterUtils.formatPercent(this.getCountADNF(), this.getCountTriedIndices())).append("%)\n");
        sb.append("countDNF    : ").append(this.getCountDNF()).append("  (").append(FormatterUtils.formatPercent(this.getCountDNF(), this.getCountTriedIndices())).append("%)\n");
        sb.append("countInvalid: ").append(this.getCountInvalid()).append("  (").append(FormatterUtils.formatPercent(this.getCountInvalid(), this.getCountTriedIndices())).append("%)\n");
        sb.append("countValid  : ").append(this.getCountValid()).append("  (").append(FormatterUtils.formatPercent(this.getCountValid(), this.getCountTriedIndices())).append("%)\n");
        sb.append("subsequentFailures: ").append(this.getSubsequentInvalidMsgs()).append("\n");
        return sb.toString();
    }

    public static String getSummaryInfoString(List<Board> boardList) {
        LocalDate localDate = new LocalDate(DateTimeZone.UTC);
        long dateMillis = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
        String dirDateString = DateFun.FORMAT_DATE.print(localDate);
        long sumNodeTimeToday = 0L;
        int sumCountTriedIndicesToday = 0;
        int sumCountADNFToday = 0;
        int sumCountDNFToday = 0;
        int sumCountInvalidToday = 0;
        int sumCountValidToday = 0;
        long sumNodeTimeOverall = 0L;
        int sumCountTriedIndicesOverall = 0;
        int sumCountADNFOverall = 0;
        int sumCountDNFOverall = 0;
        int sumCountInvalidOverall = 0;
        int sumCountValidOverall = 0;
        for (Board b : boardList) {
            if (!b.hasBoardUpdateInformations()) continue;
            List<BoardUpdateInformation> l = b.getBoardUpdateInformationList();
            for (BoardUpdateInformation bui : l) {
                if (bui.getDateMillis() == dateMillis) {
                    sumNodeTimeToday += bui.getNodeTime();
                    sumCountTriedIndicesToday += bui.getCountTriedIndices();
                    sumCountADNFToday += bui.getCountADNF();
                    sumCountDNFToday += bui.getCountDNF();
                    sumCountInvalidToday += bui.getCountInvalid();
                    sumCountValidToday += bui.getCountValid();
                }
                sumNodeTimeOverall += bui.getNodeTime();
                sumCountTriedIndicesOverall += bui.getCountTriedIndices();
                sumCountADNFOverall += bui.getCountADNF();
                sumCountDNFOverall += bui.getCountDNF();
                sumCountInvalidOverall += bui.getCountInvalid();
                sumCountValidOverall += bui.getCountValid();
            }
        }
        int dayCountToday = (int)(sumNodeTimeToday / 86400000L);
        int dayCountOverall = (int)(sumNodeTimeOverall / 86400000L);
        String infoString = "Summary for current session:" + "\n" + "\n" + "*** Today (" + dirDateString + ") ***\n" + "\n" + "nodeTime: " + dayCountToday + "d " + DateFun.FORMAT_TIME_PLAIN.print(sumNodeTimeToday) + "  (" + FormatterUtils.formatFraction(sumNodeTimeToday / 1000L, sumCountTriedIndicesToday) + " s/req)\n" + "countTriedIndices : " + sumCountTriedIndicesToday + "\n" + "countADNF   : " + sumCountADNFToday + "  (" + FormatterUtils.formatPercent(sumCountADNFToday, sumCountTriedIndicesToday) + "%)\n" + "countDNF    : " + sumCountDNFToday + "  (" + FormatterUtils.formatPercent(sumCountDNFToday, sumCountTriedIndicesToday) + "%)\n" + "countInvalid: " + sumCountInvalidToday + "  (" + FormatterUtils.formatPercent(sumCountInvalidToday, sumCountTriedIndicesToday) + "%)\n" + "countValid  : " + sumCountValidToday + "  (" + FormatterUtils.formatPercent(sumCountValidToday, sumCountTriedIndicesToday) + "%)\n" + "\n" + "*** Overall ***\n" + "\n" + "nodeTime: " + dayCountOverall + "d " + DateFun.FORMAT_TIME_PLAIN.print(sumNodeTimeOverall) + "  (" + FormatterUtils.formatFraction(sumNodeTimeOverall / 1000L, sumCountTriedIndicesOverall) + " s/req)\n" + "countTriedIndices: " + sumCountTriedIndicesOverall + "\n" + "countValid  : " + sumCountValidOverall + "  (" + FormatterUtils.formatPercent(sumCountValidOverall, sumCountTriedIndicesOverall) + "%)\n" + "countInvalid: " + sumCountInvalidOverall + "  (" + FormatterUtils.formatPercent(sumCountInvalidOverall, sumCountTriedIndicesOverall) + "%)\n" + "countADNF   : " + sumCountADNFOverall + "  (" + FormatterUtils.formatPercent(sumCountADNFOverall, sumCountTriedIndicesOverall) + "%)\n" + "countDNF    : " + sumCountDNFOverall + "  (" + FormatterUtils.formatPercent(sumCountDNFOverall, sumCountTriedIndicesOverall) + "%)\n";
        return infoString;
    }

    public synchronized boolean updateBoardUpdateAllowedState() {
        this.isBoardUpdateAllowed = this.checkBoardUpdateAllowedState();
        return this.isBoardUpdateAllowed;
    }

    public synchronized boolean checkBoardUpdateAllowedState() {
        if (!MainFrame.getInstance().getTofTree().isStopBoardUpdatesWhenDOSed()) {
            return true;
        }
        int maxSubsequentFailuresAllowed = MainFrame.getInstance().getTofTree().getMaxInvalidMessagesPerDayThreshold();
        return this.getSubsequentInvalidMsgs() <= maxSubsequentFailuresAllowed;
    }

    public synchronized boolean isBoardUpdateAllowed() {
        if (this.isBoardUpdateAllowed == null) {
            this.updateBoardUpdateAllowedState();
        }
        return this.isBoardUpdateAllowed;
    }

    private int getSubsequentInvalidMsgs() {
        return this.subsequentInvalidMsgs;
    }

    public void resetSubsequentInvalidMsgs() {
        this.subsequentInvalidMsgs = 0;
    }

    private void incSubsequentInvalidMsgs() {
        ++this.subsequentInvalidMsgs;
    }
}

