/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.MainFrame;
import frost.boards.AbstractNode;
import frost.boards.Board;
import frost.boards.TOF;
import frost.fcp.BoardKeyPair;
import frost.fcp.FcpHandler;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class BoardSettingsFrame
extends JDialog {
    private final Language language;
    private final AbstractNode node;
    private final JFrame parentFrame;
    private final Listener listener = new Listener();
    private final JCheckBox autoUpdateEnabled = new JCheckBox();
    private final JButton cancelButton = new JButton();
    private boolean exitState;
    private final JButton generateKeyButton = new JButton();
    private final JRadioButton storeSentMessages_default = new JRadioButton();
    private final JRadioButton storeSentMessages_false = new JRadioButton();
    private final JRadioButton storeSentMessages_true = new JRadioButton();
    private final JLabel storeSentMessagesLabel = new JLabel();
    private final JRadioButton hideBad_default = new JRadioButton();
    private final JRadioButton hideBad_false = new JRadioButton();
    private final JRadioButton hideBad_true = new JRadioButton();
    private final JLabel hideBadMessagesLabel = new JLabel();
    private final JRadioButton hideCheck_default = new JRadioButton();
    private final JRadioButton hideCheck_false = new JRadioButton();
    private final JRadioButton hideCheck_true = new JRadioButton();
    private final JLabel hideCheckMessagesLabel = new JLabel();
    private final JRadioButton hideObserve_default = new JRadioButton();
    private final JRadioButton hideObserve_false = new JRadioButton();
    private final JRadioButton hideObserve_true = new JRadioButton();
    private final JLabel hideObserveMessagesLabel = new JLabel();
    private final JLabel hideUnsignedMessagesLabel = new JLabel();
    private final JRadioButton maxMessageDisplay_default = new JRadioButton();
    private final JRadioButton maxMessageDisplay_set = new JRadioButton();
    private final JTextField maxMessageDisplay_value = new JTextField(6);
    private final JLabel maxMessageDisplayDaysLabel = new JLabel();
    private final JRadioButton maxMessageDownload_default = new JRadioButton();
    private final JRadioButton maxMessageDownload_set = new JRadioButton();
    private final JTextField maxMessageDownload_value = new JTextField(6);
    private final JLabel maxMessageDownloadDaysLabel = new JLabel();
    private final JButton okButton = new JButton();
    private final JCheckBox overrideSettingsCheckBox = new JCheckBox();
    private final JLabel privateKeyLabel = new JLabel();
    private final JTextField privateKeyTextField = new JTextField();
    private final JRadioButton publicBoardRadioButton = new JRadioButton();
    private final JLabel publicKeyLabel = new JLabel();
    private final JTextField publicKeyTextField = new JTextField();
    private final JRadioButton secureBoardRadioButton = new JRadioButton();
    private final JRadioButton signedOnly_default = new JRadioButton();
    private final JRadioButton signedOnly_false = new JRadioButton();
    private final JRadioButton signedOnly_true = new JRadioButton();
    JPanel settingsPanel = new JPanel(new GridBagLayout());
    private final JLabel descriptionLabel = new JLabel();
    private final JTextArea descriptionTextArea = new JTextArea(3, 40);
    private JScrollPane descriptionScrollPane;

    public BoardSettingsFrame(JFrame parentFrame, AbstractNode node) {
        super(parentFrame);
        this.parentFrame = parentFrame;
        this.node = node;
        this.language = Language.getInstance();
        this.setModal(true);
        this.enableEvents(64L);
        this.initialize();
        this.setSize(430, 615);
        this.setLocationRelativeTo(parentFrame);
    }

    private void cancel() {
        this.exitState = false;
        this.dispose();
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.cancel();
    }

    private void generateKeyButton_actionPerformed(ActionEvent e) {
        try {
            BoardKeyPair kp = FcpHandler.inst().generateBoardKeyPair();
            if (kp != null) {
                this.privateKeyTextField.setText(kp.getPrivateBoardKey());
                this.publicKeyTextField.setText(kp.getPublicBoardKey());
            }
        }
        catch (Throwable ex) {
            JOptionPane.showMessageDialog(this.parentFrame, ex.toString(), this.language.getString("BoardSettings.generateKeyPairErrorDialog.title"), 2);
        }
    }

    private void overrideSettingsCheckBox_actionPerformed(ActionEvent e) {
        this.setPanelEnabled(this.settingsPanel, this.overrideSettingsCheckBox.isSelected());
    }

    public boolean getExitState() {
        return this.exitState;
    }

    private JPanel getSettingsPanel() {
        this.settingsPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        this.settingsPanel.setLayout(new GridBagLayout());
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.maxMessageDisplay_default);
        bg2.add(this.maxMessageDisplay_set);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.maxMessageDownload_default);
        bg1.add(this.maxMessageDownload_set);
        ButtonGroup bg3 = new ButtonGroup();
        bg3.add(this.signedOnly_default);
        bg3.add(this.signedOnly_false);
        bg3.add(this.signedOnly_true);
        ButtonGroup bg4 = new ButtonGroup();
        bg4.add(this.hideBad_default);
        bg4.add(this.hideBad_true);
        bg4.add(this.hideBad_false);
        ButtonGroup bg5 = new ButtonGroup();
        bg5.add(this.hideCheck_default);
        bg5.add(this.hideCheck_true);
        bg5.add(this.hideCheck_false);
        ButtonGroup bg6 = new ButtonGroup();
        bg6.add(this.hideObserve_default);
        bg6.add(this.hideObserve_true);
        bg6.add(this.hideObserve_false);
        ButtonGroup bg7 = new ButtonGroup();
        bg7.add(this.storeSentMessages_default);
        bg7.add(this.storeSentMessages_true);
        bg7.add(this.storeSentMessages_false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        this.settingsPanel.add((Component)this.overrideSettingsCheckBox, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(5, 25, 0, 5);
        this.settingsPanel.add((Component)this.autoUpdateEnabled, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.maxMessageDisplayDaysLabel, constraints);
        constraints.insets = new Insets(0, 35, 0, 5);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.settingsPanel.add((Component)this.maxMessageDisplay_default, constraints);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.gridx = 1;
        this.settingsPanel.add((Component)this.maxMessageDisplay_set, constraints);
        constraints.gridx = 2;
        this.settingsPanel.add((Component)this.maxMessageDisplay_value, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.maxMessageDownloadDaysLabel, constraints);
        constraints.insets = new Insets(0, 35, 0, 5);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.settingsPanel.add((Component)this.maxMessageDownload_default, constraints);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.gridx = 1;
        this.settingsPanel.add((Component)this.maxMessageDownload_set, constraints);
        constraints.gridx = 2;
        this.settingsPanel.add((Component)this.maxMessageDownload_value, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.hideUnsignedMessagesLabel, constraints);
        constraints.insets = new Insets(0, 35, 0, 5);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.settingsPanel.add((Component)this.signedOnly_default, constraints);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.gridx = 1;
        this.settingsPanel.add((Component)this.signedOnly_true, constraints);
        constraints.gridx = 2;
        this.settingsPanel.add((Component)this.signedOnly_false, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.hideBadMessagesLabel, constraints);
        constraints.insets = new Insets(0, 35, 0, 5);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.settingsPanel.add((Component)this.hideBad_default, constraints);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.gridx = 1;
        this.settingsPanel.add((Component)this.hideBad_true, constraints);
        constraints.gridx = 2;
        this.settingsPanel.add((Component)this.hideBad_false, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.hideCheckMessagesLabel, constraints);
        constraints.insets = new Insets(0, 35, 0, 5);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.settingsPanel.add((Component)this.hideCheck_default, constraints);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.gridx = 1;
        this.settingsPanel.add((Component)this.hideCheck_true, constraints);
        constraints.gridx = 2;
        this.settingsPanel.add((Component)this.hideCheck_false, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.hideObserveMessagesLabel, constraints);
        constraints.insets = new Insets(0, 35, 5, 5);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.settingsPanel.add((Component)this.hideObserve_default, constraints);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.gridx = 1;
        this.settingsPanel.add((Component)this.hideObserve_true, constraints);
        constraints.gridx = 2;
        this.settingsPanel.add((Component)this.hideObserve_false, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.storeSentMessagesLabel, constraints);
        constraints.insets = new Insets(0, 35, 5, 5);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.settingsPanel.add((Component)this.storeSentMessages_default, constraints);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.gridx = 1;
        this.settingsPanel.add((Component)this.storeSentMessages_true, constraints);
        constraints.gridx = 2;
        this.settingsPanel.add((Component)this.storeSentMessages_false, constraints);
        this.overrideSettingsCheckBox.addActionListener(this.listener);
        this.setPanelEnabled(this.settingsPanel, this.node.isBoard() ? ((Board)this.node).isConfigured() : false);
        return this.settingsPanel;
    }

    private void initialize() {
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setContentPane(contentPanel);
        contentPanel.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.maxMessageDisplay_value, this.language);
        new TextComponentClipboardMenu(this.maxMessageDownload_value, this.language);
        new TextComponentClipboardMenu(this.privateKeyTextField, this.language);
        new TextComponentClipboardMenu(this.publicKeyTextField, this.language);
        new TextComponentClipboardMenu(this.descriptionTextArea, this.language);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridwidth = 3;
        constraints.weightx = 2.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        contentPanel.add((Component)this.getKeysPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        contentPanel.add((Component)this.descriptionLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.descriptionScrollPane = new JScrollPane(this.descriptionTextArea);
        contentPanel.add((Component)this.descriptionScrollPane, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 3;
        contentPanel.add((Component)this.getSettingsPanel(), constraints);
        constraints.insets = new Insets(3, 3, 0, 3);
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        constraints.weightx = 2.0;
        constraints.gridx = 0;
        constraints.gridy = 4;
        contentPanel.add((Component)this.okButton, constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.gridy = 4;
        contentPanel.add((Component)this.cancelButton, constraints);
        this.descriptionLabel.setEnabled(false);
        this.descriptionTextArea.setEnabled(false);
        this.publicBoardRadioButton.setSelected(true);
        this.privateKeyTextField.setEnabled(false);
        this.publicKeyTextField.setEnabled(false);
        this.generateKeyButton.setEnabled(false);
        this.okButton.addActionListener(this.listener);
        this.cancelButton.addActionListener(this.listener);
        this.loadKeypair();
        this.loadBoardSettings();
    }

    private JPanel getKeysPanel() {
        JPanel keysPanel = new JPanel();
        keysPanel.setLayout(new GridBagLayout());
        ButtonGroup isSecureGroup = new ButtonGroup();
        isSecureGroup.add(this.publicBoardRadioButton);
        isSecureGroup.add(this.secureBoardRadioButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 3, 0);
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.weightx = 0.2;
        keysPanel.add((Component)this.publicBoardRadioButton, constraints);
        constraints.insets = new Insets(3, 0, 3, 0);
        constraints.weightx = 0.2;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        keysPanel.add((Component)this.secureBoardRadioButton, constraints);
        constraints.gridx = 2;
        constraints.gridwidth = 1;
        constraints.weightx = 0.8;
        constraints.fill = 0;
        constraints.anchor = 13;
        keysPanel.add((Component)this.generateKeyButton, constraints);
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        keysPanel.add((Component)this.privateKeyLabel, constraints);
        constraints.insets = new Insets(3, 3, 3, 0);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        constraints.weightx = 0.8;
        keysPanel.add((Component)this.privateKeyTextField, constraints);
        constraints.insets = new Insets(3, 0, 3, 0);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        keysPanel.add((Component)this.publicKeyLabel, constraints);
        constraints.insets = new Insets(3, 3, 3, 0);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        keysPanel.add((Component)this.publicKeyTextField, constraints);
        this.publicBoardRadioButton.addActionListener(this.listener);
        this.secureBoardRadioButton.addActionListener(this.listener);
        this.generateKeyButton.addActionListener(this.listener);
        return keysPanel;
    }

    private void loadBoardSettings() {
        if (this.node.isFolder()) {
            this.descriptionLabel.setEnabled(false);
            this.descriptionTextArea.setEnabled(false);
            this.overrideSettingsCheckBox.setSelected(false);
        } else if (this.node.isBoard()) {
            Board board = (Board)this.node;
            this.descriptionLabel.setEnabled(true);
            this.descriptionTextArea.setEnabled(true);
            if (board.getDescription() != null) {
                this.descriptionTextArea.setText(board.getDescription());
            }
            this.overrideSettingsCheckBox.setSelected(board.isConfigured());
            if (!board.isConfigured() || board.getMaxMessageDisplayObj() == null) {
                this.maxMessageDisplay_default.setSelected(true);
            } else {
                this.maxMessageDisplay_set.setSelected(true);
                this.maxMessageDisplay_value.setText("" + board.getMaxMessageDisplay());
            }
            if (!board.isConfigured() || board.getMaxMessageDownloadObj() == null) {
                this.maxMessageDownload_default.setSelected(true);
            } else {
                this.maxMessageDownload_set.setSelected(true);
                this.maxMessageDownload_value.setText("" + board.getMaxMessageDownload());
            }
            if (!board.isConfigured()) {
                this.autoUpdateEnabled.setSelected(true);
            } else if (board.getAutoUpdateEnabled()) {
                this.autoUpdateEnabled.setSelected(true);
            } else {
                this.autoUpdateEnabled.setSelected(false);
            }
            if (!board.isConfigured() || board.getShowSignedOnlyObj() == null) {
                this.signedOnly_default.setSelected(true);
            } else if (board.getShowSignedOnly()) {
                this.signedOnly_true.setSelected(true);
            } else {
                this.signedOnly_false.setSelected(true);
            }
            if (!board.isConfigured() || board.getHideBadObj() == null) {
                this.hideBad_default.setSelected(true);
            } else if (board.getHideBad()) {
                this.hideBad_true.setSelected(true);
            } else {
                this.hideBad_false.setSelected(true);
            }
            if (!board.isConfigured() || board.getHideCheckObj() == null) {
                this.hideCheck_default.setSelected(true);
            } else if (board.getHideCheck()) {
                this.hideCheck_true.setSelected(true);
            } else {
                this.hideCheck_false.setSelected(true);
            }
            if (!board.isConfigured() || board.getHideObserveObj() == null) {
                this.hideObserve_default.setSelected(true);
            } else if (board.getHideObserve()) {
                this.hideObserve_true.setSelected(true);
            } else {
                this.hideObserve_false.setSelected(true);
            }
            if (!board.isConfigured() || board.getStoreSentMessagesObj() == null) {
                this.storeSentMessages_default.setSelected(true);
            } else if (board.getStoreSentMessages()) {
                this.storeSentMessages_true.setSelected(true);
            } else {
                this.storeSentMessages_false.setSelected(true);
            }
        }
    }

    private void loadKeypair() {
        if (this.node.isFolder()) {
            this.privateKeyTextField.setEnabled(false);
            this.publicKeyTextField.setEnabled(false);
            this.generateKeyButton.setEnabled(false);
            this.publicBoardRadioButton.setEnabled(false);
            this.secureBoardRadioButton.setEnabled(false);
        } else if (this.node.isBoard()) {
            Board board = (Board)this.node;
            String privateKey = board.getPrivateKey();
            String publicKey = board.getPublicKey();
            if (privateKey != null) {
                this.privateKeyTextField.setText(privateKey);
            } else {
                this.privateKeyTextField.setText(this.language.getString("BoardSettings.text.keyNotAvailable"));
            }
            if (publicKey != null) {
                this.publicKeyTextField.setText(publicKey);
            } else {
                this.publicKeyTextField.setText(this.language.getString("BoardSettings.text.keyNotAvailable"));
            }
            if (board.isWriteAccessBoard() || board.isReadAccessBoard()) {
                this.privateKeyTextField.setEnabled(true);
                this.publicKeyTextField.setEnabled(true);
                this.generateKeyButton.setEnabled(true);
                this.secureBoardRadioButton.setSelected(true);
            } else {
                this.privateKeyTextField.setEnabled(false);
                this.publicKeyTextField.setEnabled(false);
                this.generateKeyButton.setEnabled(false);
                this.publicBoardRadioButton.setSelected(true);
            }
        }
    }

    private void ok() {
        if (this.node.isBoard()) {
            int result;
            if (this.publicBoardRadioButton.isSelected() && !((Board)this.node).isPublicBoard() && (result = JOptionPane.showConfirmDialog(this, this.language.getString("BoardSettings.looseKeysWarningDialog.body"), this.language.getString("BoardSettings.looseKeysWarningDialog.title"), 0, 2)) == 1) {
                return;
            }
            this.applySettingsToBoard((Board)this.node);
        } else if (this.node.isFolder()) {
            this.applySettingsToFolder(this.node);
        }
        this.updateBoard(this.node);
        this.exitState = true;
        this.dispose();
    }

    private void applySettingsToFolder(AbstractNode b) {
        if (b.isFolder()) {
            for (int x = 0; x < b.getChildCount(); ++x) {
                AbstractNode b2 = (AbstractNode)b.getChildAt(x);
                this.applySettingsToFolder(b2);
            }
            return;
        }
        if (!(b instanceof Board)) {
            return;
        }
        Board board = (Board)b;
        if (this.overrideSettingsCheckBox.isSelected()) {
            board.setConfigured(true);
            board.setAutoUpdateEnabled(this.autoUpdateEnabled.isSelected());
            if (this.maxMessageDisplay_default.isSelected() || this.maxMessageDisplay_set.isSelected()) {
                if (!this.maxMessageDisplay_default.isSelected()) {
                    board.setMaxMessageDays(new Integer(this.maxMessageDisplay_value.getText()));
                } else {
                    board.setMaxMessageDays(null);
                }
            }
            if (this.maxMessageDownload_default.isSelected() || this.maxMessageDownload_set.isSelected()) {
                if (!this.maxMessageDownload_default.isSelected()) {
                    board.setMaxMessageDownload(new Integer(this.maxMessageDownload_value.getText()));
                } else {
                    board.setMaxMessageDownload(null);
                }
            }
            if (this.signedOnly_default.isSelected() || this.signedOnly_true.isSelected() || this.signedOnly_false.isSelected()) {
                if (!this.signedOnly_default.isSelected()) {
                    board.setShowSignedOnly(this.signedOnly_true.isSelected());
                } else {
                    board.setShowSignedOnly(null);
                }
            }
            if (this.hideBad_default.isSelected() || this.hideBad_true.isSelected() || this.hideBad_false.isSelected()) {
                if (!this.hideBad_default.isSelected()) {
                    board.setHideBad(this.hideBad_true.isSelected());
                } else {
                    board.setHideBad(null);
                }
            }
            if (this.hideCheck_default.isSelected() || this.hideCheck_true.isSelected() || this.hideCheck_false.isSelected()) {
                if (!this.hideCheck_default.isSelected()) {
                    board.setHideCheck(this.hideCheck_true.isSelected());
                } else {
                    board.setHideCheck(null);
                }
            }
            if (this.hideObserve_default.isSelected() || this.hideObserve_true.isSelected() || this.hideObserve_false.isSelected()) {
                if (!this.hideObserve_default.isSelected()) {
                    board.setHideObserve(this.hideObserve_true.isSelected());
                } else {
                    board.setHideObserve(null);
                }
            }
            if (this.storeSentMessages_default.isSelected() || this.storeSentMessages_true.isSelected() || this.storeSentMessages_false.isSelected()) {
                if (!this.storeSentMessages_default.isSelected()) {
                    board.setStoreSentMessages(this.storeSentMessages_true.isSelected());
                } else {
                    board.setStoreSentMessages(null);
                }
            }
        } else {
            board.setConfigured(false);
        }
    }

    private void applySettingsToBoard(Board board) {
        String desc = this.descriptionTextArea.getText().trim();
        if (desc.length() > 0) {
            board.setDescription(desc);
        } else {
            board.setDescription(null);
        }
        if (this.secureBoardRadioButton.isSelected()) {
            String privateKey = this.privateKeyTextField.getText();
            String publicKey = this.publicKeyTextField.getText();
            if (publicKey.startsWith("SSK@")) {
                board.setPublicKey(publicKey);
            } else {
                board.setPublicKey(null);
            }
            if (privateKey.startsWith("SSK@")) {
                board.setPrivateKey(privateKey);
            } else {
                board.setPrivateKey(null);
            }
        } else {
            board.setPublicKey(null);
            board.setPrivateKey(null);
        }
        if (this.overrideSettingsCheckBox.isSelected()) {
            board.setConfigured(true);
            board.setAutoUpdateEnabled(this.autoUpdateEnabled.isSelected());
            if (!this.maxMessageDisplay_default.isSelected()) {
                board.setMaxMessageDays(new Integer(this.maxMessageDisplay_value.getText()));
            } else {
                board.setMaxMessageDays(null);
            }
            if (!this.maxMessageDownload_default.isSelected()) {
                board.setMaxMessageDownload(new Integer(this.maxMessageDownload_value.getText()));
            } else {
                board.setMaxMessageDownload(null);
            }
            if (!this.signedOnly_default.isSelected()) {
                board.setShowSignedOnly(this.signedOnly_true.isSelected());
            } else {
                board.setShowSignedOnly(null);
            }
            if (!this.hideBad_default.isSelected()) {
                board.setHideBad(this.hideBad_true.isSelected());
            } else {
                board.setHideBad(null);
            }
            if (!this.hideCheck_default.isSelected()) {
                board.setHideCheck(this.hideCheck_true.isSelected());
            } else {
                board.setHideCheck(null);
            }
            if (!this.hideObserve_default.isSelected()) {
                board.setHideObserve(this.hideObserve_true.isSelected());
            } else {
                board.setHideObserve(null);
            }
            if (!this.storeSentMessages_default.isSelected()) {
                board.setStoreSentMessages(this.storeSentMessages_true.isSelected());
            } else {
                board.setStoreSentMessages(null);
            }
        } else {
            board.setConfigured(false);
        }
    }

    private void updateBoard(AbstractNode b) {
        if (b.isBoard()) {
            MainFrame.getInstance().updateTofTree(b);
            TOF.getInstance().searchUnreadMessages((Board)b);
            if (b == MainFrame.getInstance().getTofTreeModel().getSelectedNode()) {
                MainFrame.getInstance().tofTree_actionPerformed(null);
            }
        } else if (b.isFolder()) {
            for (int x = 0; x < b.getChildCount(); ++x) {
                AbstractNode b2 = (AbstractNode)b.getChildAt(x);
                this.updateBoard(b2);
            }
        }
    }

    private void okButton_actionPerformed(ActionEvent e) {
        this.ok();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(e);
    }

    private void radioButton_actionPerformed(ActionEvent e) {
        if (this.publicBoardRadioButton.isSelected()) {
            this.privateKeyTextField.setEnabled(false);
            this.publicKeyTextField.setEnabled(false);
            this.generateKeyButton.setEnabled(false);
        } else {
            this.privateKeyTextField.setEnabled(true);
            this.publicKeyTextField.setEnabled(true);
            this.generateKeyButton.setEnabled(true);
        }
    }

    private void refreshLanguage() {
        if (this.node.isFolder()) {
            this.setTitle(this.language.getString("BoardSettings.title.folderSettings") + " '" + this.node.getName() + "'");
        } else if (this.node.isBoard()) {
            this.setTitle(this.language.getString("BoardSettings.title.boardSettings") + " '" + this.node.getName() + "'");
        }
        this.publicBoardRadioButton.setText(this.language.getString("BoardSettings.label.publicBoard"));
        this.secureBoardRadioButton.setText(this.language.getString("BoardSettings.label.secureBoard"));
        this.okButton.setText(this.language.getString("Common.ok"));
        this.cancelButton.setText(this.language.getString("Common.cancel"));
        this.generateKeyButton.setText(this.language.getString("BoardSettings.button.generateNewKeypair"));
        this.overrideSettingsCheckBox.setText(this.language.getString("BoardSettings.label.overrideDefaultSettings"));
        String useDefault = this.language.getString("BoardSettings.label.useDefault");
        String yes = this.language.getString("BoardSettings.label.yes");
        String no = this.language.getString("BoardSettings.label.no");
        this.maxMessageDisplay_default.setText(useDefault);
        this.maxMessageDisplay_set.setText(this.language.getString("BoardSettings.label.setTo") + ":");
        this.maxMessageDownload_default.setText(useDefault);
        this.maxMessageDownload_set.setText(this.language.getString("BoardSettings.label.setTo") + ":");
        this.signedOnly_default.setText(useDefault);
        this.signedOnly_true.setText(yes);
        this.signedOnly_false.setText(no);
        this.hideBad_default.setText(useDefault);
        this.hideBad_true.setText(yes);
        this.hideBad_false.setText(no);
        this.hideCheck_default.setText(useDefault);
        this.hideCheck_true.setText(yes);
        this.hideCheck_false.setText(no);
        this.hideObserve_default.setText(useDefault);
        this.hideObserve_true.setText(yes);
        this.hideObserve_false.setText(no);
        this.storeSentMessages_default.setText(useDefault);
        this.storeSentMessages_true.setText(yes);
        this.storeSentMessages_false.setText(no);
        this.autoUpdateEnabled.setText(this.language.getString("BoardSettings.label.enableAutomaticBoardUpdate"));
        this.publicKeyLabel.setText(this.language.getString("BoardSettings.label.publicKey") + " :");
        this.privateKeyLabel.setText(this.language.getString("BoardSettings.label.privateKey") + " :");
        this.maxMessageDisplayDaysLabel.setText(this.language.getString("BoardSettings.label.maximumMessageDisplay"));
        this.maxMessageDownloadDaysLabel.setText(this.language.getString("BoardSettings.label.maximumMessageDownload"));
        this.hideUnsignedMessagesLabel.setText(this.language.getString("BoardSettings.label.hideUnsignedMessages"));
        this.hideBadMessagesLabel.setText(this.language.getString("BoardSettings.label.hideBadMessages"));
        this.hideCheckMessagesLabel.setText(this.language.getString("BoardSettings.label.hideCheckMessages"));
        this.hideObserveMessagesLabel.setText(this.language.getString("BoardSettings.label.hideObserveMessages"));
        this.storeSentMessagesLabel.setText(this.language.getString("BoardSettings.label.storeSentMessages"));
        this.descriptionLabel.setText(this.language.getString("BoardSettings.label.description"));
    }

    public boolean runDialog() {
        this.setModal(true);
        this.setVisible(true);
        return this.exitState;
    }

    private void setPanelEnabled(JPanel panel, boolean enabled) {
        int componentCount = panel.getComponentCount();
        for (int x = 0; x < componentCount; ++x) {
            Component c = panel.getComponent(x);
            if (c == this.overrideSettingsCheckBox) continue;
            c.setEnabled(enabled);
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == BoardSettingsFrame.this.publicBoardRadioButton) {
                BoardSettingsFrame.this.radioButton_actionPerformed(e);
            } else if (e.getSource() == BoardSettingsFrame.this.secureBoardRadioButton) {
                BoardSettingsFrame.this.radioButton_actionPerformed(e);
            } else if (e.getSource() == BoardSettingsFrame.this.generateKeyButton) {
                BoardSettingsFrame.this.generateKeyButton_actionPerformed(e);
            } else if (e.getSource() == BoardSettingsFrame.this.okButton) {
                BoardSettingsFrame.this.okButton_actionPerformed(e);
            } else if (e.getSource() == BoardSettingsFrame.this.cancelButton) {
                BoardSettingsFrame.this.cancelButton_actionPerformed(e);
            } else if (e.getSource() == BoardSettingsFrame.this.overrideSettingsCheckBox) {
                BoardSettingsFrame.this.overrideSettingsCheckBox_actionPerformed(e);
            }
        }
    }
}

