/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
extends DefaultMutableTreeNode
implements Comparable<AbstractNode> {
    protected String name = null;
    protected String nameLowerCase = null;

    protected AbstractNode(String newName) {
        this.name = newName;
    }

    public boolean containsUnreadMessages() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLowerCase() {
        if (this.nameLowerCase == null) {
            this.nameLowerCase = this.getName().toLowerCase();
        }
        return this.nameLowerCase;
    }

    public Enumeration<AbstractNode> depthFirstEnumeration() {
        return super.depthFirstEnumeration();
    }

    public Enumeration<AbstractNode> breadthFirstEnumeration() {
        return super.breadthFirstEnumeration();
    }

    public Enumeration<AbstractNode> children() {
        return super.children();
    }

    @Override
    public int compareTo(AbstractNode o) {
        AbstractNode board = o;
        if (board.isFolder() == this.isFolder() || board.isBoard() == this.isBoard()) {
            return this.getNameLowerCase().compareTo(board.getNameLowerCase());
        }
        return this.isFolder() ? -1 : 1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean isBoard() {
        return false;
    }

    public boolean isFolder() {
        return false;
    }

    public boolean isUnsentMessagesFolder() {
        return false;
    }

    public boolean isSentMessagesFolder() {
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

