/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.MainFrame;
import frost.SettingsClass;
import frost.util.FileAccess;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;

public class Startup {
    private static final Logger logger = Logger.getLogger(Startup.class.getName());

    public static void startupCheck(SettingsClass settings) {
        Startup.checkDirectories(settings);
        Startup.copyFiles();
        Startup.cleanTempDir(settings);
        File oldJarFile = new File("lib/mckoidb.jar");
        if (oldJarFile.isFile()) {
            oldJarFile.delete();
        }
    }

    private static void copyFiles() {
        String fileSeparator = System.getProperty("file.separator");
        try {
            boolean copyResource = false;
            File systrayDllFile = new File("exec" + fileSeparator + "JSysTray.dll");
            if (!systrayDllFile.isFile()) {
                copyResource = true;
            } else {
                URL url = MainFrame.class.getResource("/data/JSysTray.dll");
                URLConnection urlConn = url.openConnection();
                long len = urlConn.getContentLength();
                if (len != systrayDllFile.length()) {
                    systrayDllFile.delete();
                    copyResource = true;
                }
            }
            if (copyResource) {
                FileAccess.copyFromResource("/data/JSysTray.dll", systrayDllFile);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void checkDirectories(SettingsClass settings) {
        File storeDirectory;
        File tempDirectory;
        File execDirectory;
        File downloadDirectory = new File(settings.getValue("downloadDirectory"));
        if (!downloadDirectory.isDirectory()) {
            logger.warning("Creating download directory");
            downloadDirectory.mkdirs();
        }
        if (!(execDirectory = new File("exec")).isDirectory()) {
            logger.warning("Creating exec directory");
            execDirectory.mkdirs();
        }
        if (!(tempDirectory = new File(settings.getValue("temp.dir"))).isDirectory()) {
            logger.warning("Creating temp directory");
            tempDirectory.mkdirs();
        }
        if (!(storeDirectory = new File(settings.getValue("store.dir"))).isDirectory()) {
            logger.warning("Creating store directory");
            storeDirectory.mkdirs();
        }
    }

    private static void cleanTempDir(SettingsClass settings) {
        File[] entries;
        for (File entry : entries = new File(settings.getValue("temp.dir")).listFiles()) {
            if (entry.isDirectory()) continue;
            entry.delete();
        }
    }
}

