/*
 * Decompiled with CFR 0.152.
 */
package mseries.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import mseries.utils.FormConstraints;
import mseries.utils.FormLayoutInfo;

public class FormLayout
implements LayoutManager2,
Serializable {
    protected static final int MAXGRIDSIZE = 20;
    protected static final int MINWIDTH = 35;
    protected static final int MINHEIGHT = 17;
    protected Hashtable comptable = new Hashtable();
    protected FormConstraints defaultConstraints = new FormConstraints();
    protected FormLayoutInfo info = new FormLayoutInfo(this);

    public FormLayoutInfo getInfo() {
        return this.info;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof FormConstraints) {
            this.setConstraints(comp, (FormConstraints)constraints);
        } else if (constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a FormConstraint");
        }
    }

    public void removeLayoutComponent(Component comp) {
        this.removeConstraints(comp);
    }

    public void setConstraints(Component comp, FormConstraints constraints) {
        this.comptable.put(comp, constraints.clone());
    }

    private void removeConstraints(Component comp) {
        this.comptable.remove(comp);
    }

    public FormConstraints getConstraints(Component comp) {
        FormConstraints constraints = (FormConstraints)this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraints(comp, this.defaultConstraints);
            constraints = (FormConstraints)this.comptable.get(comp);
        }
        return (FormConstraints)constraints.clone();
    }

    protected FormConstraints lookupConstraints(Component comp) {
        FormConstraints constraints = (FormConstraints)this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraints(comp, this.defaultConstraints);
            constraints = (FormConstraints)this.comptable.get(comp);
        }
        return constraints;
    }

    void installFormInfo(FormLayoutInfo info) {
        this.info = info;
    }

    public void layoutContainer(Container parent) {
        this.calculateGridSize(parent, parent.getSize());
        this.setComponentBounds(parent);
    }

    protected void calculateGridSize(Container parent, Dimension size) {
        Insets insets = parent.getInsets();
        int adjW = 0;
        this.info.calculateLayoutInfo(parent);
        adjW = 0;
        int quot = 0;
        int rem = 0;
        int spare = 0;
        int w = this.info.getActualWidth();
        w = w + insets.left + insets.right;
        spare = w - size.width;
        do {
            if (spare > 0) {
                quot = spare / this.info.getColsNotAtMin();
                rem = spare % this.info.getColsNotAtMin();
                adjW += (quot += rem > 0 ? 1 : 0);
            }
            Component[] components = parent.getComponents();
            int y = -1;
            int x = -1;
            for (int compindex = 0; compindex < components.length; ++compindex) {
                Component comp = components[compindex];
                if (!comp.isVisible()) continue;
                FormConstraints constraints = this.lookupConstraints(comp);
                x = constraints.gridx == -1 ? x + 1 : constraints.gridx;
                y = constraints.gridy == -1 ? y + 1 : constraints.gridy;
                constraints.tempX = x;
                constraints.tempY = y;
                if (this.info.atMin[x]) continue;
                int newWidth = this.info.colWidth[x] - adjW;
                this.info.actualWidth[x] = Math.max(35, newWidth);
                if (35 <= newWidth) continue;
                this.info.atMin[x] = true;
            }
            w = this.info.getActualWidth();
        } while ((spare = (w = w + insets.left + insets.right) - size.width) > this.info.width && this.info.getColsNotAtMin() > 0);
    }

    protected void setComponentBounds(Container parent) {
        Rectangle r = new Rectangle();
        Insets insets = parent.getInsets();
        Component[] components = parent.getComponents();
        int y = -1;
        int x = -1;
        for (int compindex = 0; compindex < components.length; ++compindex) {
            int i;
            Component comp = components[compindex];
            if (!comp.isVisible()) continue;
            FormConstraints constraints = this.lookupConstraints(comp);
            x = constraints.gridx == -1 ? x + 1 : constraints.gridx;
            y = constraints.gridy == -1 ? y + 1 : constraints.gridy;
            constraints.tempX = x;
            constraints.tempY = y;
            int marginH = constraints.insets.left + constraints.insets.right;
            int marginV = constraints.insets.top + constraints.insets.bottom;
            int pWidth = comp.getPreferredSize().width;
            if (constraints.spansColumns) {
                int w = 0;
                for (i = x; i < this.info.width; ++i) {
                    w += this.info.actualWidth[i];
                }
                r.width = Math.min(pWidth, w - marginH);
            } else {
                r.width = constraints.fill ? this.info.actualWidth[x] - marginH : Math.min(pWidth, this.info.actualWidth[x] - marginH);
            }
            constraints.cellWidth = this.info.actualWidth[x] - marginH;
            int pHeight = comp.getPreferredSize().height;
            int newHeight = this.info.rowHeight[y];
            this.info.actualHeight[y] = Math.max(17, newHeight);
            r.height = Math.min(pHeight, this.info.actualHeight[y] - marginV);
            constraints.cellHeight = this.info.actualHeight[y] - marginV;
            r.x = insets.left;
            r.y = insets.top;
            for (i = 0; i < constraints.tempX; ++i) {
                r.x += this.info.actualWidth[i];
            }
            for (i = 0; i < constraints.tempY; ++i) {
                r.y += this.info.rowHeight[i];
            }
            this.applyGravity(constraints, r);
            comp.setBounds(r);
        }
    }

    protected void applyGravity(FormConstraints constraints, Rectangle r) {
        r.x += constraints.insets.left;
        r.y += constraints.insets.top;
        int diffx = 0;
        if (r.width < constraints.cellWidth) {
            diffx = constraints.cellWidth - r.width;
        }
        int diffy = 0;
        if (r.height < constraints.cellHeight) {
            diffy = constraints.cellHeight - r.height;
        }
        switch (constraints.anchor) {
            case 10: {
                r.x += diffx / 2;
                r.y += diffy / 2;
                break;
            }
            case 11: {
                r.x += diffx / 2;
                break;
            }
            case 15: {
                r.x += diffx / 2;
                r.y += diffy;
                break;
            }
            case 13: {
                r.x += diffx;
                r.y += diffy / 2;
            }
            case 17: {
                r.y += diffy / 2;
                break;
            }
            case 12: {
                r.x += diffx;
                break;
            }
            case 16: {
                r.y += diffy;
                break;
            }
            case 14: {
                r.y += diffy;
                r.x += diffx;
                break;
            }
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.info.calculateLayoutInfo(parent);
        Insets insets = parent.getInsets();
        Dimension d = this.info.getPreferredSize();
        d.width = d.width + insets.left + insets.right;
        d.height = d.height + insets.top + insets.bottom;
        return d;
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.info.calculateLayoutInfo(parent);
        Insets insets = parent.getInsets();
        Dimension d = this.info.getMinimumSize();
        d.width = d.width + insets.left + insets.right;
        d.height = d.height + insets.top + insets.bottom;
        return d;
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }
}

