/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.io.Serializable;
import java.util.HashSet;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ScreenUtilities {
    public static Container getParentWindow(Component c) {
        Container parent = null;
        if (c != null) {
            parent = c.getParent();
        }
        for (Container p = parent; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                if (p.getParent() instanceof JInternalFrame) continue;
                parent = ((JRootPane)p).getLayeredPane();
                for (p = parent.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
                }
                break;
            }
            if (!(p instanceof Window)) continue;
            parent = p;
            break;
        }
        return parent;
    }

    public static Point convertScreenLocationToParent(Container parent, int x, int y) {
        Serializable p;
        Window parentWindow = null;
        for (p = parent; p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            parentWindow = (Window)p;
            break;
        }
        if (parentWindow != null) {
            p = new Point(x, y);
            SwingUtilities.convertPointFromScreen((Point)p, parent);
            return p;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor found");
    }

    public static Dialog getParentDialog(Component child) {
        Dialog parentWindow = null;
        for (Container p = child.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Dialog)) continue;
            parentWindow = (Dialog)p;
            break;
        }
        return parentWindow;
    }

    public static Frame getParentFrame(Component child) {
        Frame parentWindow = null;
        for (Container p = child.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            parentWindow = (Frame)p;
            break;
        }
        return parentWindow;
    }

    public static HashSet getDefaultFocusTraversalKeys(int id) {
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>();
        switch (id) {
            case 0: {
                keys.add(KeyStroke.getKeyStroke(9, 2));
                break;
            }
            case 1: {
                keys.add(KeyStroke.getKeyStroke(9, 3));
            }
        }
        return keys;
    }
}

