/*
 * Decompiled with CFR 0.152.
 */
package mseries.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import mseries.Calendar.Header;

public class BasicHeaderUI
extends ComponentUI {
    protected Header header;

    public static ComponentUI createUI(JComponent x) {
        return new BasicHeaderUI();
    }

    public void installUI(JComponent c) {
        this.header = (Header)c;
        this.installDefaults();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public Font getFont() {
        return this.header.getFont();
    }

    public void paint(Graphics g, JComponent c) {
        int cellWidth = this.getCellSize().width;
        int cellHeight = this.getCellSize().height;
        int cols = this.header.getCols();
        Font font = this.getFont();
        int strWidth = 0;
        int strHeight = 0;
        for (int w = 0; w < cols; ++w) {
            if (this.isOpaque()) {
                g.setColor(this.header.getBackground(w));
                g.fillRect(0, 0, cellWidth, cellHeight);
            }
            String legend = this.header.getColumnName(w);
            g.translate(cellWidth * w, 0);
            if (legend != null) {
                g.setFont(this.getFont());
                FontMetrics fm = g.getFontMetrics();
                strWidth = fm.stringWidth(legend);
                strHeight = fm.getHeight();
                int x = cellWidth - strWidth - 4;
                int y = (cellHeight - strHeight) / 2 + strHeight - 4;
                g.setColor(this.header.getForeground(w));
                g.drawString(legend, x, y);
            }
            g.translate(-cellWidth * w, 0);
        }
    }

    public boolean isOpaque() {
        return this.header.isOpaque();
    }

    protected Dimension getCellSize() {
        return this.header.getCellSize();
    }
}

