/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import mseries.Calendar.CalendarPanel;
import mseries.Calendar.FocusChecker;
import mseries.Calendar.GridSelectionEvent;
import mseries.Calendar.GridSelectionListener;
import mseries.Calendar.Header;
import mseries.Calendar.MButtonChanger;
import mseries.Calendar.MDSAction;
import mseries.Calendar.MDateChanger;
import mseries.Calendar.MDateOutOfRangeException;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.Calendar.MMonth;
import mseries.Calendar.MMonthEvent;
import mseries.Calendar.MMonthListener;
import mseries.Calendar.MScrollBarChanger;
import mseries.Calendar.MSpinnerChanger;
import mseries.Calendar.SpecialDayModel;
import mseries.ui.MChangeEvent;
import mseries.ui.MChangeListener;
import mseries.ui.MImagePanel;

public class MDateSelectorPanel
extends MImagePanel
implements MMonthListener,
GridSelectionListener,
MChangeListener,
MouseListener {
    private CalendarPanel calendar;
    private MMonth dataModel;
    private Date today = new Date();
    private boolean hasTodayButton = false;
    private JButton todayButton;
    private boolean changerEditable;
    private MDateChanger scrollbar;
    private ResourceBundle rb;
    private Header header;
    private boolean focusCycleRoot = false;
    private GridBagConstraints c;
    private int clickCount = 2;
    private SpecialDayModel specialDayModel = null;
    FocusChecker fc;
    private boolean closeOnToday = true;

    public MDateSelectorPanel() {
        super(new GridBagLayout());
        Date minDate = null;
        Date maxDate = null;
        DateFormat df = DateFormat.getDateInstance(3, new Locale("en", "GB"));
        try {
            minDate = df.parse("1/1/1900");
            maxDate = df.parse("31/12/2037");
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
        }
        this.init(false, minDate, maxDate);
    }

    public MDateSelectorPanel(boolean lazy, Date min, Date max) {
        super(new GridBagLayout());
        this.init(lazy, min, max);
    }

    private void init(boolean lazy, Date min, Date max) {
        this.dataModel = new MMonth(min, max);
        this.dataModel.addMMonthListener(this);
        this.fc = new FocusChecker();
        this.fc.setAction(new MDSAction(){

            public void doAction() {
                MDateSelectorPanel.this.dataModel.lostFocus();
            }
        });
        this.c = new GridBagConstraints();
        this.header = new Header(this.dataModel.getColumnCount());
        this.calendar = new CalendarPanel();
        this.calendar.setModel(this.dataModel);
        this.registerListeners();
        this.setColours(this.calendar);
        if (!lazy) {
            this.setPullDownConstraints(new MDefaultPullDownConstraints());
        }
    }

    protected void setChangerStyle(int style) {
        this.removeAll();
        this.c.insets = new Insets(0, 0, 4, 0);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridy = -1;
        this.c.anchor = 10;
        switch (style) {
            case 4: {
                this.scrollbar = new MButtonChanger();
                this.c.fill = 1;
                this.add((Component)((Object)this.scrollbar), this.c);
                this.c.fill = 0;
                this.add((Component)this.header, this.c);
                this.c.fill = 0;
                this.add((Component)this.calendar, this.c);
                this.scrollbar.addFListener(this.fc);
                this.fc.addComponent(this.scrollbar);
                break;
            }
            case 3: {
                this.scrollbar = new MSpinnerChanger(this.changerEditable);
                this.c.fill = 1;
                this.add((Component)((Object)this.scrollbar), this.c);
                this.c.fill = 0;
                this.add((Component)this.header, this.c);
                this.c.fill = 0;
                this.add((Component)this.calendar, this.c);
                this.scrollbar.addFListener(this.fc);
                this.fc.addComponent(this.scrollbar);
                break;
            }
            case 5: {
                this.c.fill = 0;
                this.add((Component)this.header, this.c);
                this.c.fill = 0;
                this.add((Component)this.calendar, this.c);
                break;
            }
            default: {
                this.scrollbar = new MScrollBarChanger();
                this.c.fill = 1;
                this.add((Component)this.header, this.c);
                this.c.fill = 0;
                this.add((Component)this.calendar, this.c);
                this.c.fill = 1;
                this.add((Component)((Object)this.scrollbar), this.c);
            }
        }
        this.scrollbar.setMinimum(this.dataModel.getMinimum());
        this.scrollbar.setMaximum(this.dataModel.getMaximum());
        this.scrollbar.setValue(this.dataModel.getCurrentDate());
        this.scrollbar.addMChangeListener(this);
        this.setDate(new Date());
        this.setColours(this);
        this.scrollbar.setOpaque(false);
        if (this.getShowTodayButton()) {
            this.todayButton = new JButton(this.rb.getString("Today"));
            this.todayButton.addFocusListener(this.fc);
            this.fc.addComponent(this.todayButton);
            this.todayButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MDateSelectorPanel.this.setDMY(MDateSelectorPanel.this.today);
                    if (MDateSelectorPanel.this.getCloseOnToday()) {
                        MDateSelectorPanel.this.close("CLOSE");
                    }
                }
            });
            this.c.fill = 0;
            this.add((Component)this.todayButton, this.c);
        }
    }

    public void requestFocus() {
        this.calendar.requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.calendar.setEnabled(enabled);
        this.scrollbar.setEnabled(enabled);
    }

    public void setTextLocalizer(ResourceBundle rb) {
        this.rb = rb;
        this.header.setTextLocalizer(rb);
    }

    public ResourceBundle getTextLocalizer() {
        return this.rb;
    }

    public void setMinimum(Date min) {
        this.dataModel.setMinimum(min);
    }

    public Date getMinimum() {
        return this.dataModel.getMinimum();
    }

    public void setMaximum(Date max) {
        this.dataModel.setMaximum(max);
    }

    public Date getMaximum() {
        return this.dataModel.getMaximum();
    }

    public void setCloseOnToday(boolean close) {
        this.closeOnToday = close;
    }

    public boolean getCloseOnToday() {
        return this.closeOnToday;
    }

    public void setShowTodayButton(boolean show) {
        this.hasTodayButton = show;
    }

    public boolean getShowTodayButton() {
        return this.hasTodayButton;
    }

    public void setDate(Date date) {
        try {
            this.dataModel.setDate(date);
        }
        catch (MDateOutOfRangeException e) {
            try {
                this.dataModel.setDate(this.dataModel.getMinimum());
            }
            catch (MDateOutOfRangeException mDateOutOfRangeException) {
                // empty catch block
            }
        }
    }

    public void setDMY(Date date) {
        try {
            this.dataModel.setDMY(date);
        }
        catch (MDateOutOfRangeException e) {
            try {
                this.dataModel.setDate(this.dataModel.getMinimum());
            }
            catch (MDateOutOfRangeException mDateOutOfRangeException) {
                // empty catch block
            }
        }
    }

    public Date getDate() {
        return this.dataModel.getCurrentDate();
    }

    public void setFirstDay(int firstDay) {
        this.header.setFirstDay(firstDay);
        this.dataModel.setFirstDay(firstDay);
    }

    public int getFirstDay() {
        return this.dataModel.getFirstDay();
    }

    public void addMMonthListener(MMonthListener l) {
        this.dataModel.addMMonthListener(l);
    }

    public void removeMMonthListener(MMonthListener l) {
        this.dataModel.removeMMonthListener(l);
    }

    public void setPullDownConstraints(MDateSelectorConstraints c) {
        Font font;
        Dimension cellSize;
        String imageFile;
        Color background;
        Color foreground;
        Color[] backgrounds;
        Color[] foregrounds;
        int firstDay;
        ResourceBundle rb = c.getResourceBundle();
        this.changerEditable = c.isChangerEditable();
        this.setChangerStyle(c.getChangerStyle());
        if (rb != null) {
            try {
                this.setTextLocalizer(rb);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        if ((firstDay = c.getFirstDay()) > 0 && firstDay < 8) {
            this.setFirstDay(firstDay);
        }
        if ((foregrounds = c.getForegrounds()) != null) {
            this.setForeground(foregrounds);
        }
        if ((backgrounds = c.getBackgrounds()) != null) {
            this.setBackground(backgrounds);
        }
        if ((foreground = c.getForeground()) != null) {
            this.setForeground(foreground);
        }
        if ((background = c.getBackground()) != null) {
            this.setBackground(background);
        }
        if ((imageFile = c.getImageFile()) != null) {
            this.setImageFile(imageFile);
        }
        if ((cellSize = c.getCellSize()) != null) {
            this.setCellSize(cellSize);
        }
        if ((foreground = c.getTodayForeground()) != null) {
            this.calendar.setTodayForeground(foreground);
        }
        if ((background = c.getTodayBackground()) != null) {
            this.calendar.setTodayBackground(background);
        }
        if ((foreground = c.getOutOfRangeForeground()) != null) {
            this.calendar.setOutOfRangeForeground(foreground);
        }
        if ((background = c.getOutOfRangeBackground()) != null) {
            this.calendar.setOutOfRangeBackground(background);
        }
        this.clickCount = c.getSelectionClickCount();
        this.specialDayModel = c.getSpecialDayModel();
        if (this.specialDayModel != null) {
            this.calendar.setSpecialModel(this.specialDayModel);
        }
        if ((font = c.getFont()) != null) {
            this.setFont(font);
        }
    }

    public void gridCellChanged(GridSelectionEvent e) {
        if (e.isExitEvent()) {
            this.dataModel.exitEvent();
        } else {
            try {
                this.dataModel.setCurrentDate(e.getY(), e.getX());
            }
            catch (MDateOutOfRangeException mDateOutOfRangeException) {
                // empty catch block
            }
        }
    }

    public void dataChanged(MMonthEvent e) {
        Calendar date = e.getNewDate();
        switch (e.getType()) {
            case 2: {
                this.scrollbar.setMinimum(this.dataModel.getMinimum());
                this.scrollbar.setValue(this.dataModel.getCurrentDate());
                break;
            }
            case 3: {
                this.scrollbar.setMaximum(this.dataModel.getMaximum());
                this.scrollbar.setValue(this.dataModel.getCurrentDate());
                break;
            }
            case 1: {
                Point pnt = this.dataModel.getCurrentPoint();
                this.calendar.setCurrentDate(pnt);
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                this.header.repaint();
            }
            case 0: {
                this.calendar.tableChanged();
                this.scrollbar.setValue(date.getTime());
                Point pnt = this.dataModel.getCurrentPoint();
                this.calendar.setCurrentDate(pnt);
                break;
            }
        }
    }

    public void setImageFile(String imageFile) {
        super.setImageFile(imageFile);
        this.calendar.setHasImage(this.hasImage());
        this.calendar.tableChanged();
        this.calendar.requestFocus();
        this.repaint();
    }

    public void valueChanged(MChangeEvent event) {
        int increment = this.getDateValue();
        switch (event.getType()) {
            case 1: {
                this.dataModel.exitEvent();
                break;
            }
            case 0: {
                try {
                    this.dataModel.addToMin(increment);
                    break;
                }
                catch (MDateOutOfRangeException mDateOutOfRangeException) {
                    // empty catch block
                }
            }
        }
    }

    private void registerListeners() {
        this.addMouseListener(new MouseAdapter(){});
        this.calendar.addMouseListener(this);
        this.calendar.addGridSelectionListener(this);
        this.calendar.addFocusListener(this.fc);
        this.fc.addComponent(this.calendar);
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == this.clickCount) {
            this.dataModel.exitEvent();
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    private int getDateValue() {
        return this.scrollbar.getValue();
    }

    protected void setColours(Component c) {
        c.setBackground(this.getBackground());
        c.setForeground(this.getForeground());
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        this.updateComponentColours(this);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.updateComponentColours(this);
    }

    private void updateComponentColours(Container c) {
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            this.setColours(children[i]);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            this.setComponentFont(children[i]);
        }
    }

    public void setComponentFont(Component c) {
        c.setFont(this.getFont());
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            for (int i = 0; i < children.length; ++i) {
                children[i].setFont(this.getFont());
                this.setComponentFont(children[i]);
            }
        }
    }

    public void setForeground(int day, Color color) {
        this.calendar.setForeground(day, color);
        this.header.setForeground(day, color);
        this.repaint();
    }

    public void setBackground(int day, Color color) {
        this.calendar.setBackground(day, color);
        this.header.setBackground(day, color);
    }

    public void setBackground(Color[] colors) {
        this.calendar.setBackground(colors);
        this.header.setBackground(colors);
        this.repaint();
    }

    public void setForeground(Color[] colors) {
        this.calendar.setForeground(colors);
        this.header.setForeground(colors);
        this.repaint();
    }

    public void setCellSize(Dimension cellSize) {
        this.calendar.setCellSize(cellSize);
        this.header.setCellSize(cellSize);
    }

    public void setFocusCycleRoot(boolean fcr) {
        this.focusCycleRoot = fcr;
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void close(String command) {
        if (command.equals("CLOSE")) {
            this.dataModel.exitEvent();
        } else {
            this.dataModel.lostFocus();
        }
    }
}

