/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import freenet.support.RandomAccessFileBucket2;
import java.io.IOException;

public class StripedBucketArray2 {
    private RandomAccessFileBucket2[] Buckets = null;
    private BucketData[] srcData = null;

    public Bucket[] allocate(Bucket[] src) throws IOException {
        if (this.srcData != null) {
            throw new IllegalStateException("Release the previously allocated buckets!");
        }
        long size = src[0].size();
        Bucket[] ret = new Bucket[src.length];
        try {
            this.srcData = new BucketData[src.length];
            for (int i = 0; i < src.length; ++i) {
                this.srcData[i] = StripedBucketArray2.makeBucketData(src[i]);
                ret[i] = this.srcData[i].rafb;
            }
        }
        catch (IOException ioe) {
            this.srcData = null;
            throw ioe;
        }
        return ret;
    }

    public void release() {
        if (this.srcData == null) {
            return;
        }
        for (int i = 0; i < this.srcData.length; ++i) {
            try {
                this.srcData[i].release();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.srcData = null;
    }

    public void setRange(long offset, long len) throws IOException {
        for (int i = 0; i < this.srcData.length; ++i) {
            this.srcData[i].rafb.setRange(this.srcData[i].offset + offset, len);
        }
    }

    private static BucketData makeBucketData(Bucket b) throws IOException {
        if (b instanceof RandomAccessFileBucket2) {
            return new BucketData((RandomAccessFileBucket2)b);
        }
        throw new IllegalArgumentException("Bucket must be of type RandomAccessFileBucket2.");
    }

    private static class BucketData {
        long offset = 0L;
        long len = 0L;
        boolean fromRAFB = false;
        RandomAccessFileBucket2 rafb = null;

        BucketData(RandomAccessFileBucket2 rafb) {
            RandomAccessFileBucket2.Range r = rafb.getRange();
            this.offset = r.offset;
            this.len = r.len;
            this.fromRAFB = true;
            this.rafb = rafb;
        }

        void release() {
            if (this.fromRAFB) {
                try {
                    this.rafb.setRange(this.offset, this.len);
                }
                catch (Exception exception) {}
            } else {
                this.rafb.release();
            }
            this.rafb = null;
        }
    }
}

