/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import fecimpl.FECUtils;
import fecimpl.OnionFECBase;
import freenet.client.FECDecoder;
import freenet.support.Bucket;
import freenet.support.StripedBucketArray;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;

public class OnionFECDecoder
extends OnionFECBase
implements FECDecoder {
    private static Logger logger = Logger.getLogger(OnionFECDecoder.class.getName());
    private Hashtable buckets = new Hashtable();

    public OnionFECDecoder() {
        this("OnionFEC_a_1_2", 1, 2);
    }

    protected OnionFECDecoder(String name, int redundancyNum, int redundancyDenom) {
        super(name, redundancyNum, redundancyDenom);
    }

    public void release() {
        this.releaseBuckets();
        super.release();
    }

    public void putBucket(Bucket bucket, int number) throws IOException {
        Integer index = new Integer(number);
        if (this.buckets.get(index) != null) {
            throw new IOException("You already put bucket: " + number);
        }
        this.buckets.put(index, bucket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decode(int[] decodedIndices, Bucket[] decodedBlocks) throws IOException {
        if (decodedIndices.length != decodedBlocks.length) {
            return false;
        }
        if (decodedIndices.length == 0) {
            logger.warning("OnionFECDecoder.decode -- Refusing to decode 0 segments.");
            return false;
        }
        if (!this.isDecodable()) {
            return false;
        }
        Bucket[] orderedBuckets = new Bucket[this.n];
        Enumeration e = this.buckets.keys();
        while (e.hasMoreElements()) {
            Bucket bucket;
            Integer number = (Integer)e.nextElement();
            orderedBuckets[number.intValue()] = bucket = (Bucket)this.buckets.get(number);
        }
        FECUtils.NonNulls nn = FECUtils.findNonNullBuckets(orderedBuckets, this.k);
        if (nn.missingIndices.length != decodedIndices.length) {
            return false;
        }
        if (nn.missingIndices.length > 0) {
            Bucket[] decoded = null;
            try {
                decoded = FECUtils.makeBuckets(this.bucketFactory, nn.missingIndices.length, this.blockSize, true);
                if (this.stripeWidth == -1) {
                    FECUtils.decode(this.code, nn.buckets, nn.indices, this.k, nn.missingIndices, decoded);
                } else {
                    StripedBucketArray packetArray = new StripedBucketArray();
                    StripedBucketArray decodedArray = new StripedBucketArray();
                    try {
                        int stripeCount = this.blockSize / this.stripeWidth;
                        Bucket[] packetStripe = packetArray.allocate(nn.buckets);
                        Bucket[] decodedStripe = decodedArray.allocate(decoded);
                        for (int i = 0; i < stripeCount; ++i) {
                            logger.fine("Decoding stripe " + i);
                            packetArray.setRange(i * this.stripeWidth, this.stripeWidth);
                            decodedArray.setRange(i * this.stripeWidth, this.stripeWidth);
                            FECUtils.decode(this.code, packetStripe, nn.indices, this.k, nn.missingIndices, decodedStripe);
                        }
                    }
                    finally {
                        packetArray.release();
                        decodedArray.release();
                    }
                }
                int index = 0;
                for (int i = 0; i < this.k; ++i) {
                    if (orderedBuckets[i] == null) {
                        decodedIndices[index] = i;
                        decodedBlocks[index] = decoded[index];
                        decoded[index] = null;
                        ++index;
                    }
                    this.buckets.remove(new Integer(i));
                }
                decoded = null;
            }
            catch (Throwable throwable) {
                FECUtils.freeBuckets(this.bucketFactory, decoded);
                this.releaseBuckets();
                throw throwable;
            }
            FECUtils.freeBuckets(this.bucketFactory, decoded);
            this.releaseBuckets();
        }
        return true;
    }

    public boolean setSegment(int seg) {
        if (this.currentSegment != seg) {
            this.releaseBuckets();
            return super.setSegment(seg);
        }
        return true;
    }

    public boolean isDecodable() {
        return this.buckets.size() >= this.k;
    }

    public int missingBlocks() {
        int count = 0;
        for (int i = 0; i < this.n; ++i) {
            if (this.buckets.get(new Integer(i)) == null) continue;
            ++count;
        }
        return this.n - count;
    }

    private void releaseBuckets() {
        Enumeration e = this.buckets.elements();
        while (e.hasMoreElements()) {
            Bucket bucket = (Bucket)e.nextElement();
            try {
                this.bucketFactory.freeBucket(bucket);
            }
            catch (IOException iOException) {}
        }
        this.buckets.clear();
    }
}

