/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import com.onionnetworks.fec.DefaultFECCodeFactory;
import com.onionnetworks.fec.FECCode;
import fecimpl.SegmentationParams;
import freenet.support.BucketFactory;

public class OnionFECBase {
    protected String name = null;
    protected int redundancyNumerator = -1;
    protected int redundancyDenominator = -1;
    protected SegmentationParams segParams = null;
    protected int n = -1;
    protected int k = -1;
    protected int blockSize = -1;
    protected int stripeWidth = -1;
    protected int currentSegment = -1;
    protected FECCode code = null;
    protected BucketFactory bucketFactory = null;

    protected OnionFECBase(String name, int redundancyNumerator, int redundancyDenominator) {
        this.name = name;
        this.redundancyNumerator = redundancyNumerator;
        this.redundancyDenominator = redundancyDenominator;
    }

    protected SegmentationParams calculateParams(long fileSize) {
        return new SegmentationParams(fileSize, this.redundancyNumerator, this.redundancyDenominator);
    }

    public boolean init(long fileSize, BucketFactory factory) {
        this.release();
        this.segParams = this.calculateParams(fileSize);
        this.bucketFactory = factory;
        this.n = this.segParams.baseN;
        this.k = this.segParams.baseK;
        this.blockSize = this.segParams.baseBlockSize;
        this.stripeWidth = this.segParams.baseStripeWidth;
        this.currentSegment = 0;
        DefaultFECCodeFactory f = new DefaultFECCodeFactory();
        this.code = f.createFECCode(this.k, this.n);
        return this.code != null;
    }

    public void release() {
        this.code = null;
    }

    public String getName() {
        return this.name;
    }

    public int getBlockSize(int segment) {
        if (this.segParams.segments == 1 || segment < this.segParams.segments - 1) {
            return this.segParams.baseBlockSize;
        }
        return this.segParams.endBlockSize;
    }

    public int getBlockSize() {
        return this.getBlockSize(this.currentSegment);
    }

    public int getCheckBlockSize(int segment) {
        return this.getBlockSize(segment);
    }

    public int getCheckBlockSize() {
        return this.getCheckBlockSize(this.currentSegment);
    }

    public int getK() {
        return this.k;
    }

    public int getN() {
        return this.n;
    }

    public int getN(int segment) {
        if (this.segParams.segments == 1 || segment < this.segParams.segments - 1) {
            return this.segParams.baseN;
        }
        return this.segParams.endN;
    }

    public int getK(int segment) {
        if (this.segParams.segments == 1 || segment < this.segParams.segments - 1) {
            return this.segParams.baseK;
        }
        return this.segParams.endK;
    }

    public int getTotalN() {
        if (this.segParams.segments == 1) {
            return this.segParams.baseN;
        }
        return (this.segParams.segments - 1) * this.segParams.baseN + this.segParams.endN;
    }

    public int getTotalK() {
        if (this.segParams.segments == 1) {
            return this.segParams.baseK;
        }
        return (this.segParams.segments - 1) * this.segParams.baseK + this.segParams.endK;
    }

    public int getSegmentCount() {
        return this.segParams.segments;
    }

    public int getCurrentSegment() {
        return this.currentSegment;
    }

    public int getSegmentSize() {
        return this.segParams.baseSegmentSize;
    }

    public int getSegmentSize(int segment) {
        if (this.segParams.segments == 1 || segment < this.segParams.segments - 1) {
            return this.segParams.baseSegmentSize;
        }
        return this.segParams.endSegmentSize;
    }

    public boolean setSegment(int segment) {
        DefaultFECCodeFactory f;
        FECCode newCode;
        if (segment < 0 || segment >= this.segParams.segments) {
            return false;
        }
        if (this.segParams.segments < 2 || segment == this.currentSegment) {
            return true;
        }
        if (this.currentSegment < this.segParams.segments - 1 && segment < this.segParams.segments - 1) {
            return true;
        }
        int newN = this.segParams.baseN;
        int newK = this.segParams.baseK;
        int newBlockSize = this.segParams.baseBlockSize;
        int newStripeWidth = this.segParams.baseStripeWidth;
        if (segment == this.segParams.segments - 1) {
            newK = this.segParams.endK;
            newN = this.segParams.endN;
            newBlockSize = this.segParams.endBlockSize;
            newStripeWidth = this.segParams.endStripeWidth;
        }
        if ((newCode = (f = new DefaultFECCodeFactory()).createFECCode(newK, newN)) != null) {
            this.code = newCode;
            this.n = newN;
            this.k = newK;
            this.blockSize = newBlockSize;
            this.stripeWidth = newStripeWidth;
            this.currentSegment = segment;
            return true;
        }
        return false;
    }
}

