/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.util.Util;
import java.util.logging.Logger;

public class FECMath {
    private static Logger logger = Logger.getLogger(FECMath.class.getName());
    public int gfBits;
    public int gfSize;
    public static final String[] prim_polys = new String[]{null, null, "111", "1101", "11001", "101001", "1100001", "10010001", "101110001", "1000100001", "10010000001", "101000000001", "1100101000001", "11011000000001", "110000100010001", "1100000000000001", "11010000000010001"};
    public char[] gf_exp;
    public int[] gf_log;
    public char[] inverse;
    public char[][] gf_mul_table;

    public FECMath() {
        this(8);
    }

    public FECMath(int gfBits) {
        this.gfBits = gfBits;
        this.gfSize = (1 << gfBits) - 1;
        this.gf_exp = new char[2 * this.gfSize];
        this.gf_log = new int[this.gfSize + 1];
        this.inverse = new char[this.gfSize + 1];
        if (gfBits < 2 || gfBits > 16) {
            throw new IllegalArgumentException("gfBits must be 2 .. 16");
        }
        this.generateGF();
        if (gfBits <= 8) {
            this.initMulTable();
        }
    }

    public final void generateGF() {
        String primPoly = prim_polys[this.gfBits];
        char mask = '\u0001';
        this.gf_exp[this.gfBits] = '\u0000';
        int i = 0;
        while (i < this.gfBits) {
            this.gf_exp[i] = mask;
            this.gf_log[this.gf_exp[i]] = i;
            if (primPoly.charAt(i) == '1') {
                int n = this.gfBits;
                this.gf_exp[n] = (char)(this.gf_exp[n] ^ mask);
            }
            ++i;
            mask = (char)(mask << 1);
        }
        this.gf_log[this.gf_exp[this.gfBits]] = this.gfBits;
        mask = (char)(1 << this.gfBits - 1);
        for (i = this.gfBits + 1; i < this.gfSize; ++i) {
            this.gf_exp[i] = this.gf_exp[i - 1] >= mask ? (char)(this.gf_exp[this.gfBits] ^ (this.gf_exp[i - 1] ^ mask) << 1) : (char)(this.gf_exp[i - 1] << 1);
            this.gf_log[this.gf_exp[i]] = i;
        }
        this.gf_log[0] = this.gfSize;
        for (i = 0; i < this.gfSize; ++i) {
            this.gf_exp[i + this.gfSize] = this.gf_exp[i];
        }
        this.inverse[0] = '\u0000';
        this.inverse[1] = '\u0001';
        for (i = 2; i <= this.gfSize; ++i) {
            this.inverse[i] = this.gf_exp[this.gfSize - this.gf_log[i]];
        }
    }

    public final void initMulTable() {
        if (this.gfBits <= 8) {
            int j;
            this.gf_mul_table = new char[this.gfSize + 1][this.gfSize + 1];
            for (int i = 0; i < this.gfSize + 1; ++i) {
                for (j = 0; j < this.gfSize + 1; ++j) {
                    this.gf_mul_table[i][j] = this.gf_exp[this.modnn(this.gf_log[i] + this.gf_log[j])];
                }
            }
            for (j = 0; j < this.gfSize + 1; ++j) {
                this.gf_mul_table[j][0] = '\u0000';
                this.gf_mul_table[0][j] = '\u0000';
            }
        }
    }

    public final char modnn(int x) {
        while (x >= this.gfSize) {
            x -= this.gfSize;
            x = (x >> this.gfBits) + (x & this.gfSize);
        }
        return (char)x;
    }

    public final char mul(char x, char y) {
        if (this.gfBits <= 8) {
            return this.gf_mul_table[x][y];
        }
        if (x == '\u0000' || y == '\u0000') {
            return '\u0000';
        }
        return this.gf_exp[this.gf_log[x] + this.gf_log[y]];
    }

    public static final char[] createGFMatrix(int rows, int cols) {
        return new char[rows * cols];
    }

    public final void addMul(char[] dst, int dstPos, char[] src, int srcPos, char c, int len) {
        if (c == '\u0000') {
            return;
        }
        int unroll = 16;
        int i = dstPos;
        int j = srcPos;
        int lim = dstPos + len;
        if (this.gfBits <= 8) {
            char[] gf_mulc = this.gf_mul_table[c];
            while (i < lim && lim - i > unroll) {
                int n = i;
                dst[n] = (char)(dst[n] ^ gf_mulc[src[j]]);
                int n2 = i + 1;
                dst[n2] = (char)(dst[n2] ^ gf_mulc[src[j + 1]]);
                int n3 = i + 2;
                dst[n3] = (char)(dst[n3] ^ gf_mulc[src[j + 2]]);
                int n4 = i + 3;
                dst[n4] = (char)(dst[n4] ^ gf_mulc[src[j + 3]]);
                int n5 = i + 4;
                dst[n5] = (char)(dst[n5] ^ gf_mulc[src[j + 4]]);
                int n6 = i + 5;
                dst[n6] = (char)(dst[n6] ^ gf_mulc[src[j + 5]]);
                int n7 = i + 6;
                dst[n7] = (char)(dst[n7] ^ gf_mulc[src[j + 6]]);
                int n8 = i + 7;
                dst[n8] = (char)(dst[n8] ^ gf_mulc[src[j + 7]]);
                int n9 = i + 8;
                dst[n9] = (char)(dst[n9] ^ gf_mulc[src[j + 8]]);
                int n10 = i + 9;
                dst[n10] = (char)(dst[n10] ^ gf_mulc[src[j + 9]]);
                int n11 = i + 10;
                dst[n11] = (char)(dst[n11] ^ gf_mulc[src[j + 10]]);
                int n12 = i + 11;
                dst[n12] = (char)(dst[n12] ^ gf_mulc[src[j + 11]]);
                int n13 = i + 12;
                dst[n13] = (char)(dst[n13] ^ gf_mulc[src[j + 12]]);
                int n14 = i + 13;
                dst[n14] = (char)(dst[n14] ^ gf_mulc[src[j + 13]]);
                int n15 = i + 14;
                dst[n15] = (char)(dst[n15] ^ gf_mulc[src[j + 14]]);
                int n16 = i + 15;
                dst[n16] = (char)(dst[n16] ^ gf_mulc[src[j + 15]]);
                i += unroll;
                j += unroll;
            }
            while (i < lim) {
                int n = i++;
                dst[n] = (char)(dst[n] ^ gf_mulc[src[j]]);
                ++j;
            }
        } else {
            int mulcPos = this.gf_log[c];
            while (i < lim) {
                char y = src[j];
                if (y != '\u0000') {
                    int n = i;
                    dst[n] = (char)(dst[n] ^ this.gf_exp[mulcPos + this.gf_log[y]]);
                }
                ++i;
                ++j;
            }
        }
    }

    public final void addMul(byte[] dst, int dstPos, byte[] _src, int srcPos, byte c, int len) {
        if (c == 0) {
            return;
        }
        int lim = dstPos + len;
        int unrolledLoopEnd = lim - len % 16;
        byte[] src = _src;
        char[] gf_mulc = this.gf_mul_table[c & 0xFF];
        if (dstPos == srcPos) {
            int i;
            for (i = dstPos; i < unrolledLoopEnd; ++i) {
                int n = i;
                dst[n] = (byte)(dst[n] ^ gf_mulc[src[i] & 0xFF]);
                int n2 = ++i;
                dst[n2] = (byte)(dst[n2] ^ gf_mulc[src[i] & 0xFF]);
                int n3 = ++i;
                dst[n3] = (byte)(dst[n3] ^ gf_mulc[src[i] & 0xFF]);
                int n4 = ++i;
                dst[n4] = (byte)(dst[n4] ^ gf_mulc[src[i] & 0xFF]);
                int n5 = ++i;
                dst[n5] = (byte)(dst[n5] ^ gf_mulc[src[i] & 0xFF]);
                int n6 = ++i;
                dst[n6] = (byte)(dst[n6] ^ gf_mulc[src[i] & 0xFF]);
                int n7 = ++i;
                dst[n7] = (byte)(dst[n7] ^ gf_mulc[src[i] & 0xFF]);
                int n8 = ++i;
                dst[n8] = (byte)(dst[n8] ^ gf_mulc[src[i] & 0xFF]);
                int n9 = ++i;
                dst[n9] = (byte)(dst[n9] ^ gf_mulc[src[i] & 0xFF]);
                int n10 = ++i;
                dst[n10] = (byte)(dst[n10] ^ gf_mulc[src[i] & 0xFF]);
                int n11 = ++i;
                dst[n11] = (byte)(dst[n11] ^ gf_mulc[src[i] & 0xFF]);
                int n12 = ++i;
                dst[n12] = (byte)(dst[n12] ^ gf_mulc[src[i] & 0xFF]);
                int n13 = ++i;
                dst[n13] = (byte)(dst[n13] ^ gf_mulc[src[i] & 0xFF]);
                int n14 = ++i;
                dst[n14] = (byte)(dst[n14] ^ gf_mulc[src[i] & 0xFF]);
                int n15 = ++i;
                dst[n15] = (byte)(dst[n15] ^ gf_mulc[src[i] & 0xFF]);
                int n16 = ++i;
                dst[n16] = (byte)(dst[n16] ^ gf_mulc[src[i] & 0xFF]);
            }
            while (i < lim) {
                int n = i;
                dst[n] = (byte)(dst[n] ^ gf_mulc[src[i] & 0xFF]);
                ++i;
            }
            return;
        }
        int i = dstPos;
        int j = srcPos;
        while (i < unrolledLoopEnd) {
            int n = i++;
            dst[n] = (byte)(dst[n] ^ gf_mulc[src[j] & 0xFF]);
            int n17 = i++;
            dst[n17] = (byte)(dst[n17] ^ gf_mulc[src[++j] & 0xFF]);
            int n18 = i++;
            dst[n18] = (byte)(dst[n18] ^ gf_mulc[src[++j] & 0xFF]);
            int n19 = i++;
            dst[n19] = (byte)(dst[n19] ^ gf_mulc[src[++j] & 0xFF]);
            int n20 = i++;
            dst[n20] = (byte)(dst[n20] ^ gf_mulc[src[++j] & 0xFF]);
            int n21 = i++;
            dst[n21] = (byte)(dst[n21] ^ gf_mulc[src[++j] & 0xFF]);
            int n22 = i++;
            dst[n22] = (byte)(dst[n22] ^ gf_mulc[src[++j] & 0xFF]);
            int n23 = i++;
            dst[n23] = (byte)(dst[n23] ^ gf_mulc[src[++j] & 0xFF]);
            int n24 = i++;
            dst[n24] = (byte)(dst[n24] ^ gf_mulc[src[++j] & 0xFF]);
            int n25 = i++;
            dst[n25] = (byte)(dst[n25] ^ gf_mulc[src[++j] & 0xFF]);
            int n26 = i++;
            dst[n26] = (byte)(dst[n26] ^ gf_mulc[src[++j] & 0xFF]);
            int n27 = i++;
            dst[n27] = (byte)(dst[n27] ^ gf_mulc[src[++j] & 0xFF]);
            int n28 = i++;
            dst[n28] = (byte)(dst[n28] ^ gf_mulc[src[++j] & 0xFF]);
            int n29 = i++;
            dst[n29] = (byte)(dst[n29] ^ gf_mulc[src[++j] & 0xFF]);
            int n30 = i++;
            dst[n30] = (byte)(dst[n30] ^ gf_mulc[src[++j] & 0xFF]);
            int n31 = i++;
            dst[n31] = (byte)(dst[n31] ^ gf_mulc[src[++j] & 0xFF]);
            ++j;
        }
        while (i < lim) {
            int n = i++;
            dst[n] = (byte)(dst[n] ^ gf_mulc[src[j] & 0xFF]);
            ++j;
        }
    }

    public final void matMul(char[] a, char[] b, char[] c, int n, int k, int m) {
        this.matMul(a, 0, b, 0, c, 0, n, k, m);
    }

    public final void matMul(char[] a, int aStart, char[] b, int bStart, char[] c, int cStart, int n, int k, int m) {
        for (int row = 0; row < n; ++row) {
            for (int col = 0; col < m; ++col) {
                int posA = row * k;
                int posB = col;
                char acc = '\u0000';
                int i = 0;
                while (i < k) {
                    acc = (char)(acc ^ this.mul(a[aStart + posA], b[bStart + posB]));
                    ++i;
                    ++posA;
                    posB += m;
                }
                c[cStart + (row * m + col)] = acc;
            }
        }
    }

    public static final boolean isIdentity(char[] m, int k) {
        int pos = 0;
        for (int row = 0; row < k; ++row) {
            for (int col = 0; col < k; ++col) {
                if (row == col && m[pos] != '\u0001' || row != col && m[pos] != '\u0000') {
                    return false;
                }
                ++pos;
            }
        }
        return true;
    }

    public final void invertMatrix(char[] src, int k) throws IllegalArgumentException {
        int col;
        int[] indxc = new int[k];
        int[] indxr = new int[k];
        int[] ipiv = new int[k];
        char[] id_row = FECMath.createGFMatrix(1, k);
        char[] temp_row = FECMath.createGFMatrix(1, k);
        for (col = 0; col < k; ++col) {
            int irow = -1;
            int icol = -1;
            boolean foundPiv = false;
            if (ipiv[col] != 1 && src[col * k + col] != '\u0000') {
                irow = col;
                icol = col;
                foundPiv = true;
            }
            if (!foundPiv) {
                block1: for (int row = 0; row < k; ++row) {
                    if (ipiv[row] == 1) continue;
                    for (int ix = 0; ix < k; ++ix) {
                        if (ipiv[ix] == 0) {
                            if (src[row * k + ix] == '\u0000') continue;
                            irow = row;
                            icol = ix;
                            foundPiv = true;
                            break block1;
                        }
                        if (ipiv[ix] <= 1) continue;
                        throw new IllegalArgumentException("singular matrix");
                    }
                }
            }
            if (!foundPiv && icol == -1) {
                throw new IllegalArgumentException("XXX pivot not found!");
            }
            foundPiv = false;
            ipiv[icol] = ipiv[icol] + 1;
            if (irow != icol) {
                for (int ix = 0; ix < k; ++ix) {
                    char tmp = src[irow * k + ix];
                    src[irow * k + ix] = src[icol * k + ix];
                    src[icol * k + ix] = tmp;
                }
            }
            indxr[col] = irow;
            indxc[col] = icol;
            int pivotRowPos = icol * k;
            char c = src[pivotRowPos + icol];
            if (c == '\u0000') {
                throw new IllegalArgumentException("singular matrix 2");
            }
            if (c != '\u0001') {
                c = this.inverse[c];
                src[pivotRowPos + icol] = '\u0001';
                for (int ix = 0; ix < k; ++ix) {
                    src[pivotRowPos + ix] = this.mul(c, src[pivotRowPos + ix]);
                }
            }
            id_row[icol] = '\u0001';
            if (!Util.arraysEqual(src, pivotRowPos, id_row, 0, k)) {
                int p = 0;
                int ix = 0;
                while (ix < k) {
                    if (ix != icol) {
                        c = src[p + icol];
                        src[p + icol] = '\u0000';
                        this.addMul(src, p, src, pivotRowPos, c, k);
                    }
                    ++ix;
                    p += k;
                }
            }
            id_row[icol] = '\u0000';
        }
        for (col = k - 1; col >= 0; --col) {
            if (indxr[col] < 0 || indxr[col] >= k) {
                logger.finer("AARGH, indxr[col] " + indxr[col]);
                continue;
            }
            if (indxc[col] < 0 || indxc[col] >= k) {
                logger.finer("AARGH, indxc[col] " + indxc[col]);
                continue;
            }
            if (indxr[col] == indxc[col]) continue;
            for (int row = 0; row < k; ++row) {
                char tmp = src[row * k + indxc[col]];
                src[row * k + indxc[col]] = src[row * k + indxr[col]];
                src[row * k + indxr[col]] = tmp;
            }
        }
    }

    public final void invertVandermonde(char[] src, int k) {
        if (k == 1) {
            return;
        }
        char[] c = FECMath.createGFMatrix(1, k);
        char[] b = FECMath.createGFMatrix(1, k);
        char[] p = FECMath.createGFMatrix(1, k);
        int j = 1;
        int i = 0;
        while (i < k) {
            c[i] = '\u0000';
            p[i] = src[j];
            ++i;
            j += k;
        }
        c[k - 1] = p[0];
        for (int i2 = 1; i2 < k; ++i2) {
            char p_i = p[i2];
            for (int j2 = k - 1 - (i2 - 1); j2 < k - 1; ++j2) {
                int n = j2;
                c[n] = (char)(c[n] ^ this.mul(p_i, c[j2 + 1]));
            }
            int n = k - 1;
            c[n] = (char)(c[n] ^ p_i);
        }
        for (int row = 0; row < k; ++row) {
            char xx = p[row];
            char t = '\u0001';
            b[k - 1] = '\u0001';
            for (int i3 = k - 2; i3 >= 0; --i3) {
                b[i3] = (char)(c[i3 + 1] ^ this.mul(xx, b[i3 + 1]));
                t = (char)(this.mul(xx, t) ^ b[i3]);
            }
            for (int col = 0; col < k; ++col) {
                src[col * k + row] = this.mul(this.inverse[t], b[col]);
            }
        }
    }

    public final char[] createEncodeMatrix(int k, int n) {
        if (k > this.gfSize + 1 || n > this.gfSize + 1 || k > n) {
            throw new IllegalArgumentException("Invalid parameters n=" + n + ",k=" + k + ",gfSize=" + this.gfSize);
        }
        char[] encMatrix = FECMath.createGFMatrix(n, k);
        char[] tmpMatrix = FECMath.createGFMatrix(n, k);
        tmpMatrix[0] = '\u0001';
        int pos = k;
        int row = 0;
        while (row < n - 1) {
            for (int col = 0; col < k; ++col) {
                tmpMatrix[pos + col] = this.gf_exp[this.modnn(row * col)];
            }
            ++row;
            pos += k;
        }
        this.invertVandermonde(tmpMatrix, k);
        this.matMul(tmpMatrix, k * k, tmpMatrix, 0, encMatrix, k * k, n - k, k, k);
        Util.bzero(encMatrix, 0, k * k);
        int i = 0;
        int col = 0;
        while (col < k) {
            encMatrix[i] = '\u0001';
            ++col;
            i += k + 1;
        }
        return encMatrix;
    }

    protected final char[] createDecodeMatrix(char[] encMatrix, int[] index, int k, int n) {
        char[] matrix = FECMath.createGFMatrix(k, k);
        int i = 0;
        int pos = 0;
        while (i < k) {
            System.arraycopy(encMatrix, index[i] * k, matrix, pos, k);
            ++i;
            pos += k;
        }
        this.invertMatrix(matrix, k);
        return matrix;
    }
}

