/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.provider.PKIXCertPath;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.util.encoders.Base64;

public class JDKX509CertificateFactory
extends CertificateFactorySpi {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();
    private SignedData sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;
    private SignedData sCrlData = null;
    private int sCrlDataObjectCount = 0;
    private InputStream currentCrlStream = null;

    private int getLimit(InputStream inputStream) throws IOException {
        if (inputStream instanceof ByteArrayInputStream) {
            return inputStream.available();
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != 10 && n >= 0) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        if (n < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private Certificate readDERCertificate(ASN1InputStream aSN1InputStream) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof DERObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true));
            return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
        }
        return new X509CertificateObject(X509CertificateStructure.getInstance(aSN1Sequence));
    }

    private Certificate readPKCS7Certificate(InputStream inputStream) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream, this.getLimit(inputStream));
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof DERObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true));
            return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
        }
        return new X509CertificateObject(X509CertificateStructure.getInstance(aSN1Sequence));
    }

    private Certificate readPEMCertificate(InputStream inputStream) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(inputStream)) != null && !string.equals("-----BEGIN CERTIFICATE-----") && !string.equals("-----BEGIN X509 CERTIFICATE-----")) {
        }
        while ((string = this.readLine(inputStream)) != null && !string.equals("-----END CERTIFICATE-----") && !string.equals("-----END X509 CERTIFICATE-----")) {
            stringBuffer.append(string);
        }
        if (stringBuffer.length() != 0) {
            return this.readDERCertificate(new ASN1InputStream(Base64.decode(stringBuffer.toString())));
        }
        return null;
    }

    private CRL readDERCRL(ASN1InputStream aSN1InputStream) throws IOException, CRLException {
        return new X509CRLObject(new CertificateList((ASN1Sequence)aSN1InputStream.readObject()));
    }

    private CRL readPEMCRL(InputStream inputStream) throws IOException, CRLException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(inputStream)) != null && !string.equals("-----BEGIN CRL-----") && !string.equals("-----BEGIN X509 CRL-----")) {
        }
        while ((string = this.readLine(inputStream)) != null && !string.equals("-----END CRL-----") && !string.equals("-----END X509 CRL-----")) {
            stringBuffer.append(string);
        }
        if (stringBuffer.length() != 0) {
            return this.readDERCRL(new ASN1InputStream(Base64.decode(stringBuffer.toString())));
        }
        return null;
    }

    private CRL readPKCS7CRL(InputStream inputStream) throws IOException, CRLException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream, this.getLimit(inputStream));
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof DERObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sCrlData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true));
            return new X509CRLObject(CertificateList.getInstance(this.sCrlData.getCRLs().getObjectAt(this.sCrlDataObjectCount++)));
        }
        return new X509CRLObject(CertificateList.getInstance(aSN1Sequence));
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (this.currentStream == null) {
            this.currentStream = inputStream;
            this.sData = null;
            this.sDataObjectCount = 0;
        } else if (this.currentStream != inputStream) {
            this.currentStream = inputStream;
            this.sData = null;
            this.sDataObjectCount = 0;
        }
        try {
            if (this.sData != null) {
                if (this.sDataObjectCount != this.sData.getCertificates().size()) {
                    return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
                }
                this.sData = null;
                this.sDataObjectCount = 0;
                return null;
            }
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(10);
            int n = inputStream.read();
            if (n == -1) {
                return null;
            }
            if (n != 48) {
                inputStream.reset();
                return this.readPEMCertificate(inputStream);
            }
            if (inputStream.read() == 128) {
                inputStream.reset();
                return this.readPKCS7Certificate(new ASN1InputStream(inputStream, this.getLimit(inputStream)));
            }
            inputStream.reset();
            return this.readDERCertificate(new ASN1InputStream(inputStream, this.getLimit(inputStream)));
        }
        catch (Exception exception) {
            throw new CertificateException(exception.toString());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        Certificate certificate;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        while ((certificate = this.engineGenerateCertificate(inputStream)) != null) {
            arrayList.add(certificate);
        }
        return arrayList;
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (this.currentCrlStream == null) {
            this.currentCrlStream = inputStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        } else if (this.currentCrlStream != inputStream) {
            this.currentCrlStream = inputStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        }
        try {
            if (this.sCrlData != null) {
                if (this.sCrlDataObjectCount != this.sCrlData.getCertificates().size()) {
                    return new X509CRLObject(CertificateList.getInstance(this.sCrlData.getCRLs().getObjectAt(this.sCrlDataObjectCount++)));
                }
                this.sCrlData = null;
                this.sCrlDataObjectCount = 0;
                return null;
            }
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(10);
            if (inputStream.read() != 48) {
                inputStream.reset();
                return this.readPEMCRL(inputStream);
            }
            if (inputStream.read() == 128) {
                inputStream.reset();
                return this.readPKCS7CRL(inputStream);
            }
            inputStream.reset();
            return this.readDERCRL(new ASN1InputStream(inputStream, this.getLimit(inputStream)));
        }
        catch (CRLException cRLException) {
            throw cRLException;
        }
        catch (Exception exception) {
            throw new CRLException(exception.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        CRL cRL;
        ArrayList<CRL> arrayList = new ArrayList<CRL>();
        while ((cRL = this.engineGenerateCRL(inputStream)) != null) {
            arrayList.add(cRL);
        }
        return arrayList;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        return this.engineGenerateCertPath(inputStream, "PkiPath");
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        return new PKIXCertPath(inputStream, string);
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || e instanceof X509Certificate) continue;
            throw new CertificateException("list contains none X509Certificate object while creating CertPath\n" + e.toString());
        }
        return new PKIXCertPath(list);
    }
}

