/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.garret.perst.BitIndex;
import org.garret.perst.CustomSerializable;
import org.garret.perst.Key;
import org.garret.perst.XMLImportException;
import org.garret.perst.impl.BitIndexImpl;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeCaseInsensitiveFieldIndex;
import org.garret.perst.impl.BtreeCaseInsensitiveMultiFieldIndex;
import org.garret.perst.impl.BtreeCompoundIndex;
import org.garret.perst.impl.BtreeFieldIndex;
import org.garret.perst.impl.BtreeMultiFieldIndex;
import org.garret.perst.impl.ByteBuffer;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.ObjectHeader;
import org.garret.perst.impl.PersistentSet;
import org.garret.perst.impl.PersistentStub;
import org.garret.perst.impl.StorageImpl;

public class XMLImporter {
    StorageImpl storage;
    XMLScanner scanner;
    int[] idMap;
    static final String dateFormat = "EEE, d MMM yyyy kk:mm:ss z";
    static final DateFormat httpFormatter = new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss z", Locale.ENGLISH);

    public XMLImporter(StorageImpl storage, Reader reader) {
        this.storage = storage;
        this.scanner = new XMLScanner(reader);
    }

    public void importDatabase() throws XMLImportException {
        int tkn;
        if (this.scanner.scan() != 4 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals("database")) {
            this.throwException("No root element");
        }
        if (this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals("root") || this.scanner.scan() != 8 || this.scanner.scan() != 1 || this.scanner.scan() != 5) {
            this.throwException("Database element should have \"root\" attribute");
        }
        int rootId = 0;
        try {
            rootId = Integer.parseInt(this.scanner.getString());
        }
        catch (NumberFormatException x) {
            this.throwException("Incorrect root object specification");
        }
        this.idMap = new int[rootId * 2];
        this.idMap[rootId] = this.storage.allocateId();
        this.storage.header.root[1 - this.storage.currIndex].rootObject = this.idMap[rootId];
        while ((tkn = this.scanner.scan()) == 4) {
            String elemName;
            if (this.scanner.scan() != 0) {
                this.throwException("Element name expected");
            }
            if ((elemName = this.scanner.getIdentifier()).equals("org.garret.perst.impl.Btree") || elemName.equals("org.garret.perst.impl.BitIndexImpl") || elemName.equals("org.garret.perst.impl.PersistentSet") || elemName.equals("org.garret.perst.impl.BtreeFieldIndex") || elemName.equals("org.garret.perst.impl.BtreeCaseInsensitiveFieldIndex") || elemName.equals("org.garret.perst.impl.BtreeCompoundIndex") || elemName.equals("org.garret.perst.impl.BtreeMultiFieldIndex") || elemName.equals("org.garret.perst.impl.BtreeCaseInsensitiveMultiFieldIndex")) {
                this.createIndex(elemName);
                continue;
            }
            this.createObject(this.readElement(elemName));
        }
        if (tkn != 6 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals("database") || this.scanner.scan() != 5) {
            this.throwException("Root element is not closed");
        }
    }

    final String getAttribute(XMLElement elem, String name) throws XMLImportException {
        String value = elem.getAttribute(name);
        if (value == null) {
            this.throwException("Attribute " + name + " is not set");
        }
        return value;
    }

    final int getIntAttribute(XMLElement elem, String name) throws XMLImportException {
        String value = elem.getAttribute(name);
        if (value == null) {
            this.throwException("Attribute " + name + " is not set");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException x) {
            this.throwException("Attribute " + name + " should has integer value");
            return -1;
        }
    }

    final int mapId(int id) {
        int oid = 0;
        if (id != 0) {
            if (id >= this.idMap.length) {
                int[] newMap = new int[id * 2];
                System.arraycopy(this.idMap, 0, newMap, 0, this.idMap.length);
                this.idMap = newMap;
                this.idMap[id] = oid = this.storage.allocateId();
            } else {
                oid = this.idMap[id];
                if (oid == 0) {
                    this.idMap[id] = oid = this.storage.allocateId();
                }
            }
        }
        return oid;
    }

    final int mapType(String signature) throws XMLImportException {
        for (int i = 0; i < ClassDescriptor.signature.length; ++i) {
            if (!ClassDescriptor.signature[i].equals(signature)) continue;
            return i;
        }
        this.throwException("Bad type");
        return -1;
    }

    final Key createCompoundKey(int[] types, String[] values) throws XMLImportException {
        ByteBuffer buf = new ByteBuffer();
        int dst = 0;
        try {
            block15: for (int i = 0; i < types.length; ++i) {
                String value = values[i];
                switch (types[i]) {
                    case 0: {
                        buf.extend(dst + 1);
                        buf.arr[dst++] = (byte)(Integer.parseInt(value) != 0 ? 1 : 0);
                        continue block15;
                    }
                    case 1: {
                        buf.extend(dst + 1);
                        buf.arr[dst++] = Byte.parseByte(value);
                        continue block15;
                    }
                    case 2: {
                        buf.extend(dst + 2);
                        Bytes.pack2(buf.arr, dst, (short)Integer.parseInt(value));
                        dst += 2;
                        continue block15;
                    }
                    case 3: {
                        buf.extend(dst + 2);
                        Bytes.pack2(buf.arr, dst, Short.parseShort(value));
                        dst += 2;
                        continue block15;
                    }
                    case 4: 
                    case 14: {
                        buf.extend(dst + 4);
                        Bytes.pack4(buf.arr, dst, Integer.parseInt(value));
                        dst += 4;
                        continue block15;
                    }
                    case 10: {
                        buf.extend(dst + 4);
                        Bytes.pack4(buf.arr, dst, this.mapId(Integer.parseInt(value)));
                        dst += 4;
                        continue block15;
                    }
                    case 5: 
                    case 9: {
                        buf.extend(dst + 8);
                        Bytes.pack8(buf.arr, dst, Long.parseLong(value));
                        dst += 8;
                        continue block15;
                    }
                    case 6: {
                        buf.extend(dst + 4);
                        Bytes.pack4(buf.arr, dst, Float.floatToIntBits(Float.parseFloat(value)));
                        dst += 4;
                        continue block15;
                    }
                    case 7: {
                        buf.extend(dst + 8);
                        Bytes.pack8(buf.arr, dst, Double.doubleToLongBits(Double.parseDouble(value)));
                        dst += 8;
                        continue block15;
                    }
                    case 8: {
                        dst = buf.packString(dst, value, this.storage.encoding);
                        continue block15;
                    }
                    case 21: {
                        buf.extend(dst + 4 + (value.length() >>> 1));
                        Bytes.pack4(buf.arr, dst, value.length() >>> 1);
                        dst += 4;
                        int n = value.length();
                        for (int j = 0; j < n; j += 2) {
                            buf.arr[dst++] = (byte)(this.getHexValue(value.charAt(j)) << 4 | this.getHexValue(value.charAt(j + 1)));
                        }
                        continue block15;
                    }
                    default: {
                        this.throwException("Bad key type");
                    }
                }
            }
        }
        catch (NumberFormatException x) {
            this.throwException("Failed to convert key value");
        }
        return new Key(buf.toArray());
    }

    final Key createKey(int type, String value) throws XMLImportException {
        try {
            switch (type) {
                case 0: {
                    return new Key(Integer.parseInt(value) != 0);
                }
                case 1: {
                    return new Key(Byte.parseByte(value));
                }
                case 2: {
                    return new Key((char)Integer.parseInt(value));
                }
                case 3: {
                    return new Key(Short.parseShort(value));
                }
                case 4: 
                case 14: {
                    return new Key(Integer.parseInt(value));
                }
                case 10: {
                    return new Key(new PersistentStub(this.storage, this.mapId(Integer.parseInt(value))));
                }
                case 5: {
                    return new Key(Long.parseLong(value));
                }
                case 6: {
                    return new Key(Float.parseFloat(value));
                }
                case 7: {
                    return new Key(Double.parseDouble(value));
                }
                case 8: {
                    return new Key(value);
                }
                case 21: {
                    byte[] buf = new byte[value.length() >> 1];
                    for (int i = 0; i < buf.length; ++i) {
                        buf[i] = (byte)(this.getHexValue(value.charAt(i * 2)) << 4 | this.getHexValue(value.charAt(i * 2 + 1)));
                    }
                    return new Key(buf);
                }
                case 9: {
                    Date date;
                    if (value.equals("null")) {
                        date = null;
                    } else {
                        date = httpFormatter.parse(value, new ParsePosition(0));
                        if (date == null) {
                            this.throwException("Invalid date");
                        }
                    }
                    return new Key(date);
                }
            }
            this.throwException("Bad key type");
        }
        catch (NumberFormatException x) {
            this.throwException("Failed to convert key value");
        }
        return null;
    }

    final int parseInt(String str) throws XMLImportException {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException x) {
            this.throwException("Bad integer constant");
            return -1;
        }
    }

    final void createIndex(String indexType) throws XMLImportException {
        int tkn;
        Btree btree = null;
        int oid = 0;
        boolean unique = false;
        String className = null;
        String fieldName = null;
        String[] fieldNames = null;
        int[] types = null;
        long autoinc = 0L;
        String type = null;
        while ((tkn = this.scanner.scan()) == 0) {
            String attrName = this.scanner.getIdentifier();
            if (this.scanner.scan() != 8 || this.scanner.scan() != 1) {
                this.throwException("Attribute value expected");
            }
            String attrValue = this.scanner.getString();
            if (attrName.equals("id")) {
                oid = this.mapId(this.parseInt(attrValue));
                continue;
            }
            if (attrName.equals("unique")) {
                unique = this.parseInt(attrValue) != 0;
                continue;
            }
            if (attrName.equals("class")) {
                className = attrValue;
                continue;
            }
            if (attrName.equals("type")) {
                type = attrValue;
                continue;
            }
            if (attrName.equals("autoinc")) {
                autoinc = this.parseInt(attrValue);
                continue;
            }
            if (attrName.equals("field")) {
                fieldName = attrValue;
                continue;
            }
            if (attrName.startsWith("type")) {
                int typeNo = Integer.parseInt(attrName.substring(4));
                if (types == null || types.length <= typeNo) {
                    int[] newTypes = new int[typeNo + 1];
                    if (types != null) {
                        System.arraycopy(types, 0, newTypes, 0, types.length);
                    }
                    types = newTypes;
                }
                types[typeNo] = this.mapType(attrValue);
                continue;
            }
            if (!attrName.startsWith("field")) continue;
            int fieldNo = Integer.parseInt(attrName.substring(5));
            if (fieldNames == null || fieldNames.length <= fieldNo) {
                String[] newFieldNames = new String[fieldNo + 1];
                if (fieldNames != null) {
                    System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
                }
                fieldNames = newFieldNames;
            }
            fieldNames[fieldNo] = attrValue;
        }
        if (tkn != 5) {
            this.throwException("Unclosed element tag");
        }
        if (oid == 0) {
            this.throwException("ID is not specified or index");
        }
        if (className != null) {
            Class cls = ClassDescriptor.loadClass(this.storage, className);
            if (fieldName != null) {
                btree = indexType.equals("org.garret.perst.impl.BtreeCaseInsensitiveFieldIndex") ? new BtreeCaseInsensitiveFieldIndex(cls, fieldName, unique, autoinc) : new BtreeFieldIndex(cls, fieldName, unique, autoinc);
            } else if (fieldNames != null) {
                btree = indexType.equals("org.garret.perst.impl.BtreeCaseInsensitiveMultiFieldIndex") ? new BtreeCaseInsensitiveMultiFieldIndex(cls, fieldNames, unique) : new BtreeMultiFieldIndex(cls, fieldNames, unique);
            } else {
                this.throwException("Field name is not specified for field index");
            }
        } else if (types != null) {
            btree = new BtreeCompoundIndex(types, unique);
        } else if (type == null) {
            if (indexType.equals("org.garret.perst.impl.PersistentSet")) {
                btree = new PersistentSet();
            } else {
                this.throwException("Key type is not specified for index");
            }
        } else {
            btree = indexType.equals("org.garret.perst.impl.BitIndexImpl") ? new BitIndexImpl() : new Btree(this.mapType(type), unique);
        }
        this.storage.assignOid(btree, oid);
        while ((tkn = this.scanner.scan()) == 4) {
            int i;
            String[] values;
            if (this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals("ref")) {
                this.throwException("<ref> element expected");
            }
            XMLElement ref = this.readElement("ref");
            Key key = null;
            int mask = 0;
            if (fieldNames != null) {
                values = new String[fieldNames.length];
                for (i = 0; i < values.length; ++i) {
                    values[i] = this.getAttribute(ref, "key" + i);
                }
                key = this.createCompoundKey(((BtreeMultiFieldIndex)btree).types, values);
            } else if (types != null) {
                values = new String[types.length];
                for (i = 0; i < values.length; ++i) {
                    values[i] = this.getAttribute(ref, "key" + i);
                }
                key = this.createCompoundKey(types, values);
            } else if (btree instanceof BitIndex) {
                mask = this.getIntAttribute(ref, "key");
            } else {
                key = this.createKey(btree.type, this.getAttribute(ref, "key"));
            }
            PersistentStub obj = new PersistentStub(this.storage, this.mapId(this.getIntAttribute(ref, "id")));
            if (btree instanceof BitIndex) {
                ((BitIndex)((Object)btree)).put(obj, mask);
                continue;
            }
            btree.insert(key, obj, false);
        }
        if (tkn != 6 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals(indexType) || this.scanner.scan() != 5) {
            this.throwException("Element is not closed");
        }
        byte[] data = this.storage.packObject(btree, false);
        int size = ObjectHeader.getSize(data, 0);
        long pos = this.storage.allocate(size, 0);
        this.storage.setPos(oid, pos | 2L);
        this.storage.pool.put(pos & 0xFFFFFFFFFFFFFFF8L, data, size);
    }

    final void createObject(XMLElement elem) throws XMLImportException {
        Class cls = ClassDescriptor.loadClass(this.storage, elem.name);
        ClassDescriptor desc = this.storage.getClassDescriptor(cls);
        int oid = this.mapId(this.getIntAttribute(elem, "id"));
        ByteBuffer buf = new ByteBuffer();
        int offs = 8;
        buf.extend(offs);
        offs = this.packObject(elem, desc, offs, buf);
        ObjectHeader.setSize(buf.arr, 0, offs);
        ObjectHeader.setType(buf.arr, 0, desc.getOid());
        long pos = this.storage.allocate(offs, 0);
        this.storage.setPos(oid, pos | 2L);
        this.storage.pool.put(pos, buf.arr, offs);
    }

    final int getHexValue(char ch) throws XMLImportException {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        this.throwException("Bad hexadecimal constant");
        return -1;
    }

    final int importBinary(XMLElement elem, int offs, ByteBuffer buf, String fieldName) throws XMLImportException {
        if (elem == null || elem.isNullValue()) {
            buf.extend(offs + 4);
            Bytes.pack4(buf.arr, offs, -1);
            offs += 4;
        } else if (elem.isStringValue()) {
            String hexStr = elem.getStringValue();
            int len = hexStr.length();
            if (hexStr.startsWith("#")) {
                buf.extend(offs + 4 + len / 2 - 1);
                Bytes.pack4(buf.arr, offs, -2 - this.getHexValue(hexStr.charAt(1)));
                offs += 4;
                for (int j = 2; j < len; j += 2) {
                    buf.arr[offs++] = (byte)(this.getHexValue(hexStr.charAt(j)) << 4 | this.getHexValue(hexStr.charAt(j + 1)));
                }
            } else {
                buf.extend(offs + 4 + len / 2);
                Bytes.pack4(buf.arr, offs, len / 2);
                offs += 4;
                for (int j = 0; j < len; j += 2) {
                    buf.arr[offs++] = (byte)(this.getHexValue(hexStr.charAt(j)) << 4 | this.getHexValue(hexStr.charAt(j + 1)));
                }
            }
        } else {
            XMLElement ref = elem.getSibling("ref");
            if (ref != null) {
                buf.extend(offs + 4);
                Bytes.pack4(buf.arr, offs, this.mapId(this.getIntAttribute(ref, "id")));
                offs += 4;
            } else {
                XMLElement item = elem.getSibling("element");
                int len = item == null ? 0 : item.getCounter();
                buf.extend(offs + 4 + len);
                Bytes.pack4(buf.arr, offs, len);
                offs += 4;
                while (--len >= 0) {
                    if (item.isIntValue()) {
                        buf.arr[offs] = (byte)item.getIntValue();
                    } else if (item.isRealValue()) {
                        buf.arr[offs] = (byte)item.getRealValue();
                    } else {
                        this.throwException("Conversion for field " + fieldName + " is not possible");
                    }
                    item = item.getNextSibling();
                    ++offs;
                }
            }
        }
        return offs;
    }

    final int packObject(XMLElement objElem, ClassDescriptor desc, int offs, ByteBuffer buf) throws XMLImportException {
        block30: for (ClassDescriptor.FieldDescriptor fd : desc.allFields) {
            String fieldName = fd.fieldName;
            XMLElement elem = objElem != null ? objElem.getSibling(fieldName) : null;
            switch (fd.type) {
                case 1: {
                    buf.extend(offs + 1);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            buf.arr[offs] = (byte)elem.getIntValue();
                        } else if (elem.isRealValue()) {
                            buf.arr[offs] = (byte)elem.getRealValue();
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    ++offs;
                    continue block30;
                }
                case 0: {
                    buf.extend(offs + 1);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            buf.arr[offs] = (byte)(elem.getIntValue() != 0L ? 1 : 0);
                        } else if (elem.isRealValue()) {
                            buf.arr[offs] = (byte)(elem.getRealValue() != 0.0 ? 1 : 0);
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    ++offs;
                    continue block30;
                }
                case 2: 
                case 3: {
                    buf.extend(offs + 2);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            Bytes.pack2(buf.arr, offs, (short)elem.getIntValue());
                        } else if (elem.isRealValue()) {
                            Bytes.pack2(buf.arr, offs, (short)elem.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    offs += 2;
                    continue block30;
                }
                case 4: {
                    buf.extend(offs + 4);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            Bytes.pack4(buf.arr, offs, (int)elem.getIntValue());
                        } else if (elem.isRealValue()) {
                            Bytes.pack4(buf.arr, offs, (int)elem.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    offs += 4;
                    continue block30;
                }
                case 5: {
                    buf.extend(offs + 8);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            Bytes.pack8(buf.arr, offs, elem.getIntValue());
                        } else if (elem.isRealValue()) {
                            Bytes.pack8(buf.arr, offs, (long)elem.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    offs += 8;
                    continue block30;
                }
                case 6: {
                    buf.extend(offs + 4);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            Bytes.pack4(buf.arr, offs, Float.floatToIntBits(elem.getIntValue()));
                        } else if (elem.isRealValue()) {
                            Bytes.pack4(buf.arr, offs, Float.floatToIntBits((float)elem.getRealValue()));
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    offs += 4;
                    continue block30;
                }
                case 7: {
                    buf.extend(offs + 8);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            Bytes.pack8(buf.arr, offs, Double.doubleToLongBits(elem.getIntValue()));
                        } else if (elem.isRealValue()) {
                            Bytes.pack8(buf.arr, offs, Double.doubleToLongBits(elem.getRealValue()));
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    offs += 8;
                    continue block30;
                }
                case 14: {
                    buf.extend(offs + 4);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            Bytes.pack4(buf.arr, offs, (int)elem.getIntValue());
                        } else if (elem.isRealValue()) {
                            Bytes.pack4(buf.arr, offs, (int)elem.getRealValue());
                        } else if (elem.isNullValue()) {
                            Bytes.pack4(buf.arr, offs, -1);
                        } else if (elem.isStringValue()) {
                            Bytes.pack4(buf.arr, offs, ((Enum)Enum.valueOf(fd.field.getType(), elem.getStringValue())).ordinal());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    offs += 4;
                    continue block30;
                }
                case 9: {
                    buf.extend(offs + 8);
                    if (elem != null) {
                        if (elem.isIntValue()) {
                            Bytes.pack8(buf.arr, offs, elem.getIntValue());
                        } else if (elem.isNullValue()) {
                            Bytes.pack8(buf.arr, offs, -1L);
                        } else if (elem.isStringValue()) {
                            Date date = httpFormatter.parse(elem.getStringValue(), new ParsePosition(0));
                            if (date == null) {
                                this.throwException("Invalid date");
                            }
                            Bytes.pack8(buf.arr, offs, date.getTime());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                    }
                    offs += 8;
                    continue block30;
                }
                case 8: {
                    if (elem != null) {
                        String value = null;
                        if (elem.isIntValue()) {
                            value = Long.toString(elem.getIntValue());
                        } else if (elem.isRealValue()) {
                            value = Double.toString(elem.getRealValue());
                        } else if (elem.isStringValue()) {
                            value = elem.getStringValue();
                        } else if (elem.isNullValue()) {
                            value = null;
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        offs = buf.packString(offs, value, this.storage.encoding);
                        continue block30;
                    }
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, -1);
                    offs += 4;
                    continue block30;
                }
                case 10: {
                    int oid = 0;
                    if (elem != null) {
                        XMLElement ref = elem.getSibling("ref");
                        if (ref == null) {
                            this.throwException("<ref> element expected");
                        }
                        oid = this.mapId(this.getIntAttribute(ref, "id"));
                    }
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, oid);
                    offs += 4;
                    continue block30;
                }
                case 11: {
                    offs = this.packObject(elem, fd.valueDesc, offs, buf);
                    continue block30;
                }
                case 12: 
                case 21: {
                    offs = this.importBinary(elem, offs, buf, fieldName);
                    continue block30;
                }
                case 15: {
                    if (!elem.isStringValue()) {
                        this.throwException("text element expected");
                    }
                    String str = elem.getStringValue();
                    try {
                        CustomSerializable obj = this.storage.serializer.parse(str);
                        this.storage.serializer.pack(obj, buf.getOutputStream());
                        offs = buf.size();
                    }
                    catch (IOException x) {
                        this.throwException("exception in custom serializer: " + x);
                    }
                    continue block30;
                }
                case 20: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        if (item.isIntValue()) {
                            buf.arr[offs] = (byte)(item.getIntValue() != 0L ? 1 : 0);
                        } else if (item.isRealValue()) {
                            buf.arr[offs] = (byte)(item.getRealValue() != 0.0 ? 1 : 0);
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        item = item.getNextSibling();
                        ++offs;
                    }
                    continue block30;
                }
                case 22: 
                case 23: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len * 2);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        if (item.isIntValue()) {
                            Bytes.pack2(buf.arr, offs, (short)item.getIntValue());
                        } else if (item.isRealValue()) {
                            Bytes.pack2(buf.arr, offs, (short)item.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        item = item.getNextSibling();
                        offs += 2;
                    }
                    continue block30;
                }
                case 24: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        if (item.isIntValue()) {
                            Bytes.pack4(buf.arr, offs, (int)item.getIntValue());
                        } else if (item.isRealValue()) {
                            Bytes.pack4(buf.arr, offs, (int)item.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        item = item.getNextSibling();
                        offs += 4;
                    }
                    continue block30;
                }
                case 34: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    Class<?> enumType = fd.field.getType();
                    offs += 4;
                    while (--len >= 0) {
                        if (item.isIntValue()) {
                            Bytes.pack4(buf.arr, offs, (int)item.getIntValue());
                        } else if (item.isRealValue()) {
                            Bytes.pack4(buf.arr, offs, (int)item.getRealValue());
                        } else if (item.isNullValue()) {
                            Bytes.pack4(buf.arr, offs, -1);
                        } else if (item.isStringValue()) {
                            Bytes.pack4(buf.arr, offs, ((Enum)Enum.valueOf(enumType, item.getStringValue())).ordinal());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        item = item.getNextSibling();
                        offs += 4;
                    }
                    continue block30;
                }
                case 25: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len * 8);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        if (item.isIntValue()) {
                            Bytes.pack8(buf.arr, offs, item.getIntValue());
                        } else if (item.isRealValue()) {
                            Bytes.pack8(buf.arr, offs, (long)item.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        item = item.getNextSibling();
                        offs += 8;
                    }
                    continue block30;
                }
                case 26: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        if (item.isIntValue()) {
                            Bytes.pack4(buf.arr, offs, Float.floatToIntBits(item.getIntValue()));
                        } else if (item.isRealValue()) {
                            Bytes.pack4(buf.arr, offs, Float.floatToIntBits((float)item.getRealValue()));
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        item = item.getNextSibling();
                        offs += 4;
                    }
                    continue block30;
                }
                case 27: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len * 8);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        if (item.isIntValue()) {
                            Bytes.pack8(buf.arr, offs, Double.doubleToLongBits(item.getIntValue()));
                        } else if (item.isRealValue()) {
                            Bytes.pack8(buf.arr, offs, Double.doubleToLongBits(item.getRealValue()));
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        item = item.getNextSibling();
                        offs += 8;
                    }
                    continue block30;
                }
                case 29: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len * 8);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        if (item.isNullValue()) {
                            Bytes.pack8(buf.arr, offs, -1L);
                        } else if (item.isStringValue()) {
                            Date date = httpFormatter.parse(item.getStringValue(), new ParsePosition(0));
                            if (date == null) {
                                this.throwException("Invalid date");
                            }
                            Bytes.pack8(buf.arr, offs, date.getTime());
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        item = item.getNextSibling();
                        offs += 8;
                    }
                    continue block30;
                }
                case 28: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        String value = null;
                        if (item.isIntValue()) {
                            value = Long.toString(item.getIntValue());
                        } else if (item.isRealValue()) {
                            value = Double.toString(item.getRealValue());
                        } else if (item.isStringValue()) {
                            value = item.getStringValue();
                        } else if (item.isNullValue()) {
                            value = null;
                        } else {
                            this.throwException("Conversion for field " + fieldName + " is not possible");
                        }
                        offs = buf.packString(offs, value, this.storage.encoding);
                        item = item.getNextSibling();
                    }
                    continue block30;
                }
                case 13: 
                case 30: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        XMLElement ref = item.getSibling("ref");
                        if (ref == null) {
                            this.throwException("<ref> element expected");
                        }
                        int oid = this.mapId(this.getIntAttribute(ref, "id"));
                        Bytes.pack4(buf.arr, offs, oid);
                        item = item.getNextSibling();
                        offs += 4;
                    }
                    continue block30;
                }
                case 31: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    ClassDescriptor elemDesc = fd.valueDesc;
                    while (--len >= 0) {
                        offs = this.packObject(item, elemDesc, offs, buf);
                        item = item.getNextSibling();
                    }
                    continue block30;
                }
                case 32: {
                    if (elem == null || elem.isNullValue()) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block30;
                    }
                    XMLElement item = elem.getSibling("element");
                    int len = item == null ? 0 : item.getCounter();
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    while (--len >= 0) {
                        offs = this.importBinary(item, offs, buf, fieldName);
                        item = item.getNextSibling();
                    }
                    continue block30;
                }
            }
        }
        return offs;
    }

    final XMLElement readElement(String name) throws XMLImportException {
        XMLElement elem = new XMLElement(name);
        block11: while (true) {
            switch (this.scanner.scan()) {
                case 7: {
                    return elem;
                }
                case 5: {
                    int tkn;
                    while ((tkn = this.scanner.scan()) == 4) {
                        if (this.scanner.scan() != 0) {
                            this.throwException("Element name expected");
                        }
                        String siblingName = this.scanner.getIdentifier();
                        XMLElement sibling = this.readElement(siblingName);
                        elem.addSibling(sibling);
                    }
                    switch (tkn) {
                        case 1: {
                            elem.setStringValue(this.scanner.getString());
                            tkn = this.scanner.scan();
                            break;
                        }
                        case 2: {
                            elem.setIntValue(this.scanner.getInt());
                            tkn = this.scanner.scan();
                            break;
                        }
                        case 3: {
                            elem.setRealValue(this.scanner.getReal());
                            tkn = this.scanner.scan();
                            break;
                        }
                        case 0: {
                            if (this.scanner.getIdentifier().equals("null")) {
                                elem.setNullValue();
                            } else {
                                elem.setStringValue(this.scanner.getIdentifier());
                            }
                            tkn = this.scanner.scan();
                        }
                    }
                    if (tkn != 6 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals(name) || this.scanner.scan() != 5) {
                        this.throwException("Element is not closed");
                    }
                    return elem;
                }
                case 0: {
                    String attribute = this.scanner.getIdentifier();
                    if (this.scanner.scan() != 8 || this.scanner.scan() != 1) {
                        this.throwException("Attribute value expected");
                    }
                    elem.addAttribute(attribute, this.scanner.getString());
                    continue block11;
                }
            }
            this.throwException("Unexpected token");
        }
    }

    final void throwException(String message) throws XMLImportException {
        throw new XMLImportException(this.scanner.getLine(), this.scanner.getColumn(), message);
    }

    static class XMLScanner {
        static final int XML_IDENT = 0;
        static final int XML_SCONST = 1;
        static final int XML_ICONST = 2;
        static final int XML_FCONST = 3;
        static final int XML_LT = 4;
        static final int XML_GT = 5;
        static final int XML_LTS = 6;
        static final int XML_GTS = 7;
        static final int XML_EQ = 8;
        static final int XML_EOF = 9;
        Reader reader;
        int line;
        int column;
        char[] sconst;
        long iconst;
        double fconst;
        int slen;
        String ident;
        int size;
        int ungetChar;
        boolean hasUngetChar;

        XMLScanner(Reader in) {
            this.reader = in;
            this.size = 1024;
            this.sconst = new char[1024];
            this.line = 1;
            this.column = 0;
            this.hasUngetChar = false;
        }

        final int get() throws XMLImportException {
            if (this.hasUngetChar) {
                this.hasUngetChar = false;
                return this.ungetChar;
            }
            try {
                int ch = this.reader.read();
                if (ch == 10) {
                    ++this.line;
                    this.column = 0;
                } else {
                    this.column = ch == 9 ? (this.column += this.column + 8 & 0xFFFFFFF8) : ++this.column;
                }
                return ch;
            }
            catch (IOException x) {
                throw new XMLImportException(this.line, this.column, x.getMessage());
            }
        }

        final void unget(int ch) {
            if (ch == 10) {
                --this.line;
            } else {
                --this.column;
            }
            this.ungetChar = ch;
            this.hasUngetChar = true;
        }

        /*
         * Unable to fully structure code
         */
        final int scan() throws XMLImportException {
            block16: while (true) {
                if ((ch = this.get()) < 0) {
                    return 9;
                }
                if (ch <= 32) continue;
                switch (ch) {
                    case 60: {
                        ch = this.get();
                        if (ch == 63) {
                            while ((ch = this.get()) != 63) {
                                if (ch >= 0) continue;
                                throw new XMLImportException(this.line, this.column, "Bad XML file format");
                            }
                            ch = this.get();
                            if (ch != 62) ** break;
                            continue block16;
                            throw new XMLImportException(this.line, this.column, "Bad XML file format");
                        }
                        if (ch != 47) {
                            this.unget(ch);
                            return 4;
                        }
                        return 6;
                    }
                    case 62: {
                        return 5;
                    }
                    case 47: {
                        ch = this.get();
                        if (ch != 62) {
                            this.unget(ch);
                            throw new XMLImportException(this.line, this.column, "Bad XML file format");
                        }
                        return 7;
                    }
                    case 61: {
                        return 8;
                    }
                    case 34: {
                        i = 0;
                        while (true) {
                            if ((ch = this.get()) < 0) {
                                throw new XMLImportException(this.line, this.column, "Bad XML file format");
                            }
                            if (ch != 38) ** GOTO lbl59
                            switch (this.get()) {
                                case 97: {
                                    if (this.get() != 109 || this.get() != 112 || this.get() != 59) {
                                        throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                    }
                                    ch = 38;
                                    ** GOTO lbl62
                                }
                                case 108: {
                                    if (this.get() != 116 || this.get() != 59) {
                                        throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                    }
                                    ch = 60;
                                    ** GOTO lbl62
                                }
                                case 103: {
                                    if (this.get() != 116 || this.get() != 59) {
                                        throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                    }
                                    ch = 62;
                                    ** GOTO lbl62
                                }
                                case 113: {
                                    if (this.get() != 117 || this.get() != 111 || this.get() != 116 || this.get() != 59) {
                                        throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                    }
                                    ch = 34;
                                    ** GOTO lbl62
                                }
                                default: {
                                    throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                }
                            }
lbl59:
                            // 1 sources

                            if (ch == 34) {
                                this.slen = i;
                                return 1;
                            }
lbl62:
                            // 6 sources

                            if (i == this.size) {
                                newBuf = new char[this.size *= 2];
                                System.arraycopy(this.sconst, 0, newBuf, 0, i);
                                this.sconst = newBuf;
                            }
                            this.sconst[i++] = (char)ch;
                        }
                    }
                    case 43: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        i = 0;
                        floatingPoint = false;
                        while (true) {
                            if (!Character.isDigit((char)ch) && ch != 45 && ch != 43 && ch != 46 && ch != 69) {
                                this.unget(ch);
                                try {
                                    if (floatingPoint) {
                                        this.fconst = Double.parseDouble(new String(this.sconst, 0, i));
                                        return 3;
                                    }
                                    this.iconst = Long.parseLong(new String(this.sconst, 0, i));
                                    return 2;
                                }
                                catch (NumberFormatException x) {
                                    throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                }
                            }
                            if (i == this.size) {
                                throw new XMLImportException(this.line, this.column, "Bad XML file format");
                            }
                            this.sconst[i++] = (char)ch;
                            if (ch == 46) {
                                floatingPoint = true;
                            }
                            ch = this.get();
                        }
                    }
                }
                break;
            }
            i = 0;
            while (Character.isLetterOrDigit((char)ch) || ch == 45 || ch == 58 || ch == 95 || ch == 46) {
                if (i == this.size) {
                    throw new XMLImportException(this.line, this.column, "Bad XML file format");
                }
                if (ch == 45) {
                    ch = 36;
                }
                this.sconst[i++] = (char)ch;
                ch = this.get();
            }
            this.unget(ch);
            if (i == 0) {
                throw new XMLImportException(this.line, this.column, "Bad XML file format");
            }
            this.ident = new String(this.sconst, 0, i);
            return 0;
        }

        final String getIdentifier() {
            return this.ident;
        }

        final String getString() {
            return new String(this.sconst, 0, this.slen);
        }

        final long getInt() {
            return this.iconst;
        }

        final double getReal() {
            return this.fconst;
        }

        final int getLine() {
            return this.line;
        }

        final int getColumn() {
            return this.column;
        }
    }

    static class XMLElement {
        private XMLElement next;
        private XMLElement prev;
        private String name;
        private HashMap siblings;
        private HashMap attributes;
        private String svalue;
        private long ivalue;
        private double rvalue;
        private int valueType;
        private int counter;
        static final int NO_VALUE = 0;
        static final int STRING_VALUE = 1;
        static final int INT_VALUE = 2;
        static final int REAL_VALUE = 3;
        static final int NULL_VALUE = 4;

        XMLElement(String name) {
            this.name = name;
            this.valueType = 0;
        }

        final void addSibling(XMLElement elem) {
            XMLElement prev;
            if (this.siblings == null) {
                this.siblings = new HashMap();
            }
            if ((prev = (XMLElement)this.siblings.get(elem.name)) != null) {
                elem.next = null;
                elem.prev = prev.prev;
                elem.prev.next = elem;
                prev.prev = elem;
                ++prev.counter;
            } else {
                this.siblings.put(elem.name, elem);
                elem.prev = elem;
                elem.counter = 1;
            }
        }

        final void addAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(name, value);
        }

        final XMLElement getSibling(String name) {
            if (this.siblings != null) {
                return (XMLElement)this.siblings.get(name);
            }
            return null;
        }

        final XMLElement getNextSibling() {
            return this.next;
        }

        final int getCounter() {
            return this.counter;
        }

        final String getAttribute(String name) {
            return this.attributes != null ? (String)this.attributes.get(name) : null;
        }

        final void setIntValue(long val) {
            this.ivalue = val;
            this.valueType = 2;
        }

        final void setRealValue(double val) {
            this.rvalue = val;
            this.valueType = 3;
        }

        final void setStringValue(String val) {
            this.svalue = val;
            this.valueType = 1;
        }

        final void setNullValue() {
            this.valueType = 4;
        }

        final String getStringValue() {
            return this.svalue;
        }

        final long getIntValue() {
            return this.ivalue;
        }

        final double getRealValue() {
            return this.rvalue;
        }

        final boolean isIntValue() {
            return this.valueType == 2;
        }

        final boolean isRealValue() {
            return this.valueType == 3;
        }

        final boolean isStringValue() {
            return this.valueType == 1;
        }

        final boolean isNullValue() {
            return this.valueType == 4;
        }
    }
}

