/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.garret.perst.Assert;
import org.garret.perst.BitIndex;
import org.garret.perst.Blob;
import org.garret.perst.CustomAllocator;
import org.garret.perst.CustomSerializable;
import org.garret.perst.CustomSerializer;
import org.garret.perst.FieldIndex;
import org.garret.perst.IFile;
import org.garret.perst.INamedClassLoader;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentList;
import org.garret.perst.IPersistentMap;
import org.garret.perst.IPersistentSet;
import org.garret.perst.IResource;
import org.garret.perst.Index;
import org.garret.perst.Link;
import org.garret.perst.MemoryUsage;
import org.garret.perst.MultidimensionalComparator;
import org.garret.perst.MultidimensionalIndex;
import org.garret.perst.PatriciaTrie;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentCollection;
import org.garret.perst.PersistentComparator;
import org.garret.perst.PersistentIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.Query;
import org.garret.perst.Relation;
import org.garret.perst.SortedCollection;
import org.garret.perst.SpatialIndex;
import org.garret.perst.SpatialIndexR2;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.StorageListener;
import org.garret.perst.TimeSeries;
import org.garret.perst.XMLImportException;
import org.garret.perst.impl.AltBtree;
import org.garret.perst.impl.AltBtreeCaseInsensitiveFieldIndex;
import org.garret.perst.impl.AltBtreeCaseInsensitiveMultiFieldIndex;
import org.garret.perst.impl.AltBtreeCompoundIndex;
import org.garret.perst.impl.AltBtreeFieldIndex;
import org.garret.perst.impl.AltBtreeMultiFieldIndex;
import org.garret.perst.impl.AltPersistentSet;
import org.garret.perst.impl.BitIndexImpl;
import org.garret.perst.impl.Bitmap;
import org.garret.perst.impl.BitmapCustomAllocator;
import org.garret.perst.impl.BlobImpl;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeCaseInsensitiveFieldIndex;
import org.garret.perst.impl.BtreeCaseInsensitiveMultiFieldIndex;
import org.garret.perst.impl.BtreeCompoundIndex;
import org.garret.perst.impl.BtreeFieldIndex;
import org.garret.perst.impl.BtreeMultiFieldIndex;
import org.garret.perst.impl.ByteBuffer;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.DefaultAllocator;
import org.garret.perst.impl.DefaultPersistentComparator;
import org.garret.perst.impl.FastSerializable;
import org.garret.perst.impl.GenericSort;
import org.garret.perst.impl.GenericSortArray;
import org.garret.perst.impl.Header;
import org.garret.perst.impl.KDTree;
import org.garret.perst.impl.LinkImpl;
import org.garret.perst.impl.LruObjectCache;
import org.garret.perst.impl.MultiFile;
import org.garret.perst.impl.OSFile;
import org.garret.perst.impl.ObjectHeader;
import org.garret.perst.impl.OidHashTable;
import org.garret.perst.impl.PTrie;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.PagePool;
import org.garret.perst.impl.PersistentListImpl;
import org.garret.perst.impl.PersistentMapImpl;
import org.garret.perst.impl.PersistentSet;
import org.garret.perst.impl.PersistentStub;
import org.garret.perst.impl.PinWeakHashTable;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.RandomAccessBlobImpl;
import org.garret.perst.impl.Rc4File;
import org.garret.perst.impl.ReflectionProvider;
import org.garret.perst.impl.RelationImpl;
import org.garret.perst.impl.RndBtree;
import org.garret.perst.impl.RndBtreeCaseInsensitiveFieldIndex;
import org.garret.perst.impl.RndBtreeCaseInsensitiveMultiFieldIndex;
import org.garret.perst.impl.RndBtreeCompoundIndex;
import org.garret.perst.impl.RndBtreeFieldIndex;
import org.garret.perst.impl.RndBtreeMultiFieldIndex;
import org.garret.perst.impl.RootPage;
import org.garret.perst.impl.Rtree;
import org.garret.perst.impl.RtreeR2;
import org.garret.perst.impl.ScalableList;
import org.garret.perst.impl.ScalableSet;
import org.garret.perst.impl.SoftHashTable;
import org.garret.perst.impl.StrongHashTable;
import org.garret.perst.impl.ThickIndex;
import org.garret.perst.impl.ThreadTransactionContext;
import org.garret.perst.impl.TimeSeriesImpl;
import org.garret.perst.impl.Ttree;
import org.garret.perst.impl.WeakHashTable;
import org.garret.perst.impl.XMLExporter;
import org.garret.perst.impl.XMLImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageImpl
implements Storage {
    static final int dbDefaultInitIndexSize = 1024;
    static final int dbDefaultObjectCacheInitSize = 1319;
    static final long dbDefaultExtensionQuantum = 0x100000L;
    static final long dbDefaultPagePoolLruLimit = 0x1000000000000000L;
    static final int dbDatabaseOidBits = 31;
    static final int dbDatabaseOffsetBits = 32;
    static final int dbLargeDatabaseOffsetBits = 40;
    static final int dbMaxObjectOid = Integer.MAX_VALUE;
    static final int dbAllocationQuantumBits = 5;
    static final int dbAllocationQuantum = 32;
    static final int dbBitmapSegmentBits = 20;
    static final int dbBitmapSegmentSize = 0x100000;
    static final int dbBitmapPages = 4096;
    static final int dbLargeBitmapPages = 0x100000;
    static final int dbHandlesPerPageBits = 9;
    static final int dbHandlesPerPage = 512;
    static final int dbDirtyPageBitmapSize = 524288;
    static final int dbInvalidId = 0;
    static final int dbBitmapId = 1;
    static final int dbFirstUserId = 4097;
    static final int dbPageObjectFlag = 1;
    static final int dbModifiedFlag = 2;
    static final int dbFreeHandleFlag = 4;
    static final int dbFlagsMask = 7;
    static final int dbFlagsBits = 3;
    static final byte dbDatabaseFormatVersion = 2;
    static final int pageBits = 32768;
    static final int inc = 16;
    private int initIndexSize = 1024;
    private int objectCacheInitSize = 1319;
    private long extensionQuantum = 0x100000L;
    private String cacheKind = "lru";
    private boolean readOnly = false;
    private boolean noFlush = false;
    private boolean lockFile = false;
    private boolean multiclientSupport = false;
    private boolean alternativeBtree = false;
    private boolean backgroundGc = false;
    private boolean forceStore = true;
    private long pagePoolLruLimit = 0x1000000000000000L;
    private HashMap customAllocatorMap;
    private ArrayList customAllocatorList;
    private CustomAllocator defaultAllocator;
    boolean replicationAck = false;
    boolean concurrentIterator = false;
    int slaveConnectionTimeout = 60;
    Properties properties = new Properties();
    String encoding = null;
    PagePool pool;
    Header header;
    int[] dirtyPagesMap;
    boolean modified;
    int currRBitmapPage;
    int currRBitmapOffs;
    int currPBitmapPage;
    int currPBitmapOffs;
    Location reservedChain;
    CloneNode cloneList;
    boolean insideCloneBitmap;
    int committedIndexSize;
    int currIndexSize;
    int currIndex;
    long usedSize;
    int[] bitmapPageAvailableSpace;
    boolean opened;
    int[] greyBitmap;
    int[] blackBitmap;
    long gcThreshold;
    long allocatedDelta;
    boolean gcDone;
    boolean gcActive;
    Object backgroundGcMonitor;
    Object backgroundGcStartMonitor;
    GcThread gcThread;
    int bitmapExtentBase;
    ClassLoader loader;
    HashMap loaderMap;
    CustomSerializer serializer;
    StorageListener listener;
    long transactionId;
    IFile file;
    int nNestedTransactions;
    int nBlockedTransactions;
    int nCommittedTransactions;
    long scheduledCommitTime;
    Object transactionMonitor;
    PersistentResource transactionLock;
    final ThreadLocal transactionContext = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new ThreadTransactionContext();
        }
    };
    boolean useSerializableTransactions;
    OidHashTable objectCache;
    HashMap classDescMap;
    ClassDescriptor descList;

    final int getBitmapPageId(int i) {
        return i < 4096 ? 1 + i : this.header.root[1 - this.currIndex].bitmapExtent + i - this.bitmapExtentBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getPos(int oid) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            if (oid == 0 || oid >= this.currIndexSize) {
                throw new StorageError(15);
            }
            Page pg = this.pool.getPage(this.header.root[1 - this.currIndex].index + ((long)(oid >>> 9) << 12));
            long pos = Bytes.unpack8(pg.data, (oid & 0x1FF) << 3);
            this.pool.unfix(pg);
            return pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setPos(int oid, long pos) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            int n = oid >>> 14;
            this.dirtyPagesMap[n] = this.dirtyPagesMap[n] | 1 << (oid >>> 9 & 0x1F);
            Page pg = this.pool.putPage(this.header.root[1 - this.currIndex].index + ((long)(oid >>> 9) << 12));
            Bytes.pack8(pg.data, (oid & 0x1FF) << 3, pos);
            this.pool.unfix(pg);
        }
    }

    final byte[] get(int oid) {
        long pos = this.getPos(oid);
        if ((pos & 5L) != 0L) {
            throw new StorageError(15);
        }
        return this.pool.get(pos & 0xFFFFFFFFFFFFFFF8L);
    }

    final Page getPage(int oid) {
        long pos = this.getPos(oid);
        if ((pos & 5L) != 1L) {
            throw new StorageError(16);
        }
        return this.pool.getPage(pos & 0xFFFFFFFFFFFFFFF8L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Page putPage(int oid) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            long pos = this.getPos(oid);
            if ((pos & 5L) != 1L) {
                throw new StorageError(16);
            }
            if ((pos & 2L) == 0L) {
                int n = oid >>> 14;
                this.dirtyPagesMap[n] = this.dirtyPagesMap[n] | 1 << (oid >>> 9 & 0x1F);
                this.allocate(4096L, oid);
                this.cloneBitmap(pos & 0xFFFFFFFFFFFFFFF8L, 4096L);
                pos = this.getPos(oid);
            }
            this.modified = true;
            return this.pool.putPage(pos & 0xFFFFFFFFFFFFFFF8L);
        }
    }

    int allocatePage() {
        int oid = this.allocateId();
        this.setPos(oid, this.allocate(4096L, 0) | 1L | 2L);
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deallocateObject(IPersistent obj) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            if (obj.getOid() == 0) {
                return;
            }
            if (this.useSerializableTransactions) {
                ThreadTransactionContext ctx = this.getTransactionContext();
                if (ctx.nested != 0) {
                    ctx.deleted.add(obj);
                    return;
                }
            }
            this.deallocateObject0(obj);
        }
    }

    @Override
    public void throwObject(IPersistent obj) {
        this.objectCache.remove(obj.getOid());
    }

    private void deallocateObject0(IPersistent obj) {
        CustomAllocator allocator;
        int oid = obj.getOid();
        long pos = this.getPos(oid);
        this.objectCache.remove(oid);
        int offs = (int)pos & 0xFFF;
        if ((offs & 5) != 0) {
            throw new StorageError(16);
        }
        Page pg = this.pool.getPage(pos - (long)offs);
        int size = ObjectHeader.getSize(pg.data, offs &= 0xFFFFFFF8);
        this.pool.unfix(pg);
        this.freeId(oid);
        CustomAllocator customAllocator = allocator = this.customAllocatorMap != null ? this.getCustomAllocator(obj.getClass()) : null;
        if (allocator != null) {
            allocator.free(pos & 0xFFFFFFFFFFFFFFF8L, size);
        } else if ((pos & 2L) != 0L) {
            this.free(pos & 0xFFFFFFFFFFFFFFF8L, size);
        } else {
            this.cloneBitmap(pos, size);
        }
        obj.assignOid(null, 0, false);
    }

    final void freePage(int oid) {
        long pos = this.getPos(oid);
        Assert.that((pos & 5L) == 1L);
        if ((pos & 2L) != 0L) {
            this.free(pos & 0xFFFFFFFFFFFFFFF8L, 4096L);
        } else {
            this.cloneBitmap(pos & 0xFFFFFFFFFFFFFFF8L, 4096L);
        }
        this.freeId(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int allocateId() {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            int curr = 1 - this.currIndex;
            this.setDirty();
            int oid = this.header.root[curr].freeList;
            if (oid != 0) {
                this.header.root[curr].freeList = (int)(this.getPos(oid) >> 3);
                Assert.that(this.header.root[curr].freeList >= 0);
                int n = oid >>> 14;
                this.dirtyPagesMap[n] = this.dirtyPagesMap[n] | 1 << (oid >>> 9 & 0x1F);
                return oid;
            }
            if (this.currIndexSize > Integer.MAX_VALUE) {
                throw new StorageError(30);
            }
            if (this.currIndexSize >= this.header.root[curr].indexSize) {
                int oldIndexSize = this.header.root[curr].indexSize;
                int newIndexSize = oldIndexSize << 1;
                if (newIndexSize < oldIndexSize && (newIndexSize = 2147483136) <= oldIndexSize) {
                    throw new StorageError(10);
                }
                long newIndex = this.allocate((long)newIndexSize * 8L, 0);
                if (this.currIndexSize >= this.header.root[curr].indexSize) {
                    long oldIndex = this.header.root[curr].index;
                    this.pool.copy(newIndex, oldIndex, (long)this.currIndexSize * 8L);
                    this.header.root[curr].index = newIndex;
                    this.header.root[curr].indexSize = newIndexSize;
                    this.free(oldIndex, (long)oldIndexSize * 8L);
                } else {
                    this.free(newIndex, (long)newIndexSize * 8L);
                }
            }
            oid = this.currIndexSize++;
            this.header.root[curr].indexUsed = this.currIndexSize;
            return oid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeId(int oid) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            this.setPos(oid, (long)this.header.root[1 - this.currIndex].freeList << 3 | 4L);
            this.header.root[1 - this.currIndex].freeList = oid;
        }
    }

    static final void memset(Page pg, int offs, int pattern, int len) {
        byte[] arr = pg.data;
        byte pat = (byte)pattern;
        while (--len >= 0) {
            arr[offs++] = pat;
        }
    }

    final void extend(long size) {
        if (size > this.header.root[1 - this.currIndex].size) {
            this.header.root[1 - this.currIndex].size = size;
        }
    }

    @Override
    public long getUsedSize() {
        return this.usedSize;
    }

    @Override
    public long getDatabaseSize() {
        return this.header.root[1 - this.currIndex].size;
    }

    final boolean wasReserved(long pos, long size) {
        Location location = this.reservedChain;
        while (location != null) {
            if (pos >= location.pos && pos - location.pos < location.size || pos <= location.pos && location.pos - pos < size) {
                return true;
            }
            location = location.next;
        }
        return false;
    }

    final void reserveLocation(long pos, long size) {
        Location location = new Location();
        location.pos = pos;
        location.size = size;
        location.next = this.reservedChain;
        this.reservedChain = location;
    }

    final void commitLocation() {
        this.reservedChain = this.reservedChain.next;
    }

    final void setDirty() {
        this.modified = true;
        if (!this.header.dirty) {
            this.header.dirty = true;
            Page pg = this.pool.putPage(0L);
            this.header.pack(pg.data);
            this.pool.flush();
            this.pool.unfix(pg);
        }
    }

    protected boolean isDirty() {
        return this.header.dirty;
    }

    final Page putBitmapPage(int i) {
        return this.putPage(this.getBitmapPageId(i));
    }

    final Page getBitmapPage(int i) {
        return this.getPage(this.getBitmapPageId(i));
    }

    final long allocate(long size, int oid) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            int offs;
            int firstPage;
            int objBitSize;
            this.setDirty();
            size = size + 32L - 1L & 0xFFFFFFFFFFFFFFE0L;
            Assert.that(size != 0L);
            this.allocatedDelta += size;
            if (this.allocatedDelta > this.gcThreshold) {
                this.gc0();
            }
            Assert.that((long)(objBitSize = (int)(size >> 5)) == size >> 5);
            int holeBitSize = 0;
            int alignment = (int)size & 0xFFF;
            int holeBeforeFreePage = 0;
            int freeBitmapPage = 0;
            int curr = 1 - this.currIndex;
            int lastPage = this.header.root[curr].bitmapEnd - 1;
            this.usedSize += size;
            if (alignment == 0) {
                firstPage = this.currPBitmapPage;
                offs = this.currPBitmapOffs + 16 - 1 & 0xFFFFFFF0;
            } else {
                firstPage = this.currRBitmapPage;
                offs = this.currRBitmapOffs;
            }
            while (true) {
                long pos;
                int startOffs;
                Page pg;
                int spaceNeeded;
                int i;
                if (alignment == 0) {
                    for (i = firstPage; i < lastPage; ++i) {
                        int n = spaceNeeded = objBitSize - holeBitSize < 32768 ? objBitSize - holeBitSize : 32768;
                        if (this.bitmapPageAvailableSpace[i] <= spaceNeeded) {
                            holeBitSize = 0;
                            offs = 0;
                            continue;
                        }
                        pg = this.getBitmapPage(i);
                        startOffs = offs;
                        while (offs < 4096) {
                            if (pg.data[offs++] != 0) {
                                offs = offs + 16 - 1 & 0xFFFFFFF0;
                                holeBitSize = 0;
                                continue;
                            }
                            if ((holeBitSize += 8) != objBitSize) continue;
                            pos = ((long)i * 4096L + (long)offs) * 8L - (long)holeBitSize << 5;
                            if (this.wasReserved(pos, size)) {
                                startOffs = offs = offs + 16 - 1 & 0xFFFFFFF0;
                                holeBitSize = 0;
                                continue;
                            }
                            this.reserveLocation(pos, size);
                            this.currPBitmapPage = i;
                            this.currPBitmapOffs = offs;
                            this.extend(pos + size);
                            if (oid != 0) {
                                long prev = this.getPos(oid);
                                int marker = (int)prev & 7;
                                this.pool.copy(pos, prev - (long)marker, size);
                                this.setPos(oid, pos | (long)marker | 2L);
                            }
                            this.pool.unfix(pg);
                            pg = this.putBitmapPage(i);
                            int holeBytes = holeBitSize >> 3;
                            if (holeBytes > offs) {
                                StorageImpl.memset(pg, 0, 255, offs);
                                holeBytes -= offs;
                                this.pool.unfix(pg);
                                pg = this.putBitmapPage(--i);
                                offs = 4096;
                            }
                            while (holeBytes > 4096) {
                                StorageImpl.memset(pg, 0, 255, 4096);
                                holeBytes -= 4096;
                                this.bitmapPageAvailableSpace[i] = 0;
                                this.pool.unfix(pg);
                                pg = this.putBitmapPage(--i);
                            }
                            StorageImpl.memset(pg, offs - holeBytes, 255, holeBytes);
                            this.commitLocation();
                            this.pool.unfix(pg);
                            return pos;
                        }
                        if (startOffs == 0 && holeBitSize == 0 && spaceNeeded < this.bitmapPageAvailableSpace[i]) {
                            this.bitmapPageAvailableSpace[i] = spaceNeeded;
                        }
                        offs = 0;
                        this.pool.unfix(pg);
                    }
                } else {
                    for (i = firstPage; i < lastPage; ++i) {
                        int n = spaceNeeded = objBitSize - holeBitSize < 32768 ? objBitSize - holeBitSize : 32768;
                        if (this.bitmapPageAvailableSpace[i] <= spaceNeeded) {
                            holeBitSize = 0;
                            offs = 0;
                            continue;
                        }
                        pg = this.getBitmapPage(i);
                        startOffs = offs;
                        while (offs < 4096) {
                            int mask = pg.data[offs] & 0xFF;
                            if (holeBitSize + Bitmap.firstHoleSize[mask] >= objBitSize) {
                                pos = ((long)i * 4096L + (long)offs) * 8L - (long)holeBitSize << 5;
                                if (this.wasReserved(pos, size)) {
                                    startOffs = ++offs;
                                    holeBitSize = 0;
                                    continue;
                                }
                                this.reserveLocation(pos, size);
                                this.currRBitmapPage = i;
                                this.currRBitmapOffs = offs;
                                this.extend(pos + size);
                                if (oid != 0) {
                                    long prev = this.getPos(oid);
                                    int marker = (int)prev & 7;
                                    this.pool.copy(pos, prev - (long)marker, size);
                                    this.setPos(oid, pos | (long)marker | 2L);
                                }
                                this.pool.unfix(pg);
                                pg = this.putBitmapPage(i);
                                int n2 = offs;
                                pg.data[n2] = (byte)(pg.data[n2] | (byte)((1 << objBitSize - holeBitSize) - 1));
                                if (holeBitSize != 0) {
                                    if (holeBitSize > offs * 8) {
                                        StorageImpl.memset(pg, 0, 255, offs);
                                        holeBitSize -= offs * 8;
                                        this.pool.unfix(pg);
                                        pg = this.putBitmapPage(--i);
                                        offs = 4096;
                                    }
                                    while (holeBitSize > 32768) {
                                        StorageImpl.memset(pg, 0, 255, 4096);
                                        holeBitSize -= 32768;
                                        this.bitmapPageAvailableSpace[i] = 0;
                                        this.pool.unfix(pg);
                                        pg = this.putBitmapPage(--i);
                                    }
                                    while ((holeBitSize -= 8) > 0) {
                                        pg.data[--offs] = -1;
                                    }
                                    int n3 = offs - 1;
                                    pg.data[n3] = (byte)(pg.data[n3] | (byte)(~((1 << -holeBitSize) - 1)));
                                }
                                this.pool.unfix(pg);
                                this.commitLocation();
                                return pos;
                            }
                            if (Bitmap.maxHoleSize[mask] >= objBitSize) {
                                byte holeBitOffset = Bitmap.maxHoleOffset[mask];
                                pos = ((long)i * 4096L + (long)offs) * 8L + (long)holeBitOffset << 5;
                                if (this.wasReserved(pos, size)) {
                                    startOffs = ++offs;
                                    holeBitSize = 0;
                                    continue;
                                }
                                this.reserveLocation(pos, size);
                                this.currRBitmapPage = i;
                                this.currRBitmapOffs = offs;
                                this.extend(pos + size);
                                if (oid != 0) {
                                    long prev = this.getPos(oid);
                                    int marker = (int)prev & 7;
                                    this.pool.copy(pos, prev - (long)marker, size);
                                    this.setPos(oid, pos | (long)marker | 2L);
                                }
                                this.pool.unfix(pg);
                                pg = this.putBitmapPage(i);
                                int n4 = offs;
                                pg.data[n4] = (byte)(pg.data[n4] | (byte)((1 << objBitSize) - 1 << holeBitOffset));
                                this.pool.unfix(pg);
                                this.commitLocation();
                                return pos;
                            }
                            ++offs;
                            if (Bitmap.lastHoleSize[mask] == 8) {
                                holeBitSize += 8;
                                continue;
                            }
                            holeBitSize = Bitmap.lastHoleSize[mask];
                        }
                        if (startOffs == 0 && holeBitSize == 0 && spaceNeeded < this.bitmapPageAvailableSpace[i]) {
                            this.bitmapPageAvailableSpace[i] = spaceNeeded;
                        }
                        offs = 0;
                        this.pool.unfix(pg);
                    }
                }
                if (firstPage == 0) {
                    int len;
                    int j;
                    if (freeBitmapPage > i) {
                        i = freeBitmapPage;
                        holeBitSize = holeBeforeFreePage;
                    }
                    int skip = (objBitSize -= holeBitSize) + 128 - 1 & 0xFFFFFF80;
                    pos = ((long)i << 20) + ((long)skip << 5);
                    long extension = size > this.extensionQuantum ? size : this.extensionQuantum;
                    int oldIndexSize = 0;
                    long oldIndex = 0L;
                    int morePages = (int)((extension + 1044480L - 1L) / 1044480L);
                    if (i + morePages > 0x100000) {
                        throw new StorageError(10);
                    }
                    if (i <= 4096 && i + morePages > 4096) {
                        oldIndexSize = this.header.root[curr].indexSize;
                        if (oldIndexSize <= this.currIndexSize + 0x100000 - 4096) {
                            int newIndexSize = oldIndexSize;
                            oldIndex = this.header.root[curr].index;
                            do {
                                if ((newIndexSize <<= 1) >= 0) continue;
                                newIndexSize = 2147483136;
                                if (newIndexSize >= this.currIndexSize + 0x100000 - 4096) break;
                                throw new StorageError(10);
                            } while (newIndexSize <= this.currIndexSize + 0x100000 - 4096);
                            if (size + (long)newIndexSize * 8L > this.extensionQuantum) {
                                extension = size + (long)newIndexSize * 8L;
                                morePages = (int)((extension + 1044480L - 1L) / 1044480L);
                            }
                            this.extend(pos + (long)morePages * 4096L + (long)newIndexSize * 8L);
                            long newIndex = pos + (long)morePages * 4096L;
                            this.fillBitmap(pos + (long)(skip >> 3) + (long)morePages * 16L, newIndexSize >>> 5);
                            this.pool.copy(newIndex, oldIndex, (long)oldIndexSize * 8L);
                            this.header.root[curr].index = newIndex;
                            this.header.root[curr].indexSize = newIndexSize;
                        }
                        int[] newBitmapPageAvailableSpace = new int[0x100000];
                        System.arraycopy(this.bitmapPageAvailableSpace, 0, newBitmapPageAvailableSpace, 0, 4096);
                        for (j = 4096; j < 0x100000; ++j) {
                            newBitmapPageAvailableSpace[j] = Integer.MAX_VALUE;
                        }
                        this.bitmapPageAvailableSpace = newBitmapPageAvailableSpace;
                        for (j = 0; j < 1044480; ++j) {
                            this.setPos(this.currIndexSize + j, 4L);
                        }
                        this.header.root[curr].bitmapExtent = this.currIndexSize;
                        this.header.root[curr].indexUsed = this.currIndexSize += 1044480;
                    }
                    this.extend(pos + (long)morePages * 4096L);
                    long adr = pos;
                    for (len = objBitSize >> 3; len >= 4096; len -= 4096) {
                        pg = this.pool.putPage(adr);
                        StorageImpl.memset(pg, 0, 255, 4096);
                        this.pool.unfix(pg);
                        adr += 4096L;
                    }
                    pg = this.pool.putPage(adr);
                    StorageImpl.memset(pg, 0, 255, len);
                    pg.data[len] = (byte)((1 << (objBitSize & 7)) - 1);
                    this.pool.unfix(pg);
                    this.fillBitmap(pos + (long)(skip >> 3), morePages * 16);
                    j = i;
                    while (--morePages >= 0) {
                        this.setPos(this.getBitmapPageId(j++), pos | 1L | 2L);
                        pos += 4096L;
                    }
                    this.header.root[curr].bitmapEnd = j + 1;
                    j = i + objBitSize / 32768;
                    if (alignment != 0) {
                        this.currRBitmapPage = j;
                        this.currRBitmapOffs = 0;
                    } else {
                        this.currPBitmapPage = j;
                        this.currPBitmapOffs = 0;
                    }
                    while (j > i) {
                        this.bitmapPageAvailableSpace[--j] = 0;
                    }
                    pos = (long)i * 4096L * 8L - (long)holeBitSize << 5;
                    if (oid != 0) {
                        long prev = this.getPos(oid);
                        int marker = (int)prev & 7;
                        this.pool.copy(pos, prev - (long)marker, size);
                        this.setPos(oid, pos | (long)marker | 2L);
                    }
                    if (holeBitSize != 0) {
                        this.reserveLocation(pos, size);
                        while (holeBitSize > 32768) {
                            holeBitSize -= 32768;
                            pg = this.putBitmapPage(--i);
                            StorageImpl.memset(pg, 0, 255, 4096);
                            this.bitmapPageAvailableSpace[i] = 0;
                            this.pool.unfix(pg);
                        }
                        pg = this.putBitmapPage(--i);
                        offs = 4096;
                        while ((holeBitSize -= 8) > 0) {
                            pg.data[--offs] = -1;
                        }
                        int n = offs - 1;
                        pg.data[n] = (byte)(pg.data[n] | (byte)(~((1 << -holeBitSize) - 1)));
                        this.pool.unfix(pg);
                        this.commitLocation();
                    }
                    if (oldIndex != 0L) {
                        this.free(oldIndex, (long)oldIndexSize * 8L);
                    }
                    return pos;
                }
                if (this.gcThreshold != Long.MAX_VALUE && !this.gcDone && !this.gcActive) {
                    this.allocatedDelta -= size;
                    this.usedSize -= size;
                    this.gc0();
                    this.currPBitmapPage = 0;
                    this.currRBitmapPage = 0;
                    this.currPBitmapOffs = 0;
                    this.currRBitmapOffs = 0;
                    return this.allocate(size, oid);
                }
                freeBitmapPage = i;
                holeBeforeFreePage = holeBitSize;
                holeBitSize = 0;
                lastPage = firstPage + 1;
                firstPage = 0;
                offs = 0;
            }
        }
    }

    final void fillBitmap(long adr, int len) {
        Page pg;
        int off;
        while (true) {
            off = (int)adr & 0xFFF;
            pg = this.pool.putPage(adr - (long)off);
            if (4096 - off >= len) break;
            StorageImpl.memset(pg, off, 255, 4096 - off);
            this.pool.unfix(pg);
            adr += (long)(4096 - off);
            len -= 4096 - off;
        }
        StorageImpl.memset(pg, off, 255, len);
        this.pool.unfix(pg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void free(long pos, long size) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            Assert.that(pos != 0L && (pos & 0x1FL) == 0L);
            long quantNo = pos >>> 5;
            int objBitSize = (int)(size + 32L - 1L >>> 5);
            int pageId = (int)(quantNo >>> 15);
            int offs = (int)(quantNo & 0x7FFFL) >> 3;
            Page pg = this.putBitmapPage(pageId);
            int bitOffs = (int)quantNo & 7;
            this.allocatedDelta -= (long)objBitSize << 5;
            this.usedSize -= (long)objBitSize << 5;
            if ((pos & 0xFFFL) == 0L && size >= 4096L && pageId == this.currPBitmapPage && offs < this.currPBitmapOffs) {
                this.currPBitmapOffs = offs;
            }
            if (pageId == this.currRBitmapPage && offs < this.currRBitmapOffs) {
                this.currRBitmapOffs = offs;
            }
            this.bitmapPageAvailableSpace[pageId] = Integer.MAX_VALUE;
            if (objBitSize > 8 - bitOffs) {
                objBitSize -= 8 - bitOffs;
                int n = offs++;
                pg.data[n] = (byte)(pg.data[n] & (1 << bitOffs) - 1);
                while (objBitSize + offs * 8 > 32768) {
                    StorageImpl.memset(pg, offs, 0, 4096 - offs);
                    this.pool.unfix(pg);
                    pg = this.putBitmapPage(++pageId);
                    this.bitmapPageAvailableSpace[pageId] = Integer.MAX_VALUE;
                    objBitSize -= (4096 - offs) * 8;
                    offs = 0;
                }
                while ((objBitSize -= 8) > 0) {
                    pg.data[offs++] = 0;
                }
                int n2 = offs;
                pg.data[n2] = (byte)(pg.data[n2] & (byte)(~((1 << objBitSize + 8) - 1)));
            } else {
                int n = offs;
                pg.data[n] = (byte)(pg.data[n] & (byte)(~((1 << objBitSize) - 1 << bitOffs)));
            }
            this.pool.unfix(pg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cloneBitmap(long pos, long size) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            if (this.insideCloneBitmap) {
                Assert.that(size == 4096L);
                this.cloneList = new CloneNode(pos, this.cloneList);
            } else {
                this.insideCloneBitmap = true;
                while (true) {
                    long quantNo = pos >>> 5;
                    int objBitSize = (int)(size + 32L - 1L >>> 5);
                    int pageId = (int)(quantNo >>> 15);
                    int offs = (int)(quantNo & 0x7FFFL) >> 3;
                    int bitOffs = (int)quantNo & 7;
                    int oid = this.getBitmapPageId(pageId);
                    pos = this.getPos(oid);
                    if ((pos & 2L) == 0L) {
                        int n = oid >>> 14;
                        this.dirtyPagesMap[n] = this.dirtyPagesMap[n] | 1 << (oid >>> 9 & 0x1F);
                        this.allocate(4096L, oid);
                        this.cloneBitmap(pos & 0xFFFFFFFFFFFFFFF8L, 4096L);
                    }
                    if (objBitSize > 8 - bitOffs) {
                        objBitSize -= 8 - bitOffs;
                        ++offs;
                        while (objBitSize + offs * 8 > 32768) {
                            if (((pos = this.getPos(oid = this.getBitmapPageId(++pageId))) & 2L) == 0L) {
                                int n = oid >>> 14;
                                this.dirtyPagesMap[n] = this.dirtyPagesMap[n] | 1 << (oid >>> 9 & 0x1F);
                                this.allocate(4096L, oid);
                                this.cloneBitmap(pos & 0xFFFFFFFFFFFFFFF8L, 4096L);
                            }
                            objBitSize -= (4096 - offs) * 8;
                            offs = 0;
                        }
                    }
                    if (this.cloneList == null) break;
                    pos = this.cloneList.pos;
                    size = 4096L;
                    this.cloneList = this.cloneList.next;
                }
                this.insideCloneBitmap = false;
            }
        }
    }

    @Override
    public void open(String filePath) {
        this.open(filePath, 0x400000);
    }

    @Override
    public void open(IFile file) {
        this.open(file, 0x400000);
    }

    @Override
    public synchronized void open(String filePath, int pagePoolSize) {
        IFile file = filePath.startsWith("@") ? new MultiFile(filePath.substring(1), this.readOnly, this.noFlush) : new OSFile(filePath, this.readOnly, this.noFlush);
        try {
            this.open(file, pagePoolSize);
        }
        catch (StorageError ex) {
            file.close();
            throw ex;
        }
    }

    @Override
    public synchronized void open(String filePath, int pagePoolSize, String cryptKey) {
        Rc4File file = new Rc4File(filePath, this.readOnly, this.noFlush, cryptKey);
        try {
            this.open(file, pagePoolSize);
        }
        catch (StorageError ex) {
            file.close();
            throw ex;
        }
    }

    @Override
    public void clearObjectCache() {
        this.objectCache.clear();
    }

    protected OidHashTable createObjectCache(String kind, int pagePoolSize, int objectCacheSize) {
        if (pagePoolSize == 0 || "strong".equals(kind)) {
            return new StrongHashTable(objectCacheSize);
        }
        if ("soft".equals(kind)) {
            return new SoftHashTable(objectCacheSize);
        }
        if ("weak".equals(kind)) {
            return new WeakHashTable(objectCacheSize);
        }
        if ("pinned".equals(kind)) {
            return new PinWeakHashTable(objectCacheSize);
        }
        return new LruObjectCache(objectCacheSize);
    }

    protected void initialize(IFile file, int pagePoolSize) {
        this.file = file;
        if (this.lockFile && !this.multiclientSupport && !file.tryLock(false)) {
            throw new StorageError(27);
        }
        this.dirtyPagesMap = new int[131073];
        this.gcThreshold = Long.MAX_VALUE;
        this.backgroundGcMonitor = new Object();
        this.backgroundGcStartMonitor = new Object();
        this.gcThread = null;
        this.gcActive = false;
        this.gcDone = false;
        this.allocatedDelta = 0L;
        this.reservedChain = null;
        this.cloneList = null;
        this.insideCloneBitmap = false;
        this.nNestedTransactions = 0;
        this.nBlockedTransactions = 0;
        this.nCommittedTransactions = 0;
        this.scheduledCommitTime = Long.MAX_VALUE;
        this.transactionMonitor = new Object();
        this.transactionLock = new PersistentResource();
        this.modified = false;
        this.objectCache = this.createObjectCache(this.cacheKind, pagePoolSize, this.objectCacheInitSize);
        this.classDescMap = new HashMap();
        this.descList = null;
        this.header = new Header();
        this.pool = new PagePool(pagePoolSize / 4096, this.pagePoolLruLimit);
        this.pool.open(file);
    }

    @Override
    public synchronized void open(IFile file, int pagePoolSize) {
        Page pg;
        int i;
        byte[] buf;
        int rc;
        if (this.opened) {
            throw new StorageError(2);
        }
        this.initialize(file, pagePoolSize);
        if (this.multiclientSupport) {
            this.beginThreadTransaction(0);
        }
        if ((rc = file.read(0L, buf = new byte[139])) > 0 && rc < 139) {
            throw new StorageError(11);
        }
        this.header.unpack(buf);
        if (this.header.curr < 0 || this.header.curr > 1) {
            throw new StorageError(11);
        }
        this.transactionId = this.header.transactionId;
        if (this.header.databaseFormatVersion == 0) {
            long used;
            int indexSize = this.initIndexSize;
            if (indexSize < 4097) {
                indexSize = 4097;
            }
            indexSize = indexSize + 512 - 1 & 0xFFFFFE00;
            this.bitmapExtentBase = 4096;
            this.currIndex = 0;
            this.header.curr = 0;
            this.header.root[0].index = used = 4096L;
            this.header.root[0].indexSize = indexSize;
            this.header.root[0].indexUsed = 4097;
            this.header.root[0].freeList = 0;
            this.header.root[1].index = used += (long)indexSize * 8L;
            this.header.root[1].indexSize = indexSize;
            this.header.root[1].indexUsed = 4097;
            this.header.root[1].freeList = 0;
            this.header.root[0].shadowIndex = this.header.root[1].index;
            this.header.root[1].shadowIndex = this.header.root[0].index;
            this.header.root[0].shadowIndexSize = indexSize;
            this.header.root[1].shadowIndexSize = indexSize;
            int bitmapPages = (int)(((used += (long)indexSize * 8L) + 1044480L - 1L) / 1044480L);
            long bitmapSize = (long)bitmapPages * 4096L;
            int usedBitmapSize = (int)(used + bitmapSize >>> 8);
            for (i = 0; i < bitmapPages; ++i) {
                pg = this.pool.putPage(used + (long)i * 4096L);
                byte[] bitmap = pg.data;
                int n = usedBitmapSize > 4096 ? 4096 : usedBitmapSize;
                for (int j = 0; j < n; ++j) {
                    bitmap[j] = -1;
                }
                usedBitmapSize -= 4096;
                this.pool.unfix(pg);
            }
            int bitmapIndexSize = 36864;
            byte[] index = new byte[bitmapIndexSize];
            Bytes.pack8(index, 0, 4L);
            for (i = 0; i < bitmapPages; ++i) {
                Bytes.pack8(index, (1 + i) * 8, used | 1L);
                used += 4096L;
            }
            this.header.root[0].bitmapEnd = 1 + i;
            this.header.root[1].bitmapEnd = 1 + i;
            while (i < 4096) {
                Bytes.pack8(index, (1 + i) * 8, 4L);
                ++i;
            }
            this.header.root[0].size = used;
            this.header.root[1].size = used;
            this.usedSize = used;
            this.currIndexSize = 4097;
            this.committedIndexSize = 4097;
            this.pool.write(this.header.root[1].index, index);
            this.pool.write(this.header.root[0].index, index);
            this.header.dirty = true;
            this.header.root[0].size = this.header.root[1].size;
            pg = this.pool.putPage(0L);
            this.header.pack(pg.data);
            this.pool.flush();
            this.pool.modify(pg);
            this.header.databaseFormatVersion = (byte)2;
            this.header.pack(pg.data);
            this.pool.unfix(pg);
            this.pool.flush();
        } else {
            int curr;
            this.currIndex = curr = this.header.curr;
            if (this.header.root[curr].indexSize != this.header.root[curr].shadowIndexSize) {
                throw new StorageError(11);
            }
            int n = this.bitmapExtentBase = this.header.databaseFormatVersion < 2 ? 0 : 4096;
            if (this.isDirty()) {
                if (this.listener != null) {
                    this.listener.databaseCorrupted();
                }
                System.err.println("Database was not normally closed: start recovery");
                this.header.root[1 - curr].size = this.header.root[curr].size;
                this.header.root[1 - curr].indexUsed = this.header.root[curr].indexUsed;
                this.header.root[1 - curr].freeList = this.header.root[curr].freeList;
                this.header.root[1 - curr].index = this.header.root[curr].shadowIndex;
                this.header.root[1 - curr].indexSize = this.header.root[curr].shadowIndexSize;
                this.header.root[1 - curr].shadowIndex = this.header.root[curr].index;
                this.header.root[1 - curr].shadowIndexSize = this.header.root[curr].indexSize;
                this.header.root[1 - curr].bitmapEnd = this.header.root[curr].bitmapEnd;
                this.header.root[1 - curr].rootObject = this.header.root[curr].rootObject;
                this.header.root[1 - curr].classDescList = this.header.root[curr].classDescList;
                this.header.root[1 - curr].bitmapExtent = this.header.root[curr].bitmapExtent;
                pg = this.pool.putPage(0L);
                this.header.pack(pg.data);
                this.pool.unfix(pg);
                this.pool.copy(this.header.root[1 - curr].index, this.header.root[curr].index, (long)this.header.root[curr].indexUsed * 8L + 4096L - 1L & 0xFFFFFFFFFFFFF000L);
                if (this.listener != null) {
                    this.listener.recoveryCompleted();
                }
                System.err.println("Recovery completed");
            }
            this.committedIndexSize = this.currIndexSize = this.header.root[1 - curr].indexUsed;
            this.usedSize = this.header.root[curr].size;
        }
        int bitmapSize = this.header.root[1 - this.currIndex].bitmapExtent == 0 ? 4096 : 0x100000;
        this.bitmapPageAvailableSpace = new int[bitmapSize];
        for (i = 0; i < this.bitmapPageAvailableSpace.length; ++i) {
            this.bitmapPageAvailableSpace[i] = Integer.MAX_VALUE;
        }
        this.currPBitmapPage = 0;
        this.currRBitmapPage = 0;
        this.currPBitmapOffs = 0;
        this.currRBitmapOffs = 0;
        this.opened = true;
        this.reloadScheme();
        if (this.multiclientSupport) {
            this.endThreadTransaction();
        }
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    static void checkIfFinal(ClassDescriptor desc) {
        Class cls = desc.cls;
        if (cls != null) {
            ClassDescriptor next = desc.next;
            while (next != null) {
                next.load();
                if (cls.isAssignableFrom(next.cls)) {
                    desc.hasSubclasses = true;
                } else if (next.cls.isAssignableFrom(cls)) {
                    next.hasSubclasses = true;
                }
                next = next.next;
            }
        }
    }

    void reloadScheme() {
        this.classDescMap.clear();
        this.customAllocatorMap = null;
        this.customAllocatorList = null;
        this.defaultAllocator = new DefaultAllocator(this);
        int descListOid = this.header.root[1 - this.currIndex].classDescList;
        this.classDescMap.put(ClassDescriptor.class, new ClassDescriptor(this, ClassDescriptor.class));
        this.classDescMap.put(ClassDescriptor.FieldDescriptor.class, new ClassDescriptor(this, ClassDescriptor.FieldDescriptor.class));
        if (descListOid != 0) {
            ClassDescriptor desc = this.descList = this.findClassDescriptor(descListOid);
            while (desc != null) {
                desc.load();
                desc = desc.next;
            }
            desc = this.descList;
            while (desc != null) {
                if (this.findClassDescriptor(desc.cls) == desc) {
                    desc.resolve();
                }
                if (desc.allocator != null) {
                    if (this.customAllocatorMap == null) {
                        this.customAllocatorMap = new HashMap();
                        this.customAllocatorList = new ArrayList();
                    }
                    desc.allocator.load();
                    this.customAllocatorMap.put(desc.cls, desc.allocator);
                    this.customAllocatorList.add(desc.allocator);
                }
                StorageImpl.checkIfFinal(desc);
                desc = desc.next;
            }
        } else {
            this.descList = null;
        }
    }

    final void assignOid(IPersistent obj, int oid) {
        obj.assignOid(this, oid, false);
    }

    final void registerClassDescriptor(ClassDescriptor desc) {
        this.classDescMap.put(desc.cls, desc);
        desc.next = this.descList;
        this.descList = desc;
        StorageImpl.checkIfFinal(desc);
        this.storeObject0(desc, false);
        this.header.root[1 - this.currIndex].classDescList = desc.getOid();
        this.modified = true;
    }

    final ClassDescriptor findClassDescriptor(Class cls) {
        return (ClassDescriptor)this.classDescMap.get(cls);
    }

    final ClassDescriptor getClassDescriptor(Class cls) {
        ClassDescriptor desc = this.findClassDescriptor(cls);
        if (desc == null) {
            desc = new ClassDescriptor(this, cls);
            this.registerClassDescriptor(desc);
        }
        return desc;
    }

    @Override
    public synchronized IPersistent getRoot() {
        if (!this.opened) {
            throw new StorageError(1);
        }
        int rootOid = this.header.root[1 - this.currIndex].rootObject;
        return rootOid == 0 ? null : this.lookupObject(rootOid, null);
    }

    @Override
    public synchronized void setRoot(IPersistent root) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        if (root == null) {
            this.header.root[1 - this.currIndex].rootObject = 0;
        } else {
            if (!root.isPersistent()) {
                this.storeObject0(root, false);
            }
            this.header.root[1 - this.currIndex].rootObject = root.getOid();
        }
        this.modified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        Object object = this.backgroundGcMonitor;
        synchronized (object) {
            StorageImpl storageImpl = this;
            synchronized (storageImpl) {
                if (!this.opened) {
                    throw new StorageError(1);
                }
                this.objectCache.flush();
                if (this.customAllocatorList != null) {
                    for (CustomAllocator alloc : this.customAllocatorList) {
                        if (alloc.isModified()) {
                            alloc.store();
                        }
                        alloc.commit();
                    }
                }
                if (!this.modified) {
                    return;
                }
                this.commit0();
                this.modified = false;
            }
        }
    }

    private final void commit0() {
        Page pg;
        int offs;
        long pos;
        int j;
        Page dstIndex;
        Page srcIndex;
        int i;
        int curr = this.currIndex;
        int[] map = this.dirtyPagesMap;
        int oldIndexSize = this.header.root[curr].indexSize;
        int newIndexSize = this.header.root[1 - curr].indexSize;
        int nPages = this.committedIndexSize >>> 9;
        if (newIndexSize > oldIndexSize) {
            long newIndex;
            this.cloneBitmap(this.header.root[curr].index, (long)oldIndexSize * 8L);
            while (true) {
                newIndex = this.allocate((long)newIndexSize * 8L, 0);
                if (newIndexSize == this.header.root[1 - curr].indexSize) break;
                this.free(newIndex, (long)newIndexSize * 8L);
                newIndexSize = this.header.root[1 - curr].indexSize;
            }
            this.header.root[1 - curr].shadowIndex = newIndex;
            this.header.root[1 - curr].shadowIndexSize = newIndexSize;
            this.free(this.header.root[curr].index, (long)oldIndexSize * 8L);
        }
        long currSize = this.header.root[1 - curr].size;
        for (i = 0; i < nPages; ++i) {
            if ((map[i >> 5] & 1 << (i & 0x1F)) == 0) continue;
            srcIndex = this.pool.getPage(this.header.root[1 - curr].index + (long)i * 4096L);
            dstIndex = this.pool.getPage(this.header.root[curr].index + (long)i * 4096L);
            for (j = 0; j < 4096; j += 8) {
                pos = Bytes.unpack8(dstIndex.data, j);
                if (Bytes.unpack8(srcIndex.data, j) == pos || pos >= currSize || (pos & 4L) != 0L) continue;
                if ((pos & 1L) != 0L) {
                    this.free(pos & 0xFFFFFFFFFFFFFFF8L, 4096L);
                    continue;
                }
                if (pos == 0L) continue;
                offs = (int)pos & 0xFFF;
                pg = this.pool.getPage(pos - (long)offs);
                this.free(pos, ObjectHeader.getSize(pg.data, offs));
                this.pool.unfix(pg);
            }
            this.pool.unfix(srcIndex);
            this.pool.unfix(dstIndex);
        }
        int n = this.committedIndexSize & 0x1FF;
        if (n != 0 && (map[i >> 5] & 1 << (i & 0x1F)) != 0) {
            srcIndex = this.pool.getPage(this.header.root[1 - curr].index + (long)i * 4096L);
            dstIndex = this.pool.getPage(this.header.root[curr].index + (long)i * 4096L);
            j = 0;
            do {
                pos = Bytes.unpack8(dstIndex.data, j);
                if (Bytes.unpack8(srcIndex.data, j) != pos && pos < currSize && (pos & 4L) == 0L) {
                    if ((pos & 1L) != 0L) {
                        this.free(pos & 0xFFFFFFFFFFFFFFF8L, 4096L);
                    } else if (pos != 0L) {
                        offs = (int)pos & 0xFFF;
                        pg = this.pool.getPage(pos - (long)offs);
                        this.free(pos, ObjectHeader.getSize(pg.data, offs));
                        this.pool.unfix(pg);
                    }
                }
                j += 8;
            } while (--n != 0);
            this.pool.unfix(srcIndex);
            this.pool.unfix(dstIndex);
        }
        for (i = 0; i <= nPages; ++i) {
            if ((map[i >> 5] & 1 << (i & 0x1F)) == 0) continue;
            pg = this.pool.putPage(this.header.root[1 - curr].index + (long)i * 4096L);
            for (j = 0; j < 4096; j += 8) {
                Bytes.pack8(pg.data, j, Bytes.unpack8(pg.data, j) & 0xFFFFFFFFFFFFFFFDL);
            }
            this.pool.unfix(pg);
        }
        if (this.currIndexSize > this.committedIndexSize) {
            long end = this.header.root[1 - curr].index + 4096L - 1L + (long)this.currIndexSize * 8L & 0xFFFFFFFFFFFFF000L;
            for (long page = this.header.root[1 - curr].index + (long)this.committedIndexSize * 8L & 0xFFFFFFFFFFFFF000L; page < end; page += 4096L) {
                pg = this.pool.putPage(page);
                for (j = 0; j < 4096; j += 8) {
                    Bytes.pack8(pg.data, j, Bytes.unpack8(pg.data, j) & 0xFFFFFFFFFFFFFFFDL);
                }
                this.pool.unfix(pg);
            }
        }
        this.header.root[1 - curr].usedSize = this.usedSize;
        pg = this.pool.putPage(0L);
        this.header.pack(pg.data);
        this.pool.flush();
        this.pool.modify(pg);
        Assert.that(this.header.transactionId == this.transactionId);
        this.header.transactionId = ++this.transactionId;
        this.header.curr = curr ^= 1;
        this.header.dirty = true;
        this.header.pack(pg.data);
        this.pool.unfix(pg);
        this.pool.flush();
        this.header.root[1 - curr].size = this.header.root[curr].size;
        this.header.root[1 - curr].indexUsed = this.currIndexSize;
        this.header.root[1 - curr].freeList = this.header.root[curr].freeList;
        this.header.root[1 - curr].bitmapEnd = this.header.root[curr].bitmapEnd;
        this.header.root[1 - curr].rootObject = this.header.root[curr].rootObject;
        this.header.root[1 - curr].classDescList = this.header.root[curr].classDescList;
        this.header.root[1 - curr].bitmapExtent = this.header.root[curr].bitmapExtent;
        if (this.currIndexSize == 0 || newIndexSize != oldIndexSize) {
            this.header.root[1 - curr].index = this.header.root[curr].shadowIndex;
            this.header.root[1 - curr].indexSize = this.header.root[curr].shadowIndexSize;
            this.header.root[1 - curr].shadowIndex = this.header.root[curr].index;
            this.header.root[1 - curr].shadowIndexSize = this.header.root[curr].indexSize;
            this.pool.copy(this.header.root[1 - curr].index, this.header.root[curr].index, (long)this.currIndexSize * 8L);
            i = this.currIndexSize + 16384 - 1 >>> 14;
            while (--i >= 0) {
                map[i] = 0;
            }
        } else {
            for (i = 0; i < nPages; ++i) {
                if ((map[i >> 5] & 1 << (i & 0x1F)) == 0) continue;
                int n2 = i >> 5;
                map[n2] = map[n2] - (1 << (i & 0x1F));
                this.pool.copy(this.header.root[1 - curr].index + (long)i * 4096L, this.header.root[curr].index + (long)i * 4096L, 4096L);
            }
            if (this.currIndexSize > i * 512 && ((map[i >> 5] & 1 << (i & 0x1F)) != 0 || this.currIndexSize != this.committedIndexSize)) {
                this.pool.copy(this.header.root[1 - curr].index + (long)i * 4096L, this.header.root[curr].index + (long)i * 4096L, 8L * (long)this.currIndexSize - (long)i * 4096L);
                j = i >>> 5;
                n = this.currIndexSize + 16384 - 1 >>> 14;
                while (j < n) {
                    map[j++] = 0;
                }
            }
        }
        this.gcDone = false;
        this.currIndex = curr;
        this.committedIndexSize = this.currIndexSize;
        if (this.multiclientSupport) {
            this.pool.flush();
            pg = this.pool.putPage(0L);
            this.header.dirty = false;
            this.header.pack(pg.data);
            this.pool.unfix(pg);
            this.pool.flush();
        }
    }

    @Override
    public synchronized void rollback() {
        if (!this.opened) {
            throw new StorageError(1);
        }
        this.objectCache.invalidate();
        if (!this.modified) {
            return;
        }
        this.rollback0();
        this.modified = false;
    }

    private final void rollback0() {
        int curr = this.currIndex;
        int[] map = this.dirtyPagesMap;
        if (this.header.root[1 - curr].index != this.header.root[curr].shadowIndex) {
            this.pool.copy(this.header.root[curr].shadowIndex, this.header.root[curr].index, 8L * (long)this.committedIndexSize);
        } else {
            int nPages = this.committedIndexSize + 512 - 1 >>> 9;
            for (int i = 0; i < nPages; ++i) {
                if ((map[i >> 5] & 1 << (i & 0x1F)) == 0) continue;
                this.pool.copy(this.header.root[curr].shadowIndex + (long)i * 4096L, this.header.root[curr].index + (long)i * 4096L, 4096L);
            }
        }
        int j = this.currIndexSize + 16384 - 1 >>> 14;
        while (--j >= 0) {
            map[j] = 0;
        }
        this.header.root[1 - curr].index = this.header.root[curr].shadowIndex;
        this.header.root[1 - curr].indexSize = this.header.root[curr].shadowIndexSize;
        this.header.root[1 - curr].indexUsed = this.committedIndexSize;
        this.header.root[1 - curr].freeList = this.header.root[curr].freeList;
        this.header.root[1 - curr].bitmapEnd = this.header.root[curr].bitmapEnd;
        this.header.root[1 - curr].size = this.header.root[curr].size;
        this.header.root[1 - curr].rootObject = this.header.root[curr].rootObject;
        this.header.root[1 - curr].classDescList = this.header.root[curr].classDescList;
        this.header.root[1 - curr].bitmapExtent = this.header.root[curr].bitmapExtent;
        this.usedSize = this.header.root[curr].size;
        this.currIndexSize = this.committedIndexSize;
        this.currPBitmapPage = 0;
        this.currRBitmapPage = 0;
        this.currPBitmapOffs = 0;
        this.currRBitmapOffs = 0;
        this.reloadScheme();
    }

    @Override
    public synchronized void backup(OutputStream out) throws IOException {
        long pos;
        int i;
        if (!this.opened) {
            throw new StorageError(1);
        }
        this.objectCache.flush();
        int curr = 1 - this.currIndex;
        final int nObjects = this.header.root[curr].indexUsed;
        long indexOffs = this.header.root[curr].index;
        int nUsedIndexPages = (nObjects + 512 - 1) / 512;
        int nIndexPages = (this.header.root[curr].indexSize + 512 - 1) / 512;
        long totalRecordsSize = 0L;
        long nPagedObjects = 0L;
        int bitmapExtent = this.header.root[curr].bitmapExtent;
        final long[] index = new long[nObjects];
        final int[] oids = new int[nObjects];
        if (bitmapExtent == 0) {
            bitmapExtent = Integer.MAX_VALUE;
        }
        int j = 0;
        for (i = 0; i < nUsedIndexPages; ++i) {
            Page pg = this.pool.getPage(indexOffs + (long)i * 4096L);
            for (int k = 0; k < 512 && j < nObjects; ++k, ++j) {
                long pos2;
                index[j] = pos2 = Bytes.unpack8(pg.data, k * 8);
                oids[j] = j;
                if ((pos2 & 4L) != 0L) continue;
                if ((pos2 & 1L) != 0L) {
                    ++nPagedObjects;
                    continue;
                }
                if (pos2 == 0L) continue;
                int offs = (int)pos2 & 0xFFF;
                Page op = this.pool.getPage(pos2 - (long)offs);
                int size = ObjectHeader.getSize(op.data, offs & 0xFFFFFFF8);
                size = size + 32 - 1 & 0xFFFFFFE0;
                totalRecordsSize += (long)size;
                this.pool.unfix(op);
            }
            this.pool.unfix(pg);
        }
        Header newHeader = new Header();
        newHeader.curr = 0;
        newHeader.dirty = false;
        newHeader.databaseFormatVersion = this.header.databaseFormatVersion;
        long newFileSize = (nPagedObjects + (long)(nIndexPages * 2) + 1L) * 4096L + totalRecordsSize;
        newFileSize = newFileSize + 4096L - 1L & 0xFFFFFFFFFFFFF000L;
        newHeader.root = new RootPage[2];
        newHeader.root[0] = new RootPage();
        newHeader.root[1] = new RootPage();
        newHeader.root[0].size = newHeader.root[1].size = newFileSize;
        newHeader.root[1].shadowIndex = 4096L;
        newHeader.root[0].index = 4096L;
        newHeader.root[0].shadowIndex = newHeader.root[1].index = 4096L + (long)nIndexPages * 4096L;
        newHeader.root[1].shadowIndexSize = newHeader.root[1].indexSize = nIndexPages * 512;
        newHeader.root[0].indexSize = newHeader.root[1].indexSize;
        newHeader.root[0].shadowIndexSize = newHeader.root[1].indexSize;
        newHeader.root[0].indexUsed = newHeader.root[1].indexUsed = nObjects;
        newHeader.root[0].freeList = newHeader.root[1].freeList = this.header.root[curr].freeList;
        newHeader.root[0].bitmapEnd = newHeader.root[1].bitmapEnd = this.header.root[curr].bitmapEnd;
        newHeader.root[0].rootObject = newHeader.root[1].rootObject = this.header.root[curr].rootObject;
        newHeader.root[0].classDescList = newHeader.root[1].classDescList = this.header.root[curr].classDescList;
        newHeader.root[0].bitmapExtent = newHeader.root[1].bitmapExtent = this.header.root[curr].bitmapExtent;
        byte[] page = new byte[4096];
        newHeader.pack(page);
        out.write(page);
        long pageOffs = (long)(nIndexPages * 2 + 1) * 4096L;
        long recOffs = (nPagedObjects + (long)(nIndexPages * 2) + 1L) * 4096L;
        GenericSort.sort(new GenericSortArray(){

            public int size() {
                return nObjects;
            }

            public int compare(int i, int j) {
                return index[i] < index[j] ? -1 : (index[i] == index[j] ? 0 : 1);
            }

            public void swap(int i, int j) {
                long t1 = index[i];
                index[i] = index[j];
                index[j] = t1;
                int t2 = oids[i];
                oids[i] = oids[j];
                oids[j] = t2;
            }
        });
        byte[] newIndex = new byte[nIndexPages * 512 * 8];
        for (i = 0; i < nObjects; ++i) {
            pos = index[i];
            int oid = oids[i];
            if ((pos & 4L) == 0L) {
                if ((pos & 1L) != 0L) {
                    Bytes.pack8(newIndex, oid * 8, pageOffs | 1L);
                    pageOffs += 4096L;
                    continue;
                }
                if (pos == 0L) continue;
                Bytes.pack8(newIndex, oid * 8, recOffs);
                int offs = (int)pos & 0xFFF;
                Page op = this.pool.getPage(pos - (long)offs);
                int size = ObjectHeader.getSize(op.data, offs & 0xFFFFFFF8);
                size = size + 32 - 1 & 0xFFFFFFE0;
                recOffs += (long)size;
                this.pool.unfix(op);
                continue;
            }
            Bytes.pack8(newIndex, oid * 8, pos);
        }
        out.write(newIndex);
        out.write(newIndex);
        for (i = 0; i < nObjects; ++i) {
            pos = index[i];
            if (((int)pos & 5) != 1) continue;
            if (oids[i] < 4097 || oids[i] >= bitmapExtent && oids[i] < bitmapExtent + 0x100000 - 4096) {
                int pageId = oids[i] < 4097 ? oids[i] - 1 : oids[i] - bitmapExtent + this.bitmapExtentBase;
                long mappedSpace = (long)pageId * 4096L * 8L * 32L;
                if (mappedSpace >= newFileSize) {
                    Arrays.fill(page, (byte)0);
                } else if (mappedSpace + 0x100000L <= newFileSize) {
                    Arrays.fill(page, (byte)-1);
                } else {
                    int nBits = (int)(newFileSize - mappedSpace >> 5);
                    Arrays.fill(page, 0, nBits >> 3, (byte)-1);
                    page[nBits >> 3] = (byte)((1 << (nBits & 7)) - 1);
                    Arrays.fill(page, (nBits >> 3) + 1, 4096, (byte)0);
                }
                out.write(page);
                continue;
            }
            Page pg = this.pool.getPage(pos & 0xFFFFFFFFFFFFFFF8L);
            out.write(pg.data);
            this.pool.unfix(pg);
        }
        for (i = 0; i < nObjects; ++i) {
            pos = index[i];
            if (pos == 0L || ((int)pos & 5) != 0) continue;
            int offs = (int)(pos &= 0xFFFFFFFFFFFFFFF8L) & 0xFFF;
            Page pg = this.pool.getPage(pos - (long)offs);
            int size = ObjectHeader.getSize(pg.data, offs);
            size = size + 32 - 1 & 0xFFFFFFE0;
            while (true) {
                if (4096 - offs >= size) break;
                out.write(pg.data, offs, 4096 - offs);
                size -= 4096 - offs;
                offs = 0;
                this.pool.unfix(pg);
                pg = this.pool.getPage(pos += (long)(4096 - offs));
            }
            out.write(pg.data, offs, size);
            this.pool.unfix(pg);
        }
        if (recOffs != newFileSize) {
            Assert.that(newFileSize - recOffs < 4096L);
            int align = (int)(newFileSize - recOffs);
            Arrays.fill(page, 0, align, (byte)0);
            out.write(page, 0, align);
        }
    }

    @Override
    public <T> Query<T> createQuery() {
        return new QueryImpl(this);
    }

    @Override
    public synchronized <T extends IPersistent> IPersistentSet<T> createScalableSet() {
        return this.createScalableSet(8);
    }

    @Override
    public synchronized <T extends IPersistent> IPersistentSet<T> createScalableSet(int initialSize) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new ScalableSet(this, initialSize);
    }

    @Override
    public <T extends IPersistent> IPersistentList<T> createList() {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new PersistentListImpl(this);
    }

    @Override
    public <T extends IPersistent> IPersistentList<T> createScalableList() {
        return this.createScalableList(8);
    }

    @Override
    public <T extends IPersistent> IPersistentList<T> createScalableList(int initialSize) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new ScalableList(this, initialSize);
    }

    @Override
    public <K extends Comparable, V extends IPersistent> IPersistentMap<K, V> createMap(Class keyType) {
        return this.createMap(keyType, 4);
    }

    @Override
    public <K extends Comparable, V extends IPersistent> IPersistentMap<K, V> createMap(Class keyType, int initialSize) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new PersistentMapImpl(this, keyType, initialSize);
    }

    @Override
    public synchronized <T extends IPersistent> IPersistentSet<T> createSet() {
        if (!this.opened) {
            throw new StorageError(1);
        }
        PersistentCollection set = this.alternativeBtree ? new AltPersistentSet() : new PersistentSet();
        set.assignOid(this, 0, false);
        return set;
    }

    @Override
    public synchronized <T extends IPersistent> BitIndex<T> createBitIndex() {
        if (!this.opened) {
            throw new StorageError(1);
        }
        BitIndexImpl index = new BitIndexImpl();
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public synchronized <T extends IPersistent> Index<T> createIndex(Class keyType, boolean unique) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        PersistentCollection index = this.alternativeBtree ? new AltBtree(keyType, unique) : new Btree(keyType, unique);
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public synchronized <T extends IPersistent> Index<T> createIndex(Class[] keyTypes, boolean unique) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        PersistentCollection index = this.alternativeBtree ? new AltBtreeCompoundIndex(keyTypes, unique) : new BtreeCompoundIndex(keyTypes, unique);
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public synchronized <T extends IPersistent> MultidimensionalIndex<T> createMultidimensionalIndex(MultidimensionalComparator<T> comparator) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new KDTree<T>(this, comparator);
    }

    @Override
    public synchronized <T extends IPersistent> MultidimensionalIndex<T> createMultidimensionalIndex(Class type, String[] fieldNames) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new KDTree(this, type, fieldNames);
    }

    @Override
    public synchronized <T extends IPersistent> Index<T> createThickIndex(Class keyType) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new ThickIndex(keyType, this);
    }

    @Override
    public synchronized <T extends IPersistent> SpatialIndex<T> createSpatialIndex() {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new Rtree();
    }

    @Override
    public synchronized <T extends IPersistent> SpatialIndexR2<T> createSpatialIndexR2() {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new RtreeR2(this);
    }

    @Override
    public <T extends IPersistent> FieldIndex<T> createFieldIndex(Class type, String fieldName, boolean unique) {
        return this.createFieldIndex(type, fieldName, unique, false);
    }

    @Override
    public synchronized <T extends IPersistent> FieldIndex<T> createFieldIndex(Class type, String fieldName, boolean unique, boolean caseInsensitive) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        PersistentCollection index = caseInsensitive ? (this.alternativeBtree ? new AltBtreeCaseInsensitiveFieldIndex(type, fieldName, unique) : new BtreeCaseInsensitiveFieldIndex(type, fieldName, unique)) : (this.alternativeBtree ? new AltBtreeFieldIndex(type, fieldName, unique) : new BtreeFieldIndex(type, fieldName, unique));
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public <T extends IPersistent> FieldIndex<T> createFieldIndex(Class type, String[] fieldNames, boolean unique) {
        return this.createFieldIndex(type, fieldNames, unique, false);
    }

    @Override
    public synchronized <T extends IPersistent> FieldIndex<T> createFieldIndex(Class type, String[] fieldNames, boolean unique, boolean caseInsensitive) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        PersistentCollection index = caseInsensitive ? (this.alternativeBtree ? new AltBtreeCaseInsensitiveMultiFieldIndex(type, fieldNames, unique) : new BtreeCaseInsensitiveMultiFieldIndex(type, fieldNames, unique)) : (this.alternativeBtree ? new AltBtreeMultiFieldIndex(type, fieldNames, unique) : new BtreeMultiFieldIndex(type, fieldNames, unique));
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public synchronized <T extends IPersistent> Index<T> createRandomAccessIndex(Class keyType, boolean unique) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        RndBtree index = new RndBtree(keyType, unique);
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public synchronized <T extends IPersistent> Index<T> createRandomAccessIndex(Class[] keyTypes, boolean unique) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        RndBtreeCompoundIndex index = new RndBtreeCompoundIndex(keyTypes, unique);
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public <T extends IPersistent> FieldIndex<T> createRandomAccessFieldIndex(Class type, String fieldName, boolean unique) {
        return this.createRandomAccessFieldIndex(type, fieldName, unique, false);
    }

    @Override
    public synchronized <T extends IPersistent> FieldIndex<T> createRandomAccessFieldIndex(Class type, String fieldName, boolean unique, boolean caseInsensitive) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        RndBtreeFieldIndex index = caseInsensitive ? new RndBtreeCaseInsensitiveFieldIndex(type, fieldName, unique) : new RndBtreeFieldIndex(type, fieldName, unique);
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public <T extends IPersistent> FieldIndex<T> createRandomAccessFieldIndex(Class type, String[] fieldNames, boolean unique) {
        return this.createRandomAccessFieldIndex(type, fieldNames, unique, false);
    }

    @Override
    public synchronized <T extends IPersistent> FieldIndex<T> createRandomAccessFieldIndex(Class type, String[] fieldNames, boolean unique, boolean caseInsensitive) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        RndBtreeMultiFieldIndex index = caseInsensitive ? new RndBtreeCaseInsensitiveMultiFieldIndex(type, fieldNames, unique) : new RndBtreeMultiFieldIndex(type, fieldNames, unique);
        index.assignOid(this, 0, false);
        return index;
    }

    @Override
    public <T extends IPersistent> SortedCollection<T> createSortedCollection(PersistentComparator<T> comparator, boolean unique) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new Ttree<T>(comparator, unique);
    }

    public <T extends IPersistent & Comparable> SortedCollection<T> createSortedCollection(boolean unique) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        return new Ttree(new DefaultPersistentComparator(), unique);
    }

    @Override
    public <T extends IPersistent> Link<T> createLink() {
        return this.createLink(8);
    }

    @Override
    public <T extends IPersistent> Link<T> createLink(int initialSize) {
        return new LinkImpl(initialSize);
    }

    @Override
    public <M extends IPersistent, O extends IPersistent> Relation<M, O> createRelation(O owner) {
        return new RelationImpl(owner);
    }

    @Override
    public Blob createBlob() {
        return new BlobImpl(this, 4076);
    }

    @Override
    public Blob createRandomAccessBlob() {
        return new RandomAccessBlobImpl(this);
    }

    @Override
    public <T extends TimeSeries.Tick> TimeSeries<T> createTimeSeries(Class blockClass, long maxBlockTimeInterval) {
        return new TimeSeriesImpl(this, blockClass, maxBlockTimeInterval);
    }

    @Override
    public <T extends IPersistent> PatriciaTrie<T> createPatriciaTrie() {
        return new PTrie();
    }

    final long getGCPos(int oid) {
        Page pg = this.pool.getPage(this.header.root[this.currIndex].index + ((long)(oid >>> 9) << 12));
        long pos = Bytes.unpack8(pg.data, (oid & 0x1FF) << 3);
        this.pool.unfix(pg);
        return pos;
    }

    final void markOid(int oid) {
        if (oid != 0) {
            int bit;
            long pos = this.getGCPos(oid);
            if ((pos & 5L) != 0L) {
                throw new StorageError(15);
            }
            if (pos < this.header.root[this.currIndex].size && (this.blackBitmap[(bit = (int)(pos >>> 5)) >>> 5] & 1 << (bit & 0x1F)) == 0) {
                int n = bit >>> 5;
                this.greyBitmap[n] = this.greyBitmap[n] | 1 << (bit & 0x1F);
            }
        }
    }

    final Page getGCPage(int oid) {
        return this.pool.getPage(this.getGCPos(oid) & 0xFFFFFFFFFFFFFFF8L);
    }

    @Override
    public void setGcThreshold(long maxAllocatedDelta) {
        this.gcThreshold = maxAllocatedDelta;
    }

    private void mark() {
        int bitmapSize = (int)(this.header.root[this.currIndex].size >>> 10) + 1;
        if (this.listener != null) {
            this.listener.gcStarted();
        }
        this.greyBitmap = new int[bitmapSize];
        this.blackBitmap = new int[bitmapSize];
        int rootOid = this.header.root[this.currIndex].rootObject;
        if (rootOid != 0) {
            boolean existsNotMarkedObjects;
            this.markOid(rootOid);
            do {
                existsNotMarkedObjects = false;
                for (int i = 0; i < bitmapSize; ++i) {
                    if (this.greyBitmap[i] == 0) continue;
                    existsNotMarkedObjects = true;
                    for (int j = 0; j < 32; ++j) {
                        if ((this.greyBitmap[i] & 1 << j) == 0) continue;
                        long pos = ((long)i << 5) + (long)j << 5;
                        int n = i;
                        this.greyBitmap[n] = this.greyBitmap[n] & ~(1 << j);
                        int n2 = i;
                        this.blackBitmap[n2] = this.blackBitmap[n2] | 1 << j;
                        int offs = (int)pos & 0xFFF;
                        Page pg = this.pool.getPage(pos - (long)offs);
                        int typeOid = ObjectHeader.getType(pg.data, offs);
                        if (typeOid != 0) {
                            ClassDescriptor desc = this.findClassDescriptor(typeOid);
                            if (Btree.class.isAssignableFrom(desc.cls)) {
                                Btree btree = new Btree(pg.data, 8 + offs);
                                btree.assignOid(this, 0, false);
                                btree.markTree();
                            } else if (desc.hasReferences) {
                                this.markObject(this.pool.get(pos), 8, desc);
                            }
                        }
                        this.pool.unfix(pg);
                    }
                }
            } while (existsNotMarkedObjects);
        }
    }

    private int sweep() {
        int nDeallocated = 0;
        this.gcDone = true;
        int j = this.committedIndexSize;
        for (int i = 4097; i < j; ++i) {
            int bit;
            long pos = this.getGCPos(i);
            if (pos == 0L || ((int)pos & 5) != 0 || (this.blackBitmap[(bit = (int)(pos >>> 5)) >>> 5] & 1 << (bit & 0x1F)) != 0 || this.getPos(i) != pos) continue;
            int offs = (int)pos & 0xFFF;
            Page pg = this.pool.getPage(pos - (long)offs);
            int typeOid = ObjectHeader.getType(pg.data, offs);
            if (typeOid == 0) continue;
            ClassDescriptor desc = this.findClassDescriptor(typeOid);
            ++nDeallocated;
            if (Btree.class.isAssignableFrom(desc.cls)) {
                Btree btree = new Btree(pg.data, 8 + offs);
                this.pool.unfix(pg);
                btree.assignOid(this, i, false);
                btree.deallocate();
            } else {
                int size = ObjectHeader.getSize(pg.data, offs);
                this.pool.unfix(pg);
                this.freeId(i);
                this.objectCache.remove(i);
                this.cloneBitmap(pos, size);
            }
            if (this.listener == null) continue;
            this.listener.deallocateObject(desc.cls, i);
        }
        this.greyBitmap = null;
        this.blackBitmap = null;
        this.allocatedDelta = 0L;
        this.gcActive = false;
        if (this.listener != null) {
            this.listener.gcCompleted(nDeallocated);
        }
        return nDeallocated;
    }

    @Override
    public synchronized int gc() {
        return this.gc0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int gc0() {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            if (!this.opened) {
                throw new StorageError(1);
            }
            if (this.gcDone || this.gcActive) {
                return 0;
            }
            this.gcActive = true;
            if (this.backgroundGc) {
                if (this.gcThread == null) {
                    this.gcThread = new GcThread();
                }
                this.gcThread.activate();
                return 0;
            }
            this.mark();
            return this.sweep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap getMemoryDump() {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            if (!this.opened) {
                throw new StorageError(1);
            }
            int bitmapSize = (int)(this.header.root[this.currIndex].size >>> 10) + 1;
            this.greyBitmap = new int[bitmapSize];
            this.blackBitmap = new int[bitmapSize];
            int rootOid = this.header.root[this.currIndex].rootObject;
            HashMap<Class, MemoryUsage> map = new HashMap<Class, MemoryUsage>();
            if (rootOid != 0) {
                boolean existsNotMarkedObjects;
                MemoryUsage indexUsage = new MemoryUsage(Index.class);
                MemoryUsage fieldIndexUsage = new MemoryUsage(FieldIndex.class);
                MemoryUsage classUsage = new MemoryUsage(Class.class);
                this.markOid(rootOid);
                do {
                    existsNotMarkedObjects = false;
                    for (int i = 0; i < bitmapSize; ++i) {
                        if (this.greyBitmap[i] == 0) continue;
                        existsNotMarkedObjects = true;
                        for (int j = 0; j < 32; ++j) {
                            if ((this.greyBitmap[i] & 1 << j) == 0) continue;
                            long pos = ((long)i << 5) + (long)j << 5;
                            int n = i;
                            this.greyBitmap[n] = this.greyBitmap[n] & ~(1 << j);
                            int n2 = i;
                            this.blackBitmap[n2] = this.blackBitmap[n2] | 1 << j;
                            int offs = (int)pos & 0xFFF;
                            Page pg = this.pool.getPage(pos - (long)offs);
                            int typeOid = ObjectHeader.getType(pg.data, offs);
                            int objSize = ObjectHeader.getSize(pg.data, offs);
                            int alignedSize = objSize + 32 - 1 & 0xFFFFFFE0;
                            if (typeOid != 0) {
                                this.markOid(typeOid);
                                ClassDescriptor desc = this.findClassDescriptor(typeOid);
                                if (Btree.class.isAssignableFrom(desc.cls)) {
                                    Btree btree = new Btree(pg.data, 8 + offs);
                                    btree.assignOid(this, 0, false);
                                    int nPages = btree.markTree();
                                    if (FieldIndex.class.isAssignableFrom(desc.cls)) {
                                        ++fieldIndexUsage.nInstances;
                                        fieldIndexUsage.totalSize += (long)nPages * 4096L + (long)objSize;
                                        fieldIndexUsage.allocatedSize += (long)nPages * 4096L + (long)alignedSize;
                                    } else {
                                        ++indexUsage.nInstances;
                                        indexUsage.totalSize += (long)nPages * 4096L + (long)objSize;
                                        indexUsage.allocatedSize += (long)nPages * 4096L + (long)alignedSize;
                                    }
                                } else {
                                    MemoryUsage usage = (MemoryUsage)map.get(desc.cls);
                                    if (usage == null) {
                                        usage = new MemoryUsage(desc.cls);
                                        map.put(desc.cls, usage);
                                    }
                                    ++usage.nInstances;
                                    usage.totalSize += (long)objSize;
                                    usage.allocatedSize += (long)alignedSize;
                                    if (desc.hasReferences) {
                                        this.markObject(this.pool.get(pos), 8, desc);
                                    }
                                }
                            } else {
                                ++classUsage.nInstances;
                                classUsage.totalSize += (long)objSize;
                                classUsage.allocatedSize += (long)alignedSize;
                            }
                            this.pool.unfix(pg);
                        }
                    }
                } while (existsNotMarkedObjects);
                if (indexUsage.nInstances != 0) {
                    map.put(Index.class, indexUsage);
                }
                if (fieldIndexUsage.nInstances != 0) {
                    map.put(FieldIndex.class, fieldIndexUsage);
                }
                if (classUsage.nInstances != 0) {
                    map.put(Class.class, classUsage);
                }
                MemoryUsage system = new MemoryUsage(Storage.class);
                system.totalSize += (long)this.header.root[0].indexSize * 8L;
                system.totalSize += (long)this.header.root[1].indexSize * 8L;
                system.totalSize += (long)(this.header.root[this.currIndex].bitmapEnd - 1) * 4096L;
                system.totalSize += 4096L;
                system.allocatedSize = this.header.root[this.currIndex].bitmapExtent != 0 ? this.getBitmapUsedSpace(1, 4097) + this.getBitmapUsedSpace(this.header.root[this.currIndex].bitmapExtent + 4096 - this.bitmapExtentBase, this.header.root[this.currIndex].bitmapExtent + this.header.root[this.currIndex].bitmapEnd - 1 - this.bitmapExtentBase) : this.getBitmapUsedSpace(1, this.header.root[this.currIndex].bitmapEnd);
                system.nInstances = this.header.root[this.currIndex].indexSize;
                map.put(Storage.class, system);
            }
            return map;
        }
    }

    final long getBitmapUsedSpace(int from, int till) {
        long allocated = 0L;
        while (from < till) {
            Page pg = this.getGCPage(from);
            for (int j = 0; j < 4096; ++j) {
                for (int mask = pg.data[j] & 0xFF; mask != 0; mask >>= 1) {
                    if ((mask & 1) == 0) continue;
                    allocated += 32L;
                }
            }
            this.pool.unfix(pg);
            ++from;
        }
        return allocated;
    }

    final int markObject(byte[] obj, int offs, ClassDescriptor desc) {
        block21: for (ClassDescriptor.FieldDescriptor fd : desc.allFields) {
            switch (fd.type) {
                case 0: 
                case 1: {
                    ++offs;
                    continue block21;
                }
                case 2: 
                case 3: {
                    offs += 2;
                    continue block21;
                }
                case 4: 
                case 6: 
                case 14: {
                    offs += 4;
                    continue block21;
                }
                case 5: 
                case 7: 
                case 9: {
                    offs += 8;
                    continue block21;
                }
                case 8: {
                    int strlen = Bytes.unpack4(obj, offs);
                    offs += 4;
                    if (strlen > 0) {
                        offs += strlen * 2;
                        continue block21;
                    }
                    if (strlen >= -1) continue block21;
                    offs -= strlen + 2;
                    continue block21;
                }
                case 10: {
                    this.markOid(Bytes.unpack4(obj, offs));
                    offs += 4;
                    continue block21;
                }
                case 11: {
                    offs = this.markObject(obj, offs, fd.valueDesc);
                    continue block21;
                }
                case 12: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    if (len > 0) {
                        offs += len;
                        continue block21;
                    }
                    if (len == -12) {
                        this.markOid(Bytes.unpack4(obj, offs));
                        offs += 4;
                        continue block21;
                    }
                    if (len >= -1) continue block21;
                    offs += ClassDescriptor.sizeof[-2 - len];
                    continue block21;
                }
                case 15: {
                    try {
                        ByteArrayInputStream in = new ByteArrayInputStream(obj, offs, obj.length - offs);
                        this.serializer.unpack(in);
                        offs = obj.length - in.available();
                        continue block21;
                    }
                    catch (IOException x) {
                        throw new StorageError(17, x);
                    }
                }
                case 20: 
                case 21: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    if (len <= 0) continue block21;
                    offs += len;
                    continue block21;
                }
                case 22: 
                case 23: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    if (len <= 0) continue block21;
                    offs += len * 2;
                    continue block21;
                }
                case 24: 
                case 26: 
                case 34: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    if (len <= 0) continue block21;
                    offs += len * 4;
                    continue block21;
                }
                case 25: 
                case 27: 
                case 29: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    if (len <= 0) continue block21;
                    offs += len * 8;
                    continue block21;
                }
                case 28: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    while (--len >= 0) {
                        int strlen = Bytes.unpack4(obj, offs);
                        offs += 4;
                        if (strlen > 0) {
                            offs += strlen * 2;
                            continue;
                        }
                        if (strlen >= -1) continue;
                        offs -= strlen + 2;
                    }
                    continue block21;
                }
                case 13: 
                case 30: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    while (--len >= 0) {
                        this.markOid(Bytes.unpack4(obj, offs));
                        offs += 4;
                    }
                    continue block21;
                }
                case 31: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    ClassDescriptor valueDesc = fd.valueDesc;
                    while (--len >= 0) {
                        offs = this.markObject(obj, offs, valueDesc);
                    }
                    continue block21;
                }
                case 32: {
                    int len = Bytes.unpack4(obj, offs);
                    offs += 4;
                    while (--len >= 0) {
                        int rawlen = Bytes.unpack4(obj, offs);
                        offs += 4;
                        if (rawlen >= 0) {
                            offs += rawlen;
                            continue;
                        }
                        if (rawlen == -12) {
                            this.markOid(Bytes.unpack4(obj, offs));
                            offs += 4;
                            continue;
                        }
                        if (rawlen >= -1) continue;
                        offs += ClassDescriptor.sizeof[-2 - rawlen];
                    }
                    continue block21;
                }
            }
        }
        return offs;
    }

    @Override
    public ThreadTransactionContext getTransactionContext() {
        return (ThreadTransactionContext)this.transactionContext.get();
    }

    @Override
    public ThreadTransactionContext setTransactionContext(ThreadTransactionContext ctx) {
        ThreadTransactionContext oldCtx = (ThreadTransactionContext)this.transactionContext.get();
        this.transactionContext.set(ctx);
        return oldCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginThreadTransaction(int mode) {
        switch (mode) {
            case 2: {
                if (this.multiclientSupport) {
                    throw new IllegalArgumentException("Illegal transaction mode");
                }
                this.useSerializableTransactions = true;
                ++this.getTransactionContext().nested;
                break;
            }
            case 0: 
            case 1: {
                if (this.multiclientSupport) {
                    if (mode == 0) {
                        this.transactionLock.exclusiveLock();
                    } else {
                        this.transactionLock.sharedLock();
                    }
                    Object object = this.transactionMonitor;
                    synchronized (object) {
                        if (this.nNestedTransactions++ == 0) {
                            int curr;
                            this.file.lock(mode == 1);
                            byte[] buf = new byte[139];
                            int rc = this.file.read(0L, buf);
                            if (rc > 0 && rc < 139) {
                                throw new StorageError(11);
                            }
                            this.header.unpack(buf);
                            this.currIndex = curr = this.header.curr;
                            this.committedIndexSize = this.currIndexSize = this.header.root[1 - curr].indexUsed;
                            this.usedSize = this.header.root[curr].size;
                            if (this.header.transactionId != this.transactionId) {
                                if (this.bitmapPageAvailableSpace != null) {
                                    for (int i = 0; i < this.bitmapPageAvailableSpace.length; ++i) {
                                        this.bitmapPageAvailableSpace[i] = Integer.MAX_VALUE;
                                    }
                                }
                                this.objectCache.clear();
                                this.pool.clear();
                                this.transactionId = this.header.transactionId;
                            }
                        }
                        break;
                    }
                }
                Object object = this.transactionMonitor;
                synchronized (object) {
                    if (this.scheduledCommitTime != Long.MAX_VALUE) {
                        ++this.nBlockedTransactions;
                        while (System.currentTimeMillis() >= this.scheduledCommitTime) {
                            try {
                                this.transactionMonitor.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        --this.nBlockedTransactions;
                    }
                    ++this.nNestedTransactions;
                }
                if (mode == 0) {
                    this.transactionLock.exclusiveLock();
                    break;
                }
                this.transactionLock.sharedLock();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal transaction mode");
            }
        }
    }

    @Override
    public void endThreadTransaction() {
        this.endThreadTransaction(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endThreadTransaction(int maxDelay) {
        if (this.multiclientSupport) {
            if (maxDelay != Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Delay is not supported for global transactions");
            }
            Object object = this.transactionMonitor;
            synchronized (object) {
                this.transactionLock.unlock();
                if (this.nNestedTransactions != 0 && --this.nNestedTransactions == 0) {
                    this.commit();
                    this.pool.flush();
                    this.file.unlock();
                }
            }
            return;
        }
        ThreadTransactionContext ctx = this.getTransactionContext();
        if (ctx.nested != 0) {
            if (--ctx.nested == 0) {
                ArrayList modified = ctx.modified;
                ArrayList deleted = ctx.deleted;
                IdentityHashMap locked = ctx.locked;
                Object object = this.backgroundGcMonitor;
                synchronized (object) {
                    StorageImpl storageImpl = this;
                    synchronized (storageImpl) {
                        OidHashTable oidHashTable = this.objectCache;
                        synchronized (oidHashTable) {
                            int i = modified.size();
                            while (--i >= 0) {
                                ((IPersistent)modified.get(i)).store();
                            }
                            i = deleted.size();
                            while (--i >= 0) {
                                this.deallocateObject0((IPersistent)deleted.get(i));
                            }
                            if (modified.size() + deleted.size() > 0) {
                                this.commit0();
                            }
                        }
                    }
                }
                Iterator iterator = locked.values().iterator();
                while (iterator.hasNext()) {
                    ((IResource)iterator.next()).reset();
                }
                modified.clear();
                deleted.clear();
                locked.clear();
            }
        } else {
            Object object = this.transactionMonitor;
            synchronized (object) {
                this.transactionLock.unlock();
                if (this.nNestedTransactions != 0) {
                    if (--this.nNestedTransactions == 0) {
                        ++this.nCommittedTransactions;
                        this.commit();
                        this.scheduledCommitTime = Long.MAX_VALUE;
                        if (this.nBlockedTransactions != 0) {
                            this.transactionMonitor.notifyAll();
                        }
                    } else if (maxDelay != Integer.MAX_VALUE) {
                        long nextCommit = System.currentTimeMillis() + (long)maxDelay;
                        if (nextCommit < this.scheduledCommitTime) {
                            this.scheduledCommitTime = nextCommit;
                        }
                        if (maxDelay == 0) {
                            int n = this.nCommittedTransactions;
                            ++this.nBlockedTransactions;
                            do {
                                try {
                                    this.transactionMonitor.wait();
                                }
                                catch (InterruptedException x) {
                                    // empty catch block
                                }
                            } while (this.nCommittedTransactions == n);
                            --this.nBlockedTransactions;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackThreadTransaction() {
        if (this.multiclientSupport) {
            Object object = this.transactionMonitor;
            synchronized (object) {
                this.transactionLock.reset();
                this.nNestedTransactions = 0;
                this.rollback();
                this.file.unlock();
            }
            return;
        }
        ThreadTransactionContext ctx = this.getTransactionContext();
        if (ctx.nested != 0) {
            ArrayList modified = ctx.modified;
            IdentityHashMap locked = ctx.locked;
            StorageImpl storageImpl = this;
            synchronized (storageImpl) {
                OidHashTable oidHashTable = this.objectCache;
                synchronized (oidHashTable) {
                    int i = modified.size();
                    while (--i >= 0) {
                        IPersistent obj = (IPersistent)modified.get(i);
                        int oid = obj.getOid();
                        if (this.getPos(oid) == 0L) {
                            this.freeId(oid);
                        }
                        obj.invalidate();
                    }
                }
            }
            Iterator iterator = locked.values().iterator();
            while (iterator.hasNext()) {
                ((IResource)iterator.next()).reset();
            }
            ctx.nested = 0;
            modified.clear();
            ctx.deleted.clear();
            locked.clear();
        } else {
            Object object = this.transactionMonitor;
            synchronized (object) {
                this.transactionLock.reset();
                this.nNestedTransactions = 0;
                if (this.nBlockedTransactions != 0) {
                    this.transactionMonitor.notifyAll();
                }
                this.rollback();
            }
        }
    }

    @Override
    public boolean lockObject(IPersistent obj) {
        if (this.useSerializableTransactions) {
            ThreadTransactionContext ctx = this.getTransactionContext();
            if (ctx.nested != 0) {
                return ctx.locked.put(obj, obj) == null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.backgroundGcMonitor;
        synchronized (object) {
            this.commit();
            this.opened = false;
        }
        if (this.gcThread != null) {
            this.gcThread.activate();
            try {
                this.gcThread.join();
            }
            catch (InterruptedException x) {
                // empty catch block
            }
        }
        if (this.isDirty()) {
            Page pg = this.pool.putPage(0L);
            this.header.pack(pg.data);
            this.pool.flush();
            this.pool.modify(pg);
            this.header.dirty = false;
            this.header.pack(pg.data);
            this.pool.unfix(pg);
            this.pool.flush();
        }
        this.pool.close();
        this.pool = null;
        this.objectCache = null;
        this.classDescMap = null;
        this.bitmapPageAvailableSpace = null;
        this.dirtyPagesMap = null;
        this.descList = null;
    }

    @Override
    public synchronized void exportXML(Writer writer) throws IOException {
        if (!this.opened) {
            throw new StorageError(1);
        }
        this.objectCache.flush();
        int rootOid = this.header.root[1 - this.currIndex].rootObject;
        if (rootOid != 0) {
            XMLExporter xmlExporter = new XMLExporter(this, writer);
            xmlExporter.exportDatabase(rootOid);
        }
    }

    @Override
    public synchronized void importXML(Reader reader) throws XMLImportException {
        if (!this.opened) {
            throw new StorageError(1);
        }
        XMLImporter xmlImporter = new XMLImporter(this, reader);
        xmlImporter.importDatabase();
    }

    private boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("true".equalsIgnoreCase(s) || "t".equalsIgnoreCase(s) || "1".equals(s)) {
                return true;
            }
            if ("false".equalsIgnoreCase(s) || "f".equalsIgnoreCase(s) || "0".equals(s)) {
                return false;
            }
        }
        throw new StorageError(23);
    }

    private long getIntegerValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new StorageError(23);
    }

    @Override
    public void setProperties(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
        String value = props.getProperty("perst.implicit.values");
        if (value != null) {
            ClassDescriptor.treateAnyNonPersistentObjectAsValue = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.serialize.transient.objects")) != null) {
            ClassDescriptor.serializeNonPersistentObjects = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.object.cache.init.size")) != null) {
            this.objectCacheInitSize = (int)this.getIntegerValue(value);
            if (this.objectCacheInitSize <= 0) {
                throw new IllegalArgumentException("Initial object cache size should be positive");
            }
        }
        if ((value = props.getProperty("perst.object.cache.kind")) != null) {
            this.cacheKind = value;
        }
        if ((value = props.getProperty("perst.object.index.init.size")) != null) {
            this.initIndexSize = (int)this.getIntegerValue(value);
        }
        if ((value = props.getProperty("perst.extension.quantum")) != null) {
            this.extensionQuantum = this.getIntegerValue(value);
        }
        if ((value = props.getProperty("perst.gc.threshold")) != null) {
            this.gcThreshold = this.getIntegerValue(value);
        }
        if ((value = props.getProperty("perst.file.readonly")) != null) {
            this.readOnly = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.file.noflush")) != null) {
            this.noFlush = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.alternative.btree")) != null) {
            this.alternativeBtree = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.background.gc")) != null) {
            this.backgroundGc = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.string.encoding")) != null) {
            this.encoding = value;
        }
        if ((value = props.getProperty("perst.lock.file")) != null) {
            this.lockFile = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.replication.ack")) != null) {
            this.replicationAck = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.concurrent.iterator")) != null) {
            this.concurrentIterator = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.slave.connection.timeout")) != null) {
            this.slaveConnectionTimeout = (int)this.getIntegerValue(value);
        }
        if ((value = props.getProperty("perst.force.store")) != null) {
            this.forceStore = this.getBooleanValue(value);
        }
        if ((value = props.getProperty("perst.page.pool.lru.limit")) != null) {
            this.pagePoolLruLimit = this.getIntegerValue(value);
        }
        if ((value = props.getProperty("perst.multiclient.support")) != null) {
            this.multiclientSupport = this.getBooleanValue(value);
        }
        if (this.multiclientSupport && this.backgroundGc) {
            throw new IllegalArgumentException("In mutliclient access mode bachround GC is not supported");
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
        if (name.equals("perst.implicit.values")) {
            ClassDescriptor.treateAnyNonPersistentObjectAsValue = this.getBooleanValue(value);
        } else if (name.equals("perst.serialize.transient.objects")) {
            ClassDescriptor.serializeNonPersistentObjects = this.getBooleanValue(value);
        } else if (name.equals("perst.object.cache.init.size")) {
            this.objectCacheInitSize = (int)this.getIntegerValue(value);
            if (this.objectCacheInitSize <= 0) {
                throw new IllegalArgumentException("Initial object cache size should be positive");
            }
        } else if (name.equals("perst.object.cache.kind")) {
            this.cacheKind = (String)value;
        } else if (name.equals("perst.object.index.init.size")) {
            this.initIndexSize = (int)this.getIntegerValue(value);
        } else if (name.equals("perst.extension.quantum")) {
            this.extensionQuantum = this.getIntegerValue(value);
        } else if (name.equals("perst.gc.threshold")) {
            this.gcThreshold = this.getIntegerValue(value);
        } else if (name.equals("perst.file.readonly")) {
            this.readOnly = this.getBooleanValue(value);
        } else if (name.equals("perst.file.noflush")) {
            this.noFlush = this.getBooleanValue(value);
        } else if (name.equals("perst.alternative.btree")) {
            this.alternativeBtree = this.getBooleanValue(value);
        } else if (name.equals("perst.background.gc")) {
            this.backgroundGc = this.getBooleanValue(value);
        } else if (name.equals("perst.string.encoding")) {
            this.encoding = value == null ? null : value.toString();
        } else if (name.equals("perst.lock.file")) {
            this.lockFile = this.getBooleanValue(value);
        } else if (name.equals("perst.replication.ack")) {
            this.replicationAck = this.getBooleanValue(value);
        } else if (name.equals("perst.concurrent.iterator")) {
            this.concurrentIterator = this.getBooleanValue(value);
        } else if (name.equals("perst.slave.connection.timeout")) {
            this.slaveConnectionTimeout = (int)this.getIntegerValue(value);
        } else if (name.equals("perst.force.store")) {
            this.forceStore = this.getBooleanValue(value);
        } else if (name.equals("perst.page.pool.lru.limit")) {
            this.pagePoolLruLimit = this.getIntegerValue(value);
        } else if (name.equals("perst.multiclient.support")) {
            this.multiclientSupport = this.getBooleanValue(value);
        } else {
            throw new StorageError(22);
        }
        if (this.multiclientSupport && this.backgroundGc) {
            throw new IllegalArgumentException("In mutliclient access mode bachround GC is not supported");
        }
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public StorageListener setListener(StorageListener listener) {
        StorageListener prevListener = this.listener;
        this.listener = listener;
        return prevListener;
    }

    @Override
    public synchronized IPersistent getObjectByOID(int oid) {
        return oid == 0 ? null : this.lookupObject(oid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void modifyObject(IPersistent obj) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            if (!obj.isModified()) {
                if (this.useSerializableTransactions) {
                    ThreadTransactionContext ctx = this.getTransactionContext();
                    if (ctx.nested != 0) {
                        ctx.modified.add(obj);
                        return;
                    }
                }
                this.objectCache.setDirty(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void storeObject(IPersistent obj) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            this.storeObject0(obj, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFinalizedObject(IPersistent obj) {
        if (this.opened) {
            OidHashTable oidHashTable = this.objectCache;
            synchronized (oidHashTable) {
                if (obj.getOid() != 0) {
                    this.storeObject0(obj, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int makePersistent(IPersistent obj) {
        if (!this.opened) {
            throw new StorageError(1);
        }
        if (obj == null) {
            return 0;
        }
        int oid = obj.getOid();
        if (oid != 0) {
            return oid;
        }
        if (this.forceStore && (!this.useSerializableTransactions || this.getTransactionContext().nested == 0)) {
            OidHashTable oidHashTable = this.objectCache;
            synchronized (oidHashTable) {
                this.storeObject0(obj, false);
            }
            return obj.getOid();
        }
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            oid = this.allocateId();
            obj.assignOid(this, oid, false);
            this.setPos(oid, 0L);
            this.objectCache.put(oid, obj);
            obj.modify();
            return oid;
        }
    }

    private final CustomAllocator getCustomAllocator(Class cls) {
        CustomAllocator alloc;
        Object a = this.customAllocatorMap.get(cls);
        if (a != null) {
            return a == this.defaultAllocator ? null : (CustomAllocator)a;
        }
        Class superclass = cls.getSuperclass();
        if (superclass != null && (alloc = this.getCustomAllocator(superclass)) != null) {
            this.customAllocatorMap.put(cls, alloc);
            return alloc;
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            CustomAllocator alloc2 = this.getCustomAllocator(interfaces[i]);
            if (alloc2 == null) continue;
            this.customAllocatorMap.put(cls, alloc2);
            return alloc2;
        }
        this.customAllocatorMap.put(cls, this.defaultAllocator);
        return null;
    }

    private final void storeObject0(IPersistent obj, boolean finalized) {
        long pos;
        CustomAllocator allocator;
        obj.onStore();
        int oid = obj.getOid();
        boolean newObject = false;
        if (oid == 0) {
            oid = this.allocateId();
            if (!finalized) {
                this.objectCache.put(oid, obj);
            }
            obj.assignOid(this, oid, false);
            newObject = true;
        } else if (obj.isModified()) {
            this.objectCache.clearDirty(obj);
        }
        byte[] data = this.packObject(obj, finalized);
        int newSize = ObjectHeader.getSize(data, 0);
        CustomAllocator customAllocator = allocator = this.customAllocatorMap != null ? this.getCustomAllocator(obj.getClass()) : null;
        if (newObject || (pos = this.getPos(oid)) == 0L) {
            pos = allocator != null ? allocator.allocate(newSize) : this.allocate(newSize, 0);
            this.setPos(oid, pos | 2L);
        } else {
            int offs = (int)pos & 0xFFF;
            if ((offs & 5) != 0) {
                throw new StorageError(16);
            }
            Page pg = this.pool.getPage(pos - (long)offs);
            int size = ObjectHeader.getSize(pg.data, offs & 0xFFFFFFF8);
            this.pool.unfix(pg);
            if ((pos & 2L) == 0L) {
                if (allocator != null) {
                    allocator.free(pos & 0xFFFFFFFFFFFFFFF8L, size);
                    pos = allocator.allocate(newSize);
                } else {
                    this.cloneBitmap(pos & 0xFFFFFFFFFFFFFFF8L, size);
                    pos = this.allocate(newSize, 0);
                }
                this.setPos(oid, pos | 2L);
            } else {
                pos &= 0xFFFFFFFFFFFFFFF8L;
                if (newSize != size) {
                    if (allocator != null) {
                        long newPos = allocator.reallocate(pos, size, newSize);
                        if (newPos != pos) {
                            pos = newPos;
                            this.setPos(oid, pos | 2L);
                        } else if (newSize < size) {
                            ObjectHeader.setSize(data, 0, size);
                        }
                    } else if ((newSize + 32 - 1 & 0xFFFFFFE0) > (size + 32 - 1 & 0xFFFFFFE0)) {
                        long newPos = this.allocate(newSize, 0);
                        this.cloneBitmap(pos, size);
                        this.free(pos, size);
                        pos = newPos;
                        this.setPos(oid, pos | 2L);
                    } else if (newSize < size) {
                        ObjectHeader.setSize(data, 0, size);
                    }
                }
            }
        }
        this.modified = true;
        this.pool.put(pos, data, newSize);
    }

    @Override
    public synchronized void loadObject(IPersistent obj) {
        if (obj.isRaw()) {
            this.loadStub(obj.getOid(), obj, obj.getClass());
        }
    }

    final synchronized IPersistent lookupObject(int oid, Class cls) {
        IPersistent obj = this.objectCache.get(oid);
        if (obj == null || obj.isRaw()) {
            obj = this.loadStub(oid, obj, cls);
        }
        return obj;
    }

    protected int swizzle(IPersistent obj, boolean finalized) {
        int oid = 0;
        if (obj != null) {
            if (!obj.isPersistent()) {
                this.storeObject0(obj, finalized);
            }
            oid = obj.getOid();
        }
        return oid;
    }

    final ClassDescriptor findClassDescriptor(int oid) {
        return (ClassDescriptor)this.lookupObject(oid, ClassDescriptor.class);
    }

    protected IPersistent unswizzle(int oid, Class cls, boolean recursiveLoading) {
        ClassDescriptor desc;
        if (oid == 0) {
            return null;
        }
        if (recursiveLoading) {
            return this.lookupObject(oid, cls);
        }
        IPersistent stub = this.objectCache.get(oid);
        if (stub != null) {
            return stub;
        }
        if (cls == Persistent.class || (desc = this.findClassDescriptor(cls)) == null || desc.hasSubclasses) {
            long pos = this.getPos(oid);
            int offs = (int)pos & 0xFFF;
            if ((offs & 5) != 0) {
                throw new StorageError(16);
            }
            Page pg = this.pool.getPage(pos - (long)offs);
            int typeOid = ObjectHeader.getType(pg.data, offs & 0xFFFFFFF8);
            this.pool.unfix(pg);
            desc = this.findClassDescriptor(typeOid);
        }
        stub = (IPersistent)desc.newInstance();
        stub.assignOid(this, oid, true);
        this.objectCache.put(oid, stub);
        return stub;
    }

    final IPersistent loadStub(int oid, IPersistent obj, Class cls) {
        long pos = this.getPos(oid);
        if ((pos & 5L) != 0L) {
            throw new StorageError(16);
        }
        byte[] body = this.pool.get(pos & 0xFFFFFFFFFFFFFFF8L);
        int typeOid = ObjectHeader.getType(body, 0);
        ClassDescriptor desc = typeOid == 0 ? this.findClassDescriptor(cls) : this.findClassDescriptor(typeOid);
        if (obj == null) {
            obj = (IPersistent)desc.newInstance();
            this.objectCache.put(oid, obj);
        }
        obj.assignOid(this, oid, false);
        if (obj instanceof FastSerializable) {
            ((FastSerializable)((Object)obj)).unpack(body, 8, this.encoding);
        } else {
            try {
                this.unpackObject(obj, desc, obj.recursiveLoading(), body, 8, obj);
            }
            catch (Exception x) {
                throw new StorageError(17, x);
            }
        }
        obj.onLoad();
        return obj;
    }

    final int unpackObject(Object obj, ClassDescriptor desc, boolean recursiveLoading, byte[] body, int offs, IPersistent po) throws Exception {
        ClassDescriptor.FieldDescriptor[] all = desc.allFields;
        ReflectionProvider provider = ClassDescriptor.getReflectionProvider();
        block72: for (ClassDescriptor.FieldDescriptor fd : all) {
            int len;
            Field f = fd.field;
            if (f == null || obj == null) {
                switch (fd.type) {
                    case 0: 
                    case 1: {
                        ++offs;
                        break;
                    }
                    case 2: 
                    case 3: {
                        offs += 2;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 10: 
                    case 14: {
                        offs += 4;
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 9: {
                        offs += 8;
                        break;
                    }
                    case 8: {
                        len = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (len > 0) {
                            offs += len * 2;
                            break;
                        }
                        if (len >= -1) continue block72;
                        offs -= len + 2;
                        break;
                    }
                    case 11: {
                        offs = this.unpackObject(null, fd.valueDesc, recursiveLoading, body, offs, po);
                        break;
                    }
                    case 12: 
                    case 20: 
                    case 21: {
                        len = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (len > 0) {
                            offs += len;
                            break;
                        }
                        if (len >= -1) continue block72;
                        offs += ClassDescriptor.sizeof[-2 - len];
                        break;
                    }
                    case 15: {
                        ByteArrayInputStream in = new ByteArrayInputStream(body, offs, body.length - offs);
                        this.serializer.unpack(in);
                        offs = body.length - in.available();
                        break;
                    }
                    case 22: 
                    case 23: {
                        len = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (len <= 0) continue block72;
                        offs += len * 2;
                        break;
                    }
                    case 13: 
                    case 24: 
                    case 26: 
                    case 30: 
                    case 34: {
                        len = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (len <= 0) continue block72;
                        offs += len * 4;
                        break;
                    }
                    case 25: 
                    case 27: 
                    case 29: {
                        len = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (len <= 0) continue block72;
                        offs += len * 8;
                        break;
                    }
                    case 28: {
                        len = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (len <= 0) continue block72;
                        for (int j = 0; j < len; ++j) {
                            int strlen = Bytes.unpack4(body, offs);
                            offs += 4;
                            if (strlen > 0) {
                                offs += strlen * 2;
                                continue;
                            }
                            if (strlen >= -1) continue;
                            offs -= strlen + 2;
                        }
                        continue block72;
                    }
                    case 31: {
                        len = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (len <= 0) continue block72;
                        ClassDescriptor valueDesc = fd.valueDesc;
                        for (int j = 0; j < len; ++j) {
                            offs = this.unpackObject(null, valueDesc, recursiveLoading, body, offs, po);
                        }
                        continue block72;
                    }
                    case 32: {
                        len = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (len <= 0) continue block72;
                        for (int j = 0; j < len; ++j) {
                            int rawlen = Bytes.unpack4(body, offs);
                            offs += 4;
                            if (rawlen > 0) {
                                offs += rawlen;
                                continue;
                            }
                            if (rawlen >= -1) continue;
                            offs += ClassDescriptor.sizeof[-2 - rawlen];
                        }
                        continue block72;
                    }
                }
                continue;
            }
            if (offs >= body.length) continue;
            switch (fd.type) {
                case 0: {
                    provider.setBoolean(f, obj, body[offs++] != 0);
                    continue block72;
                }
                case 1: {
                    provider.setByte(f, obj, body[offs++]);
                    continue block72;
                }
                case 2: {
                    provider.setChar(f, obj, (char)Bytes.unpack2(body, offs));
                    offs += 2;
                    continue block72;
                }
                case 3: {
                    provider.setShort(f, obj, Bytes.unpack2(body, offs));
                    offs += 2;
                    continue block72;
                }
                case 4: {
                    provider.setInt(f, obj, Bytes.unpack4(body, offs));
                    offs += 4;
                    continue block72;
                }
                case 5: {
                    provider.setLong(f, obj, Bytes.unpack8(body, offs));
                    offs += 8;
                    continue block72;
                }
                case 6: {
                    provider.setFloat(f, obj, Float.intBitsToFloat(Bytes.unpack4(body, offs)));
                    offs += 4;
                    continue block72;
                }
                case 7: {
                    provider.setDouble(f, obj, Double.longBitsToDouble(Bytes.unpack8(body, offs)));
                    offs += 8;
                    continue block72;
                }
                case 14: {
                    int index = Bytes.unpack4(body, offs);
                    if (index >= 0) {
                        provider.set(f, obj, fd.field.getType().getEnumConstants()[index]);
                    } else {
                        provider.set(f, obj, null);
                    }
                    offs += 4;
                    continue block72;
                }
                case 8: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    String str = null;
                    if (len >= 0) {
                        char[] chars = new char[len];
                        for (int j = 0; j < len; ++j) {
                            chars[j] = (char)Bytes.unpack2(body, offs);
                            offs += 2;
                        }
                        str = new String(chars);
                    } else if (len < -1) {
                        str = this.encoding != null ? new String(body, offs, -2 - len, this.encoding) : new String(body, offs, -2 - len);
                        offs -= 2 + len;
                    }
                    provider.set(f, obj, str);
                    continue block72;
                }
                case 9: {
                    long msec = Bytes.unpack8(body, offs);
                    offs += 8;
                    Date date = null;
                    if (msec >= 0L) {
                        date = new Date(msec);
                    }
                    provider.set(f, obj, date);
                    continue block72;
                }
                case 10: {
                    provider.set(f, obj, this.unswizzle(Bytes.unpack4(body, offs), f.getType(), recursiveLoading));
                    offs += 4;
                    continue block72;
                }
                case 11: {
                    Object value = fd.valueDesc.newInstance();
                    offs = this.unpackObject(value, fd.valueDesc, recursiveLoading, body, offs, po);
                    provider.set(f, obj, value);
                    continue block72;
                }
                case 12: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len >= 0) {
                        ByteArrayInputStream bin = new ByteArrayInputStream(body, offs, len);
                        PersistentObjectInputStream in = new PersistentObjectInputStream(bin);
                        provider.set(f, obj, in.readObject());
                        in.close();
                        offs += len;
                        continue block72;
                    }
                    if (len >= 0) continue block72;
                    Serializable val = null;
                    switch (-2 - len) {
                        case 0: {
                            val = Boolean.valueOf(body[offs++] != 0);
                            break;
                        }
                        case 1: {
                            val = new Byte(body[offs++]);
                            break;
                        }
                        case 2: {
                            val = new Character((char)Bytes.unpack2(body, offs));
                            offs += 2;
                            break;
                        }
                        case 3: {
                            val = new Short(Bytes.unpack2(body, offs));
                            offs += 2;
                            break;
                        }
                        case 4: {
                            val = new Integer(Bytes.unpack4(body, offs));
                            offs += 4;
                            break;
                        }
                        case 5: {
                            val = new Long(Bytes.unpack8(body, offs));
                            offs += 8;
                            break;
                        }
                        case 6: {
                            val = new Float(Float.intBitsToFloat(Bytes.unpack4(body, offs)));
                            offs += 4;
                            break;
                        }
                        case 7: {
                            val = new Double(Double.longBitsToDouble(Bytes.unpack8(body, offs)));
                            offs += 8;
                            break;
                        }
                        case 9: {
                            val = new Date(Bytes.unpack8(body, offs));
                            offs += 8;
                            break;
                        }
                        case 10: {
                            val = this.unswizzle(Bytes.unpack4(body, offs), Persistent.class, recursiveLoading);
                            offs += 4;
                        }
                    }
                    provider.set(f, obj, val);
                    continue block72;
                }
                case 15: {
                    ByteArrayInputStream in = new ByteArrayInputStream(body, offs, body.length - offs);
                    provider.set(f, obj, this.serializer.unpack(in));
                    offs = body.length - in.available();
                    continue block72;
                }
                case 21: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    byte[] arr = new byte[len];
                    System.arraycopy(body, offs, arr, 0, len);
                    offs += len;
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 20: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    boolean[] arr = new boolean[len];
                    for (int j = 0; j < len; ++j) {
                        arr[j] = body[offs++] != 0;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 23: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    short[] arr = new short[len];
                    for (int j = 0; j < len; ++j) {
                        arr[j] = Bytes.unpack2(body, offs);
                        offs += 2;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 22: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    char[] arr = new char[len];
                    for (int j = 0; j < len; ++j) {
                        arr[j] = (char)Bytes.unpack2(body, offs);
                        offs += 2;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 24: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    int[] arr = new int[len];
                    for (int j = 0; j < len; ++j) {
                        arr[j] = Bytes.unpack4(body, offs);
                        offs += 4;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 34: {
                    int j;
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        f.set(obj, null);
                        continue block72;
                    }
                    Class<?> elemType = f.getType().getComponentType();
                    Enum[] enumConstants = (Enum[])elemType.getEnumConstants();
                    Enum[] arr = (Enum[])Array.newInstance(elemType, len);
                    for (j = 0; j < len; ++j) {
                        int index = Bytes.unpack4(body, offs);
                        if (index >= 0) {
                            arr[j] = enumConstants[index];
                        }
                        offs += 4;
                    }
                    f.set(obj, arr);
                    continue block72;
                }
                case 25: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    long[] arr = new long[len];
                    for (int j = 0; j < len; ++j) {
                        arr[j] = Bytes.unpack8(body, offs);
                        offs += 8;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 26: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    float[] arr = new float[len];
                    for (int j = 0; j < len; ++j) {
                        arr[j] = Float.intBitsToFloat(Bytes.unpack4(body, offs));
                        offs += 4;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 27: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    double[] arr = new double[len];
                    for (int j = 0; j < len; ++j) {
                        arr[j] = Double.longBitsToDouble(Bytes.unpack8(body, offs));
                        offs += 8;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 29: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    Date[] arr = new Date[len];
                    for (int j = 0; j < len; ++j) {
                        long msec = Bytes.unpack8(body, offs);
                        offs += 8;
                        if (msec < 0L) continue;
                        arr[j] = new Date(msec);
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 28: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    String[] arr = new String[len];
                    for (int j = 0; j < len; ++j) {
                        int strlen = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (strlen >= 0) {
                            char[] chars = new char[strlen];
                            for (int k = 0; k < strlen; ++k) {
                                chars[k] = (char)Bytes.unpack2(body, offs);
                                offs += 2;
                            }
                            arr[j] = new String(chars);
                            continue;
                        }
                        if (strlen >= -1) continue;
                        arr[j] = this.encoding != null ? new String(body, offs, -2 - strlen, this.encoding) : new String(body, offs, -2 - strlen);
                        offs -= 2 + strlen;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 30: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    Class<?> elemType = f.getType().getComponentType();
                    IPersistent[] arr = (IPersistent[])Array.newInstance(elemType, len);
                    for (int j = 0; j < len; ++j) {
                        arr[j] = this.unswizzle(Bytes.unpack4(body, offs), elemType, recursiveLoading);
                        offs += 4;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 31: {
                    int j;
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    Class<?> elemType = f.getType().getComponentType();
                    Object[] arr = (Object[])Array.newInstance(elemType, len);
                    ClassDescriptor valueDesc = fd.valueDesc;
                    for (j = 0; j < len; ++j) {
                        Object value = valueDesc.newInstance();
                        offs = this.unpackObject(value, valueDesc, recursiveLoading, body, offs, po);
                        arr[j] = value;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 32: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    Class<?> elemType = f.getType().getComponentType();
                    Object[] arr = (Object[])Array.newInstance(elemType, len);
                    for (int j = 0; j < len; ++j) {
                        int rawlen = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (rawlen >= 0) {
                            ByteArrayInputStream bin = new ByteArrayInputStream(body, offs, rawlen);
                            PersistentObjectInputStream in = new PersistentObjectInputStream(bin);
                            arr[j] = in.readObject();
                            in.close();
                            offs += rawlen;
                            continue;
                        }
                        Serializable val = null;
                        switch (-2 - rawlen) {
                            case 0: {
                                val = Boolean.valueOf(body[offs++] != 0);
                                break;
                            }
                            case 1: {
                                val = new Byte(body[offs++]);
                                break;
                            }
                            case 2: {
                                val = new Character((char)Bytes.unpack2(body, offs));
                                offs += 2;
                                break;
                            }
                            case 3: {
                                val = new Short(Bytes.unpack2(body, offs));
                                offs += 2;
                                break;
                            }
                            case 4: {
                                val = new Integer(Bytes.unpack4(body, offs));
                                offs += 4;
                                break;
                            }
                            case 5: {
                                val = new Long(Bytes.unpack8(body, offs));
                                offs += 8;
                                break;
                            }
                            case 6: {
                                val = new Float(Float.intBitsToFloat(Bytes.unpack4(body, offs)));
                                offs += 4;
                                break;
                            }
                            case 7: {
                                val = new Double(Double.longBitsToDouble(Bytes.unpack8(body, offs)));
                                offs += 8;
                                break;
                            }
                            case 9: {
                                val = new Date(Bytes.unpack8(body, offs));
                                offs += 8;
                                break;
                            }
                            case 10: {
                                val = this.unswizzle(Bytes.unpack4(body, offs), Persistent.class, recursiveLoading);
                                offs += 4;
                            }
                        }
                        arr[j] = val;
                    }
                    provider.set(f, obj, arr);
                    continue block72;
                }
                case 13: {
                    len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        provider.set(f, obj, null);
                        continue block72;
                    }
                    IPersistent[] arr = new IPersistent[len];
                    for (int j = 0; j < len; ++j) {
                        int elemOid = Bytes.unpack4(body, offs);
                        offs += 4;
                        if (elemOid == 0) continue;
                        arr[j] = new PersistentStub(this, elemOid);
                    }
                    provider.set(f, obj, new LinkImpl(arr, po));
                }
            }
        }
        return offs;
    }

    final byte[] packObject(IPersistent obj, boolean finalized) {
        ByteBuffer buf = new ByteBuffer();
        int offs = 8;
        buf.extend(offs);
        ClassDescriptor desc = this.getClassDescriptor(obj.getClass());
        if (obj instanceof FastSerializable) {
            offs = ((FastSerializable)((Object)obj)).pack(buf, offs, this.encoding);
        } else {
            try {
                offs = this.packObject(obj, desc, offs, buf, obj, finalized);
            }
            catch (Exception x) {
                throw new StorageError(17, x);
            }
        }
        ObjectHeader.setSize(buf.arr, 0, offs);
        ObjectHeader.setType(buf.arr, 0, desc.getOid());
        return buf.arr;
    }

    final int packValue(Object value, int offs, ByteBuffer buf, boolean finalized) throws Exception {
        if (value == null) {
            buf.extend(offs + 4);
            Bytes.pack4(buf.arr, offs, -1);
            offs += 4;
        } else if (value instanceof IPersistent) {
            buf.extend(offs + 8);
            Bytes.pack4(buf.arr, offs, -12);
            Bytes.pack4(buf.arr, offs + 4, this.swizzle((IPersistent)value, finalized));
            offs += 8;
        } else {
            Class<?> c = value.getClass();
            if (c == Boolean.class) {
                buf.extend(offs + 5);
                Bytes.pack4(buf.arr, offs, -2);
                buf.arr[offs + 4] = (byte)((Boolean)value != false ? 1 : 0);
                offs += 5;
            } else if (c == Character.class) {
                buf.extend(offs + 6);
                Bytes.pack4(buf.arr, offs, -4);
                Bytes.pack2(buf.arr, offs + 4, (short)((Character)value).charValue());
                offs += 6;
            } else if (c == Byte.class) {
                buf.extend(offs + 5);
                Bytes.pack4(buf.arr, offs, -3);
                buf.arr[offs + 4] = (Byte)value;
                offs += 5;
            } else if (c == Short.class) {
                buf.extend(offs + 6);
                Bytes.pack4(buf.arr, offs, -5);
                Bytes.pack2(buf.arr, offs + 4, (Short)value);
                offs += 6;
            } else if (c == Integer.class) {
                buf.extend(offs + 8);
                Bytes.pack4(buf.arr, offs, -6);
                Bytes.pack4(buf.arr, offs + 4, (Integer)value);
                offs += 8;
            } else if (c == Long.class) {
                buf.extend(offs + 12);
                Bytes.pack4(buf.arr, offs, -7);
                Bytes.pack8(buf.arr, offs + 4, (Long)value);
                offs += 12;
            } else if (c == Float.class) {
                buf.extend(offs + 8);
                Bytes.pack4(buf.arr, offs, -8);
                Bytes.pack4(buf.arr, offs + 4, Float.floatToIntBits(((Float)value).floatValue()));
                offs += 8;
            } else if (c == Double.class) {
                buf.extend(offs + 12);
                Bytes.pack4(buf.arr, offs, -9);
                Bytes.pack8(buf.arr, offs + 4, Double.doubleToLongBits((Double)value));
                offs += 12;
            } else if (c == Date.class) {
                buf.extend(offs + 12);
                Bytes.pack4(buf.arr, offs, -11);
                Bytes.pack8(buf.arr, offs + 4, ((Date)value).getTime());
                offs += 12;
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream out = this.loaderMap != null ? new PersistentObjectOutputStream(bout) : new ObjectOutputStream(bout);
                out.writeObject(value);
                out.close();
                byte[] arr = bout.toByteArray();
                int len = arr.length;
                buf.extend(offs + 4 + len);
                Bytes.pack4(buf.arr, offs, len);
                System.arraycopy(arr, 0, buf.arr, offs += 4, len);
                offs += len;
            }
        }
        return offs;
    }

    final int packObject(Object obj, ClassDescriptor desc, int offs, ByteBuffer buf, IPersistent po, boolean finalized) throws Exception {
        block32: for (ClassDescriptor.FieldDescriptor fd : desc.allFields) {
            Field f = fd.field;
            switch (fd.type) {
                case 1: {
                    buf.extend(offs + 1);
                    buf.arr[offs++] = f.getByte(obj);
                    continue block32;
                }
                case 0: {
                    buf.extend(offs + 1);
                    buf.arr[offs++] = (byte)(f.getBoolean(obj) ? 1 : 0);
                    continue block32;
                }
                case 3: {
                    buf.extend(offs + 2);
                    Bytes.pack2(buf.arr, offs, f.getShort(obj));
                    offs += 2;
                    continue block32;
                }
                case 2: {
                    buf.extend(offs + 2);
                    Bytes.pack2(buf.arr, offs, (short)f.getChar(obj));
                    offs += 2;
                    continue block32;
                }
                case 4: {
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, f.getInt(obj));
                    offs += 4;
                    continue block32;
                }
                case 5: {
                    buf.extend(offs + 8);
                    Bytes.pack8(buf.arr, offs, f.getLong(obj));
                    offs += 8;
                    continue block32;
                }
                case 6: {
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, Float.floatToIntBits(f.getFloat(obj)));
                    offs += 4;
                    continue block32;
                }
                case 7: {
                    buf.extend(offs + 8);
                    Bytes.pack8(buf.arr, offs, Double.doubleToLongBits(f.getDouble(obj)));
                    offs += 8;
                    continue block32;
                }
                case 14: {
                    Enum e = (Enum)f.get(obj);
                    buf.extend(offs + 4);
                    if (e == null) {
                        Bytes.pack4(buf.arr, offs, -1);
                    } else {
                        Bytes.pack4(buf.arr, offs, e.ordinal());
                    }
                    offs += 4;
                    continue block32;
                }
                case 9: {
                    buf.extend(offs + 8);
                    Date d = (Date)f.get(obj);
                    long msec = d == null ? -1L : d.getTime();
                    Bytes.pack8(buf.arr, offs, msec);
                    offs += 8;
                    continue block32;
                }
                case 8: {
                    offs = buf.packString(offs, (String)f.get(obj), this.encoding);
                    continue block32;
                }
                case 10: {
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, this.swizzle((IPersistent)f.get(obj), finalized));
                    offs += 4;
                    continue block32;
                }
                case 11: {
                    Object value = f.get(obj);
                    if (value == null) {
                        throw new StorageError(19, fd.fieldName);
                    }
                    if (value instanceof IPersistent) {
                        throw new StorageError(24);
                    }
                    offs = this.packObject(value, fd.valueDesc, offs, buf, po, finalized);
                    continue block32;
                }
                case 12: {
                    offs = this.packValue(f.get(obj), offs, buf, finalized);
                    continue block32;
                }
                case 15: {
                    this.serializer.pack((CustomSerializable)f.get(obj), buf.getOutputStream());
                    offs = buf.size();
                    continue block32;
                }
                case 21: {
                    Object[] arr = (byte[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len);
                    Bytes.pack4(buf.arr, offs, len);
                    System.arraycopy(arr, 0, buf.arr, offs += 4, len);
                    offs += len;
                    continue block32;
                }
                case 20: {
                    Object[] arr = (boolean[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    int j = 0;
                    while (j < len) {
                        buf.arr[offs] = (byte)(arr[j] != 0 ? 1 : 0);
                        ++j;
                        ++offs;
                    }
                    continue block32;
                }
                case 23: {
                    Object[] arr = (short[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 2);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        Bytes.pack2(buf.arr, offs, arr[j]);
                        offs += 2;
                    }
                    continue block32;
                }
                case 22: {
                    Object[] arr = (char[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 2);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        Bytes.pack2(buf.arr, offs, arr[j]);
                        offs += 2;
                    }
                    continue block32;
                }
                case 24: {
                    Object[] arr = (int[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        Bytes.pack4(buf.arr, offs, arr[j]);
                        offs += 4;
                    }
                    continue block32;
                }
                case 34: {
                    Object[] arr = (Enum[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        if (arr[j] == null) {
                            Bytes.pack4(buf.arr, offs, -1);
                        } else {
                            Bytes.pack4(buf.arr, offs, arr[j].ordinal());
                        }
                        offs += 4;
                    }
                    continue block32;
                }
                case 25: {
                    Object[] arr = (long[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 8);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        Bytes.pack8(buf.arr, offs, arr[j]);
                        offs += 8;
                    }
                    continue block32;
                }
                case 26: {
                    Object[] arr = (float[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        Bytes.pack4(buf.arr, offs, Float.floatToIntBits(arr[j]));
                        offs += 4;
                    }
                    continue block32;
                }
                case 27: {
                    Object[] arr = (double[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 8);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        Bytes.pack8(buf.arr, offs, Double.doubleToLongBits(arr[j]));
                        offs += 8;
                    }
                    continue block32;
                }
                case 29: {
                    Object[] arr = (Date[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 8);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        byte d = arr[j];
                        long msec = d == null ? -1L : d.getTime();
                        Bytes.pack8(buf.arr, offs, msec);
                        offs += 8;
                    }
                    continue block32;
                }
                case 28: {
                    Object[] arr = (String[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        offs = buf.packString(offs, (String)arr[j], this.encoding);
                    }
                    continue block32;
                }
                case 30: {
                    Object[] arr = (IPersistent[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        Bytes.pack4(buf.arr, offs, this.swizzle((IPersistent)arr[j], finalized));
                        offs += 4;
                    }
                    continue block32;
                }
                case 31: {
                    Object[] arr = (Object[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    ClassDescriptor elemDesc = fd.valueDesc;
                    for (int j = 0; j < len; ++j) {
                        byte value = arr[j];
                        if (value == null) {
                            throw new StorageError(19, fd.fieldName);
                        }
                        offs = this.packObject(value, elemDesc, offs, buf, po, finalized);
                    }
                    continue block32;
                }
                case 32: {
                    Object[] arr = (Object[])f.get(obj);
                    if (arr == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    int len = arr.length;
                    buf.extend(offs + 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        offs = this.packValue(arr[j], offs, buf, finalized);
                    }
                    continue block32;
                }
                case 13: {
                    LinkImpl link = (LinkImpl)f.get(obj);
                    if (link == null) {
                        buf.extend(offs + 4);
                        Bytes.pack4(buf.arr, offs, -1);
                        offs += 4;
                        continue block32;
                    }
                    link.owner = po;
                    int len = link.size();
                    buf.extend(offs + 4 + len * 4);
                    Bytes.pack4(buf.arr, offs, len);
                    offs += 4;
                    for (int j = 0; j < len; ++j) {
                        Bytes.pack4(buf.arr, offs, this.swizzle(link.getRaw(j), finalized));
                        offs += 4;
                    }
                    if (finalized) continue block32;
                    link.unpin();
                    continue block32;
                }
            }
        }
        return offs;
    }

    @Override
    public ClassLoader setClassLoader(ClassLoader loader) {
        ClassLoader prev = loader;
        this.loader = loader;
        return prev;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public void registerClassLoader(INamedClassLoader loader) {
        if (this.loaderMap == null) {
            this.loaderMap = new HashMap();
        }
        this.loaderMap.put(loader.getName(), loader);
    }

    @Override
    public ClassLoader findClassLoader(String name) {
        if (this.loaderMap == null) {
            return null;
        }
        return (ClassLoader)this.loaderMap.get(name);
    }

    @Override
    public void setCustomSerializer(CustomSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public Iterator merge(Iterator[] selections) {
        HashSet<Object> result = null;
        for (int i = 0; i < selections.length; ++i) {
            Iterator iterator = selections[i];
            HashSet<Integer> newResult = new HashSet<Integer>();
            while (iterator.hasNext()) {
                Integer oid = new Integer(((PersistentIterator)((Object)iterator)).nextOid());
                if (result != null && !result.contains(oid)) continue;
                newResult.add(oid);
            }
            result = newResult;
            if (result.size() == 0) break;
        }
        if (result == null) {
            result = new HashSet();
        }
        return new HashIterator(result);
    }

    @Override
    public Iterator join(Iterator[] selections) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < selections.length; ++i) {
            Iterator iterator = selections[i];
            while (iterator.hasNext()) {
                result.add(new Integer(((PersistentIterator)((Object)iterator)).nextOid()));
            }
        }
        return new HashIterator(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerCustomAllocator(Class cls, CustomAllocator allocator) {
        OidHashTable oidHashTable = this.objectCache;
        synchronized (oidHashTable) {
            ClassDescriptor desc = this.getClassDescriptor(cls);
            desc.allocator = allocator;
            this.storeObject0(desc, false);
            if (this.customAllocatorMap == null) {
                this.customAllocatorMap = new HashMap();
                this.customAllocatorList = new ArrayList();
            }
            this.customAllocatorMap.put(cls, desc.allocator);
            this.customAllocatorList.add(desc.allocator);
        }
    }

    @Override
    public CustomAllocator createBitmapAllocator(int quantum, long base, long extension, long limit) {
        return new BitmapCustomAllocator(this, quantum, base, extension, limit);
    }

    @Override
    public int getDatabaseFormatVersion() {
        return this.header.databaseFormatVersion;
    }

    class HashIterator
    implements PersistentIterator,
    Iterator {
        Iterator oids;

        HashIterator(HashSet result) {
            this.oids = result.iterator();
        }

        public Object next() {
            return StorageImpl.this.lookupObject(this.nextOid(), null);
        }

        public int nextOid() {
            return (Integer)this.oids.next();
        }

        public boolean hasNext() {
            return this.oids.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class PersistentObjectOutputStream
    extends ObjectOutputStream {
        PersistentObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        protected void annotateClass(Class cls) throws IOException {
            ClassLoader loader = cls.getClassLoader();
            this.writeObject(loader instanceof INamedClassLoader ? ((INamedClassLoader)((Object)loader)).getName() : null);
        }
    }

    class PersistentObjectInputStream
    extends ObjectInputStream {
        PersistentObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object obj) throws IOException {
            int oid;
            if (obj instanceof IPersistent && (oid = ((IPersistent)obj).getOid()) != 0) {
                return StorageImpl.this.lookupObject(oid, obj.getClass());
            }
            return obj;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            ClassLoader cl;
            String classLoaderName = null;
            if (StorageImpl.this.loaderMap != null) {
                classLoaderName = (String)this.readObject();
            }
            ClassLoader classLoader = cl = classLoaderName != null ? StorageImpl.this.findClassLoader(classLoaderName) : StorageImpl.this.loader;
            if (cl != null) {
                try {
                    return Class.forName(desc.getName(), false, cl);
                }
                catch (ClassNotFoundException x) {
                    // empty catch block
                }
            }
            return super.resolveClass(desc);
        }
    }

    class GcThread
    extends Thread {
        private boolean go;

        GcThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activate() {
            Object object = StorageImpl.this.backgroundGcStartMonitor;
            synchronized (object) {
                this.go = true;
                StorageImpl.this.backgroundGcStartMonitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Object object = StorageImpl.this.backgroundGcStartMonitor;
                    synchronized (object) {
                        while (!this.go && StorageImpl.this.opened) {
                            StorageImpl.this.backgroundGcStartMonitor.wait();
                        }
                        if (!StorageImpl.this.opened) {
                            return;
                        }
                        this.go = false;
                    }
                    object = StorageImpl.this.backgroundGcMonitor;
                    synchronized (object) {
                        if (!StorageImpl.this.opened) {
                            return;
                        }
                        StorageImpl.this.mark();
                        StorageImpl storageImpl = StorageImpl.this;
                        synchronized (storageImpl) {
                            OidHashTable oidHashTable = StorageImpl.this.objectCache;
                            synchronized (oidHashTable) {
                                StorageImpl.this.sweep();
                            }
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    static class CloneNode {
        long pos;
        CloneNode next;

        CloneNode(long pos, CloneNode list) {
            this.pos = pos;
            this.next = list;
        }
    }

    static class Location {
        long pos;
        long size;
        Location next;

        Location() {
        }
    }
}

