/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.Link;
import org.garret.perst.PersistentCollection;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScalableSet<T extends IPersistent>
extends PersistentCollection<T>
implements IPersistentSet<T> {
    Link<T> link;
    IPersistentSet<T> set;
    static final int BTREE_THRESHOLD = 128;

    ScalableSet(StorageImpl storage, int initialSize) {
        super(storage);
        if (initialSize <= 128) {
            this.link = storage.createLink(initialSize);
        } else {
            this.set = storage.createSet();
        }
    }

    ScalableSet() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() != 0;
    }

    @Override
    public int size() {
        return this.link != null ? this.link.size() : this.set.size();
    }

    @Override
    public void clear() {
        if (this.link != null) {
            this.link.clear();
            this.modify();
        } else {
            this.set.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IPersistent) {
            IPersistent p = (IPersistent)o;
            return this.link != null ? this.link.contains(p) : this.set.contains(p);
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return this.link != null ? this.link.toArray() : this.set.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.link != null ? this.link.toArray(a) : this.set.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.link != null ? this.link.iterator() : this.set.iterator();
    }

    @Override
    public boolean add(T obj) {
        if (this.link != null) {
            if (this.link.indexOf(obj) >= 0) {
                return false;
            }
            if (this.link.size() == 128) {
                this.set = this.getStorage().createSet();
                int n = this.link.size();
                for (int i = 0; i < n; ++i) {
                    this.set.add(this.link.get(i));
                }
                this.link = null;
                this.modify();
                this.set.add(obj);
            } else {
                this.modify();
                this.link.add(obj);
            }
            return true;
        }
        return this.set.add(obj);
    }

    @Override
    public boolean remove(T o) {
        if (this.link != null) {
            if (this.link.remove(o)) {
                this.modify();
                return true;
            }
            return false;
        }
        return this.set.remove(o);
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<T> i = this.iterator();
        while (i.hasNext()) {
            h += ((IPersistent)i.next()).getOid();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        return this.containsAll(c);
    }

    @Override
    public void deallocate() {
        if (this.set != null) {
            this.set.deallocate();
        }
        super.deallocate();
    }
}

