/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.garret.perst.IPersistent;
import org.garret.perst.IterableIterator;
import org.garret.perst.PersistentCollection;
import org.garret.perst.PersistentIterator;
import org.garret.perst.RectangleR2;
import org.garret.perst.SpatialIndexR2;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.RtreeR2Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtreeR2<T extends IPersistent>
extends PersistentCollection<T>
implements SpatialIndexR2<T> {
    private int height;
    private int n;
    private RtreeR2Page root;
    private transient int updateCounter;

    RtreeR2() {
    }

    RtreeR2(Storage storage) {
        super(storage);
    }

    @Override
    public void put(RectangleR2 r, T obj) {
        if (this.root == null) {
            this.root = new RtreeR2Page(this.getStorage(), (IPersistent)obj, r);
            this.height = 1;
        } else {
            RtreeR2Page p = this.root.insert(this.getStorage(), r, (IPersistent)obj, this.height);
            if (p != null) {
                this.root = new RtreeR2Page(this.getStorage(), this.root, p);
                ++this.height;
            }
        }
        ++this.n;
        ++this.updateCounter;
        this.modify();
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public void remove(RectangleR2 r, T obj) {
        if (this.root == null) {
            throw new StorageError(5);
        }
        ArrayList reinsertList = new ArrayList();
        int reinsertLevel = this.root.remove(r, (IPersistent)obj, this.height, reinsertList);
        if (reinsertLevel < 0) {
            throw new StorageError(5);
        }
        int i = reinsertList.size();
        while (--i >= 0) {
            RtreeR2Page p = (RtreeR2Page)reinsertList.get(i);
            int n = p.n;
            for (int j = 0; j < n; ++j) {
                RtreeR2Page q = this.root.insert(this.getStorage(), p.b[j], (IPersistent)p.branch.get(j), this.height - reinsertLevel);
                if (q == null) continue;
                this.root = new RtreeR2Page(this.getStorage(), this.root, q);
                ++this.height;
            }
            --reinsertLevel;
            p.deallocate();
        }
        if (this.root.n == 1 && this.height > 1) {
            RtreeR2Page newRoot = (RtreeR2Page)this.root.branch.get(0);
            this.root.deallocate();
            this.root = newRoot;
            --this.height;
        }
        --this.n;
        ++this.updateCounter;
        this.modify();
    }

    @Override
    public IPersistent[] get(RectangleR2 r) {
        ArrayList result = new ArrayList();
        if (this.root != null) {
            this.root.find(r, result, this.height);
        }
        return result.toArray(new IPersistent[result.size()]);
    }

    @Override
    public ArrayList<T> getList(RectangleR2 r) {
        ArrayList result = new ArrayList();
        if (this.root != null) {
            this.root.find(r, result, this.height);
        }
        return result;
    }

    @Override
    public RectangleR2 getWrappingRectangle() {
        if (this.root != null) {
            return this.root.cover();
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.root != null) {
            this.root.purge(this.height);
            this.root = null;
        }
        this.height = 0;
        this.n = 0;
        ++this.updateCounter;
        this.modify();
    }

    @Override
    public void deallocate() {
        this.clear();
        super.deallocate();
    }

    @Override
    public Object[] toArray() {
        return this.get(this.getWrappingRectangle());
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        return this.getList(this.getWrappingRectangle()).toArray(arr);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.getWrappingRectangle());
    }

    @Override
    public IterableIterator<Map.Entry<RectangleR2, T>> entryIterator() {
        return this.entryIterator(this.getWrappingRectangle());
    }

    @Override
    public IterableIterator<T> iterator(RectangleR2 r) {
        return new RtreeIterator(r);
    }

    @Override
    public IterableIterator<Map.Entry<RectangleR2, T>> entryIterator(RectangleR2 r) {
        return new RtreeEntryIterator(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RtreeEntryIterator
    extends RtreeIterator<Map.Entry<RectangleR2, T>> {
        RtreeEntryIterator(RectangleR2 r) {
            super(r);
        }

        @Override
        protected Object current(int sp) {
            return new RtreeEntry(this.pageStack[sp], this.posStack[sp]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RtreeEntry<T>
    implements Map.Entry<RectangleR2, T> {
        RtreeR2Page pg;
        int pos;

        @Override
        public RectangleR2 getKey() {
            return this.pg.b[this.pos];
        }

        @Override
        public T getValue() {
            return this.pg.branch.get(this.pos);
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException();
        }

        RtreeEntry(RtreeR2Page pg, int pos) {
            this.pg = pg;
            this.pos = pos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RtreeIterator<E>
    extends IterableIterator<E>
    implements PersistentIterator {
        RtreeR2Page[] pageStack;
        int[] posStack;
        int counter;
        RectangleR2 r;

        RtreeIterator(RectangleR2 r) {
            this.counter = RtreeR2.this.updateCounter;
            if (RtreeR2.this.height == 0) {
                return;
            }
            this.r = r;
            this.pageStack = new RtreeR2Page[RtreeR2.this.height];
            this.posStack = new int[RtreeR2.this.height];
            if (!this.gotoFirstItem(0, RtreeR2.this.root)) {
                this.pageStack = null;
                this.posStack = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.counter != RtreeR2.this.updateCounter) {
                throw new ConcurrentModificationException();
            }
            return this.pageStack != null;
        }

        protected Object current(int sp) {
            return this.pageStack[sp].branch.get(this.posStack[sp]);
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object curr = this.current(RtreeR2.this.height - 1);
            if (!this.gotoNextItem(RtreeR2.this.height - 1)) {
                this.pageStack = null;
                this.posStack = null;
            }
            return (E)curr;
        }

        @Override
        public int nextOid() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int oid = this.pageStack[((RtreeR2)RtreeR2.this).height - 1].branch.getRaw(this.posStack[RtreeR2.this.height - 1]).getOid();
            if (!this.gotoNextItem(RtreeR2.this.height - 1)) {
                this.pageStack = null;
                this.posStack = null;
            }
            return oid;
        }

        private boolean gotoFirstItem(int sp, RtreeR2Page pg) {
            int n = pg.n;
            for (int i = 0; i < n; ++i) {
                if (!this.r.intersects(pg.b[i]) || sp + 1 != RtreeR2.this.height && !this.gotoFirstItem(sp + 1, (RtreeR2Page)pg.branch.get(i))) continue;
                this.pageStack[sp] = pg;
                this.posStack[sp] = i;
                return true;
            }
            return false;
        }

        private boolean gotoNextItem(int sp) {
            RtreeR2Page pg = this.pageStack[sp];
            int i = this.posStack[sp];
            int n = pg.n;
            while (++i < n) {
                if (!this.r.intersects(pg.b[i]) || sp + 1 != RtreeR2.this.height && !this.gotoFirstItem(sp + 1, (RtreeR2Page)pg.branch.get(i))) continue;
                this.pageStack[sp] = pg;
                this.posStack[sp] = i;
                return true;
            }
            this.pageStack[sp] = null;
            return sp > 0 ? this.gotoNextItem(sp - 1) : false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

