/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.ReplicationMasterStorageImpl;

public class ReplicationMasterFile
implements IFile,
Runnable {
    public static int LINGER_TIME = 10;
    public static int MAX_CONNECT_ATTEMPTS = 10;
    public static int CONNECTION_TIMEOUT = 1000;
    Object mutex;
    OutputStream[] out;
    InputStream[] in;
    Socket[] sockets;
    byte[] txBuf;
    byte[] rcBuf;
    IFile file;
    String[] hosts;
    int nHosts;
    int port;
    boolean ack;
    boolean listening;
    Thread listenThread;
    ServerSocket listenSocket;
    ReplicationMasterStorageImpl storage;

    public ReplicationMasterFile(ReplicationMasterStorageImpl storage, IFile file) {
        this(storage, file, storage.port, storage.hosts, storage.replicationAck);
    }

    public ReplicationMasterFile(IFile file, String[] hosts, boolean ack) {
        this(null, file, -1, hosts, ack);
    }

    private ReplicationMasterFile(ReplicationMasterStorageImpl storage, IFile file, int port, String[] hosts, boolean ack) {
        this.storage = storage;
        this.file = file;
        this.hosts = hosts;
        this.ack = ack;
        this.port = port;
        this.mutex = new Object();
        this.sockets = new Socket[hosts.length];
        this.out = new OutputStream[hosts.length];
        if (ack) {
            this.in = new InputStream[hosts.length];
            this.rcBuf = new byte[1];
        }
        this.txBuf = new byte[4104];
        this.nHosts = 0;
        for (int i = 0; i < hosts.length; ++i) {
            this.connect(i);
        }
        if (port >= 0) {
            try {
                this.listenSocket = new ServerSocket(port);
            }
            catch (IOException x) {
                throw new StorageError(28);
            }
            this.listening = true;
            this.listenThread = new Thread(this);
            this.listenThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Socket s = null;
            try {
                s = this.listenSocket.accept();
            }
            catch (IOException x) {
                x.printStackTrace();
            }
            Object x = this.mutex;
            synchronized (x) {
                if (!this.listening) {
                    return;
                }
            }
            if (s == null) continue;
            try {
                s.setSoLinger(true, LINGER_TIME);
            }
            catch (Exception x2) {
                // empty catch block
            }
            try {
                s.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addConnection(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(Socket s) {
        OutputStream os = null;
        InputStream is = null;
        try {
            os = s.getOutputStream();
            if (this.ack) {
                is = s.getInputStream();
            }
        }
        catch (IOException x) {
            x.printStackTrace();
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            int n = this.hosts.length;
            String[] newHosts = new String[n + 1];
            System.arraycopy(this.hosts, 0, newHosts, 0, n);
            newHosts[n] = s.getRemoteSocketAddress().toString();
            this.hosts = newHosts;
            OutputStream[] newOut = new OutputStream[n + 1];
            System.arraycopy(this.out, 0, newOut, 0, n);
            newOut[n] = os;
            this.out = newOut;
            if (this.ack) {
                InputStream[] newIn = new InputStream[n + 1];
                System.arraycopy(this.in, 0, newIn, 0, n);
                newIn[n] = is;
                this.in = newIn;
            }
            Socket[] newSockets = new Socket[n + 1];
            System.arraycopy(this.sockets, 0, newSockets, 0, n);
            newSockets[n] = s;
            this.sockets = newSockets;
            ++this.nHosts;
            SynchronizeThread syncThread = new SynchronizeThread(n);
            syncThread.start();
        }
    }

    public int getNumberOfAvailableHosts() {
        return this.nHosts;
    }

    protected void connect(int i) {
        String host = this.hosts[i];
        int colon = host.indexOf(58);
        int port = Integer.parseInt(host.substring(colon + 1));
        host = host.substring(0, colon);
        Socket socket = null;
        try {
            int maxAttempts = this.storage != null ? this.storage.slaveConnectionTimeout : MAX_CONNECT_ATTEMPTS;
            for (int j = 0; j < maxAttempts; ++j) {
                try {
                    socket = new Socket(InetAddress.getByName(host), port);
                    if (socket == null) {
                        Thread.sleep(CONNECTION_TIMEOUT);
                        continue;
                    }
                    break;
                }
                catch (IOException x) {
                    // empty catch block
                }
            }
        }
        catch (InterruptedException x) {
            // empty catch block
        }
        if (socket != null) {
            try {
                try {
                    socket.setSoLinger(true, LINGER_TIME);
                }
                catch (NoSuchMethodError er) {
                    // empty catch block
                }
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (Exception x) {
                    // empty catch block
                }
                this.sockets[i] = socket;
                this.out[i] = socket.getOutputStream();
                if (this.ack) {
                    this.in[i] = socket.getInputStream();
                }
                ++this.nHosts;
            }
            catch (IOException x) {
                this.handleError(this.hosts[i]);
                this.sockets[i] = null;
                this.out[i] = null;
            }
        }
    }

    public boolean handleError(String host) {
        System.err.println("Failed to establish connection with host " + host);
        return this.storage != null && this.storage.listener != null ? this.storage.listener.replicationError(host) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long pos, byte[] buf) {
        Object object = this.mutex;
        synchronized (object) {
            block8: for (int i = 0; i < this.out.length; ++i) {
                while (this.out[i] != null) {
                    try {
                        Socket socket = this.sockets[i];
                        synchronized (socket) {
                            Bytes.pack8(this.txBuf, 0, pos);
                            System.arraycopy(buf, 0, this.txBuf, 8, buf.length);
                            this.out[i].write(this.txBuf);
                            if (!this.ack || pos != 0L || this.in[i].read(this.rcBuf) == 1) {
                                continue block8;
                            }
                        }
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                    this.out[i] = null;
                    this.sockets[i] = null;
                    --this.nHosts;
                    if (!this.handleError(this.hosts[i])) continue block8;
                    this.connect(i);
                }
            }
        }
        this.file.write(pos, buf);
    }

    public int read(long pos, byte[] buf) {
        return this.file.read(pos, buf);
    }

    public void sync() {
        this.file.sync();
    }

    public boolean tryLock(boolean shared) {
        return this.file.tryLock(shared);
    }

    public void lock(boolean shared) {
        this.file.lock(shared);
    }

    public void unlock() {
        this.file.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.listenThread != null) {
            Object object = this.mutex;
            synchronized (object) {
                this.listening = false;
            }
            try {
                Socket s = new Socket("localhost", this.port);
                s.close();
            }
            catch (IOException x) {
                // empty catch block
            }
            try {
                this.listenThread.join();
            }
            catch (InterruptedException x) {
                // empty catch block
            }
            try {
                this.listenSocket.close();
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        this.file.close();
        Bytes.pack8(this.txBuf, 0, -1L);
        for (int i = 0; i < this.out.length; ++i) {
            if (this.sockets[i] == null) continue;
            try {
                this.out[i].write(this.txBuf);
                this.out[i].close();
                if (this.in != null) {
                    this.in[i].close();
                }
                this.sockets[i].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long length() {
        return this.file.length();
    }

    class SynchronizeThread
    extends Thread {
        int i;

        SynchronizeThread(int i) {
            this.i = i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket s;
            long size = ReplicationMasterFile.this.storage.getDatabaseSize();
            OutputStream os = null;
            InputStream is = null;
            Object object = ReplicationMasterFile.this.mutex;
            synchronized (object) {
                s = ReplicationMasterFile.this.sockets[this.i];
                if (s == null) {
                    return;
                }
                os = ReplicationMasterFile.this.out[this.i];
                if (ReplicationMasterFile.this.ack) {
                    is = ReplicationMasterFile.this.in[this.i];
                }
            }
            for (long pos = 0L; pos < size; pos += 4096L) {
                Object object2;
                Page pg = ReplicationMasterFile.this.storage.pool.getPage(pos);
                try {
                    object2 = s;
                    synchronized (object2) {
                        Bytes.pack8(ReplicationMasterFile.this.txBuf, 0, pos);
                        System.arraycopy(pg.data, 0, ReplicationMasterFile.this.txBuf, 8, 4096);
                        ReplicationMasterFile.this.storage.pool.unfix(pg);
                        os.write(ReplicationMasterFile.this.txBuf);
                        if (!ReplicationMasterFile.this.ack || pos != 0L || is.read(ReplicationMasterFile.this.rcBuf) == 1) {
                            continue;
                        }
                    }
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
                object2 = ReplicationMasterFile.this.mutex;
                synchronized (object2) {
                    if (ReplicationMasterFile.this.sockets[this.i] != null) {
                        ReplicationMasterFile.this.handleError(ReplicationMasterFile.this.hosts[this.i]);
                        ReplicationMasterFile.this.sockets[this.i] = null;
                        ReplicationMasterFile.this.out[this.i] = null;
                        --ReplicationMasterFile.this.nHosts;
                    }
                    return;
                }
            }
            Socket socket = s;
            synchronized (socket) {
                Bytes.pack8(ReplicationMasterFile.this.txBuf, 0, -2L);
                try {
                    os.write(ReplicationMasterFile.this.txBuf);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

