/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.garret.perst.CompileError;
import org.garret.perst.GenericIndex;
import org.garret.perst.IterableIterator;
import org.garret.perst.IteratorWrapper;
import org.garret.perst.JSQLRuntimeException;
import org.garret.perst.Key;
import org.garret.perst.Query;
import org.garret.perst.Resolver;
import org.garret.perst.Storage;
import org.garret.perst.impl.AggregateFunctionNode;
import org.garret.perst.impl.BinOpNode;
import org.garret.perst.impl.Binding;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.CompareNode;
import org.garret.perst.impl.ConstantNode;
import org.garret.perst.impl.ContainsNode;
import org.garret.perst.impl.ConvertAnyNode;
import org.garret.perst.impl.CurrentNode;
import org.garret.perst.impl.DateLiteralNode;
import org.garret.perst.impl.ElementNode;
import org.garret.perst.impl.EmptyNode;
import org.garret.perst.impl.ExistsNode;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.GetAtNode;
import org.garret.perst.impl.IndexNode;
import org.garret.perst.impl.IntLiteralNode;
import org.garret.perst.impl.InvokeAnyNode;
import org.garret.perst.impl.InvokeElementNode;
import org.garret.perst.impl.InvokeNode;
import org.garret.perst.impl.LiteralNode;
import org.garret.perst.impl.LoadAnyNode;
import org.garret.perst.impl.LoadNode;
import org.garret.perst.impl.Node;
import org.garret.perst.impl.OrderNode;
import org.garret.perst.impl.ParameterNode;
import org.garret.perst.impl.RealLiteralNode;
import org.garret.perst.impl.ResolveNode;
import org.garret.perst.impl.StorageImpl;
import org.garret.perst.impl.StrLiteralNode;
import org.garret.perst.impl.Symbol;
import org.garret.perst.impl.UnaryOpNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl<T>
implements Query<T> {
    int pos;
    char[] buf;
    char[] str;
    String query;
    long ivalue;
    String svalue;
    double fvalue;
    Class cls;
    Node tree;
    String ident;
    int lex;
    int vars;
    Binding bindings;
    OrderNode order;
    ContainsNode contains;
    ArrayList parameters;
    boolean runtimeErrorsReporting;
    HashMap resolveMap;
    HashMap<String, GenericIndex<T>> indices;
    StorageImpl storage;
    static Hashtable symtab;
    static Class[] defaultProfile;
    static Node[] noArguments;
    static final Object dummyKeyValue;
    static final int tknIdent = 1;
    static final int tknLpar = 2;
    static final int tknRpar = 3;
    static final int tknLbr = 4;
    static final int tknRbr = 5;
    static final int tknDot = 6;
    static final int tknComma = 7;
    static final int tknPower = 8;
    static final int tknIconst = 9;
    static final int tknSconst = 10;
    static final int tknFconst = 11;
    static final int tknAdd = 12;
    static final int tknSub = 13;
    static final int tknMul = 14;
    static final int tknDiv = 15;
    static final int tknAnd = 16;
    static final int tknOr = 17;
    static final int tknNot = 18;
    static final int tknNull = 19;
    static final int tknNeg = 20;
    static final int tknEq = 21;
    static final int tknNe = 22;
    static final int tknGt = 23;
    static final int tknGe = 24;
    static final int tknLt = 25;
    static final int tknLe = 26;
    static final int tknBetween = 27;
    static final int tknEscape = 28;
    static final int tknExists = 29;
    static final int tknLike = 30;
    static final int tknIn = 31;
    static final int tknLength = 32;
    static final int tknLower = 33;
    static final int tknUpper = 34;
    static final int tknAbs = 35;
    static final int tknIs = 36;
    static final int tknInteger = 37;
    static final int tknReal = 38;
    static final int tknString = 39;
    static final int tknFirst = 40;
    static final int tknLast = 41;
    static final int tknCurrent = 42;
    static final int tknCol = 44;
    static final int tknTrue = 45;
    static final int tknFalse = 46;
    static final int tknWhere = 47;
    static final int tknOrder = 48;
    static final int tknAsc = 49;
    static final int tknDesc = 50;
    static final int tknEof = 51;
    static final int tknSin = 52;
    static final int tknCos = 53;
    static final int tknTan = 54;
    static final int tknAsin = 55;
    static final int tknAcos = 56;
    static final int tknAtan = 57;
    static final int tknSqrt = 58;
    static final int tknLog = 59;
    static final int tknExp = 60;
    static final int tknCeil = 61;
    static final int tknFloor = 62;
    static final int tknBy = 63;
    static final int tknHaving = 64;
    static final int tknGroup = 65;
    static final int tknAvg = 66;
    static final int tknCount = 67;
    static final int tknMax = 68;
    static final int tknMin = 69;
    static final int tknSum = 70;
    static final int tknWith = 71;
    static final int tknParam = 72;
    static final int tknContains = 73;

    @Override
    public IterableIterator<T> select(Class cls, Iterator<T> iterator, String query) throws CompileError {
        this.query = query;
        this.buf = query.toCharArray();
        this.str = new char[this.buf.length];
        this.cls = cls;
        this.compile();
        return this.execute(iterator);
    }

    @Override
    public IterableIterator<T> select(String className, Iterator<T> iterator, String query) throws CompileError {
        this.cls = ClassDescriptor.loadClass(this.storage, className);
        return this.select(this.cls, iterator, query);
    }

    @Override
    public void setParameter(int index, Object value) {
        this.parameters.set(index - 1, value);
    }

    @Override
    public void setIntParameter(int index, long value) {
        this.setParameter(index, new Long(value));
    }

    @Override
    public void setRealParameter(int index, double value) {
        this.setParameter(index, new Double(value));
    }

    @Override
    public void setBoolParameter(int index, boolean value) {
        this.setParameter(index, new Boolean(value));
    }

    @Override
    public void prepare(Class cls, String query) {
        this.query = query;
        this.buf = query.toCharArray();
        this.str = new char[this.buf.length];
        this.cls = cls;
        this.compile();
    }

    @Override
    public void prepare(String className, String query) {
        this.cls = ClassDescriptor.loadClass(this.storage, className);
        this.query = query;
        this.buf = query.toCharArray();
        this.str = new char[this.buf.length];
        this.compile();
    }

    @Override
    public IterableIterator<T> execute(Iterator<T> iterator) {
        FilterIterator<T> result = this.applyIndex(this.tree);
        if (result == null) {
            result = new FilterIterator<T>(this, iterator, this.tree);
        }
        if (this.order != null) {
            ArrayList list = new ArrayList();
            while (result.hasNext()) {
                list.add(result.next());
            }
            this.sort(list);
            return new IteratorWrapper(list.iterator());
        }
        return result;
    }

    private void sort(ArrayList<T> selection) {
        T top;
        int k;
        int i;
        OrderNode order = this.order;
        if (selection.size() == 0) {
            return;
        }
        OrderNode ord = order;
        while (ord != null) {
            if (ord.fieldName != null) {
                ord.resolveName(selection.get(0).getClass());
            }
            ord = ord.next;
        }
        int n = selection.size();
        int j = i = n / 2;
        while (i >= 1) {
            k = i;
            top = selection.get(k - 1);
            do {
                if (k * 2 == n || order.compare(selection.get(k * 2 - 1), selection.get(k * 2)) > 0) {
                    if (order.compare(top, selection.get(k * 2 - 1)) >= 0) break;
                    selection.set(k - 1, selection.get(k * 2 - 1));
                    k *= 2;
                    continue;
                }
                if (order.compare(top, selection.get(k * 2)) >= 0) break;
                selection.set(k - 1, selection.get(k * 2));
                k = k * 2 + 1;
            } while (k <= j);
            selection.set(k - 1, top);
            --i;
        }
        for (i = n; i >= 2; --i) {
            top = selection.get(i - 1);
            selection.set(i - 1, selection.get(0));
            selection.set(0, top);
            k = 1;
            j = (i - 1) / 2;
            while (k <= j) {
                if (k * 2 == i - 1 || order.compare(selection.get(k * 2 - 1), selection.get(k * 2)) > 0) {
                    if (order.compare(top, selection.get(k * 2 - 1)) >= 0) break;
                    selection.set(k - 1, selection.get(k * 2 - 1));
                    k *= 2;
                    continue;
                }
                if (order.compare(top, selection.get(k * 2)) >= 0) break;
                selection.set(k - 1, selection.get(k * 2));
                k = k * 2 + 1;
            }
            selection.set(k - 1, top);
        }
    }

    public void reportRuntimeError(JSQLRuntimeException x) {
        if (this.runtimeErrorsReporting) {
            String fieldName;
            StringBuffer buf = new StringBuffer();
            buf.append(x.getMessage());
            Class cls = x.getTarget();
            if (cls != null) {
                buf.append(cls.getName());
                buf.append('.');
            }
            if ((fieldName = x.getFieldName()) != null) {
                buf.append(fieldName);
            }
            System.err.println(buf);
        }
        if (this.storage != null && this.storage.listener != null) {
            this.storage.listener.JSQLRuntimeError(x);
        }
    }

    @Override
    public void enableRuntimeErrorReporting(boolean enabled) {
        this.runtimeErrorsReporting = enabled;
    }

    @Override
    public void setResolver(Class original, Class resolved, Resolver resolver) {
        if (this.resolveMap == null) {
            this.resolveMap = new HashMap();
        }
        this.resolveMap.put(original, new ResolveMapping(resolved, resolver));
    }

    @Override
    public void addIndex(String key, GenericIndex<T> index) {
        if (this.indices == null) {
            this.indices = new HashMap();
        }
        this.indices.put(key, index);
    }

    private final GenericIndex<T> getIndex(String key) {
        return this.indices != null ? this.indices.get(key) : null;
    }

    private static Key keyLiteral(Class type, Node node, boolean inclusive) {
        Object value = ((LiteralNode)node).getValue();
        if (type.equals(Long.TYPE)) {
            return new Key(((Number)value).longValue(), inclusive);
        }
        if (type.equals(Integer.TYPE)) {
            return new Key(((Number)value).intValue(), inclusive);
        }
        if (type.equals(Byte.TYPE)) {
            return new Key(((Number)value).byteValue(), inclusive);
        }
        if (type.equals(Short.TYPE)) {
            return new Key(((Number)value).shortValue(), inclusive);
        }
        if (type.equals(Character.TYPE)) {
            return new Key(value instanceof Number ? (char)((Number)value).intValue() : ((Character)value).charValue(), inclusive);
        }
        if (type.equals(Float.TYPE)) {
            return new Key(((Number)value).floatValue(), inclusive);
        }
        if (type.equals(Double.TYPE)) {
            return new Key(((Number)value).doubleValue(), inclusive);
        }
        if (type.equals(String.class)) {
            return new Key((String)value, inclusive);
        }
        if (type.equals(Date.class)) {
            return new Key((Date)value, inclusive);
        }
        return null;
    }

    public QueryImpl(Storage storage) {
        this.storage = (StorageImpl)storage;
        this.parameters = new ArrayList();
        this.runtimeErrorsReporting = true;
    }

    final int scan() {
        int p;
        int eol = this.buf.length;
        char ch = '\u0000';
        for (p = this.pos; p < eol && Character.isWhitespace(ch = this.buf[p]); ++p) {
        }
        if (p == eol) {
            return 51;
        }
        this.pos = ++p;
        switch (ch) {
            case '+': {
                return 12;
            }
            case '-': {
                return 13;
            }
            case '*': {
                return 14;
            }
            case '/': {
                return 15;
            }
            case '.': {
                return 6;
            }
            case ',': {
                return 7;
            }
            case '(': {
                return 2;
            }
            case ')': {
                return 3;
            }
            case '[': {
                return 4;
            }
            case ']': {
                return 5;
            }
            case ':': {
                return 44;
            }
            case '^': {
                return 8;
            }
            case '?': {
                return 72;
            }
            case '<': {
                if (p < eol) {
                    if (this.buf[p] == '=') {
                        ++this.pos;
                        return 26;
                    }
                    if (this.buf[p] == '>') {
                        ++this.pos;
                        return 22;
                    }
                }
                return 25;
            }
            case '>': {
                if (p < eol && this.buf[p] == '=') {
                    ++this.pos;
                    return 24;
                }
                return 23;
            }
            case '=': {
                return 21;
            }
            case '!': {
                if (p == eol || this.buf[p] != '=') {
                    throw new CompileError("Invalid token '!'", p - 1);
                }
                ++this.pos;
                return 22;
            }
            case '|': {
                if (p == eol || this.buf[p] != '|') {
                    throw new CompileError("Invalid token '!'", p - 1);
                }
                ++this.pos;
                return 12;
            }
            case '\'': {
                int i = 0;
                while (true) {
                    if (p == eol) {
                        throw new CompileError("Unexpected end of string constant", p);
                    }
                    if (this.buf[p] == '\'' && (++p == eol || this.buf[p] != '\'')) {
                        this.svalue = new String(this.str, 0, i);
                        this.pos = p;
                        return 10;
                    }
                    this.str[i++] = this.buf[p++];
                }
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int i = p - 1;
                while (p < eol && Character.isDigit(ch = this.buf[p])) {
                    ++p;
                }
                if (ch == '.' || ch == 'e' || ch == 'E') {
                    while (!(++p >= eol || !Character.isDigit(this.buf[p]) && this.buf[p] != 'e' && this.buf[p] != 'E' && this.buf[p] != '.' && (ch != 'e' && ch != 'E' || this.buf[p] != '-' && this.buf[p] != '+'))) {
                    }
                    this.pos = p;
                    try {
                        this.fvalue = Double.valueOf(this.query.substring(i, p));
                    }
                    catch (NumberFormatException x) {
                        throw new CompileError("Bad floating point constant", i);
                    }
                    return 11;
                }
                this.pos = p;
                try {
                    this.ivalue = Long.parseLong(this.query.substring(i, p), 10);
                }
                catch (NumberFormatException x) {
                    throw new CompileError("Bad floating point constant", i);
                }
                return 9;
            }
        }
        if (Character.isLetter(ch) || ch == '$' || ch == '_') {
            int i = p - 1;
            while (p < eol && (Character.isLetterOrDigit(ch = this.buf[p]) || ch == '$' || ch == '_')) {
                ++p;
            }
            this.pos = p;
            this.ident = this.query.substring(i, p);
            Symbol s = (Symbol)symtab.get(this.ident);
            return s == null ? 1 : s.tkn;
        }
        throw new CompileError("Invalid symbol: " + ch, p - 1);
    }

    final Node disjunction() {
        Node left = this.conjunction();
        if (this.lex == 17) {
            int p = this.pos;
            Node right = this.disjunction();
            if (left.type == 1 && right.type == 1) {
                left = new BinOpNode(1, 6, left, right);
            } else if (left.type == 0 && right.type == 0) {
                left = new BinOpNode(0, 95, left, right);
            } else if (left.type == 20 || right.type == 20) {
                left = new BinOpNode(20, 126, left, right);
            } else {
                throw new CompileError("Bad operands for OR operator", p);
            }
        }
        return left;
    }

    final Node conjunction() {
        Node left = this.comparison();
        if (this.lex == 16) {
            int p = this.pos;
            Node right = this.conjunction();
            if (left.type == 1 && right.type == 1) {
                left = new BinOpNode(1, 5, left, right);
            } else if (left.type == 0 && right.type == 0) {
                left = new BinOpNode(0, 94, left, right);
            } else if (left.type == 20 || right.type == 20) {
                left = new BinOpNode(20, 125, left, right);
            } else {
                throw new CompileError("Bad operands for AND operator", p);
            }
        }
        return left;
    }

    static final Node int2real(Node expr) {
        if (expr.tag == 68) {
            return new RealLiteralNode(((IntLiteralNode)expr).value);
        }
        return new UnaryOpNode(2, 45, expr);
    }

    static final Node str2date(Node expr) {
        if (expr.tag == 70) {
            return new DateLiteralNode(new Date(((StrLiteralNode)expr).value));
        }
        return new UnaryOpNode(7, 153, expr);
    }

    final int compare(Node expr, BinOpNode list) {
        int n = 1;
        if (list.left != null) {
            n = this.compare(expr, (BinOpNode)list.left);
        }
        Node elem = list.right;
        int cop = 0;
        if (elem.type == 19) {
            elem.type = expr.type;
        }
        if (expr.type == 1) {
            if (elem.type == 2) {
                expr = new UnaryOpNode(2, 45, expr);
                cop = 18;
            } else if (elem.type == 1) {
                cop = 11;
            }
        } else if (expr.type == 2) {
            if (elem.type == 2) {
                cop = 18;
            } else if (elem.type == 1) {
                cop = 18;
                elem = QueryImpl.int2real(elem);
            }
        } else if (expr.type == 7 && elem.type == 7) {
            cop = 145;
        } else if (expr.type == 6 && elem.type == 6) {
            cop = 25;
        } else if (expr.type == 5 && elem.type == 5) {
            cop = 36;
        } else if (expr.type == 0 && elem.type == 0) {
            cop = 34;
        } else if (expr.type == 20) {
            cop = 131;
        }
        if (cop == 0) {
            throw new CompileError("Expression " + n + " in right part of IN " + "operator has incompatible type", this.pos);
        }
        list.type = 0;
        if (list.left != null) {
            list.right = new BinOpNode(0, cop, expr, elem);
            list.tag = 95;
        } else {
            list.left = expr;
            list.right = elem;
            list.tag = cop;
        }
        return ++n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Node comparison() {
        boolean not;
        Node left;
        block102: {
            Node right;
            int rightPos;
            int cop;
            int leftPos;
            block100: {
                block101: {
                    leftPos = this.pos;
                    left = this.addition();
                    cop = this.lex;
                    if (cop != 21 && cop != 22 && cop != 23 && cop != 24 && cop != 26 && cop != 25 && cop != 27 && cop != 30 && cop != 18 && cop != 36) {
                        if (cop != 31) return left;
                    }
                    rightPos = this.pos;
                    not = false;
                    if (cop == 18) {
                        not = true;
                        cop = this.scan();
                        if (cop != 30 && cop != 27 && cop != 31) {
                            throw new CompileError("LIKE, BETWEEN or IN expected", rightPos);
                        }
                        rightPos = this.pos;
                    } else if (cop == 36) {
                        if (left.type < 5) {
                            throw new CompileError("IS [NOT] NULL predicate can be applied only to references,arrays or string", rightPos);
                        }
                        rightPos = this.pos;
                        cop = this.scan();
                        if (cop == 19) {
                            left = new UnaryOpNode(0, 49, left);
                        } else {
                            if (cop != 18) throw new CompileError("[NOT] NULL expected", rightPos);
                            rightPos = this.pos;
                            if (this.scan() != 19) throw new CompileError("NULL expected", rightPos);
                            left = new UnaryOpNode(0, 96, new UnaryOpNode(0, 49, left));
                        }
                        this.lex = this.scan();
                        return left;
                    }
                    right = this.addition();
                    if (cop != 31) break block100;
                    if (right.type == 4 || left.type != 20 && right.type != 20) break block101;
                    left = new BinOpNode(0, 139, left, right);
                    break block102;
                }
                switch (right.type) {
                    case 18: {
                        left = new BinOpNode(0, 143, left, right);
                        break block102;
                    }
                    case 8: {
                        if (left.type != 0) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 72, left, right);
                        break block102;
                    }
                    case 10: {
                        if (left.type != 1) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 74, left, right);
                        break block102;
                    }
                    case 9: {
                        if (left.type != 1) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 73, left, right);
                        break block102;
                    }
                    case 11: {
                        if (left.type != 1) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 75, left, right);
                        break block102;
                    }
                    case 12: {
                        if (left.type != 1) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 76, left, right);
                        break block102;
                    }
                    case 13: {
                        if (left.type != 1) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 77, left, right);
                        break block102;
                    }
                    case 14: {
                        if (left.type == 1) {
                            left = QueryImpl.int2real(left);
                        } else if (left.type != 2) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 78, left, right);
                        break block102;
                    }
                    case 15: {
                        if (left.type == 1) {
                            left = QueryImpl.int2real(left);
                        } else if (left.type != 2) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 79, left, right);
                        break block102;
                    }
                    case 17: {
                        if (left.type != 5) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 81, left, right);
                        break block102;
                    }
                    case 16: {
                        if (left.type != 6) {
                            throw new CompileError("Incompatible types of IN operator operands", rightPos);
                        }
                        left = new BinOpNode(0, 80, left, right);
                        break block102;
                    }
                    case 6: {
                        if (left.type != 6) {
                            throw new CompileError("Left operand of IN expression hasn't string type", leftPos);
                        }
                        left = new BinOpNode(0, 82, left, right);
                        break block102;
                    }
                    case 4: {
                        this.compare(left, (BinOpNode)right);
                        left = right;
                        break block102;
                    }
                    default: {
                        throw new CompileError("List of expressions or array expected", rightPos);
                    }
                }
            }
            if (cop == 27) {
                int andPos = this.pos;
                if (this.lex != 16) {
                    throw new CompileError("AND expected", this.pos);
                }
                Node right2 = this.addition();
                if (right.type == 19) {
                    right.type = left.type;
                }
                if (right2.type == 19) {
                    right2.type = left.type;
                }
                if (left.type == 20 || right.type == 20 || right2.type == 20) {
                    left = new CompareNode(137, left, right, right2);
                } else if (left.type == 2 || right.type == 2 || right2.type == 2) {
                    if (left.type == 1) {
                        left = QueryImpl.int2real(left);
                    } else if (left.type != 2) {
                        throw new CompileError("operand of BETWEEN operator should be of integer, real or string type", leftPos);
                    }
                    if (right.type == 1) {
                        right = QueryImpl.int2real(right);
                    } else if (right.type != 2) {
                        throw new CompileError("operand of BETWEEN operator should be of integer, real or string type", rightPos);
                    }
                    if (right2.type == 1) {
                        right2 = QueryImpl.int2real(right2);
                    } else if (right2.type != 2) {
                        throw new CompileError("operand of BETWEEN operator should be of integer, real or string type", andPos);
                    }
                    left = new CompareNode(24, left, right, right2);
                } else if (left.type == 1 && right.type == 1 && right2.type == 1) {
                    left = new CompareNode(17, left, right, right2);
                } else if (left.type == 6 && right.type == 6 && right2.type == 6) {
                    left = new CompareNode(31, left, right, right2);
                } else {
                    if (left.type != 7) throw new CompileError("operands of BETWEEN operator should be of integer, real or string type", rightPos);
                    if (right.type == 6) {
                        right = QueryImpl.str2date(right);
                    } else if (right.type != 7) {
                        throw new CompileError("operands of BETWEEN operator should be of date type", rightPos);
                    }
                    if (right2.type == 6) {
                        right2 = QueryImpl.str2date(right2);
                    } else if (right2.type != 7) {
                        throw new CompileError("operands of BETWEEN operator should be of date type", andPos);
                    }
                    left = new CompareNode(151, left, right, right2);
                }
            } else if (cop == 30) {
                if (right.type == 19) {
                    right.type = left.type;
                }
                if (left.type == 20) {
                    left = new ConvertAnyNode(6, left);
                }
                if (right.type == 20) {
                    right = new ConvertAnyNode(6, right);
                }
                if (left.type != 6) throw new CompileError("operands of LIKE operator should be of string type", rightPos);
                if (right.type != 6) {
                    throw new CompileError("operands of LIKE operator should be of string type", rightPos);
                }
                if (this.lex == 28) {
                    rightPos = this.pos;
                    if (this.scan() != 10) {
                        throw new CompileError("String literal espected after ESCAPE", rightPos);
                    }
                    left = new CompareNode(33, left, right, new StrLiteralNode(this.svalue));
                    this.lex = this.scan();
                } else {
                    left = new CompareNode(32, left, right, null);
                }
            } else {
                if (right.type == 19) {
                    right.type = left.type;
                }
                if (left.type == 19) {
                    left.type = right.type;
                }
                if (left.type == 20 || right.type == 20) {
                    left = new BinOpNode(0, 131 + cop - 21, left, right);
                } else if (left.type == 2 || right.type == 2) {
                    if (left.type == 1) {
                        left = QueryImpl.int2real(left);
                    } else if (left.type != 2) {
                        throw new CompileError("operands of relation operator should be of intger, real or string type", leftPos);
                    }
                    if (right.type == 1) {
                        right = QueryImpl.int2real(right);
                    } else if (right.type != 2) {
                        throw new CompileError("operands of relation operator should be of intger, real or string type", rightPos);
                    }
                    left = new BinOpNode(0, 18 + cop - 21, left, right);
                } else if (left.type == 1 && right.type == 1) {
                    left = new BinOpNode(0, 11 + cop - 21, left, right);
                } else if (left.type == 6 && right.type == 6) {
                    left = new BinOpNode(0, 25 + cop - 21, left, right);
                } else if (left.type == 7) {
                    if (right.type == 6) {
                        right = QueryImpl.str2date(right);
                    } else if (right.type != 7) {
                        throw new CompileError("right opeerand of relation operator should be of date type", rightPos);
                    }
                    left = new BinOpNode(0, 145 + cop - 21, left, right);
                } else if (left.type == 5 && right.type == 5) {
                    if (cop != 21 && cop != 22) {
                        throw new CompileError("References can be checked only for equality", rightPos);
                    }
                    left = new BinOpNode(0, 36 + cop - 21, left, right);
                } else {
                    if (left.type != 0) throw new CompileError("operands of relation operator should be of integer, real or string type", rightPos);
                    if (right.type != 0) throw new CompileError("operands of relation operator should be of integer, real or string type", rightPos);
                    if (cop != 21 && cop != 22) {
                        throw new CompileError("Boolean variables can be checked only for equality", rightPos);
                    }
                    left = new BinOpNode(0, 34 + cop - 21, left, right);
                }
            }
        }
        if (!not) return left;
        return new UnaryOpNode(0, 96, left);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Node addition() {
        int leftPos = this.pos;
        Node left = this.multiplication();
        while (this.lex == 12 || this.lex == 13) {
            int cop = this.lex;
            int rightPos = this.pos;
            Node right = this.multiplication();
            if (left.type == 20 || right.type == 20) {
                left = new BinOpNode(20, cop == 12 ? 121 : 122, left, right);
            } else if (left.type == 2 || right.type == 2) {
                if (left.type == 1) {
                    left = QueryImpl.int2real(left);
                } else if (left.type != 2) {
                    throw new CompileError("operands of arithmetic operators should be of integer or real type", leftPos);
                }
                if (right.type == 1) {
                    right = QueryImpl.int2real(right);
                } else if (right.type != 2) {
                    throw new CompileError("operands of arithmetic operator should be of integer or real type", rightPos);
                }
                left = new BinOpNode(2, cop == 12 ? 38 : 39, left, right);
            } else if (left.type == 1 && right.type == 1) {
                left = new BinOpNode(1, cop == 12 ? 1 : 2, left, right);
            } else {
                if (left.type != 6 || right.type != 6) throw new CompileError("operands of arithmentic operator should be of integer or real type", rightPos);
                if (cop != 12) throw new CompileError("Operation - is not defined for strings", rightPos);
                left = new BinOpNode(6, 99, left, right);
            }
            leftPos = rightPos;
        }
        return left;
    }

    final Node multiplication() {
        int leftPos = this.pos;
        Node left = this.power();
        while (this.lex == 14 || this.lex == 15) {
            int cop = this.lex;
            int rightPos = this.pos;
            Node right = this.power();
            if (left.type == 20 || right.type == 20) {
                left = new BinOpNode(20, cop == 14 ? 123 : 124, left, right);
            } else if (left.type == 2 || right.type == 2) {
                if (left.type == 1) {
                    left = QueryImpl.int2real(left);
                } else if (left.type != 2) {
                    throw new CompileError("operands of arithmetic operators should be of integer or real type", leftPos);
                }
                if (right.type == 1) {
                    right = QueryImpl.int2real(right);
                } else if (right.type != 2) {
                    throw new CompileError("operands of arithmetic operator should be of integer or real type", rightPos);
                }
                left = new BinOpNode(2, cop == 14 ? 40 : 41, left, right);
            } else if (left.type == 1 && right.type == 1) {
                left = new BinOpNode(1, cop == 14 ? 3 : 4, left, right);
            } else {
                throw new CompileError("operands of arithmentic operator should be of integer or real type", rightPos);
            }
            leftPos = rightPos;
        }
        return left;
    }

    final Node power() {
        int leftPos = this.pos;
        Node left = this.term();
        if (this.lex == 8) {
            int rightPos = this.pos;
            Node right = this.power();
            if (left.type == 20 || right.type == 20) {
                left = new BinOpNode(20, 130, left, right);
            } else if (left.type == 2 || right.type == 2) {
                if (left.type == 1) {
                    left = QueryImpl.int2real(left);
                } else if (left.type != 2) {
                    throw new CompileError("operands of arithmetic operators should be of integer or real type", leftPos);
                }
                if (right.type == 1) {
                    right = QueryImpl.int2real(right);
                } else if (right.type != 2) {
                    throw new CompileError("operands of arithmetic operator should be of integer or real type", rightPos);
                }
                left = new BinOpNode(2, 44, left, right);
            } else if (left.type == 1 && right.type == 1) {
                left = new BinOpNode(1, 10, left, right);
            } else {
                throw new CompileError("operands of arithmentic operator should be of integer or real type", rightPos);
            }
        }
        return left;
    }

    static Method lookupMethod(Class cls, String ident, Class[] profile) {
        Class scope;
        Method m = null;
        for (scope = cls; scope != null; scope = scope.getSuperclass()) {
            try {
                m = scope.getDeclaredMethod(ident, profile);
                break;
            }
            catch (Exception x) {
                continue;
            }
        }
        if (m == null && profile.length == 0) {
            ident = "get" + Character.toUpperCase(ident.charAt(0)) + ident.substring(1);
            for (scope = cls; scope != null; scope = scope.getSuperclass()) {
                try {
                    m = scope.getDeclaredMethod(ident, profile);
                    break;
                }
                catch (Exception x) {
                    continue;
                }
            }
        }
        if (m != null) {
            try {
                m.setAccessible(true);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        return m;
    }

    final Object resolve(Object obj) {
        ResolveMapping rm;
        if (this.resolveMap != null && (rm = (ResolveMapping)this.resolveMap.get(obj.getClass())) != null) {
            obj = rm.resolver.resolve(obj);
        }
        return obj;
    }

    final Node component(Node base, Class cls) {
        Field f;
        String ident = this.ident;
        this.lex = this.scan();
        if (this.lex != 2) {
            if (base == null && this.contains != null) {
                f = ClassDescriptor.locateField(this.contains.containsFieldClass, ident);
                if (f != null) {
                    return new ElementNode(this.contains.containsExpr.getFieldName(), f);
                }
            } else if (cls != null && (f = ClassDescriptor.locateField(cls, ident)) != null) {
                return new LoadNode(base, f);
            }
        }
        Class[] profile = defaultProfile;
        Node[] arguments = noArguments;
        if (this.lex == 2) {
            ArrayList<Node> argumentList = new ArrayList<Node>();
            do {
                argumentList.add(this.disjunction());
            } while (this.lex == 7);
            if (this.lex != 3) {
                throw new CompileError("')' expected", this.pos);
            }
            this.lex = this.scan();
            profile = new Class[argumentList.size()];
            arguments = new Node[profile.length];
            boolean unknownProfile = false;
            for (int i = 0; i < profile.length; ++i) {
                Class argType;
                Node arg;
                arguments[i] = arg = (Node)argumentList.get(i);
                switch (arg.type) {
                    case 1: {
                        argType = Long.TYPE;
                        break;
                    }
                    case 2: {
                        argType = Double.TYPE;
                        break;
                    }
                    case 6: {
                        argType = String.class;
                        break;
                    }
                    case 7: {
                        argType = Date.class;
                        break;
                    }
                    case 0: {
                        argType = Boolean.TYPE;
                        break;
                    }
                    case 5: {
                        argType = arg.getType();
                        break;
                    }
                    case 8: {
                        argType = boolean[].class;
                        break;
                    }
                    case 9: {
                        argType = char[].class;
                        break;
                    }
                    case 10: {
                        argType = byte[].class;
                        break;
                    }
                    case 11: {
                        argType = short[].class;
                        break;
                    }
                    case 12: {
                        argType = int[].class;
                        break;
                    }
                    case 13: {
                        argType = long[].class;
                        break;
                    }
                    case 14: {
                        argType = float[].class;
                        break;
                    }
                    case 15: {
                        argType = double[].class;
                        break;
                    }
                    case 16: {
                        argType = String[].class;
                        break;
                    }
                    case 17: {
                        argType = Object[].class;
                        break;
                    }
                    case 19: 
                    case 20: {
                        argType = Object.class;
                        unknownProfile = true;
                        break;
                    }
                    default: {
                        throw new CompileError("Invalid method argument type", this.pos);
                    }
                }
                profile[i] = argType;
            }
            if (unknownProfile) {
                if (!cls.equals(Object.class) || base != null || this.contains == null) {
                    return new InvokeAnyNode(base, ident, arguments, null);
                }
                return new InvokeAnyNode(base, ident, arguments, this.contains.containsExpr.getFieldName());
            }
        }
        Method m = null;
        if (base == null && this.contains != null) {
            m = QueryImpl.lookupMethod(this.contains.containsFieldClass, ident, profile);
            if (m != null) {
                return new InvokeElementNode(m, arguments, this.contains.containsExpr.getFieldName());
            }
            if (arguments == noArguments && cls != null && (f = ClassDescriptor.locateField(cls, ident)) != null) {
                return new LoadNode(base, f);
            }
        }
        if (cls != null && (m = QueryImpl.lookupMethod(cls, ident, profile)) != null) {
            return new InvokeNode(base, m, arguments);
        }
        if (Object.class.equals((Object)cls)) {
            return profile.length == 0 ? new LoadAnyNode(base, ident, null) : new InvokeAnyNode(base, ident, arguments, null);
        }
        if (base == null && this.contains != null && this.contains.containsFieldClass.equals(Object.class)) {
            String arrFieldName = this.contains.containsExpr.getFieldName();
            return profile.length == 0 ? new LoadAnyNode(base, ident, arrFieldName) : new InvokeAnyNode(base, ident, arguments, arrFieldName);
        }
        throw new CompileError("No field or method '" + ident + "' in class " + (cls == null ? this.contains.containsFieldClass : cls).getName(), this.pos);
    }

    final Node field(Node expr) {
        int p = this.pos;
        Class cls = expr.getType();
        block18: while (true) {
            ResolveMapping rm;
            if (this.resolveMap != null && expr.type == 5 && cls != null && (rm = (ResolveMapping)this.resolveMap.get(cls)) != null) {
                expr = new ResolveNode(expr, rm.resolver, rm.resolved);
                cls = rm.resolved;
            }
            switch (this.lex) {
                case 6: {
                    if (this.scan() != 1) {
                        throw new CompileError("identifier expected", p);
                    }
                    if (expr.type != 5 && expr.type != 20 && expr.type != 18) {
                        throw new CompileError("Left operand of '.' should be reference", p);
                    }
                    if (this.contains != null && this.contains.containsExpr.equals(expr)) {
                        expr = this.component(null, null);
                    } else {
                        if (expr.type == 18) {
                            throw new CompileError("Left operand of '.' should be reference", p);
                        }
                        expr = this.component(expr, cls);
                    }
                    cls = expr.getType();
                    continue block18;
                }
                case 4: {
                    int type;
                    int tag;
                    switch (expr.type) {
                        case 8: {
                            tag = 51;
                            type = 0;
                            break;
                        }
                        case 9: {
                            tag = 52;
                            type = 1;
                            break;
                        }
                        case 6: {
                            tag = 50;
                            type = 1;
                            break;
                        }
                        case 10: {
                            tag = 53;
                            type = 1;
                            break;
                        }
                        case 11: {
                            tag = 54;
                            type = 1;
                            break;
                        }
                        case 12: {
                            tag = 55;
                            type = 1;
                            break;
                        }
                        case 13: {
                            tag = 56;
                            type = 1;
                            break;
                        }
                        case 14: {
                            tag = 57;
                            type = 2;
                            break;
                        }
                        case 15: {
                            tag = 58;
                            type = 2;
                            break;
                        }
                        case 16: {
                            tag = 59;
                            type = 6;
                            break;
                        }
                        case 17: {
                            tag = 60;
                            cls = cls.getComponentType();
                            type = cls.isArray() ? 17 : (cls.equals(Object.class) ? 20 : 5);
                            break;
                        }
                        case 20: {
                            tag = 60;
                            type = 20;
                            break;
                        }
                        default: {
                            throw new CompileError("Index can be applied only to arrays", p);
                        }
                    }
                    p = this.pos;
                    Node index = this.disjunction();
                    if (this.lex != 5) {
                        throw new CompileError("']' expected", this.pos);
                    }
                    if (index.type == 20) {
                        index = new ConvertAnyNode(1, index);
                    } else if (index.type != 1 && index.type != 3) {
                        throw new CompileError("Index should have integer type", p);
                    }
                    expr = new GetAtNode(type, tag, expr, index);
                    this.lex = this.scan();
                    continue block18;
                }
            }
            break;
        }
        return expr;
    }

    final Node containsElement() {
        ResolveMapping rm;
        ContainsNode innerContains;
        int p = this.pos;
        Node containsExpr = this.term();
        Class arrClass = containsExpr.getType();
        if (arrClass == null || !arrClass.isArray() && !arrClass.equals(Object.class) && !Collection.class.isAssignableFrom(arrClass)) {
            throw new CompileError("Contains clause can be applied only to arrays or collections", p);
        }
        Class arrElemType = arrClass.isArray() ? arrClass.getComponentType() : Object.class;
        p = this.pos;
        Object withCondition = null;
        ContainsNode outerContains = this.contains;
        this.contains = innerContains = new ContainsNode(containsExpr, arrElemType);
        if (this.resolveMap != null && (rm = (ResolveMapping)this.resolveMap.get(arrElemType)) != null) {
            innerContains.resolver = rm.resolver;
            arrElemType = rm.resolved;
        }
        if (this.lex == 71) {
            innerContains.withExpr = this.checkType(0, this.disjunction());
        }
        if (this.lex == 65) {
            p = this.pos;
            if (this.scan() != 63) {
                throw new CompileError("GROUP BY expected", p);
            }
            p = this.pos;
            if (this.scan() != 1) {
                throw new CompileError("GROUP BY field expected", p);
            }
            if (arrElemType.equals(Object.class)) {
                innerContains.groupByFieldName = this.ident;
            } else {
                Field groupByField = ClassDescriptor.locateField(arrElemType, this.ident);
                if (groupByField == null) {
                    Method groupByMethod = QueryImpl.lookupMethod(arrElemType, this.ident, defaultProfile);
                    if (groupByMethod == null) {
                        throw new CompileError("Field '" + this.ident + "' is not found", p);
                    }
                    innerContains.groupByMethod = groupByMethod;
                    Class<?> rt = groupByMethod.getReturnType();
                    if (rt.equals(Void.TYPE) || !rt.isPrimitive() || Comparable.class.isAssignableFrom(rt)) {
                        throw new CompileError("Result type " + rt + " of sort method should be comparable", p);
                    }
                } else {
                    Class<?> type = groupByField.getType();
                    if (!type.isPrimitive() && !Comparable.class.isAssignableFrom(type)) {
                        throw new CompileError("Order by field type " + type + " should be comparable", p);
                    }
                    innerContains.groupByField = groupByField;
                    innerContains.groupByType = Node.getFieldType(type);
                }
            }
            if (this.scan() != 64) {
                throw new CompileError("HAVING expected", this.pos);
            }
            innerContains.havingExpr = this.checkType(0, this.disjunction());
        }
        this.contains = outerContains;
        return innerContains;
    }

    final Node aggregateFunction(int cop) {
        AggregateFunctionNode agr;
        int p = this.pos;
        if (this.contains == null || this.contains.groupByField == null && this.contains.groupByMethod == null && this.contains.groupByFieldName == null) {
            throw new CompileError("Aggregate function can be used only inside HAVING clause", p);
        }
        if (cop == 67) {
            if (this.scan() != 2 || this.scan() != 14 || this.scan() != 3) {
                throw new CompileError("'count(*)' expected", p);
            }
            this.lex = this.scan();
            agr = new AggregateFunctionNode(1, 115, null);
        } else {
            Node arg = this.term();
            if (arg.type == 20) {
                arg = new ConvertAnyNode(2, arg);
            } else if (arg.type != 1 && arg.type != 2) {
                throw new CompileError("Argument of aggregate function should have scalar type", p);
            }
            agr = new AggregateFunctionNode(arg.type, cop + 114 - 66, arg);
        }
        agr.index = this.contains.aggregateFunctions.size();
        this.contains.aggregateFunctions.add(agr);
        return agr;
    }

    final Node checkType(int type, Node expr) {
        if (expr.type != type) {
            if (expr.type == 20) {
                expr = new ConvertAnyNode(type, expr);
            } else if (expr.type == 19) {
                expr.type = type;
            } else {
                throw new CompileError(Node.typeNames[type] + " expression expected", this.pos);
            }
        }
        return expr;
    }

    final Node term() {
        Node expr2;
        int cop = this.scan();
        int p = this.pos;
        switch (cop) {
            case 48: 
            case 51: {
                this.lex = cop;
                return new EmptyNode();
            }
            case 72: {
                expr2 = new ParameterNode(this.parameters);
                break;
            }
            case 1: {
                Binding bp = this.bindings;
                while (bp != null) {
                    if (bp.name.equals(this.ident)) {
                        this.lex = this.scan();
                        bp.used = true;
                        return new IndexNode(bp.loopId);
                    }
                    bp = bp.next;
                }
                Node expr2 = this.component(null, this.cls);
                return this.field(expr2);
            }
            case 73: {
                return this.containsElement();
            }
            case 29: {
                Binding bp;
                if (this.scan() != 1) {
                    throw new CompileError("Free variable name expected", p);
                }
                this.bindings = bp = new Binding(this.ident, this.vars++, this.bindings);
                if (this.vars >= 32) {
                    throw new CompileError("Too many nested EXISTS clauses", p);
                }
                p = this.pos;
                if (this.scan() != 44) {
                    throw new CompileError("':' expected", p);
                }
                Node expr2 = this.checkType(0, this.term());
                if (bp.used) {
                    expr2 = new ExistsNode(expr2, this.vars - 1);
                }
                --this.vars;
                this.bindings = bp.next;
                return expr2;
            }
            case 42: {
                this.lex = this.scan();
                return this.field(new CurrentNode(this.cls));
            }
            case 46: {
                expr2 = new ConstantNode(0, 64);
                break;
            }
            case 45: {
                expr2 = new ConstantNode(0, 65);
                break;
            }
            case 19: {
                expr2 = new ConstantNode(5, 66);
                break;
            }
            case 9: {
                expr2 = new IntLiteralNode(this.ivalue);
                break;
            }
            case 11: {
                expr2 = new RealLiteralNode(this.fvalue);
                break;
            }
            case 10: {
                StrLiteralNode expr2 = new StrLiteralNode(this.svalue);
                this.lex = this.scan();
                return this.field(expr2);
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return this.aggregateFunction(cop);
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                Node expr2 = this.term();
                if (expr2.type == 1) {
                    expr2 = QueryImpl.int2real(expr2);
                } else if (expr2.type == 20) {
                    expr2 = new ConvertAnyNode(2, expr2);
                } else if (expr2.type != 2) {
                    throw new CompileError("Numeric argument expected", p);
                }
                return new UnaryOpNode(2, cop + 83 - 52, expr2);
            }
            case 35: {
                Node expr2 = this.term();
                if (expr2.type == 1) {
                    return new UnaryOpNode(1, 9, expr2);
                }
                if (expr2.type == 2) {
                    return new UnaryOpNode(2, 43, expr2);
                }
                if (expr2.type == 20) {
                    return new UnaryOpNode(20, 129, expr2);
                }
                throw new CompileError("ABS function can be applied only to integer or real expression", p);
            }
            case 32: {
                Node expr2 = this.term();
                if (expr2.type == 6) {
                    return new UnaryOpNode(1, 100, expr2);
                }
                if (expr2.type == 20) {
                    return new UnaryOpNode(1, 138, expr2);
                }
                if (expr2.type >= 8) {
                    return new UnaryOpNode(1, 61, expr2);
                }
                throw new CompileError("LENGTH function is defined only for arrays and strings", p);
            }
            case 33: {
                return this.field(new UnaryOpNode(6, 97, this.checkType(6, this.term())));
            }
            case 34: {
                return this.field(new UnaryOpNode(6, 98, this.checkType(6, this.term())));
            }
            case 37: {
                return new UnaryOpNode(1, 46, this.checkType(2, this.term()));
            }
            case 38: {
                return new UnaryOpNode(1, 45, this.checkType(1, this.term()));
            }
            case 39: {
                Node expr2 = this.term();
                if (expr2.type == 1) {
                    return this.field(new UnaryOpNode(6, 47, expr2));
                }
                if (expr2.type == 2) {
                    return this.field(new UnaryOpNode(6, 48, expr2));
                }
                if (expr2.type == 7) {
                    return this.field(new UnaryOpNode(6, 152, expr2));
                }
                if (expr2.type == 20) {
                    return this.field(new UnaryOpNode(6, 140, expr2));
                }
                throw new CompileError("STRING function can be applied only to integer or real expression", p);
            }
            case 2: {
                expr2 = this.disjunction();
                BinOpNode list = null;
                while (this.lex == 7) {
                    list = new BinOpNode(4, 0, list, expr2);
                    expr2 = this.disjunction();
                }
                if (this.lex != 3) {
                    throw new CompileError("')' expected", this.pos);
                }
                if (list == null) break;
                expr2 = new BinOpNode(4, 0, list, expr2);
                break;
            }
            case 18: {
                Node expr2 = this.comparison();
                if (expr2.type == 1) {
                    if (expr2.tag == 68) {
                        IntLiteralNode ic = (IntLiteralNode)expr2;
                        ic.value ^= 0xFFFFFFFFFFFFFFFFL;
                    } else {
                        expr2 = new UnaryOpNode(1, 8, expr2);
                    }
                    return expr2;
                }
                if (expr2.type == 0) {
                    return new UnaryOpNode(0, 96, expr2);
                }
                if (expr2.type == 20) {
                    return new UnaryOpNode(20, 128, expr2);
                }
                throw new CompileError("NOT operator can be applied only to integer or boolean expressions", p);
            }
            case 12: {
                throw new CompileError("Using of unary plus operator has no sense", p);
            }
            case 13: {
                Node expr2 = this.term();
                if (expr2.type == 1) {
                    if (expr2.tag == 68) {
                        IntLiteralNode ic = (IntLiteralNode)expr2;
                        ic.value = -ic.value;
                    } else {
                        expr2 = new UnaryOpNode(1, 7, expr2);
                    }
                } else if (expr2.type == 2) {
                    if (expr2.tag == 69) {
                        RealLiteralNode fc = (RealLiteralNode)expr2;
                        fc.value = -fc.value;
                    } else {
                        expr2 = new UnaryOpNode(2, 42, expr2);
                    }
                } else if (expr2.type == 20) {
                    expr2 = new UnaryOpNode(20, 127, expr2);
                } else {
                    throw new CompileError("Unary minus can be applied only to numeric expressions", p);
                }
                return expr2;
            }
            default: {
                throw new CompileError("operand expected", p);
            }
        }
        this.lex = this.scan();
        return expr2;
    }

    final IterableIterator filter(IterableIterator iterator, Node condition) {
        return condition == null ? iterator : new FilterIterator(this, iterator, condition);
    }

    final IterableIterator applyIndex(Node condition) {
        Node cmp;
        Node filterCondition = null;
        Node expr = condition;
        if (expr.tag == 94) {
            filterCondition = ((BinOpNode)expr).right;
            expr = ((BinOpNode)expr).left;
        }
        if (expr.tag == 111) {
            ContainsNode contains = (ContainsNode)expr;
            if (contains.withExpr == null) {
                return null;
            }
            if (contains.havingExpr != null) {
                filterCondition = condition;
            }
            expr = contains.withExpr;
        }
        if (expr instanceof BinOpNode) {
            cmp = (BinOpNode)expr;
            String key = cmp.left.getFieldName();
            if (key != null && cmp.right instanceof LiteralNode) {
                GenericIndex<T> index = this.getIndex(key);
                if (index == null) {
                    return null;
                }
                switch (expr.tag) {
                    case 11: 
                    case 18: 
                    case 25: 
                    case 34: 
                    case 131: 
                    case 145: {
                        Key value = QueryImpl.keyLiteral(index.getKeyType(), cmp.right, true);
                        if (value != null) {
                            return this.filter(index.iterator(value, value, 0), filterCondition);
                        }
                        return null;
                    }
                    case 13: 
                    case 20: 
                    case 27: 
                    case 133: 
                    case 147: {
                        Key value = QueryImpl.keyLiteral(index.getKeyType(), cmp.right, false);
                        if (value != null) {
                            return this.filter(index.iterator(value, null, 0), filterCondition);
                        }
                        return null;
                    }
                    case 14: 
                    case 21: 
                    case 28: 
                    case 134: 
                    case 148: {
                        Key value = QueryImpl.keyLiteral(index.getKeyType(), cmp.right, true);
                        if (value != null) {
                            return this.filter(index.iterator(value, null, 0), filterCondition);
                        }
                        return null;
                    }
                    case 15: 
                    case 22: 
                    case 29: 
                    case 135: 
                    case 149: {
                        Key value = QueryImpl.keyLiteral(index.getKeyType(), cmp.right, false);
                        if (value != null) {
                            return this.filter(index.iterator(null, value, 0), filterCondition);
                        }
                        return null;
                    }
                    case 16: 
                    case 23: 
                    case 30: 
                    case 136: 
                    case 150: {
                        Key value = QueryImpl.keyLiteral(index.getKeyType(), cmp.right, true);
                        if (value != null) {
                            return this.filter(index.iterator(null, value, 0), filterCondition);
                        }
                        return null;
                    }
                }
            }
        } else if (expr instanceof CompareNode) {
            cmp = (CompareNode)expr;
            String key = ((CompareNode)cmp).o1.getFieldName();
            if (key != null && ((CompareNode)cmp).o2 instanceof LiteralNode && (((CompareNode)cmp).o3 == null || ((CompareNode)cmp).o3 instanceof LiteralNode)) {
                GenericIndex<T> index = this.getIndex(key);
                if (index == null) {
                    return null;
                }
                switch (expr.tag) {
                    case 17: 
                    case 24: 
                    case 31: 
                    case 137: 
                    case 151: {
                        Key value1 = QueryImpl.keyLiteral(index.getKeyType(), ((CompareNode)cmp).o2, true);
                        Key value2 = QueryImpl.keyLiteral(index.getKeyType(), ((CompareNode)cmp).o3, true);
                        if (value1 != null && value2 != null) {
                            return this.filter(index.iterator(value1, value2, 0), filterCondition);
                        }
                        return null;
                    }
                    case 32: 
                    case 33: {
                        char ch;
                        String pattern = (String)((LiteralNode)((CompareNode)cmp).o2).getValue();
                        char escape = ((CompareNode)cmp).o3 != null ? (char)((String)((LiteralNode)((CompareNode)cmp).o3).getValue()).charAt(0) : (char)'\\';
                        int pref = 0;
                        while (pref < pattern.length() && (ch = pattern.charAt(pref)) != '%' && ch != '_') {
                            if (ch == escape) {
                                pref += 2;
                                continue;
                            }
                            ++pref;
                        }
                        if (pref <= 0) break;
                        if (pref == pattern.length()) {
                            Key value = new Key(pattern);
                            return this.filter(index.iterator(value, value, 0), filterCondition);
                        }
                        if (filterCondition != null) break;
                        return this.filter(index.prefixIterator(pattern.substring(0, pref)), condition);
                    }
                }
            }
        }
        return null;
    }

    final void compile() {
        int tkn;
        this.pos = 0;
        this.vars = 0;
        this.tree = this.checkType(0, this.disjunction());
        OrderNode last = null;
        this.order = null;
        if (this.lex == 51) {
            return;
        }
        if (this.lex != 48) {
            throw new CompileError("ORDER BY expected", this.pos);
        }
        int p = this.pos;
        if (this.scan() != 63) {
            throw new CompileError("BY expected after ORDER", p);
        }
        do {
            OrderNode node;
            p = this.pos;
            if (this.scan() != 1) {
                throw new CompileError("field name expected", p);
            }
            Field f = ClassDescriptor.locateField(this.cls, this.ident);
            if (f == null) {
                Method m = QueryImpl.lookupMethod(this.cls, this.ident, defaultProfile);
                if (m == null) {
                    if (!this.cls.equals(Object.class)) {
                        throw new CompileError("No field '" + this.ident + "' in class " + this.cls.getName(), p);
                    }
                    node = new OrderNode(this.ident);
                } else {
                    node = new OrderNode(m);
                }
            } else {
                node = new OrderNode(ClassDescriptor.getTypeCode(f.getType()), f);
            }
            if (last != null) {
                last.next = node;
            } else {
                this.order = node;
            }
            last = node;
            p = this.pos;
            tkn = this.scan();
            if (tkn == 50) {
                node.ascent = false;
                tkn = this.scan();
                continue;
            }
            if (tkn != 49) continue;
            tkn = this.scan();
        } while (tkn == 7);
        if (tkn != 51) {
            throw new CompileError("',' expected", p);
        }
    }

    static {
        defaultProfile = new Class[0];
        noArguments = new Node[0];
        dummyKeyValue = new Object();
        symtab = new Hashtable();
        symtab.put("abs", new Symbol(35));
        symtab.put("acos", new Symbol(56));
        symtab.put("and", new Symbol(16));
        symtab.put("asc", new Symbol(49));
        symtab.put("asin", new Symbol(55));
        symtab.put("atan", new Symbol(57));
        symtab.put("between", new Symbol(27));
        symtab.put("by", new Symbol(63));
        symtab.put("ceal", new Symbol(61));
        symtab.put("cos", new Symbol(53));
        symtab.put("current", new Symbol(42));
        symtab.put("desc", new Symbol(50));
        symtab.put("escape", new Symbol(28));
        symtab.put("exists", new Symbol(29));
        symtab.put("exp", new Symbol(60));
        symtab.put("false", new Symbol(46));
        symtab.put("floor", new Symbol(62));
        symtab.put("in", new Symbol(31));
        symtab.put("is", new Symbol(36));
        symtab.put("integer", new Symbol(37));
        symtab.put("last", new Symbol(41));
        symtab.put("length", new Symbol(32));
        symtab.put("like", new Symbol(30));
        symtab.put("log", new Symbol(59));
        symtab.put("lower", new Symbol(33));
        symtab.put("not", new Symbol(18));
        symtab.put("null", new Symbol(19));
        symtab.put("or", new Symbol(17));
        symtab.put("order", new Symbol(48));
        symtab.put("real", new Symbol(38));
        symtab.put("sin", new Symbol(52));
        symtab.put("sqrt", new Symbol(58));
        symtab.put("string", new Symbol(39));
        symtab.put("true", new Symbol(45));
        symtab.put("upper", new Symbol(34));
        symtab.put("having", new Symbol(64));
        symtab.put("contains", new Symbol(73));
        symtab.put("group", new Symbol(65));
        symtab.put("min", new Symbol(69));
        symtab.put("max", new Symbol(68));
        symtab.put("count", new Symbol(67));
        symtab.put("avg", new Symbol(66));
        symtab.put("sum", new Symbol(70));
        symtab.put("with", new Symbol(71));
    }

    static class ResolveMapping {
        Class resolved;
        Resolver resolver;

        ResolveMapping(Class resolved, Resolver resolver) {
            this.resolved = resolved;
            this.resolver = resolver;
        }
    }
}

