/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentSet<T extends IPersistent>
extends Btree<T>
implements IPersistentSet<T> {
    PersistentSet() {
        this.type = 10;
        this.unique = true;
    }

    @Override
    public boolean isEmpty() {
        return this.nElems == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IPersistent) {
            Key key = new Key((IPersistent)o);
            IterableIterator i = this.iterator(key, key, 0);
            return i.hasNext();
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return this.toPersistentArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        return super.toArray((E[])((IPersistent[])arr));
    }

    @Override
    public boolean add(T obj) {
        return this.put(new Key((IPersistent)obj), obj);
    }

    @Override
    public boolean remove(Object o) {
        IPersistent obj = (IPersistent)o;
        return this.removeIfExists(new BtreeKey(this.checkKey(new Key(obj)), obj.getOid()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        return this.containsAll(c);
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            h += ((IPersistent)i.next()).getOid();
        }
        return h;
    }
}

