/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Arrays;
import org.garret.perst.Assert;
import org.garret.perst.IFile;
import org.garret.perst.impl.LRU;
import org.garret.perst.impl.ObjectHeader;
import org.garret.perst.impl.Page;

class PagePool {
    LRU lru;
    Page freePages;
    Page[] hashTable;
    int poolSize;
    boolean autoExtended;
    IFile file;
    long lruLimit;
    int nDirtyPages;
    Page[] dirtyPages;
    boolean flushing;
    static final int INFINITE_POOL_INITIAL_SIZE = 8;

    PagePool(int poolSize, long lruLimit) {
        if (poolSize == 0) {
            this.autoExtended = true;
            poolSize = 8;
        }
        this.poolSize = poolSize;
        this.lruLimit = lruLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Page find(long addr, int state) {
        Page pg;
        int pageNo = (int)(addr >>> 12);
        int hashCode = pageNo % this.poolSize;
        PagePool pagePool = this;
        synchronized (pagePool) {
            pg = this.hashTable[hashCode];
            while (pg != null) {
                if (pg.offs == addr) {
                    if (pg.accessCount++ != 0) break;
                    pg.unlink();
                    break;
                }
                pg = pg.collisionChain;
            }
            if (pg == null) {
                pg = this.freePages;
                if (pg != null) {
                    this.freePages = (Page)pg.next;
                } else if (this.autoExtended) {
                    if (pageNo >= this.poolSize) {
                        int newPoolSize = pageNo >= this.poolSize * 2 ? pageNo + 1 : this.poolSize * 2;
                        Page[] newHashTable = new Page[newPoolSize];
                        System.arraycopy(this.hashTable, 0, newHashTable, 0, this.hashTable.length);
                        this.hashTable = newHashTable;
                        this.poolSize = newPoolSize;
                    }
                    pg = new Page();
                    hashCode = pageNo;
                } else {
                    Assert.that("unfixed page available", this.lru.prev != this.lru);
                    pg = (Page)this.lru.prev;
                    pg.unlink();
                    Page newPoolSize = pg;
                    synchronized (newPoolSize) {
                        if ((pg.state & 1) != 0) {
                            pg.state = 0;
                            this.file.write(pg.offs, pg.data);
                            if (!this.flushing) {
                                this.dirtyPages[pg.writeQueueIndex] = this.dirtyPages[--this.nDirtyPages];
                                this.dirtyPages[pg.writeQueueIndex].writeQueueIndex = pg.writeQueueIndex;
                            }
                        }
                    }
                    int h = (int)(pg.offs >> 12) % this.poolSize;
                    Page curr = this.hashTable[h];
                    Page prev = null;
                    while (curr != pg) {
                        prev = curr;
                        curr = curr.collisionChain;
                    }
                    if (prev == null) {
                        this.hashTable[h] = pg.collisionChain;
                    } else {
                        prev.collisionChain = pg.collisionChain;
                    }
                }
                pg.accessCount = 1;
                pg.offs = addr;
                pg.state = 2;
                pg.collisionChain = this.hashTable[hashCode];
                this.hashTable[hashCode] = pg;
            }
            if ((pg.state & 1) == 0 && (state & 1) != 0) {
                Assert.that(!this.flushing);
                if (this.nDirtyPages >= this.dirtyPages.length) {
                    Page[] newDirtyPages = new Page[this.nDirtyPages * 2];
                    System.arraycopy(this.dirtyPages, 0, newDirtyPages, 0, this.dirtyPages.length);
                    this.dirtyPages = newDirtyPages;
                }
                this.dirtyPages[this.nDirtyPages] = pg;
                pg.writeQueueIndex = this.nDirtyPages++;
                pg.state |= 1;
            }
            if ((pg.state & 2) != 0) {
                if (this.file.read(pg.offs, pg.data) < 4096) {
                    for (int i = 0; i < 4096; ++i) {
                        pg.data[i] = 0;
                    }
                }
                pg.state &= 0xFFFFFFFD;
            }
        }
        return pg;
    }

    final synchronized void copy(long dst, long src, long size) {
        long len;
        int dstOffs = (int)dst & 0xFFF;
        int srcOffs = (int)src & 0xFFF;
        Page dstPage = this.find(dst -= (long)dstOffs, 1);
        Page srcPage = this.find(src -= (long)srcOffs, 0);
        do {
            if (dstOffs == 4096) {
                this.unfix(dstPage);
                dstPage = this.find(dst += 4096L, 1);
                dstOffs = 0;
            }
            if (srcOffs == 4096) {
                this.unfix(srcPage);
                srcPage = this.find(src += 4096L, 0);
                srcOffs = 0;
            }
            if ((len = size) > (long)(4096 - srcOffs)) {
                len = 4096 - srcOffs;
            }
            if (len > (long)(4096 - dstOffs)) {
                len = 4096 - dstOffs;
            }
            System.arraycopy(srcPage.data, srcOffs, dstPage.data, dstOffs, (int)len);
            srcOffs = (int)((long)srcOffs + len);
            dstOffs = (int)((long)dstOffs + len);
        } while ((size -= len) != 0L);
        this.unfix(dstPage);
        this.unfix(srcPage);
    }

    final void write(long dstPos, byte[] src) {
        Assert.that((dstPos & 0xFFFL) == 0L);
        Assert.that((src.length & 0xFFF) == 0);
        int i = 0;
        while (i < src.length) {
            Page pg = this.find(dstPos, 1);
            byte[] dst = pg.data;
            for (int j = 0; j < 4096; ++j) {
                dst[j] = src[i++];
            }
            this.unfix(pg);
            dstPos += 4096L;
        }
    }

    final void open(IFile f) {
        this.file = f;
        this.reset();
    }

    final void reset() {
        this.lru = new LRU();
        this.freePages = null;
        this.hashTable = new Page[this.poolSize];
        this.dirtyPages = new Page[this.poolSize];
        this.nDirtyPages = 0;
        if (!this.autoExtended) {
            int i = this.poolSize;
            while (--i >= 0) {
                Page pg = new Page();
                pg.next = this.freePages;
                this.freePages = pg;
            }
        }
    }

    final void clear() {
        Assert.that(this.nDirtyPages == 0);
        this.reset();
    }

    final synchronized void close() {
        this.file.close();
        this.hashTable = null;
        this.dirtyPages = null;
        this.lru = null;
        this.freePages = null;
    }

    final synchronized void unfix(Page pg) {
        Assert.that(pg.accessCount > 0);
        if (--pg.accessCount == 0) {
            if (pg.offs <= this.lruLimit) {
                this.lru.link(pg);
            } else {
                this.lru.prev.link(pg);
            }
        }
    }

    final synchronized void modify(Page pg) {
        Assert.that(pg.accessCount > 0);
        if ((pg.state & 1) == 0) {
            Assert.that(!this.flushing);
            pg.state |= 1;
            if (this.nDirtyPages >= this.dirtyPages.length) {
                Page[] newDirtyPages = new Page[this.nDirtyPages * 2];
                System.arraycopy(this.dirtyPages, 0, newDirtyPages, 0, this.dirtyPages.length);
                this.dirtyPages = newDirtyPages;
            }
            this.dirtyPages[this.nDirtyPages] = pg;
            pg.writeQueueIndex = this.nDirtyPages++;
        }
    }

    final Page getPage(long addr) {
        return this.find(addr, 0);
    }

    final Page putPage(long addr) {
        return this.find(addr, 1);
    }

    final byte[] get(long pos) {
        Assert.that(pos != 0L);
        int offs = (int)pos & 0xFFF;
        Page pg = this.find(pos - (long)offs, 0);
        int size = ObjectHeader.getSize(pg.data, offs);
        Assert.that(size >= 8);
        byte[] obj = new byte[size];
        int dst = 0;
        while (size > 4096 - offs) {
            System.arraycopy(pg.data, offs, obj, dst, 4096 - offs);
            this.unfix(pg);
            size -= 4096 - offs;
            dst += 4096 - offs;
            pg = this.find(pos += (long)(4096 - offs), 0);
            offs = 0;
        }
        System.arraycopy(pg.data, offs, obj, dst, size);
        this.unfix(pg);
        return obj;
    }

    final void put(long pos, byte[] obj) {
        this.put(pos, obj, obj.length);
    }

    final void put(long pos, byte[] obj, int size) {
        int offs = (int)pos & 0xFFF;
        Page pg = this.find(pos - (long)offs, 1);
        int src = 0;
        while (size > 4096 - offs) {
            System.arraycopy(obj, src, pg.data, offs, 4096 - offs);
            this.unfix(pg);
            size -= 4096 - offs;
            src += 4096 - offs;
            pg = this.find(pos += (long)(4096 - offs), 1);
            offs = 0;
        }
        System.arraycopy(obj, src, pg.data, offs, size);
        this.unfix(pg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        PagePool pagePool = this;
        synchronized (pagePool) {
            this.flushing = true;
            Arrays.sort(this.dirtyPages, 0, this.nDirtyPages);
        }
        for (int i = 0; i < this.nDirtyPages; ++i) {
            Page pg;
            Page page = pg = this.dirtyPages[i];
            synchronized (page) {
                if ((pg.state & 1) != 0) {
                    this.file.write(pg.offs, pg.data);
                    pg.state &= 0xFFFFFFFE;
                }
                continue;
            }
        }
        this.file.sync();
        this.nDirtyPages = 0;
        this.flushing = false;
    }
}

