/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.util.Iterator;
import org.garret.perst.IResource;
import org.garret.perst.IterableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSafeIterator<T>
extends IterableIterator<T> {
    private IResource collection;
    private Iterator<T> iterator;
    private T next;

    @Override
    public boolean hasNext() {
        boolean result;
        if (this.next == null) {
            this.collection.sharedLock();
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                result = true;
            } else {
                result = false;
            }
            this.collection.unlock();
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public T next() {
        T obj = this.next;
        if (obj == null) {
            this.collection.sharedLock();
            obj = this.iterator.next();
            this.collection.unlock();
        } else {
            this.next = null;
        }
        return obj;
    }

    public ThreadSafeIterator(IResource collection, Iterator<T> iterator) {
        this.collection = collection;
        this.iterator = iterator;
    }

    @Override
    public void remove() {
        this.collection.exclusiveLock();
        this.iterator.remove();
        this.collection.unlock();
        this.next = null;
    }
}

