/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.net.InetAddress;
import org.garret.perst.Assert;

public class PatriciaTrieKey {
    public final long mask;
    public final int length;

    public PatriciaTrieKey(long mask, int length) {
        this.mask = mask;
        this.length = length;
    }

    public static PatriciaTrieKey fromIpAddress(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        long mask = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            mask = mask << 8 | (long)(bytes[i] & 0xFF);
        }
        return new PatriciaTrieKey(mask, bytes.length * 8);
    }

    public static PatriciaTrieKey fromIpAddress(String addr) throws NumberFormatException {
        long mask = 0L;
        int pos = 0;
        int len = 0;
        do {
            int dot;
            String part = (dot = addr.indexOf(46, pos)) < 0 ? addr.substring(pos) : addr.substring(pos, dot);
            pos = dot + 1;
            int b = Integer.parseInt(part, 10);
            mask = mask << 8 | (long)(b & 0xFF);
            len += 8;
        } while (pos > 0);
        return new PatriciaTrieKey(mask, len);
    }

    public static PatriciaTrieKey fromDecimalDigits(String digits) {
        long mask = 0L;
        int n = digits.length();
        Assert.that(n <= 16);
        for (int i = 0; i < n; ++i) {
            char ch = digits.charAt(i);
            Assert.that(ch >= '0' && ch <= '9');
            mask = mask << 4 | (long)(ch - 48);
        }
        return new PatriciaTrieKey(mask, n * 4);
    }

    public static PatriciaTrieKey from7bitString(String str) {
        long mask = 0L;
        int n = str.length();
        Assert.that(n * 7 <= 64);
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            mask = mask << 7 | (long)(ch & 0x7F);
        }
        return new PatriciaTrieKey(mask, n * 7);
    }

    public static PatriciaTrieKey from8bitString(String str) {
        long mask = 0L;
        int n = str.length();
        Assert.that(n <= 8);
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            mask = mask << 8 | (long)(ch & 0xFF);
        }
        return new PatriciaTrieKey(mask, n * 8);
    }

    public static PatriciaTrieKey fromByteArray(byte[] arr) {
        long mask = 0L;
        int n = arr.length;
        Assert.that(n <= 8);
        for (int i = 0; i < n; ++i) {
            mask = mask << 8 | (long)(arr[i] & 0xFF);
        }
        return new PatriciaTrieKey(mask, n * 8);
    }
}

