/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.IResource;
import org.garret.perst.Index;
import org.garret.perst.Indexable;
import org.garret.perst.IterableIterator;
import org.garret.perst.IteratorWrapper;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Query;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    HashMap tables;
    Storage storage;
    Index metadata;
    boolean multithreaded;
    boolean autoRegisterTables;

    public Database(Storage storage, boolean multithreaded) {
        this(storage, multithreaded, true);
    }

    public Database(Storage storage, boolean multithreaded, boolean autoRegisterTables) {
        this.storage = storage;
        this.multithreaded = multithreaded;
        this.autoRegisterTables = autoRegisterTables;
        if (multithreaded) {
            storage.setProperty("perst.alternative.btree", Boolean.TRUE);
        }
        this.metadata = (Index)storage.getRoot();
        boolean schemaUpdated = false;
        if (this.metadata == null) {
            this.beginTransaction();
            this.metadata = storage.createIndex(String.class, true);
            storage.setRoot(this.metadata);
            schemaUpdated = true;
        }
        IterableIterator iterator = this.metadata.entryIterator();
        this.tables = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry map = (Map.Entry)iterator.next();
            Table table = (Table)map.getValue();
            Class cls = ClassDescriptor.loadClass(storage, (String)map.getKey());
            this.tables.put(cls, table);
            schemaUpdated |= this.addIndices(table, cls);
        }
        if (schemaUpdated) {
            this.commitTransaction();
        }
    }

    public Database(Storage storage) {
        this(storage, false);
    }

    public void beginTransaction() {
        if (this.multithreaded) {
            this.storage.beginThreadTransaction(2);
        }
    }

    public void commitTransaction() {
        if (this.multithreaded) {
            this.storage.endThreadTransaction();
        } else {
            this.storage.commit();
        }
    }

    public void rollbackTransaction() {
        if (this.multithreaded) {
            this.storage.rollbackThreadTransaction();
        } else {
            this.storage.rollback();
        }
    }

    public boolean createTable(Class table) {
        if (this.multithreaded) {
            this.metadata.exclusiveLock();
        }
        if (this.tables.get(table) == null) {
            Table t = new Table();
            t.extent = this.storage.createSet();
            t.indices = this.storage.createLink();
            t.indicesMap = new HashMap();
            this.tables.put(table, t);
            this.metadata.put(table.getName(), t);
            this.addIndices(t, table);
            return true;
        }
        return false;
    }

    private boolean addIndices(Table table, Class cls) {
        boolean schemaUpdated = false;
        for (Field f : cls.getDeclaredFields()) {
            Indexable idx = f.getAnnotation(Indexable.class);
            if (idx == null) continue;
            schemaUpdated |= this.createIndex(table, cls, f.getName(), idx.unique(), idx.caseInsensitive());
        }
        return schemaUpdated;
    }

    public boolean dropTable(Class table) {
        if (this.multithreaded) {
            this.metadata.exclusiveLock();
        }
        if (this.tables.remove(table) != null) {
            this.metadata.remove(table.getName());
            return true;
        }
        return false;
    }

    public <T extends IPersistent> boolean addRecord(T record) {
        return this.addRecord(record.getClass(), record);
    }

    private Table locateTable(Class cls, boolean exclusive) {
        return this.locateTable(cls, exclusive, true);
    }

    private Table locateTable(Class cls, boolean exclusive, boolean shouldExist) {
        Table table = null;
        if (this.multithreaded) {
            this.metadata.sharedLock();
        }
        for (Class c = cls; c != null && (table = (Table)this.tables.get(c)) == null; c = c.getSuperclass()) {
        }
        if (table == null) {
            if (shouldExist) {
                throw new StorageError(18, cls.getName());
            }
            return null;
        }
        if (exclusive) {
            table.extent.exclusiveLock();
        } else {
            table.extent.sharedLock();
        }
        return table;
    }

    private void registerTable(Class cls) {
        if (this.multithreaded) {
            this.metadata.sharedLock();
        }
        if (this.autoRegisterTables) {
            boolean exclusiveLockSet = false;
            for (Class c = cls; c != Object.class; c = c.getSuperclass()) {
                Table t = (Table)this.tables.get(c);
                if (t != null) continue;
                if (!exclusiveLockSet) {
                    this.metadata.unlock();
                    exclusiveLockSet = true;
                }
                this.createTable(c);
            }
        }
    }

    public <T extends IPersistent> boolean addRecord(Class table, T record) {
        boolean added = false;
        boolean found = false;
        this.registerTable(table);
        ArrayList<IResource> wasInsertedIn = new ArrayList<IResource>();
        for (Class c = table; c != null; c = c.getSuperclass()) {
            Table t = (Table)this.tables.get(c);
            if (t == null) continue;
            found = true;
            if (this.multithreaded) {
                t.extent.exclusiveLock();
            }
            if (!t.extent.add(record)) continue;
            wasInsertedIn.add(t.extent);
            Iterator<Object> iterator = t.indicesMap.values().iterator();
            while (iterator.hasNext()) {
                FieldIndex index = (FieldIndex)iterator.next();
                if (index.put(record)) {
                    wasInsertedIn.add(index);
                    continue;
                }
                for (Object object : wasInsertedIn) {
                    if (object instanceof IPersistentSet) {
                        ((IPersistentSet)object).remove(record);
                        continue;
                    }
                    ((FieldIndex)object).remove(record);
                }
                return false;
            }
            added = true;
        }
        if (!found) {
            throw new StorageError(18, table.getName());
        }
        return added;
    }

    public <T extends IPersistent> boolean deleteRecord(T record) {
        return this.deleteRecord(record.getClass(), record);
    }

    public <T extends IPersistent> boolean deleteRecord(Class table, T record) {
        boolean removed = false;
        if (this.multithreaded) {
            this.metadata.sharedLock();
        }
        for (Class c = table; c != null; c = c.getSuperclass()) {
            Table t = (Table)this.tables.get(c);
            if (t == null) continue;
            if (this.multithreaded) {
                t.extent.exclusiveLock();
            }
            if (!t.extent.remove(record)) continue;
            for (FieldIndex index : t.indicesMap.values()) {
                index.remove(record);
            }
            removed = true;
        }
        if (removed) {
            record.deallocate();
        }
        return removed;
    }

    public boolean createIndex(Class table, String key, boolean unique) {
        return this.createIndex(this.locateTable(table, true), table, key, unique, false);
    }

    public boolean createIndex(Class table, String key, boolean unique, boolean caseInsensitive) {
        return this.createIndex(this.locateTable(table, true), table, key, unique, caseInsensitive);
    }

    private boolean createIndex(Table t, Class c, String key, boolean unique, boolean caseInsensitive) {
        if (t.indicesMap.get(key) == null) {
            FieldIndex index = this.storage.createFieldIndex(c, key, unique, caseInsensitive);
            t.indicesMap.put(key, index);
            t.indices.add(index);
            return true;
        }
        return false;
    }

    public boolean dropIndex(Class table, String key) {
        Table t = this.locateTable(table, true);
        FieldIndex index = (FieldIndex)t.indicesMap.remove(key);
        if (index != null) {
            t.indices.remove(t.indices.indexOf(index));
            return true;
        }
        return false;
    }

    public HashMap getIndices(Class table) {
        Table t = this.locateTable(table, true, false);
        return t == null ? new HashMap() : t.indicesMap;
    }

    public boolean excludeFromIndex(IPersistent record, String key) {
        return this.excludeFromIndex(record.getClass(), record, key);
    }

    public boolean excludeFromIndex(Class table, IPersistent record, String key) {
        Table t = this.locateTable(table, true);
        FieldIndex index = (FieldIndex)t.indicesMap.get(key);
        if (index != null) {
            index.remove(record);
            return true;
        }
        return false;
    }

    public boolean includeInIndex(IPersistent record, String key) {
        return this.includeInIndex(record.getClass(), record, key);
    }

    public boolean includeInIndex(Class table, IPersistent record, String key) {
        Table t = this.locateTable(table, true);
        FieldIndex index = (FieldIndex)t.indicesMap.get(key);
        if (index != null) {
            index.put(record);
            return true;
        }
        return false;
    }

    public <T extends IPersistent> IterableIterator<T> select(Class table, String predicate) {
        return this.select(table, predicate, false);
    }

    public <T extends IPersistent> IterableIterator<T> select(Class table, String predicate, boolean forUpdate) {
        Query<T> q = this.prepare(table, predicate, forUpdate);
        return q.execute(this.getRecords(table));
    }

    public <T extends IPersistent> Query<T> prepare(Class table, String predicate) {
        return this.prepare(table, predicate, false);
    }

    public <T extends IPersistent> Query<T> prepare(Class table, String predicate, boolean forUpdate) {
        Table t = this.locateTable(table, forUpdate, false);
        Query q = this.storage.createQuery();
        q.prepare(table, predicate);
        if (t != null) {
            for (Map.Entry entry : t.indicesMap.entrySet()) {
                FieldIndex index = (FieldIndex)entry.getValue();
                String key = (String)entry.getKey();
                q.addIndex(key, index);
            }
        }
        return q;
    }

    public <T extends IPersistent> IterableIterator<T> getRecords(Class table) {
        return this.getRecords(table, false);
    }

    public <T extends IPersistent> IterableIterator<T> getRecords(Class table, boolean forUpdate) {
        Table t = this.locateTable(table, forUpdate, false);
        return new IteratorWrapper(t == null ? new LinkedList().iterator() : t.extent.iterator());
    }

    public Storage getStorage() {
        return this.storage;
    }

    static class Table
    extends Persistent {
        IPersistentSet extent;
        Link indices;
        transient HashMap indicesMap = new HashMap();

        Table() {
        }

        public void onLoad() {
            int i = this.indices.size();
            while (--i >= 0) {
                FieldIndex index = (FieldIndex)this.indices.get(i);
                this.indicesMap.put(index.getKeyFields()[0].getName(), index);
            }
        }
    }
}

