/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.garret.perst.Assert;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Bitmap;
import org.garret.perst.impl.Bytes;

public class CompressedReadWriteFile
implements IFile {
    static final int ALLOCATION_QUANTUM_LOG = 9;
    static final int ALLOCATION_QUANTUM = 512;
    static final long MAX_PAGE_MAP_SIZE = 1000000L;
    byte[] bitmap;
    int bitmapPos;
    int bitmapExtensionQuantum;
    long pageIndexSize;
    long pageIndexCheckpointThreshold;
    RandomAccessFile dataFile;
    RandomAccessFile pageIndexFile;
    RandomAccessFile pageIndexLogFile;
    FileChannel dataChan;
    FileChannel pageIndexChan;
    MappedByteBuffer pageIndexBuffer;
    PageMap pageMap;
    boolean noFlush;
    FileLock lck;

    public void write(long pageAddr, byte[] buf) {
        try {
            if (pageAddr != 0L) {
                Assert.that((pageAddr & 0xFFFL) == 0L);
                long pagePos = 0L;
                pagePos = this.pageMap.get(pageAddr);
                if (pagePos == 0L) {
                    byte[] posBuf = new byte[8];
                    this.pageIndexBuffer.position((int)(pageAddr >>> 9));
                    this.pageIndexBuffer.get(posBuf, 0, 8);
                    pagePos = Bytes.unpack8(posBuf, 0);
                } else {
                    Bitmap.free(this.bitmap, pagePos >>> 21, (pagePos & 0xFFFL) + 512L - 1L >>> 9);
                }
                byte[] compressedBuffer = this.compress(buf);
                int size = buf.length;
                if (compressedBuffer.length <= size - 512) {
                    size = compressedBuffer.length;
                    buf = new byte[size + 512 - 1 & 0xFFFFFE00];
                    System.arraycopy(compressedBuffer, 0, buf, 0, size);
                }
                long pageOffs = this.allocate(buf.length);
                this.dataFile.seek(pageOffs);
                this.dataFile.write(buf, 0, buf.length);
                this.pageMap.put(pageAddr, pageOffs << 12 | (long)size, pagePos);
            } else {
                this.dataFile.seek(0L);
                this.dataFile.write(buf, 0, buf.length);
            }
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public int read(long pageAddr, byte[] buf) {
        try {
            if (pageAddr != 0L) {
                Assert.that((pageAddr & 0xFFFL) == 0L);
                long pagePos = 0L;
                if (this.pageMap != null) {
                    pagePos = this.pageMap.get(pageAddr);
                }
                if (pagePos == 0L) {
                    byte[] posBuf = new byte[8];
                    this.pageIndexBuffer.position((int)(pageAddr >>> 9));
                    this.pageIndexBuffer.get(posBuf, 0, 8);
                    pagePos = Bytes.unpack8(posBuf, 0);
                    if (pagePos == 0L) {
                        return 0;
                    }
                }
                this.dataFile.seek(pagePos >>> 12);
                int size = (int)(pagePos & 0xFFFL);
                if (size < 4096) {
                    byte[] compressedBuffer = new byte[size];
                    int rc = this.dataFile.read(compressedBuffer, 0, size);
                    if (rc != size) {
                        throw new StorageError(3);
                    }
                    return this.decompress(compressedBuffer, buf);
                }
                return this.dataFile.read(buf, 0, buf.length);
            }
            this.dataFile.seek(0L);
            return this.dataFile.read(buf, 0, buf.length);
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public void sync() {
        try {
            int txSize;
            if (!this.noFlush) {
                this.dataFile.getFD().sync();
            }
            if ((txSize = this.pageMap.size()) == 0) {
                return;
            }
            byte[] buf = new byte[4 + 16 * txSize];
            Bytes.pack4(buf, 0, txSize);
            int pos = 4;
            for (PageMap.Entry e : this.pageMap) {
                Bytes.pack8(buf, pos, e.addr);
                Bytes.pack8(buf, pos + 8, e.newPos);
                pos += 16;
            }
            this.pageIndexLogFile.write(buf, 0, pos);
            if (!this.noFlush) {
                this.pageIndexLogFile.getFD().sync();
            }
            for (PageMap.Entry e : this.pageMap) {
                this.setPosition(e.addr);
                Bytes.pack8(buf, 0, e.newPos);
                this.pageIndexBuffer.put(buf, 0, 8);
                if (e.oldPos == 0L) continue;
                Bitmap.free(this.bitmap, e.oldPos >>> 21, (e.oldPos & 0xFFFL) + 512L - 1L >>> 9);
            }
            this.pageMap.clear();
            if (this.pageIndexLogFile.length() > this.pageIndexCheckpointThreshold) {
                this.pageIndexBuffer.force();
                this.pageIndexLogFile.setLength(0L);
            }
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public boolean tryLock(boolean shared) {
        try {
            this.lck = this.dataChan.tryLock(0L, Long.MAX_VALUE, shared);
            return this.lck != null;
        }
        catch (IOException x) {
            return true;
        }
    }

    public void lock(boolean shared) {
        try {
            this.lck = this.dataChan.lock(0L, Long.MAX_VALUE, shared);
        }
        catch (IOException x) {
            throw new StorageError(21, x);
        }
    }

    public void unlock() {
        try {
            this.lck.release();
        }
        catch (IOException x) {
            throw new StorageError(21, x);
        }
    }

    public void close() {
        try {
            this.dataChan.close();
            this.dataFile.close();
            if (this.pageIndexLogFile != null) {
                Assert.that(this.pageMap.size() == 0);
                this.pageIndexBuffer.force();
                this.pageIndexLogFile.setLength(0L);
                this.pageIndexLogFile.close();
            }
            this.pageIndexChan.close();
            this.pageIndexFile.close();
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public long length() {
        try {
            return this.dataChan.size();
        }
        catch (IOException x) {
            return -1L;
        }
    }

    public CompressedReadWriteFile(String dataFilePath) {
        this(dataFilePath, dataFilePath + ".map", dataFilePath + ".log", 0x800000L, 0x100000L, 0x100000L, false, false);
    }

    public CompressedReadWriteFile(String dataFilePath, String pageIndexFilePath, String pageIndexLogFilePath, long dataFileExtensionQuantum, long pageIndexCheckpointThreshold, long pageIndexInitSize, boolean readOnly, boolean noFlush) {
        this.pageIndexCheckpointThreshold = pageIndexCheckpointThreshold;
        this.noFlush = noFlush;
        try {
            this.dataFile = new RandomAccessFile(dataFilePath, readOnly ? "r" : "rw");
            this.dataChan = this.dataFile.getChannel();
            this.pageIndexFile = new RandomAccessFile(pageIndexFilePath, readOnly ? "r" : "rw");
            this.pageIndexChan = this.pageIndexFile.getChannel();
            long size = this.pageIndexChan.size();
            this.pageIndexSize = readOnly || size > pageIndexInitSize ? size : pageIndexInitSize;
            this.pageIndexBuffer = this.pageIndexChan.map(readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, this.pageIndexSize);
            if (!readOnly) {
                long pageMapSize = pageIndexInitSize / 8L;
                if (pageMapSize > 1000000L) {
                    pageMapSize = 1000000L;
                }
                this.pageMap = new PageMap((int)pageMapSize);
                this.pageIndexLogFile = new RandomAccessFile(pageIndexLogFilePath, "rw");
                this.performRecovery();
                this.bitmapExtensionQuantum = (int)(dataFileExtensionQuantum >>> 12);
                this.bitmap = new byte[(int)(this.dataChan.size() >>> 12) + this.bitmapExtensionQuantum];
                this.bitmapPos = 1;
                byte[] buf = new byte[8];
                size = this.pageIndexChan.size();
                this.pageIndexBuffer.position(0);
                while ((size -= 8L) >= 0L) {
                    this.pageIndexBuffer.get(buf, 0, 8);
                    long pagePos = Bytes.unpack8(buf, 0);
                    long pageBitOffs = pagePos >>> 21;
                    long pageBitSize = (pagePos & 0xFFFL) + 512L - 1L >>> 9;
                    Bitmap.reserve(this.bitmap, pageBitOffs, pageBitSize);
                }
            }
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    protected byte[] compress(byte[] buf) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(stream);
        out.write(buf, 0, buf.length);
        out.finish();
        return stream.toByteArray();
    }

    protected int decompress(byte[] src, byte[] dst) throws IOException {
        int rc;
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(src));
        int offs = 0;
        while ((rc = ((InputStream)in).read(dst, offs, dst.length - offs)) > 0) {
            offs += rc;
        }
        return offs;
    }

    long allocate(int size) {
        Assert.that((size & 0x1FF) == 0);
        int bitSize = size >>> 9;
        long pos = Bitmap.allocate(this.bitmap, this.bitmapPos, this.bitmap.length, bitSize);
        if (pos < 0L && (pos = Bitmap.allocate(this.bitmap, 1, Bitmap.locateHoleEnd(this.bitmap, this.bitmapPos), bitSize)) < 0L) {
            byte[] newBitmap = new byte[this.bitmap.length + this.bitmapExtensionQuantum];
            System.arraycopy(this.bitmap, 0, newBitmap, 0, this.bitmap.length);
            pos = Bitmap.allocate(newBitmap, Bitmap.locateBitmapEnd(newBitmap, this.bitmap.length), newBitmap.length, bitSize);
            Assert.that(pos >= 0L);
            this.bitmap = newBitmap;
        }
        this.bitmapPos = (int)(pos + (long)bitSize >>> 3);
        return pos << 9;
    }

    void setPosition(long addr) throws IOException {
        long pos = addr >>> 9;
        if (pos + 8L >= this.pageIndexSize) {
            do {
                this.pageIndexSize *= 2L;
            } while (pos + 8L >= this.pageIndexSize);
            this.pageIndexBuffer = this.pageIndexChan.map(FileChannel.MapMode.READ_WRITE, 0L, this.pageIndexSize);
        }
        this.pageIndexBuffer.position((int)pos);
    }

    void performRecovery() throws IOException {
        int nPages;
        byte[] buf;
        int rc;
        byte[] hdr = new byte[4];
        while ((rc = this.pageIndexLogFile.read(hdr, 0, 4)) == 4 && this.pageIndexLogFile.read(buf = new byte[(nPages = Bytes.unpack4(hdr, 0)) * 16], 0, buf.length) == buf.length) {
            for (int i = 0; i < nPages; ++i) {
                this.setPosition(Bytes.unpack8(buf, i * 16));
                this.pageIndexBuffer.put(buf, i * 16 + 8, 8);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PageMap
    implements Iterable<Entry> {
        static final float LOAD_FACTOR = 0.75f;
        static final int[] primeNumbers = new int[]{17, 37, 79, 163, 331, 673, 1361, 2729, 5471, 10949, 21911, 43853, 87719, 175447, 350899, 701819, 1403641, 2807303, 5614657, 11229331, 22458671, 44917381, 89834777, 179669557, 359339171, 718678369, 1437356741, Integer.MAX_VALUE};
        Entry[] table;
        int count;
        int tableSizePrime = 0;
        int tableSize;
        int threshold;

        public PageMap(int initialCapacity) {
            while (primeNumbers[this.tableSizePrime] < initialCapacity) {
                ++this.tableSizePrime;
            }
            this.tableSize = primeNumbers[this.tableSizePrime];
            this.threshold = (int)((float)this.tableSize * 0.75f);
            this.table = new Entry[this.tableSize];
        }

        public void put(long addr, long newPos, long oldPos) {
            Entry[] tab = this.table;
            int index = (int)((addr >>> 12) % (long)this.tableSize);
            Entry e = tab[index];
            while (e != null) {
                if (e.addr == addr) {
                    e.newPos = newPos;
                    return;
                }
                e = e.next;
            }
            if (this.count >= this.threshold) {
                this.rehash();
                tab = this.table;
                index = (int)((addr >>> 12) % (long)this.tableSize);
            }
            tab[index] = new Entry(addr, newPos, oldPos, tab[index]);
            ++this.count;
        }

        public long get(long addr) {
            int index = (int)((addr >>> 12) % (long)this.tableSize);
            Entry e = this.table[index];
            while (e != null) {
                if (e.addr == addr) {
                    return e.newPos;
                }
                e = e.next;
            }
            return 0L;
        }

        public void clear() {
            Entry[] tab = this.table;
            int size = this.tableSize;
            for (int i = 0; i < size; ++i) {
                tab[i] = null;
            }
            this.count = 0;
        }

        void rehash() {
            int oldCapacity = this.tableSize;
            int newCapacity = this.tableSize = primeNumbers[++this.tableSizePrime];
            Entry[] oldMap = this.table;
            Entry[] newMap = new Entry[newCapacity];
            this.threshold = (int)((float)newCapacity * 0.75f);
            this.table = newMap;
            this.tableSize = newCapacity;
            for (int i = 0; i < oldCapacity; ++i) {
                Entry old = oldMap[i];
                while (old != null) {
                    Entry e = old;
                    old = old.next;
                    int index = (int)((e.addr >>> 12) % (long)newCapacity);
                    e.next = newMap[index];
                    newMap[index] = e;
                }
            }
        }

        @Override
        public Iterator<Entry> iterator() {
            return new PageMapIterator();
        }

        public int size() {
            return this.count;
        }

        static class Entry {
            Entry next;
            long addr;
            long newPos;
            long oldPos;

            Entry(long addr, long newPos, long oldPos, Entry chain) {
                this.next = chain;
                this.addr = addr;
                this.newPos = newPos;
                this.oldPos = oldPos;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PageMapIterator
        implements Iterator<Entry> {
            Entry curr;
            int i;

            PageMapIterator() {
                this.moveForward();
            }

            @Override
            public boolean hasNext() {
                return this.curr != null;
            }

            @Override
            public Entry next() {
                Entry e = this.curr;
                if (e == null) {
                    throw new NoSuchElementException();
                }
                this.moveForward();
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void moveForward() {
                if (this.curr != null) {
                    this.curr = this.curr.next;
                }
                while (this.curr == null && this.i < PageMap.this.tableSize) {
                    this.curr = PageMap.this.table[this.i++];
                }
            }
        }
    }
}

