/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.io.DataNotValidIOException;
import freenet.support.io.DiscontinueInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VerifyingInputStream
extends DiscontinueInputStream {
    protected long dataLength;
    protected long bytesRead;
    protected boolean finished = false;
    protected boolean stripControls = false;
    protected boolean allRead = false;

    public VerifyingInputStream(InputStream in, long dataLength) {
        super(in);
        this.dataLength = dataLength;
    }

    public void stripControls(boolean stripControls) {
        this.stripControls = stripControls;
    }

    public int read() throws IOException, DataNotValidIOException {
        if (this.finished) {
            return -1;
        }
        int ret = this.in.read();
        if (ret != -1) {
            ++this.bytesRead;
            if (this.bytesRead == this.dataLength) {
                this.finished = true;
            } else if (this.bytesRead == this.dataLength - 1L) {
                this.allRead = true;
            }
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException, DataNotValidIOException {
        int ret;
        if (this.finished) {
            return -1;
        }
        if (this.allRead) {
            int i = this.read();
            if (i == -1) {
                return -1;
            }
            b[off] = (byte)i;
            return 1;
        }
        if ((long)len > this.dataLength - this.bytesRead - 1L) {
            len = (int)(this.dataLength - this.bytesRead - 1L);
        }
        if ((ret = this.in.read(b, off, len)) != -1) {
            this.bytesRead += (long)ret;
            if (this.bytesRead == this.dataLength - 1L) {
                this.allRead = true;
            }
        }
        return ret;
    }

    public int available() throws IOException {
        int n = super.available();
        return this.allRead ? (n == 0 ? 0 : 1) : (int)Math.min((long)n, this.stripControls ? this.dataLength - this.bytesRead - 1L : this.dataLength - this.bytesRead);
    }

    public void discontinue() throws IOException {
        if (this.in instanceof DiscontinueInputStream) {
            ((DiscontinueInputStream)this.in).discontinue();
        } else {
            this.close();
        }
    }
}

