/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class ReadInputStream
extends FilterInputStream {
    public static int MAX_LENGTH = 4096;

    public static void main(String[] args) throws Throwable {
        int i;
        FileInputStream is = new FileInputStream(args[0]);
        ReadInputStream mr = new ReadInputStream(is);
        System.out.print((char)mr.read());
        System.out.print((char)((InputStream)is).read());
        for (i = 0; i < 9; ++i) {
            System.out.println(mr.readTo('\n', '\r'));
        }
        for (i = 0; i < 20; ++i) {
            System.out.print((char)((InputStream)is).read());
        }
    }

    public ReadInputStream(InputStream i) {
        super(i);
    }

    public String readln() throws IOException, EOFException {
        return this.readTo('\n', '\r');
    }

    public String readTo(char ends) throws IOException, EOFException {
        StringBuffer tmp = new StringBuffer();
        char r = ' ';
        int read = 0;
        while (true) {
            try {
                r = this.readUTF();
                ++read;
            }
            catch (EOFException e) {
                throw new EOFException(tmp.toString());
            }
            if (r == '\uffffffff') {
                throw new EOFException(tmp.toString());
            }
            if (r == ends) break;
            if (read > MAX_LENGTH) {
                throw new IOException(tmp.toString());
            }
            tmp.append(r);
        }
        return tmp.toString();
    }

    public String readTo(char ends, char ignore) throws IOException, EOFException {
        String s = this.readTo(ends);
        return s.length() > 0 && s.charAt(s.length() - 1) == ignore ? s.substring(0, s.length() - 1) : s;
    }

    public String readToEOF(char ends) throws IOException, EOFException {
        StringBuffer tmp = new StringBuffer(26);
        char r = ' ';
        int read = 0;
        while (true) {
            try {
                r = this.readUTF();
                ++read;
            }
            catch (EOFException e) {
                if (tmp.length() > 0) {
                    return tmp.toString();
                }
                throw e;
            }
            if (r == '\uffffffff') {
                if (tmp.length() > 0) {
                    return tmp.toString();
                }
                throw new EOFException();
            }
            if (r == ends) break;
            if (read > MAX_LENGTH) {
                if (tmp.length() > 0) {
                    return tmp.toString();
                }
                throw new EOFException();
            }
            tmp.append(r);
        }
        return tmp.toString();
    }

    public String readToEOF(char ends, char ignore) throws IOException, EOFException {
        String s = this.readToEOF(ends);
        return s.length() > 0 && s.charAt(s.length() - 1) == ignore ? s.substring(0, s.length() - 1) : s;
    }

    public char readUTF() throws EOFException, IOException {
        int val;
        int b = this.in.read();
        if (b == -1) {
            throw new EOFException();
        }
        if ((b & 0xE0) == 224) {
            val = (b & 0xF) << 12;
            b = this.in.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0x80) != 128) {
                throw new UTFDataFormatException("Bad encoding");
            }
            val |= (b & 0x3F) << 6;
            b = this.in.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0x80) != 128) {
                throw new UTFDataFormatException("Bad encoding");
            }
            val |= b & 0x3F;
        } else if ((b & 0xC0) == 192) {
            val = (b & 0x1F) << 6;
            b = this.in.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0x80) != 128) {
                throw new UTFDataFormatException("Bad encoding");
            }
            val |= b & 0x3F;
        } else if (b < 128) {
            val = b;
        } else {
            throw new UTFDataFormatException("Bad encoding");
        }
        return (char)val;
    }
}

