/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.Digest;
import freenet.crypt.JavaSHA1;
import freenet.crypt.SHA1;
import freenet.crypt.ciphers.Rijndael;
import freenet.crypt.ciphers.Twofish;
import freenet.support.Bucket;
import freenet.support.Fields;
import freenet.support.Loader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private static Logger logger = Logger.getLogger(Util.class.getName());
    protected static final int BUFFER_SIZE = 32768;
    public static final BigInteger ONE;
    public static final BigInteger ZERO;
    public static final BigInteger TWO;
    private static Digest ctx;
    public static byte[] ZERO_ARRAY;

    public static byte[] stringToBytes(String s) throws NumberFormatException {
        char[] c = s.toCharArray();
        byte[] bytes = new byte[c.length * 2];
        for (int i = 0; i < c.length; ++i) {
            bytes[i * 2] = (byte)(c[i] >> 8 & 0xFF);
            bytes[i * 2 + 1] = (byte)c[i];
        }
        return bytes;
    }

    public static byte[] hexToBytes(String s) throws NumberFormatException {
        if (s.length() % 2 != 0) {
            s = "0" + s;
        }
        byte[] out = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); ++i) {
            char c = Character.toLowerCase(s.charAt(i));
            if (!(c >= 'a' && c <= 'f' || c >= '0' && c <= '9')) {
                throw new NumberFormatException();
            }
            byte b = (byte)(c >= 'a' && c <= 'f' ? c - 97 + 10 : c - 48);
            if (i % 2 == 0) {
                out[i / 2] = (byte)(b << 4);
                continue;
            }
            out[(i - 1) / 2] = (byte)(out[(i - 1) / 2] | b);
        }
        return out;
    }

    public static void fillByteArrayFromInts(int[] ints, byte[] bytes) {
        int ic = 0;
        for (int i = 0; i < ints.length; ++i) {
            bytes[ic++] = (byte)(ints[i] >> 24);
            bytes[ic++] = (byte)(ints[i] >> 16);
            bytes[ic++] = (byte)(ints[i] >> 8);
            bytes[ic++] = (byte)ints[i];
        }
    }

    public static void fillByteArrayFromLongs(long[] ints, byte[] bytes) {
        int ic = 0;
        for (int i = 0; i < ints.length; ++i) {
            bytes[ic++] = (byte)(ints[i] >> 56);
            bytes[ic++] = (byte)(ints[i] >> 48);
            bytes[ic++] = (byte)(ints[i] >> 40);
            bytes[ic++] = (byte)(ints[i] >> 32);
            bytes[ic++] = (byte)(ints[i] >> 24);
            bytes[ic++] = (byte)(ints[i] >> 16);
            bytes[ic++] = (byte)(ints[i] >> 8);
            bytes[ic++] = (byte)ints[i];
        }
    }

    public static void fillIntArrayFromBytes(byte[] bytes, int[] ints) {
        int ic = 0;
        for (int i = 0; i < ints.length << 2; i += 4) {
            ints[ic++] = bytes[i] + bytes[i + 1] << 8 + bytes[i + 2] << 16 + bytes[i + 3] << 24;
        }
    }

    public static void fillLongArrayFromBytes(byte[] bytes, long[] longs) {
        int ic = 0;
        for (int i = 0; i < longs.length << 3; i += 8) {
            longs[ic++] = (long)bytes[i] + ((long)bytes[i + 1] << 8) + ((long)bytes[i + 2] << 16) + ((long)bytes[i + 3] << 24) + ((long)bytes[i + 4] << 32) + ((long)bytes[i + 5] << 40) + ((long)bytes[i + 6] << 48) + ((long)bytes[i + 7] << 56);
        }
    }

    public static boolean byteArrayEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        return Util.byteArrayEqual(a, b, 0, a.length);
    }

    public static boolean byteArrayEqual(byte[] a, byte[] b, int offset, int length) {
        int lim = offset + length;
        if (a.length < lim || b.length < lim) {
            return false;
        }
        for (int i = offset; i < lim; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] MPIbytes(BigInteger num) {
        int len = num.bitLength();
        byte[] bytes = new byte[2 + (len + 8 >> 3)];
        System.arraycopy(num.toByteArray(), 0, bytes, 2, bytes.length - 2);
        bytes[0] = (byte)(len >> 8);
        bytes[1] = (byte)len;
        return bytes;
    }

    public static void writeMPI(BigInteger num, OutputStream out) throws IOException {
        out.write(Util.MPIbytes(num));
    }

    public static BigInteger readMPI(InputStream in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        if (b1 == -1 || b2 == -1) {
            throw new EOFException();
        }
        byte[] data = new byte[(b1 << 8) + b2 + 8 >> 3];
        Util.readFully(in, data, 0, data.length);
        return new BigInteger(data);
    }

    public static BigInteger generateLargeRandom(int lowerBound, int upperBound, Random r) {
        int bl;
        if (lowerBound == upperBound) {
            return new BigInteger(lowerBound, r);
        }
        while ((bl = (r.nextInt() & Integer.MAX_VALUE) % upperBound) < lowerBound) {
        }
        BigInteger b = new BigInteger(bl, r);
        return b;
    }

    public static BigInteger byteArrayToMPI(byte[] num) {
        return new BigInteger(1, num);
    }

    public static byte[] hashBytes(Digest d, byte[] b) {
        return Util.hashBytes(d, b, 0, b.length);
    }

    public static byte[] hashBytes(Digest d, byte[] b, int offset, int length) {
        d.update(b, offset, length);
        return d.digest();
    }

    public static byte[] hashString(Digest d, String s) {
        try {
            byte[] sbytes = s.getBytes("UTF8");
            d.update(sbytes, 0, sbytes.length);
            return d.digest();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in hashString(Digest d, String s)", e);
            return null;
        }
    }

    public static byte[] hashFile(Digest d, File f) throws IOException, FileNotFoundException {
        byte[] buffer = new byte[65536];
        FileInputStream in = new FileInputStream(f);
        int rc = 0;
        do {
            if ((rc = in.read(buffer)) <= 0) continue;
            d.update(buffer, 0, rc);
        } while (rc != -1);
        return d.digest();
    }

    public static byte[] hashStream(Digest d, InputStream in, long len) throws IOException {
        byte[] buffer = new byte[65536];
        int rc = 0;
        do {
            int nBytes;
            if ((rc = in.read(buffer, 0, nBytes = len > 65536L ? 65536 : (int)len)) <= 0) continue;
            d.update(buffer, 0, rc);
        } while (rc != -1 && (len -= (long)rc) > 0L);
        return d.digest();
    }

    public static byte[] xor(byte[] b1, byte[] b2) {
        int minl = Math.min(b1.length, b2.length);
        int maxl = Math.max(b1.length, b2.length);
        byte[] rv = new byte[maxl];
        for (int i = 0; i < minl; ++i) {
            rv[i] = (byte)(b1[i] ^ b2[i]);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeKey(byte[] entropy, byte[] key, int offset, int len) {
        Digest digest = ctx;
        synchronized (digest) {
            ctx.digest();
            int ic = 0;
            while (len > 0) {
                int bc;
                ++ic;
                for (int i = 0; i < ic; ++i) {
                    ctx.update((byte)0);
                }
                ctx.update(entropy, 0, entropy.length);
                if (len > 20) {
                    ctx.digest(true, key, offset);
                    bc = 20;
                } else {
                    byte[] hash = ctx.digest();
                    bc = Math.min(len, hash.length);
                    System.arraycopy(hash, 0, key, offset, bc);
                }
                offset += bc;
                len -= bc;
            }
        }
        Util.wipe(entropy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeKey(Bucket entropy, byte[] key, int offset, int len) throws IOException {
        byte[] buffer = new byte[32768];
        Digest digest = ctx;
        synchronized (digest) {
            ctx.digest();
            int ic = 0;
            while (len > 0) {
                int bc;
                int i;
                ++ic;
                for (i = 0; i < ic; ++i) {
                    ctx.update((byte)0);
                }
                InputStream in = entropy.getInputStream();
                i = 0;
                while ((i = in.read(buffer)) > 0) {
                    ctx.update(buffer, 0, buffer.length);
                }
                in.close();
                if (len > ctx.digestSize() >> 3) {
                    ctx.digest(true, key, offset);
                    bc = ctx.digestSize() >> 3;
                } else {
                    byte[] hash = ctx.digest();
                    bc = Math.min(len, hash.length);
                    System.arraycopy(hash, 0, key, offset, bc);
                }
                offset += bc;
                len -= bc;
            }
        }
        Util.wipe(buffer);
    }

    public static BlockCipher getCipherByName(String name) {
        try {
            return (BlockCipher)Loader.getInstance("freenet.crypt.ciphers." + name);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in getCipherByName(String name)", e);
            return null;
        }
    }

    public static BlockCipher getCipherByName(String name, int keySize) {
        try {
            return (BlockCipher)Loader.getInstance("freenet.crypt.ciphers." + name, new Class[]{Integer.class}, new Object[]{new Integer(keySize)});
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in getCipherByName(String name, int keySize)", e);
            return null;
        }
    }

    public static Digest getDigestByName(String name) {
        try {
            return (Digest)Loader.getInstance("freenet.crypt." + name);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in getDigestByName(String name)", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("write")) {
            Util.writeMPI(new BigInteger("9"), System.out);
            Util.writeMPI(new BigInteger("1234567890123456789"), System.out);
            Util.writeMPI(new BigInteger("100200300400500600700800900"), System.out);
        } else if (args[0].equals("read")) {
            System.out.println("9");
            System.out.println(Util.readMPI(System.in));
            System.out.println("1234567890123456789");
            System.out.println(Util.readMPI(System.in));
            System.out.println("100200300400500600700800900");
            System.out.println(Util.readMPI(System.in));
        } else if (args[0].equals("write-mpi")) {
            Util.writeMPI(new BigInteger(args[1]), System.out);
        } else if (args[0].equals("read-mpi")) {
            System.err.println(Util.readMPI(System.in));
        } else if (args[0].equals("keygen")) {
            byte[] entropy = Util.readMPI(System.in).toByteArray();
            byte[] key = new byte[args.length > 1 ? Integer.parseInt(args[1]) : 16];
            Util.makeKey(entropy, key, 0, key.length);
            System.err.println(Fields.bytesToHex(key, 0, key.length));
        } else if (args[0].equals("shatest")) {
            Digest digest = ctx;
            synchronized (digest) {
                ctx.digest();
                ctx.update((byte)97);
                ctx.update((byte)98);
                ctx.update((byte)99);
                byte[] hash = ctx.digest();
                System.err.println(Fields.bytesToHex(hash, 0, hash.length));
            }
        }
    }

    public static void wipe(byte[] data) {
        System.arraycopy(ZERO_ARRAY, 0, data, 0, data.length);
    }

    public static int log2(long n) {
        int log2;
        for (log2 = 0; log2 < 63 && (long)(1 << log2) < n; ++log2) {
        }
        return log2;
    }

    public static void rollingHashPad(OutputStream out, long paddingLen, SHA1 ctx) throws IOException {
        byte[] hashbuf = new byte[ctx.digestSize() >> 3];
        ByteArrayOutputStream pad = new ByteArrayOutputStream();
        while (paddingLen > 0L) {
            ctx.digest(false, hashbuf, 0);
            ctx.update(hashbuf, 0, hashbuf.length);
            pad.write(hashbuf, 0, hashbuf.length);
            if (paddingLen < (long)pad.size()) {
                byte[] tmp = pad.toByteArray();
                out.write(tmp, 0, (int)paddingLen);
                paddingLen = 0L;
                continue;
            }
            pad.writeTo(out);
            paddingLen -= (long)pad.size();
        }
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        Util.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int length) throws IOException {
        int got;
        for (int total = 0; total < length; total += got) {
            got = in.read(b, off + total, length - total);
            if (got != -1) continue;
            throw new EOFException();
        }
    }

    static {
        SHA1.class.toString();
        JavaSHA1.class.toString();
        Twofish.class.toString();
        Rijndael.class.toString();
        ONE = BigInteger.valueOf(1L);
        ZERO = BigInteger.valueOf(0L);
        TWO = BigInteger.valueOf(2L);
        ctx = SHA1.getInstance();
        ZERO_ARRAY = new byte[16384];
    }
}

