/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Digest;
import freenet.crypt.ProgressiveHashOutputStream;
import freenet.crypt.SHA1;
import freenet.crypt.SHA1Factory;
import freenet.crypt.Util;
import freenet.support.Bucket;
import freenet.support.FileBucket;
import freenet.support.io.DataNotValidIOException;
import freenet.support.io.VerifyingInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressiveHashInputStream
extends VerifyingInputStream {
    private long partSize;
    private long pos = 0L;
    private Digest ctx;
    private int ds;
    private byte[] expectedHash;
    private byte[] controlBuf;
    private DataNotValidIOException dnv;

    public static void main(String[] args) throws Exception {
        int n;
        File data = new File(args[0]);
        FileInputStream fin = new FileInputStream(data);
        long partSize = Long.parseLong(args[1]);
        ProgressiveHashOutputStream hout = new ProgressiveHashOutputStream(partSize, new SHA1Factory(), (Bucket)new FileBucket());
        byte[] buf = new byte[4096];
        for (long left = data.length(); left > 0L; left -= (long)n) {
            n = fin.read(buf, 0, (int)Math.min(left, (long)buf.length));
            if (n == -1) {
                throw new EOFException("EOF while reading input file");
            }
            hout.write(buf, 0, n);
        }
        hout.close();
        byte[] init = hout.getInitialDigest();
        for (int i = 0; i < init.length; ++i) {
            System.err.print((init[i] & 0xFF) + " ");
        }
        long totalLength = hout.getLength();
        System.err.println();
        System.err.println("TotalLength = " + totalLength);
        InputStream in = hout.getInputStream();
        ProgressiveHashInputStream vin = new ProgressiveHashInputStream(in, partSize, totalLength, SHA1.getInstance(), init);
        vin.stripControls(args.length < 3 || Integer.parseInt(args[2]) == 0);
        int i = vin.read(buf);
        while (i > 0) {
            System.out.write(buf, 0, i);
            i = vin.read(buf);
        }
    }

    public ProgressiveHashInputStream(InputStream in, long partSize, long dataLength, Digest ctx, byte[] initialDigest) throws DataNotValidIOException {
        super(in, dataLength);
        this.ds = ctx.digestSize() >> 3;
        int parts = (int)(dataLength / (partSize + (long)this.ds + 1L));
        long lastPart = dataLength - (long)parts * (partSize + (long)this.ds + 1L);
        if (dataLength < 2L || lastPart < 2L || partSize <= 0L || partSize > dataLength - 1L || lastPart > partSize + 1L) {
            throw new DataNotValidIOException(132);
        }
        this.partSize = partSize;
        this.ctx = ctx;
        this.expectedHash = new byte[this.ds];
        this.controlBuf = new byte[this.ds + 1];
        System.arraycopy(initialDigest, 0, this.expectedHash, 0, this.ds);
    }

    public int read() throws DataNotValidIOException, IOException {
        if (this.dnv != null) {
            throw this.dnv;
        }
        if (this.pos < 0L) {
            return this.controlBuf[this.controlBuf.length + (int)this.pos] & 0xFF;
        }
        int b = super.read();
        if (b == -1) {
            return -1;
        }
        this.ctx.update((byte)b);
        ++this.pos;
        if (this.pos == this.partSize || this.allRead) {
            this.readControlBytes();
        }
        return b;
    }

    public int read(byte[] buf, int off, int len) throws DataNotValidIOException, IOException {
        if (this.dnv != null) {
            throw this.dnv;
        }
        if (len <= 0) {
            return 0;
        }
        if (this.pos < 0L) {
            int n = Math.min(len, 0 - (int)this.pos);
            System.arraycopy(this.controlBuf, this.controlBuf.length + (int)this.pos, buf, off, n);
            this.pos += (long)n;
            return n;
        }
        int n = super.read(buf, off, len = (int)Math.min((long)len, this.partSize - this.pos));
        if (n == -1) {
            return -1;
        }
        this.ctx.update(buf, off, n);
        this.pos += (long)n;
        if (this.pos == this.partSize || this.allRead) {
            this.readControlBytes();
        }
        return n;
    }

    private void readControlBytes() throws DataNotValidIOException, IOException {
        int togo;
        this.pos = this.stripControls ? 0 : 0 - togo;
        int b = 0;
        for (togo = this.allRead ? 1 : this.ds + 1; togo > 0; --togo) {
            b = super.read();
            if (b == -1) {
                throw new EOFException("EOF while reading control bytes");
            }
            this.controlBuf[this.controlBuf.length - togo] = (byte)b;
            if (togo == 1) continue;
            this.ctx.update((byte)b);
        }
        if (b != 0 || !Util.byteArrayEqual(this.ctx.digest(), this.expectedHash)) {
            this.dnv = new DataNotValidIOException(b == 0 ? 129 : b);
            throw this.dnv;
        }
        System.arraycopy(this.controlBuf, 0, this.expectedHash, 0, this.ds);
    }

    public void finish() throws DataNotValidIOException, IOException {
        this.finished = true;
    }
}

