/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.PCFBMode;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncipherInputStream
extends FilterInputStream {
    protected PCFBMode ctx;

    public EncipherInputStream(InputStream in, BlockCipher c) {
        this(in, new PCFBMode(c));
    }

    public EncipherInputStream(InputStream in, BlockCipher c, int bufSize) {
        this(bufSize == 0 ? in : new BufferedInputStream(in, bufSize), c);
    }

    public EncipherInputStream(InputStream in, PCFBMode ctx) {
        super(in);
        this.ctx = ctx;
    }

    public EncipherInputStream(InputStream in, PCFBMode ctx, int bufSize) {
        this(bufSize == 0 ? in : new BufferedInputStream(in, bufSize), ctx);
    }

    public int read() throws IOException {
        int rv = this.in.read();
        return rv == -1 ? -1 : this.ctx.encipher(rv);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int rv = this.in.read(b, off, len);
        if (rv != -1) {
            this.ctx.blockEncipher(b, off, rv);
        }
        return rv;
    }
}

