/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoElement;
import freenet.crypt.Digest;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.support.Fields;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CryptoKey
implements CryptoElement,
Serializable {
    protected static final Digest shactx = SHA1.getInstance();
    private static Logger logger = Logger.getLogger(CryptoKey.class.getName());

    CryptoKey() {
    }

    public static CryptoKey read(InputStream i) throws IOException {
        DataInputStream dis = new DataInputStream(i);
        String type = dis.readUTF();
        try {
            Class<?> keyClass = Class.forName(type);
            Method m = keyClass.getMethod("read", InputStream.class);
            CryptoKey k = null;
            k = (CryptoKey)m.invoke(null, dis);
            return k;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in read(InputStream i)", e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            return null;
        }
    }

    public abstract void write(OutputStream var1) throws IOException;

    public abstract String keyType();

    public abstract byte[] fingerprint();

    public abstract byte[] asBytes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] fingerprint(BigInteger[] quantities) {
        Digest digest = shactx;
        synchronized (digest) {
            for (int i = 0; i < quantities.length; ++i) {
                byte[] mpi = Util.MPIbytes(quantities[i]);
                shactx.update(mpi, 0, mpi.length);
            }
            return shactx.digest();
        }
    }

    public String verboseToString() {
        StringBuffer b = new StringBuffer();
        b.append(this.toString()).append('\t').append(this.fingerprintToString());
        return b.toString();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.keyType()).append('/');
        b.append(Fields.bytesToHex(this.fingerprint(), 16, 4));
        return b.toString();
    }

    protected DataOutputStream write(OutputStream o, String clazz) throws IOException {
        DataOutputStream dos = new DataOutputStream(o);
        dos.writeUTF(clazz);
        return dos;
    }

    public String fingerprintToString() {
        byte[] fingerprint = this.fingerprint();
        String fphex = Fields.bytesToHex(fingerprint, 0, fingerprint.length);
        StringBuffer b = new StringBuffer();
        b.append(fphex.substring(0, 4)).append(' ');
        b.append(fphex.substring(4, 8)).append(' ');
        b.append(fphex.substring(8, 12)).append(' ');
        b.append(fphex.substring(12, 16)).append(' ');
        b.append(fphex.substring(16, 20)).append("  ");
        b.append(fphex.substring(20, 24)).append(' ');
        b.append(fphex.substring(24, 28)).append(' ');
        b.append(fphex.substring(28, 32)).append(' ');
        b.append(fphex.substring(32, 36)).append(' ');
        b.append(fphex.substring(36, 40));
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        while (true) {
            CryptoKey kp = CryptoKey.read(System.in);
            System.err.println("-+ " + kp.verboseToString());
        }
    }
}

