/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.FieldSet;
import freenet.client.Base64;
import freenet.client.IllegalBase64Exception;
import freenet.support.Fields;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class FreenetURI {
    private static Logger logger = Logger.getLogger(FreenetURI.class.getName());
    private String keyType;
    private String docName;
    private String[] metaStr;
    private byte[] routingKey;
    private byte[] cryptoKey;
    private FieldSet metaInfo;

    public FreenetURI(String keyType, String docName) {
        this(keyType, docName, (String[])null, null, null, null);
    }

    public FreenetURI(String keyType, String docName, byte[] routingKey, byte[] cryptoKey) {
        this(keyType, docName, (String[])null, null, routingKey, cryptoKey);
    }

    public FreenetURI(String keyType, String docName, String metaStr, FieldSet metaInfo, byte[] routingKey, byte[] cryptoKey) {
        String[] stringArray;
        if (metaStr == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = metaStr;
        }
        this(keyType, docName, stringArray, metaInfo, routingKey, cryptoKey);
    }

    public FreenetURI(String keyType, String docName, String[] metaStr, FieldSet metaInfo, byte[] routingKey, byte[] cryptoKey) {
        this.keyType = keyType.trim().toUpperCase();
        this.docName = docName;
        this.metaStr = metaStr;
        this.metaInfo = metaInfo;
        this.routingKey = routingKey;
        this.cryptoKey = cryptoKey;
    }

    public FreenetURI(String URI) throws MalformedURLException {
        int slash2;
        int colon = URI.indexOf(58);
        if (colon != -1 && !URI.substring(0, colon).equalsIgnoreCase("freenet")) {
            throw new MalformedURLException("Invalid scheme for Freenet URI");
        }
        int atchar = URI.indexOf(64);
        if (atchar == -1) {
            this.keyType = "KSK";
            atchar = colon;
        } else {
            this.keyType = URI.substring(colon + 1, atchar).toUpperCase().trim();
        }
        URI = URI.substring(atchar + 1);
        Vector<String> sv = new Vector<String>();
        while ((slash2 = URI.lastIndexOf("//")) != -1) {
            String s = FreenetURI.urlDecode(URI.substring(slash2 + "//".length()));
            if (s != null) {
                sv.addElement(FreenetURI.urlDecode(s));
            }
            URI = URI.substring(0, slash2);
        }
        if (!sv.isEmpty()) {
            this.metaStr = new String[sv.size()];
            for (int i = 0; i < this.metaStr.length; ++i) {
                this.metaStr[i] = (String)sv.elementAt(this.metaStr.length - 1 - i);
            }
        }
        if ("KSK".equals(this.keyType)) {
            this.docName = FreenetURI.urlDecode(URI);
            return;
        }
        int slash1 = URI.indexOf(47);
        if (slash1 != -1) {
            this.docName = FreenetURI.urlDecode(URI.substring(slash1 + 1));
            URI = URI.substring(0, slash1);
        }
        StringTokenizer st = new StringTokenizer(URI, ",");
        try {
            this.routingKey = Base64.decode(st.nextToken());
            String t = st.nextToken();
            if (t.indexOf(61) == -1) {
                this.cryptoKey = Base64.decode(t);
                t = st.nextToken();
            }
            this.metaInfo = new FieldSet();
            while (true) {
                int eq;
                if ((eq = t.indexOf(61)) == -1) {
                    throw new MalformedURLException("URI meta-info must be of the form n1=v1[,n2=v2,...]");
                }
                String k = FreenetURI.urlDecode(t.substring(0, eq));
                String v = FreenetURI.urlDecode(t.substring(eq + 1));
                this.metaInfo.put(k, v);
                t = st.nextToken();
            }
        }
        catch (NoSuchElementException e) {
            if (this.metaInfo != null && this.metaInfo.isEmpty()) {
                this.metaInfo = null;
            }
        }
        catch (IllegalBase64Exception e) {
            try {
                throw new MalformedURLException("Invalid Base64 quantity: " + e);
            }
            catch (Throwable throwable) {
                if (this.metaInfo != null && this.metaInfo.isEmpty()) {
                    this.metaInfo = null;
                }
                throw throwable;
            }
        }
    }

    public void decompose() {
        String r = this.routingKey == null ? "none" : Fields.bytesToHex(this.routingKey, 0, this.routingKey.length);
        String k = this.cryptoKey == null ? "none" : Fields.bytesToHex(this.cryptoKey, 0, this.cryptoKey.length);
        StringBuffer message = new StringBuffer(this + "\n" + "Key type   : " + this.keyType + "\n" + "Routing key: " + r + "\n" + "Crypto key : " + k + "\n" + "Doc name   : " + (this.docName == null ? "none" : this.docName) + "\n" + "Meta strings:");
        if (this.metaStr == null) {
            message.append("none\n");
        } else {
            for (int i = 0; i < this.metaStr.length; ++i) {
                message.append(this.metaStr[i]);
                if (i == this.metaStr.length - 1) {
                    message.append("\n");
                    continue;
                }
                message.append(", ");
            }
        }
        message.append("Meta info  : " + (this.metaInfo == null ? "none" : "" + this.metaInfo));
        logger.fine(message.toString());
    }

    public String getGuessableKey() {
        return this.getDocName();
    }

    public String getDocName() {
        return this.docName;
    }

    public String getMetaString() {
        return this.metaStr == null || this.metaStr.length == 0 ? null : this.metaStr[0];
    }

    public String[] getAllMetaStrings() {
        return this.metaStr;
    }

    public FieldSet getMetaInfo() {
        return this.metaInfo;
    }

    public byte[] getKeyVal() {
        return this.getRoutingKey();
    }

    public byte[] getRoutingKey() {
        return this.routingKey;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKey;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public FreenetURI popMetaString() {
        String[] newMetaStr = null;
        if (this.metaStr != null && this.metaStr.length > 1) {
            newMetaStr = new String[this.metaStr.length - 1];
            System.arraycopy(this.metaStr, 1, newMetaStr, 0, newMetaStr.length);
        }
        return this.setMetaString(newMetaStr);
    }

    public FreenetURI addMetaStrings(String[] strs) {
        if (this.metaStr == null) {
            return this.setMetaString(strs);
        }
        String[] newMetaStr = new String[this.metaStr.length + strs.length];
        System.arraycopy(this.metaStr, 0, newMetaStr, 0, this.metaStr.length);
        System.arraycopy(strs, 0, newMetaStr, this.metaStr.length, strs.length);
        return this.setMetaString(strs);
    }

    public FreenetURI setDocName(String name) {
        return new FreenetURI(this.keyType, name, this.metaStr, this.metaInfo, this.routingKey, this.cryptoKey);
    }

    public FreenetURI setMetaString(String[] newMetaStr) {
        return new FreenetURI(this.keyType, this.docName, newMetaStr, this.metaInfo, this.routingKey, this.cryptoKey);
    }

    protected static String urlDecode(String s) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '+') {
                b.append(' ');
                continue;
            }
            if (s.charAt(i) == '%') {
                int n = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                b.append((char)n);
                i += 2;
                continue;
            }
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    protected static String urlEncode(String s) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') {
                b.append('+');
                continue;
            }
            if (s.charAt(i) > '\u0080' || s.charAt(i) < ',') {
                b.append('%').append(Integer.toString(s.charAt(i), 16));
                continue;
            }
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean prefix) {
        StringBuffer b = prefix ? new StringBuffer("freenet:") : new StringBuffer();
        b.append(this.keyType);
        b.append('@');
        if (!"KSK".equals(this.keyType)) {
            if (this.routingKey != null) {
                b.append(Base64.encode(this.routingKey));
            }
            if (this.cryptoKey != null) {
                b.append(',').append(Base64.encode(this.cryptoKey));
            }
            if (this.metaInfo != null) {
                Enumeration keys = this.metaInfo.keys();
                while (keys.hasMoreElements()) {
                    String k = (String)keys.nextElement();
                    String v = this.metaInfo.get(k);
                    b.append(',');
                    b.append(FreenetURI.urlEncode(k));
                    b.append('=');
                    b.append(FreenetURI.urlEncode(v));
                }
            }
            if (this.docName != null) {
                b.append('/');
            }
        }
        if (this.docName != null) {
            b.append(FreenetURI.urlEncode(this.docName));
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                b.append("//" + FreenetURI.urlEncode(this.metaStr[i]));
            }
        }
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        new FreenetURI(args[0]).decompose();
    }
}

