/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.Key;
import freenet.KeyException;
import freenet.client.AbstractClientKey;
import freenet.client.ClientKey;
import freenet.client.FreenetURI;
import freenet.crypt.Digest;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.keys.CHK;
import freenet.support.Bucket;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Random;

public class ClientCHK
extends AbstractClientKey {
    private byte[] cryptoKey;
    private CHK chk;

    public static ClientKey createFromInsertURI(Random r, FreenetURI uri) throws KeyException {
        return new ClientCHK();
    }

    public static ClientKey createFromRequestURI(FreenetURI uri) throws KeyException {
        if (uri.getRoutingKey() == null) {
            throw new KeyException("Unspecified routing key");
        }
        if (uri.getCryptoKey() == null) {
            throw new KeyException("Unspecified encryption key");
        }
        return new ClientCHK(uri.getRoutingKey(), uri.getCryptoKey());
    }

    public ClientCHK() {
    }

    public ClientCHK(byte[] val, byte[] cryptoKey) {
        this(new CHK(val), cryptoKey);
    }

    public ClientCHK(CHK chk, byte[] cryptoKey) {
        this.chk = chk;
        this.cryptoKey = cryptoKey;
    }

    public String keyType() {
        return "CHK";
    }

    public Key getKey() {
        return this.chk;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKey;
    }

    private void makeCryptoKey(InputStream in, long plainLength) throws IOException {
        byte[] buf = new byte[4096];
        Digest ctx = SHA1.getInstance();
        while (plainLength > 0L) {
            int i = in.read(buf, 0, plainLength < (long)buf.length ? (int)plainLength : buf.length);
            if (i > 0) {
                ctx.update(buf, 0, i);
                plainLength -= (long)i;
                continue;
            }
            if (i != -1) continue;
            throw new EOFException();
        }
        byte[] entropy = ctx.digest();
        this.cryptoKey = new byte[this.cipher.getKeySize() >> 3];
        Util.makeKey(entropy, this.cryptoKey, 0, this.cryptoKey.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream encode(Bucket data, long metaLength, Bucket ctBucket) throws KeyException, IOException {
        InputStream in1 = data.getInputStream();
        InputStream in2 = data.getInputStream();
        try {
            this.makeCryptoKey(in1, data.size());
            InputStream ret = super.encode(in2, data.size(), metaLength, ctBucket);
            this.chk = new CHK(this.storables, Util.log2(this.getPaddedLength()));
            InputStream inputStream = ret;
            return inputStream;
        }
        finally {
            try {
                in1.close();
            }
            catch (IOException e) {}
            try {
                in2.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream encode(Bucket meta, Bucket data, Bucket ctBucket) throws KeyException, IOException {
        InputStream ret;
        InputStream metaIn = null;
        InputStream dataIn = null;
        try {
            metaIn = meta.getInputStream();
            dataIn = data.getInputStream();
            this.makeCryptoKey(new SequenceInputStream(metaIn, dataIn), meta.size() + data.size());
        }
        finally {
            try {
                metaIn.close();
            }
            catch (IOException e) {}
            try {
                dataIn.close();
            }
            catch (IOException e) {}
        }
        try {
            metaIn = meta.getInputStream();
            dataIn = data.getInputStream();
            ret = super.encode(new SequenceInputStream(metaIn, dataIn), meta.size() + data.size(), meta.size(), ctBucket);
        }
        finally {
            try {
                metaIn.close();
            }
            catch (IOException e) {}
            try {
                dataIn.close();
            }
            catch (IOException e) {}
        }
        this.chk = new CHK(this.storables, Util.log2(this.getPaddedLength()));
        return ret;
    }
}

