/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Field;
import org.garret.perst.MultidimensionalComparator;
import org.garret.perst.Storage;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionMultidimensionalComparator<T>
extends MultidimensionalComparator<T> {
    private String className;
    private String[] fieldNames;
    private transient Class cls;
    private transient Field[] fields;
    private transient ClassDescriptor desc;

    @Override
    public void onLoad() {
        this.cls = ClassDescriptor.loadClass(this.getStorage(), this.className);
        this.locateFields();
    }

    private final void locateFields() {
        if (this.fieldNames == null) {
            this.fields = this.cls.getDeclaredFields();
        } else {
            this.fields = new Field[this.fieldNames.length];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = ClassDescriptor.locateField(this.cls, this.fieldNames[i]);
            }
        }
    }

    public ReflectionMultidimensionalComparator(Storage storage, Class cls, String[] fieldNames) {
        super(storage);
        this.cls = cls;
        this.fieldNames = fieldNames;
        this.className = ClassDescriptor.getClassName(cls);
        this.locateFields();
    }

    ReflectionMultidimensionalComparator() {
    }

    @Override
    public int compare(T m1, T m2, int i) {
        try {
            Comparable c1 = (Comparable)this.fields[i].get(m1);
            Comparable c2 = (Comparable)this.fields[i].get(m2);
            if (c1 == null && c2 == null) {
                return 0;
            }
            if (c1 == null) {
                return -2;
            }
            if (c2 == null) {
                return 2;
            }
            int diff = c1.compareTo(c2);
            return diff < 0 ? -1 : (diff == 0 ? 0 : 1);
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    @Override
    public int getNumberOfDimensions() {
        return this.fields.length;
    }

    @Override
    public T cloneField(T obj, int i) {
        if (this.desc == null) {
            this.desc = ((StorageImpl)this.getStorage()).findClassDescriptor(this.cls);
        }
        Object clone = this.desc.newInstance();
        try {
            this.fields[i].set(clone, this.fields[i].get(obj));
            return (T)clone;
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }
}

