/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.garret.perst.IPersistent;
import org.garret.perst.PatriciaTrie;
import org.garret.perst.PatriciaTrieKey;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PTrie<T extends IPersistent>
extends PersistentCollection<T>
implements PatriciaTrie<T> {
    private PTrieNode<T> rootZero;
    private PTrieNode<T> rootOne;
    private int count;

    PTrie() {
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public ArrayList<T> elements() {
        ArrayList list = new ArrayList(this.count);
        PTrie.fill(list, this.rootZero);
        PTrie.fill(list, this.rootOne);
        return list;
    }

    @Override
    public Object[] toArray() {
        return this.elements().toArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        return this.elements().toArray(arr);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements().iterator();
    }

    private static <E extends IPersistent> void fill(ArrayList<E> list, PTrieNode<E> node) {
        if (node != null) {
            list.add(node.obj);
            PTrie.fill(list, node.childZero);
            PTrie.fill(list, node.childOne);
        }
    }

    private static int firstBit(long key, int keyLength) {
        return (int)(key >>> keyLength - 1) & 1;
    }

    private static int getCommonPartLength(long keyA, int keyLengthA, long keyB, int keyLengthB) {
        if (keyLengthA > keyLengthB) {
            keyA >>>= keyLengthA - keyLengthB;
            keyLengthA = keyLengthB;
        } else {
            keyB >>>= keyLengthB - keyLengthA;
            keyLengthB = keyLengthA;
        }
        long diff = keyA ^ keyB;
        int count = 0;
        while (diff != 0L) {
            diff >>>= 1;
            ++count;
        }
        return keyLengthA - count;
    }

    @Override
    public T add(PatriciaTrieKey key, T obj) {
        this.modify();
        ++this.count;
        if (PTrie.firstBit(key.mask, key.length) == 1) {
            if (this.rootOne != null) {
                return this.rootOne.add(key.mask, key.length, obj);
            }
            this.rootOne = new PTrieNode<T>(key.mask, key.length, obj);
            return null;
        }
        if (this.rootZero != null) {
            return this.rootZero.add(key.mask, key.length, obj);
        }
        this.rootZero = new PTrieNode<T>(key.mask, key.length, obj);
        return null;
    }

    @Override
    public T findBestMatch(PatriciaTrieKey key) {
        if (PTrie.firstBit(key.mask, key.length) == 1) {
            if (this.rootOne != null) {
                return this.rootOne.findBestMatch(key.mask, key.length);
            }
        } else if (this.rootZero != null) {
            return this.rootZero.findBestMatch(key.mask, key.length);
        }
        return null;
    }

    @Override
    public T findExactMatch(PatriciaTrieKey key) {
        if (PTrie.firstBit(key.mask, key.length) == 1) {
            if (this.rootOne != null) {
                return this.rootOne.findExactMatch(key.mask, key.length);
            }
        } else if (this.rootZero != null) {
            return this.rootZero.findExactMatch(key.mask, key.length);
        }
        return null;
    }

    @Override
    public T remove(PatriciaTrieKey key) {
        T obj;
        if (PTrie.firstBit(key.mask, key.length) == 1) {
            T obj2;
            if (this.rootOne != null && (obj2 = this.rootOne.remove(key.mask, key.length)) != null) {
                this.modify();
                --this.count;
                if (this.rootOne.isNotUsed()) {
                    this.rootOne.deallocate();
                    this.rootOne = null;
                }
                return obj2;
            }
        } else if (this.rootZero != null && (obj = this.rootZero.remove(key.mask, key.length)) != null) {
            this.modify();
            --this.count;
            if (this.rootZero.isNotUsed()) {
                this.rootZero.deallocate();
                this.rootZero = null;
            }
            return obj;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.rootOne != null) {
            this.rootOne.deallocate();
            this.rootOne = null;
        }
        if (this.rootZero != null) {
            this.rootZero.deallocate();
            this.rootZero = null;
        }
        this.count = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PTrieNode<T extends IPersistent>
    extends Persistent {
        long key;
        int keyLength;
        T obj;
        PTrieNode<T> childZero;
        PTrieNode<T> childOne;

        PTrieNode(long key, int keyLength, T obj) {
            this.obj = obj;
            this.key = key;
            this.keyLength = keyLength;
        }

        PTrieNode() {
        }

        T add(long key, int keyLength, T obj) {
            if (key == this.key && keyLength == this.keyLength) {
                this.modify();
                T prevObj = this.obj;
                this.obj = obj;
                return prevObj;
            }
            int keyLengthCommon = PTrie.getCommonPartLength(key, keyLength, this.key, this.keyLength);
            int keyLengthDiff = this.keyLength - keyLengthCommon;
            long keyCommon = key >>> keyLength - keyLengthCommon;
            long keyDiff = this.key - (keyCommon << keyLengthDiff);
            if (keyLengthDiff > 0) {
                this.modify();
                PTrieNode<T> newNode = new PTrieNode<T>(keyDiff, keyLengthDiff, this.obj);
                newNode.childZero = this.childZero;
                newNode.childOne = this.childOne;
                this.key = keyCommon;
                this.keyLength = keyLengthCommon;
                this.obj = null;
                if (PTrie.firstBit(keyDiff, keyLengthDiff) == 1) {
                    this.childZero = null;
                    this.childOne = newNode;
                } else {
                    this.childZero = newNode;
                    this.childOne = null;
                }
            }
            if (keyLength > keyLengthCommon) {
                keyLengthDiff = keyLength - keyLengthCommon;
                keyDiff = key - (keyCommon << keyLengthDiff);
                if (PTrie.firstBit(keyDiff, keyLengthDiff) == 1) {
                    if (this.childOne != null) {
                        return this.childOne.add(keyDiff, keyLengthDiff, obj);
                    }
                    this.modify();
                    this.childOne = new PTrieNode<T>(keyDiff, keyLengthDiff, obj);
                    return null;
                }
                if (this.childZero != null) {
                    return this.childZero.add(keyDiff, keyLengthDiff, obj);
                }
                this.modify();
                this.childZero = new PTrieNode<T>(keyDiff, keyLengthDiff, obj);
                return null;
            }
            T prevObj = this.obj;
            this.obj = obj;
            return prevObj;
        }

        T findBestMatch(long key, int keyLength) {
            if (keyLength > this.keyLength) {
                int keyLengthCommon = PTrie.getCommonPartLength(key, keyLength, this.key, this.keyLength);
                int keyLengthDiff = keyLength - keyLengthCommon;
                long keyCommon = key >>> keyLengthDiff;
                long keyDiff = key - (keyCommon << keyLengthDiff);
                if (PTrie.firstBit(keyDiff, keyLengthDiff) == 1) {
                    if (this.childOne != null) {
                        return this.childOne.findBestMatch(keyDiff, keyLengthDiff);
                    }
                } else if (this.childZero != null) {
                    return this.childZero.findBestMatch(keyDiff, keyLengthDiff);
                }
            }
            return this.obj;
        }

        T findExactMatch(long key, int keyLength) {
            if (keyLength >= this.keyLength) {
                if (key == this.key && keyLength == this.keyLength) {
                    return this.obj;
                }
                int keyLengthCommon = PTrie.getCommonPartLength(key, keyLength, this.key, this.keyLength);
                if (keyLengthCommon == this.keyLength) {
                    int keyLengthDiff = keyLength - keyLengthCommon;
                    long keyCommon = key >>> keyLengthDiff;
                    long keyDiff = key - (keyCommon << keyLengthDiff);
                    if (PTrie.firstBit(keyDiff, keyLengthDiff) == 1) {
                        if (this.childOne != null) {
                            return this.childOne.findBestMatch(keyDiff, keyLengthDiff);
                        }
                    } else if (this.childZero != null) {
                        return this.childZero.findBestMatch(keyDiff, keyLengthDiff);
                    }
                }
            }
            return null;
        }

        boolean isNotUsed() {
            return this.obj == null && this.childOne == null && this.childZero == null;
        }

        T remove(long key, int keyLength) {
            if (keyLength >= this.keyLength) {
                T obj;
                if (key == this.key && keyLength == this.keyLength) {
                    T obj2 = this.obj;
                    this.obj = null;
                    return obj2;
                }
                int keyLengthCommon = PTrie.getCommonPartLength(key, keyLength, this.key, this.keyLength);
                int keyLengthDiff = keyLength - keyLengthCommon;
                long keyCommon = key >>> keyLengthDiff;
                long keyDiff = key - (keyCommon << keyLengthDiff);
                if (PTrie.firstBit(keyDiff, keyLengthDiff) == 1) {
                    T obj3;
                    if (this.childOne != null && (obj3 = this.childOne.findBestMatch(keyDiff, keyLengthDiff)) != null) {
                        if (this.childOne.isNotUsed()) {
                            this.modify();
                            this.childOne.deallocate();
                            this.childOne = null;
                        }
                        return obj3;
                    }
                } else if (this.childZero != null && (obj = this.childZero.findBestMatch(keyDiff, keyLengthDiff)) != null) {
                    if (this.childZero.isNotUsed()) {
                        this.modify();
                        this.childZero.deallocate();
                        this.childZero = null;
                    }
                    return obj;
                }
            }
            return null;
        }

        @Override
        public void deallocate() {
            if (this.childOne != null) {
                this.childOne.deallocate();
            }
            if (this.childZero != null) {
                this.childZero.deallocate();
            }
            super.deallocate();
        }
    }
}

