/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.garret.perst.EmbeddedLink;
import org.garret.perst.ICloneable;
import org.garret.perst.IPersistent;
import org.garret.perst.IterableIterator;
import org.garret.perst.Link;
import org.garret.perst.PersistentIterator;
import org.garret.perst.impl.PersistentStub;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkImpl<T extends IPersistent>
implements EmbeddedLink<T>,
ICloneable {
    IPersistent[] arr;
    int used;
    transient IPersistent owner;

    private final void modify() {
        if (this.owner != null) {
            this.owner.modify();
        }
    }

    @Override
    public int size() {
        return this.used;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void setSize(int newSize) {
        if (newSize < this.used) {
            int i = this.used;
            while (--i >= newSize) {
                this.arr[i] = null;
            }
        } else {
            this.reserveSpace(newSize - this.used);
        }
        this.used = newSize;
    }

    @Override
    public T get(int i) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.loadElem(i);
    }

    @Override
    public IPersistent getRaw(int i) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.arr[i];
    }

    @Override
    public void pin() {
        int n = this.used;
        for (int i = 0; i < n; ++i) {
            this.arr[i] = this.loadElem(i);
        }
    }

    @Override
    public void unpin() {
        int n = this.used;
        for (int i = 0; i < n; ++i) {
            IPersistent elem = this.arr[i];
            if (elem == null || elem.isRaw() || !elem.isPersistent()) continue;
            this.arr[i] = new PersistentStub(elem.getStorage(), elem.getOid());
        }
    }

    @Override
    public T set(int i, T obj) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        T prev = this.loadElem(i);
        this.arr[i] = obj;
        this.modify();
        return prev;
    }

    @Override
    public void setObject(int i, T obj) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        this.arr[i] = obj;
        this.modify();
    }

    @Override
    public boolean isEmpty() {
        return this.used == 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int size = this.used;
        int numMoved = size - toIndex;
        System.arraycopy(this.arr, toIndex, this.arr, fromIndex, numMoved);
        int newSize = size - (toIndex - fromIndex);
        while (size != newSize) {
            this.arr[--size] = null;
        }
        this.used = size;
        this.modify();
    }

    @Override
    public void removeObject(int i) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        --this.used;
        System.arraycopy(this.arr, i + 1, this.arr, i, this.used - i);
        this.arr[this.used] = null;
        this.modify();
    }

    @Override
    public T remove(int i) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        T obj = this.loadElem(i);
        --this.used;
        System.arraycopy(this.arr, i + 1, this.arr, i, this.used - i);
        this.arr[this.used] = null;
        this.modify();
        return obj;
    }

    void reserveSpace(int len) {
        if (this.used + len > this.arr.length) {
            IPersistent[] newArr = new IPersistent[this.used + len > this.arr.length * 2 ? this.used + len : this.arr.length * 2];
            System.arraycopy(this.arr, 0, newArr, 0, this.used);
            this.arr = newArr;
        }
        this.modify();
    }

    @Override
    public void add(int i, T obj) {
        this.insert(i, obj);
    }

    @Override
    public void insert(int i, T obj) {
        if (i < 0 || i > this.used) {
            throw new IndexOutOfBoundsException();
        }
        this.reserveSpace(1);
        System.arraycopy(this.arr, i, this.arr, i + 1, this.used - i);
        this.arr[i] = obj;
        ++this.used;
    }

    @Override
    public boolean add(T obj) {
        this.reserveSpace(1);
        this.arr[this.used++] = obj;
        return true;
    }

    @Override
    public void addAll(T[] a) {
        this.addAll((IPersistent[])a, 0, a.length);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean modified = false;
        Iterator<T> e = c.iterator();
        while (e.hasNext()) {
            this.add(index++, (T)((IPersistent)e.next()));
            modified = true;
        }
        return modified;
    }

    @Override
    public void addAll(T[] a, int from, int length) {
        this.reserveSpace(length);
        System.arraycopy(a, from, this.arr, this.used, length);
        this.used += length;
    }

    @Override
    public boolean addAll(Link<T> link) {
        int n = link.size();
        this.reserveSpace(n);
        int i = 0;
        int j = this.used;
        while (i < n) {
            this.arr[j] = link.getRaw(i);
            ++i;
            ++j;
        }
        this.used += n;
        return true;
    }

    @Override
    public Object[] toArray() {
        return this.toPersistentArray();
    }

    @Override
    public IPersistent[] toRawArray() {
        return this.arr;
    }

    @Override
    public IPersistent[] toPersistentArray() {
        IPersistent[] a = new IPersistent[this.used];
        int i = this.used;
        while (--i >= 0) {
            a[i] = this.loadElem(i);
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        if (arr.length < this.used) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.used);
        }
        int i = this.used;
        while (--i >= 0) {
            arr[i] = this.loadElem(i);
        }
        if (arr.length > this.used) {
            arr[this.used] = null;
        }
        return arr;
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    @Override
    public boolean containsObject(T obj) {
        return this.indexOfObject(obj) >= 0;
    }

    @Override
    public int lastIndexOfObject(Object obj) {
        int oid;
        IPersistent[] a = this.arr;
        if (obj instanceof IPersistent && (oid = ((IPersistent)obj).getOid()) != 0) {
            int i = this.used;
            while (--i >= 0) {
                IPersistent elem = a[i];
                if (elem == null || elem.getOid() != oid) continue;
                return i;
            }
        } else {
            int i = this.used;
            while (--i >= 0) {
                if (a[i] != obj) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int indexOfObject(Object obj) {
        int oid;
        IPersistent[] a = this.arr;
        if (obj instanceof IPersistent && (oid = ((IPersistent)obj).getOid()) != 0) {
            int n = this.used;
            for (int i = 0; i < n; ++i) {
                IPersistent elem = a[i];
                if (elem == null || elem.getOid() != oid) continue;
                return i;
            }
        } else {
            int n = this.used;
            for (int i = 0; i < n; ++i) {
                if (a[i] != obj) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int indexOf(Object obj) {
        if (obj == null) {
            int n = this.used;
            for (int i = 0; i < n; ++i) {
                if (this.arr[i] != null) continue;
                return i;
            }
        } else {
            int n = this.used;
            for (int i = 0; i < n; ++i) {
                if (!obj.equals(this.loadElem(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj == null) {
            int i = this.used;
            while (--i >= 0) {
                if (this.arr[i] != null) continue;
                return i;
            }
        } else {
            int i = this.used;
            while (--i >= 0) {
                if (!obj.equals(this.loadElem(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean containsElement(int i, T obj) {
        IPersistent elem = this.arr[i];
        return elem == obj || elem != null && elem.getOid() != 0 && elem.getOid() == obj.getOid();
    }

    @Override
    public void clear() {
        int i = this.used;
        while (--i >= 0) {
            this.arr[i] = null;
        }
        this.used = 0;
        this.modify();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i >= 0) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        Iterator<T> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add((T)((IPersistent)e.next()))) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> e = this.iterator();
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new LinkIterator(this, index);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    private final T loadElem(int i) {
        IPersistent elem = this.arr[i];
        if (elem != null && elem.isRaw()) {
            elem = ((StorageImpl)elem.getStorage()).lookupObject(elem.getOid(), null);
        }
        return (T)elem;
    }

    @Override
    public IterableIterator<T> select(Class cls, String predicate) {
        QueryImpl<T> query = new QueryImpl<T>(null);
        return query.select(cls, this.iterator(), predicate);
    }

    @Override
    public void setOwner(IPersistent obj) {
        this.owner = obj;
    }

    @Override
    public IPersistent getOwner() {
        return this.owner;
    }

    LinkImpl() {
    }

    public LinkImpl(int initSize) {
        this.arr = new IPersistent[initSize];
    }

    public LinkImpl(T[] arr, IPersistent owner) {
        this.arr = arr;
        this.owner = owner;
        this.used = arr.length;
    }

    public LinkImpl(Link link, IPersistent owner) {
        this.used = link.size();
        this.arr = new IPersistent[this.used];
        System.arraycopy(this.arr, 0, link.toRawArray(), 0, this.used);
        this.owner = owner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LinkIterator<T extends IPersistent>
    implements PersistentIterator,
    ListIterator<T> {
        private Link<T> link;
        private int i;
        private int last;

        LinkIterator(Link<T> link, int index) {
            this.link = link;
            this.i = index;
            this.last = -1;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.link.size();
        }

        @Override
        public T next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.i;
            return this.link.get(this.i++);
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public boolean hasPrevious() {
            return this.i > 0;
        }

        @Override
        public T previous() throws NoSuchElementException {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.last = --this.i;
            return this.link.get(this.i);
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public int nextOid() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.link.getRaw(this.i++).getOid();
        }

        @Override
        public void remove() {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            this.link.removeObject(this.last);
            if (this.last < this.i) {
                --this.i;
            }
        }

        @Override
        public void set(T o) {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            this.link.setObject(this.last, o);
        }

        @Override
        public void add(T o) {
            this.link.insert(this.i++, o);
            this.last = -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubList<T extends IPersistent>
    extends AbstractList<T>
    implements RandomAccess {
        private LinkImpl<T> l;
        private int offset;
        private int size;

        SubList(LinkImpl<T> list, int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > list.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this.l = list;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public T set(int index, T element) {
            this.rangeCheck(index);
            return this.l.set(index + this.offset, element);
        }

        @Override
        public T get(int index) {
            this.rangeCheck(index);
            return (T)this.l.get(index + this.offset);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void add(int index, T element) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            this.l.add(index + this.offset, element);
            ++this.size;
        }

        @Override
        public T remove(int index) {
            this.rangeCheck(index);
            Object result = this.l.remove(index + this.offset);
            --this.size;
            return (T)result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.l.removeRange(fromIndex + this.offset, toIndex + this.offset);
            this.size -= toIndex - fromIndex;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.l.addAll(this.offset + index, c);
            this.size += cSize;
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(final int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return new ListIterator<T>(){
                private ListIterator<T> i;
                {
                    this.i = SubList.this.l.listIterator(index + SubList.this.offset);
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex() < SubList.this.size;
                }

                @Override
                public T next() {
                    if (this.hasNext()) {
                        return (IPersistent)this.i.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                @Override
                public T previous() {
                    if (this.hasPrevious()) {
                        return (IPersistent)this.i.previous();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex() - SubList.this.offset;
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex() - SubList.this.offset;
                }

                @Override
                public void remove() {
                    this.i.remove();
                    SubList.this.size--;
                }

                @Override
                public void set(T o) {
                    this.i.set(o);
                }

                @Override
                public void add(T o) {
                    this.i.add(o);
                    SubList.this.size++;
                }
            };
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return new SubList<T>(this.l, this.offset + fromIndex, this.offset + toIndex);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
            }
        }
    }
}

