/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.Assert;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.RootPage;

class Header {
    int curr;
    boolean dirty;
    byte databaseFormatVersion;
    RootPage[] root;
    long transactionId;
    static final int sizeof = 139;

    Header() {
    }

    final void pack(byte[] rec) {
        int offs = 0;
        rec[offs++] = (byte)this.curr;
        rec[offs++] = (byte)(this.dirty ? 1 : 0);
        rec[offs++] = this.databaseFormatVersion;
        for (int i = 0; i < 2; ++i) {
            Bytes.pack8(rec, offs, this.root[i].size);
            Bytes.pack8(rec, offs += 8, this.root[i].index);
            Bytes.pack8(rec, offs += 8, this.root[i].shadowIndex);
            Bytes.pack8(rec, offs += 8, this.root[i].usedSize);
            Bytes.pack4(rec, offs += 8, this.root[i].indexSize);
            Bytes.pack4(rec, offs += 4, this.root[i].shadowIndexSize);
            Bytes.pack4(rec, offs += 4, this.root[i].indexUsed);
            Bytes.pack4(rec, offs += 4, this.root[i].freeList);
            Bytes.pack4(rec, offs += 4, this.root[i].bitmapEnd);
            Bytes.pack4(rec, offs += 4, this.root[i].rootObject);
            Bytes.pack4(rec, offs += 4, this.root[i].classDescList);
            Bytes.pack4(rec, offs += 4, this.root[i].bitmapExtent);
            offs += 4;
        }
        Bytes.pack8(rec, offs, this.transactionId);
        Assert.that((offs += 8) == 139);
    }

    final void unpack(byte[] rec) {
        int offs = 0;
        this.curr = rec[offs++];
        this.dirty = rec[offs++] != 0;
        this.databaseFormatVersion = rec[offs++];
        this.root = new RootPage[2];
        for (int i = 0; i < 2; ++i) {
            this.root[i] = new RootPage();
            this.root[i].size = Bytes.unpack8(rec, offs);
            this.root[i].index = Bytes.unpack8(rec, offs += 8);
            this.root[i].shadowIndex = Bytes.unpack8(rec, offs += 8);
            this.root[i].usedSize = Bytes.unpack8(rec, offs += 8);
            this.root[i].indexSize = Bytes.unpack4(rec, offs += 8);
            this.root[i].shadowIndexSize = Bytes.unpack4(rec, offs += 4);
            this.root[i].indexUsed = Bytes.unpack4(rec, offs += 4);
            this.root[i].freeList = Bytes.unpack4(rec, offs += 4);
            this.root[i].bitmapEnd = Bytes.unpack4(rec, offs += 4);
            this.root[i].rootObject = Bytes.unpack4(rec, offs += 4);
            this.root[i].classDescList = Bytes.unpack4(rec, offs += 4);
            this.root[i].bitmapExtent = Bytes.unpack4(rec, offs += 4);
            offs += 4;
        }
        this.transactionId = Bytes.unpack8(rec, offs);
        Assert.that((offs += 8) == 139);
    }
}

