/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.Assert;
import org.garret.perst.Key;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;

class BtreeKey {
    Key key;
    int oid;
    int oldOid;

    BtreeKey(Key key, int oid) {
        this.key = key;
        this.oid = oid;
    }

    final void getStr(Page pg, int i) {
        int len = BtreePage.getKeyStrSize(pg, i);
        int offs = 4 + BtreePage.getKeyStrOffs(pg, i);
        char[] sval = new char[len];
        for (int j = 0; j < len; ++j) {
            sval[j] = (char)Bytes.unpack2(pg.data, offs);
            offs += 2;
        }
        this.key = new Key(sval);
    }

    final void getByteArray(Page pg, int i) {
        int len = BtreePage.getKeyStrSize(pg, i);
        int offs = 4 + BtreePage.getKeyStrOffs(pg, i);
        byte[] bval = new byte[len];
        System.arraycopy(pg.data, offs, bval, 0, len);
        this.key = new Key(bval);
    }

    final void extract(Page pg, int offs, int type) {
        byte[] data = pg.data;
        switch (type) {
            case 0: {
                this.key = new Key(data[offs] != 0);
                break;
            }
            case 1: {
                this.key = new Key(data[offs]);
                break;
            }
            case 3: {
                this.key = new Key(Bytes.unpack2(data, offs));
                break;
            }
            case 2: {
                this.key = new Key((char)Bytes.unpack2(data, offs));
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                this.key = new Key(Bytes.unpack4(data, offs));
                break;
            }
            case 5: 
            case 9: {
                this.key = new Key(Bytes.unpack8(data, offs));
                break;
            }
            case 6: {
                this.key = new Key(Float.intBitsToFloat(Bytes.unpack4(data, offs)));
                break;
            }
            case 7: {
                this.key = new Key(Double.longBitsToDouble(Bytes.unpack8(data, offs)));
                break;
            }
            default: {
                Assert.failed("Invalid type");
            }
        }
    }

    final void pack(Page pg, int i) {
        byte[] dst = pg.data;
        switch (this.key.type) {
            case 0: 
            case 1: {
                dst[4 + i] = (byte)this.key.ival;
                break;
            }
            case 2: 
            case 3: {
                Bytes.pack2(dst, 4 + i * 2, (short)this.key.ival);
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                Bytes.pack4(dst, 4 + i * 4, this.key.ival);
                break;
            }
            case 5: 
            case 9: {
                Bytes.pack8(dst, 4 + i * 8, this.key.lval);
                break;
            }
            case 6: {
                Bytes.pack4(dst, 4 + i * 4, Float.floatToIntBits((float)this.key.dval));
                break;
            }
            case 7: {
                Bytes.pack8(dst, 4 + i * 8, Double.doubleToLongBits(this.key.dval));
                break;
            }
            default: {
                Assert.failed("Invalid type");
            }
        }
        Bytes.pack4(dst, 4 + (1023 - i - 1) * 4, this.oid);
    }
}

